/*
 * eJourn Source Code.  Copyleft Chris R. <MA_D> Hilton 2004-2006.
 * 	In remembrance of Kelee Alexus.
 *  May their never be a story as beautiful be written using these lines
 *  as the one you told with the last four words I heard you speak.
 */






#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "interface.h"
#include "support.h"
#include "settings.h"
#include "gui_al.h"
#include "simple.h"
#include "meta_functions.h"
#include "images.h"
#include "threads.h"
#include "gui_io.h"
#include "months.h"
#include "listen.h"
#include "time.h"
#include "plugins.h"
#include "journal.h"
#include "prefix.h"
#include "login.h"
#include "tabs.h"
#include "export.h"
#include "srch_pane.h"
#include "second.h"


void __lock() { elog_glob_lock(); }
void __unlock() { elog_glob_unlock(); }

extern void elog_status_hide();

int main(int argc, char *argv[])
{
	 elog_thrd_initialize();
	elog_set_loadSettings(NULL);

	printf("Settings be loaded...\n");

	int width = elog_set_get_int("width");
	if (width <= 0) {
		elog_set_set_int("width", 600);
		elog_set_set_int("height", 400);
	}


	const char *rc = elog_set_get_str("GTKTHEME");
	if (rc) {
		char **file = malloc((sizeof *file) * 2);
		elog_sp_cat(&(file[0]), rc, NULL);
		printf("Setting skin... to %s\n", file[0]);
		file[1] = NULL;
		gtk_rc_set_default_files(file);	//should I free now?
		gtk_rc_reparse_all();
	}


	ELOG_ENC_AES = "AES";
	ELOG_ENC_NONE = "NONE";
	ELOG_ERROR = malloc(1);
	setKey(NULL);

	elog_mnth_init();

	printf("Initting Months...\n");

#ifndef NO_THREADS

	g_thread_init(NULL);
	gdk_threads_set_lock_functions(G_CALLBACK(__lock), G_CALLBACK(__unlock));

	gdk_threads_init();

	//for debugging:
	//gdk_threads_set_lock_functions(G_CALLBACK(__lock), G_CALLBACK(__unlock));

#endif

#ifdef ENABLE_NLS
	bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
#endif
#ifndef NO_THREADS
	gdk_threads_enter();
#endif

	printf("Threading the gdk..\n");


	gtk_set_locale();

	gtk_init(&argc, &argv);

	char **list = gtk_rc_get_default_files();
	int c;
	for (c = 0; list[c]; ++c)
		printf("%s\n", list[c]);


#ifndef NO_THREADS
	gdk_threads_leave();
#endif




	char *fifo_loc = (char *) elog_set_get_str("FIFO_LOC");
	if (fifo_loc == NULL) {
		printf("Fifo loc'ed!\n");
		char *usr = getenv("USER");
		elog_sp_cat(&fifo_loc, "/tmp/ejourn-", usr, NULL);
	}

	char *path_journ;
	elog_sp_cat(&path_journ, getenv("HOME"), _ELOG_CONFIG,
		    "/journals.conf", NULL);
	ELOG_JOURN_CONF = path_journ;
#ifndef NO_THREADS
	gdk_threads_enter();
#endif

	elog_img_init();

	printf("Imaged\n");

	create_main_window();

	printf("Main window prepared\n");


	if (!elog_journ_initialize(path_journ)) {
		printf("Journals ready\n");
		const char *p = elog_set_get_str("path");
		if (!p)
			elog_set_set_str("path",
					 elog_journ_current()->settings->
					 path);
		printf("PATH:%s\n", elog_set_get_str("path"));
		elog_journ_set(elog_set_get_str("path"));
		if (elog_journ_current()->settings->encryption[0] == 'A'
		    && elog_journ_current()->key == NULL)
			if (create_login_window(ELOG_LGN_MODE_LOGIN))
				return 0;	//they cancelled, exit program

		printf("Key:%s\n",
		       elog_journ_current()->settings->encryption);
		printf("User logged in\n");
	} else
		return 0;	//errored in journ initialization




#ifndef NO_THREADS
	gdk_threads_leave();
#endif

	elog_scnd_initialize();
	printf("Initializing the background thread...\n");




	if (elog_set_get_str("THEME") == NULL) {
		char *theme;
		elog_sp_cat(&theme, "default", NULL);
		elog_set_set_str("THEME", theme);
	}

	elog_img_load(elog_set_get_str("THEME"));
	//struct elog_thread *img = elog_thrd_launch(elog_img_load, "default");
	//Launching this in a new thread because it's time intensive

	printf("Image themed\n");

	char *plgn_path;
	elog_sp_cat(&plgn_path, getenv("HOME"), _ELOG_CONFIG,
		    "/plugins.lst", NULL);

	elog_plgn_initialize(plgn_path);

	printf("Plugins loaded\n");
	//setting the calendar tab, this makes sure things are right.
	elog_gui_io_markCalendar();
	//************
	//opening today!

	struct cal_date *date = elog_gui_al_calendarDate(NULL);

	char *year = elog_sp_shortToString(date->year);
	char *month = elog_sp_shortToString(date->month);
	char *day = elog_sp_shortToString(date->day);


	char *path;
	elog_sp_cat(&path, elog_set_get_str("path"), "/", year, "/", month,
		    "/", day, "/", NULL);
	elog_gui_io_newEntry(path);
	elog_gui_io_dispLocation(path);
	free(path);
	free(month);
	free(year);
	free(day);

	free(date);

	elog_srch_pane_initialize();
	
	gtk_widget_show_all(_mainWindow);
	gtk_widget_hide(_res_srch_window);
	elog_status_hide();
	
	elog_tab_set(0);
	elog_gui_al_page(0);	//setting page to calendar



	//*************


	gtk_main();
	//application exit
	elog_gui_io_save();
	elog_plgn_save(plgn_path);
	elog_set_writeSettings(elog_set_confPath(NULL));
	elog_journ_saveStates(path_journ);

	elog_scnd_finish(100000);
	elog_img_free();


	unlink(fifo_loc);

	return EXIT_SUCCESS;
}
