#include "meta_functions.h"
#include "simple.h"

void recurse(struct elog_io_dir *dir,
	     void (*file_func) (const char *fileName, void *, void *),
	     void (*dir_func) (const char *fileName, void *, void *),
	     void *op1, void *op2)
{
	int j;
	int c = 0;
	for (j = 0; dir->dir[j] != NULL; ++j) {
		char *file;
		elog_sp_cat(&file, dir->path, dir->dir[j], NULL);
		if (dir->dir[j][0] != '/') {
			char *full;
			elog_sp_cat(&full, dir->path, dir->dir[j], NULL);
			file_func(full, op1, op2);
		} else {
			char *full;
			elog_sp_cat(&full, dir->path, &(dir->dir[j][3]),
				    NULL);
			dir_func(full, op1, op2);
			recurse(dir->subDir[c], file_func, dir_func, op1,
				op2);
			++c;
		}
	}


}

void blank_func(const char *fileName, void *op1, void *op2)
{
}

void elog_func_apply_recursively(const char *directory,
				 void (*file_func) (const char *fileName,
						    void *, void *),
				 void (*dir_func) (const char *fileName,
						   void *, void *),
				 void *op1, void *op2)
{

	struct elog_io_dir *head =
	    elog_io_recurseDir(directory, directory);
	if (dir_func != NULL)
		recurse(head, file_func, dir_func, op1, op2);
	else
		recurse(head, file_func, blank_func, op1, op2);
	elog_io_dir_free(head);
}
