#include <stdlib.h>
#include <stdio.h>
#include "../plugins.h"
#include "../xml.h"
#include "../journal.h"


/* All of the functions contained in this example file exist as a template for you
 * to develop your plugin modules from.
 * The plugins system works by calling your plugin at specific times during the 
 * application.
 * These times are conveniently labeled with their respective functions, those
 * function names cannot be changed. *  
 * You should be fine adding functions, but unless you call them they will not
 * be called.
 * Feel free to add global variables.
 * 
 * Unless told otherwise, most data passed in is protected.  Don't change it
 * if you value your life, err I mean program stability.
 * Don't depend on it either, it may change: plugins don't exist to change
 * program behaviour so don't try.  They add.
 */


/*  Compiling this file:
 *  gcc -shared -o modules/plgn_example.so -L. -lejourn modules/plgn_example.c
 *  The -shared is to make it loadable dynamically, and -L. -lejourn is to tell
 *  it to dynamically load the ejourn libraries.
 */


/* open(doc) is called each time a file is opened for the gui; not necessarily each
 * time it is opened period (that'd be quite silly and impossible).
 * doc is the same data as the program uses, it is the raw char of the file.
 * It can be accessed with elog_xml_scanf
 */
void ___open(struct elog_plgn_data_io *doc)
{

}
 /* save(doc,txt) is called on save events in the application.
  * Feel free to change the data, your changes will be saved.
  * It is recommended that you only use this to add to the data
  * and never remove from it.  Use elog_xml_printf to save to doc.
  */
void  ___save(struct elog_plgn_data_io *doc)
{

}
 
 /* init(gui) is called when the plugin is loaded.
  * gui will be NULL;
  */
void  ___init(char *name) //add in the gui struct once you've made it.
{

}
 
 /* end(void) is called when the program unloads your plugin.  Please clean
  * everything it's done up:  Including what it's added to the gui!
  * HINT:  You should have stored the gtk widgets you needed to delete them
  * later.
  */
void ___end(void *ignoreme)
{

}
 /* ugly(void) is called when the program exits but your plugin is still loaded.
  * It means you don't need to bother cleaning up memory really:  the kernel should
  * handle that for you and we just want that derned window to get off the users
  * desk.  So clean up what you need, save what you love, and finish it quickly if 
  * you can.
  * HINT:  A few Global state variables won't destroy the world here ;). 
  */
void ___ugly(void *ignoreme)
{

}
 
/* char *info returns user-level information about what the plugin does.
 */
char *___info()
{
  return "Adds ability to sync with a blog."
} 
 
/* char *author returns the list of authors, please insert a \n after
 * each author for display purposes.
 */
char *___author()
{
  return "Chris <MA_D> Hilton";
}
 /* journChange(char*) is called when a new journal load function happens, it is called at the
 * end of this function.  It is sent the name of the new journal, and of course you can use
 * elog_journ_current()-> to access its members since it's already loaded.
 */
void ___journChange(struct elog_plgn_data_journ *name)
{

}
 
/* search(char*) is called when a search occurs.  You are sent the term that was searched for
 * immediately when the search is called:  So it may not yet be finished; in fact assume it 
 * hasn't even started yet!
 */
void ___search(struct elog_plgn_data_srch *term)
{

}
