#include <stdlib.h>
#include <stdio.h>
#include "../plugins.h"
#include "../xml.h"
#include "../listen.h"
#include "../journal.h"
#include "../settings.h"

/* All of the functions contained in this example file exist as a template for you
 * to develop your plugin modules from.
 * The plugins system works by calling your plugin at specific times during the 
 * application.
 * These times are conveniently labeled with their respective functions, those
 * function names cannot be changed. *  
 * You should be fine adding functions, but unless you call them they will not
 * be called.
 * Feel free to add global variables.
 * 
 * Unless told otherwise, most data passed in is protected.  Don't change it
 * if you value your life, err I mean program stability.
 * Don't depend on it either, it may change: plugins don't exist to change
 * program behaviour so don't try.  They add.
 */


/*  Compiling this file:
 *  gcc -shared -o modules/plgn_example.so -L. -lejourn modules/plgn_example.c
 *  The -shared is to make it loadable dynamically, and -L. -lejourn is to tell
 *  it to dynamically load the ejourn libraries.
 */

struct elog_thread *_lsn;



void  ___init(void *ignoreme) //add in the gui struct once you've made it.
{
	char *fifo_loc = (char *)elog_set_get_str("FIFO_LOC");
	if (fifo_loc == NULL)
	{
		char *usr = getenv("USER");
		elog_sp_cat(&fifo_loc, "/tmp/ejourn-", usr, NULL);
	}
	_lsn = elog_thrd_launch(elog_lsn_initialize, fifo_loc);
}
 
 /* end(void) is called when the program unloads your plugin.  Please clean
  * everything it's done up:  Including what it's added to the gui!
  * HINT:  You should have stored the gtk widgets you needed to delete them
  * later.
  */
void ___end(void *ignoreme)
{
  elog_thrd_exit(_lsn);
}
 /* ugly(void) is called when the program exits but your plugin is still loaded.
  * It means you don't need to bother cleaning up memory really:  the kernel should
  * handle that for you and we just want that derned window to get off the users
  * desk.  So clean up what you need, save what you love, and finish it quickly if 
  * you can.
  * HINT:  A few Global state variables won't destroy the world here ;). 
  */
void ___ugly(void *ignoreme)
{
  
}
 
/* char *info returns user-level information about what the plugin does.
 */
char *___info()
{
  return "CLI Integrator -- Makes eJourn work with your command interface using the `ejourn` command.  See ejourn -h or man ejourn for more information.";

} 
 
/* char *author returns the list of authors, please insert a \n after
 * each author for display purposes.
 */
char *___author()
{
  return "CLI Integration by Chris <MA_D> Hilton";
}



