#ifndef ACTIONS_H
#define ACTIONS_H

/* Why Me?
 *	actions.h exists as a state machine which tracks the current state of 
 *  the machine (what folder it's in and whatnot).  
 *  these actions update the current state. 
 *  this is the center of the behavior of this plugin!
 */


int lst_act_open_folder(char *folder);
//Pre:  the plugin is up and loaded (almost certainly handled)
//	:	folder should be the name of a folder in the currently opened folder.
//Post:  switches to that folder, updates the gui and needed vars.

int lst_act_open_file(char *file);
//Pre:  Same as folder reqs
//Post:  Opens this file within eJourn.


int lst_act_open_item(char *item);
//Pre:  See lst_act_open_folder
//Post:  This is a convenience func.  It checks if it's a file or folder and
//		makes the call for you.


int lst_act_initialize(char *dir);
//Pre:  This is the first func called.  dir should be something like:
//		char *dir;
//		elog_sp_cat(&dir, elog_journ_current()->settings->path, "/cat", NULL);
//Post:  Initializes everything, MAGIC!

#endif
