//LICENSE:  GPLv2

#include "gui_al.h"
#include "defines.h"


int lst_al_add_item(const char *name, int type, const char *fileName)
{
  GtkTreeIter iter;
  gtk_list_store_append(_plgn_lst_model, &iter);
  
  
  GError *error = NULL;
  GdkPixbufLoader *loader = gdk_pixbuf_loader_new();
  GdkPixbuf *icon;  
  
  if (type)
    {
      gdk_pixbuf_loader_write(loader, _plgn_img_page, _plgn_img_len_page, &error);
      icon = gdk_pixbuf_loader_get_pixbuf(loader);
    }
  else
    {
      gdk_pixbuf_loader_write(loader, _plgn_img_folder, _plgn_img_len_folder, &error);
      icon = gdk_pixbuf_loader_get_pixbuf(loader);
    }
  gdk_pixbuf_loader_close(loader, &error);
  
  gtk_list_store_set(_plgn_lst_model, &iter, 0, name, 1, icon, 2, fileName, -1);                                
  return 0;
}
int lst_al_clear()
{
  gtk_list_store_clear(_plgn_lst_model);
  return 0;
}

struct lst_clip_item *lst_al_selected()
{
  GtkTreePath *path;
  GtkCellRenderer *cell;
  if (gtk_icon_view_get_cursor(_plgn_icn, &path, &cell) == TRUE);
  {
    if (path)
      {
	struct lst_clip_item *item = malloc(sizeof *item);
	GtkTreeIter iter;
	gtk_tree_model_get_iter(GTK_TREE_MODEL(_plgn_lst_model), &iter, path);
	gtk_tree_model_get(GTK_TREE_MODEL(_plgn_lst_model), &iter, 0, &(item->name),2, &(item->loc) -1);
	return item;
      }
   }
 
  return NULL;  
}

