//LICENSE:  GPLv2


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)


void
on_open_activate                     (GtkMenuItem     *menuitem,
				      gpointer         user_data)
{
  lst_act_open_item(_icn_cur);
}
void
on_create_activate                     (GtkMenuItem     *menuitem,
					gpointer         user_data)
{
  create_lst_cat_dialog();
}

void
on_icn_list_item_activated             (GtkIconView     *iconview,
					GtkTreePath     *path,
					gpointer         user_data)
{
  lst_act_open_item(_icn_cur);
}


gboolean
on_icn_list_activate_cursor_item       (GtkIconView     *iconview,
					gpointer         user_data)
{
  printf("Item cursor activate\n");
  return FALSE;
}


void
on_icn_list_select_cursor_item         (GtkIconView     *iconview,
					gpointer         user_data)
{
  printf("Item selected\n");
}


void
on_icn_list_drag_begin                 (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gpointer         user_data)
{

}


void
on_icn_list_drag_data_delete           (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gpointer         user_data)
{

}


void
on_icn_list_drag_data_get              (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					GtkSelectionData *data,
					guint            info,
					guint            time,
					gpointer         user_data)
{

}


void
on_icn_list_drag_data_received         (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gint             x,
					gint             y,
					GtkSelectionData *data,
					guint            info,
					guint            time,
					gpointer         user_data)
{

}


gboolean
on_icn_list_drag_drop                  (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gint             x,
					gint             y,
					guint            time,
					gpointer         user_data)
{

  return FALSE;
}


void
on_icn_list_drag_end                   (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gpointer         user_data)
{

}


void
on_icn_list_drag_leave                 (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					guint            time,
					gpointer         user_data)
{

}


gboolean
on_icn_list_drag_motion                (GtkWidget       *widget,
					GdkDragContext  *drag_context,
					gint             x,
					gint             y,
					guint            time,
					gpointer         user_data)
{

  return FALSE;
}


gboolean
on_icn_list_button_release_event       (GtkWidget       *widget,
					GdkEventButton  *event,
					gpointer         user_data)
{
  printf("Item button release\n");
  return FALSE;
}


static gint
my_popup_handler (GtkWidget *widget, GdkEvent *event)
{
  GtkMenu *menu;
  GdkEventButton *event_button;

  g_return_val_if_fail (widget != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_MENU (widget), FALSE);
  g_return_val_if_fail (event != NULL, FALSE);

  /* The "widget" is the menu that was supplied when 
   * g_signal_connect_swapped() was called.
   */
  menu = GTK_MENU (widget);

  if (event->type == GDK_BUTTON_PRESS)
    {
      event_button = (GdkEventButton *) event;
      if (event_button->button == 1)
	{
	  GdkEventButton *button = (GdkEventButton *)event;
	  int x = (int)(button->x);
	  int y = (int)(button->y);
	  
	  GtkTreePath *path = gtk_icon_view_get_path_at_pos(_plgn_icn, x, y);
	  if (path)
	    {
	      if (_icn_cur)
		{
		  free(_icn_cur);
		  _icn_cur = NULL;
		}
	      GtkTreeIter iter;
	      gtk_tree_model_get_iter(GTK_TREE_MODEL(_plgn_lst_model), &iter, path);
	      gtk_tree_model_get(GTK_TREE_MODEL(_plgn_lst_model), &iter, 2, &_icn_cur, -1);
	    }
	}
      if (event_button->button == 3)
	{
	  GdkEventButton *button = (GdkEventButton *)event;
	  int x = (int)(button->x);
	  int y = (int)(button->y);

	  GtkTreePath *path = gtk_icon_view_get_path_at_pos(_plgn_icn, x, y);
	  if (path)
	    {
	      if (_icn_cur)
		{
		  free(_icn_cur);
		  _icn_cur = NULL;
		}
	      GtkTreeIter iter;
	      gtk_tree_model_get_iter(GTK_TREE_MODEL(_plgn_lst_model), &iter, path);
	      gtk_tree_model_get(GTK_TREE_MODEL(_plgn_lst_model), &iter, 2, &_icn_cur, -1);
	      gtk_menu_popup(GTK_MENU(_icn_menu), NULL, NULL, NULL, NULL, event_button->button, event_button->time);
	      //I need to make a menu to popup!
	    }
	  else
	    gtk_menu_popup (menu, NULL, NULL, NULL, NULL, 
			    event_button->button, event_button->time);
	  return TRUE;
	}
    }

  return FALSE;
}


GtkWidget*
create_window1 (void)
{
  GtkWidget *notebook1 = _notebook;
  GtkWidget *hbox1;
  GtkWidget *icn_list;
  GtkWidget *label1;



  main_widget = hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (notebook1), hbox1);

  icn_list = gtk_icon_view_new ();
  gtk_widget_show (icn_list);
  gtk_box_pack_start (GTK_BOX (hbox1), icn_list, TRUE, TRUE, 0);
  gtk_icon_view_set_selection_mode (GTK_ICON_VIEW (icn_list), GTK_SELECTION_BROWSE);
  gtk_icon_view_set_orientation (GTK_ICON_VIEW (icn_list), GTK_ORIENTATION_VERTICAL);
  gtk_icon_view_set_item_width(GTK_ICON_VIEW(icn_list), 96);

  label1 = gtk_label_new (" Organizer ");
  gtk_widget_show (label1);

  gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), _plgn_page), label1);


  GtkWidget *menu = gtk_menu_new();
  GtkWidget *create = gtk_menu_item_new_with_label("Create Category");
  gtk_menu_attach(GTK_MENU(menu), create, 0, 1, 2, 3);
  gtk_widget_show(create);


  _icn_menu = gtk_menu_new();
  GtkWidget *open = gtk_menu_item_new_with_label("Open");
  gtk_menu_attach(GTK_MENU(_icn_menu), open, 0, 1, 2, 3);
  gtk_widget_show(open);


  g_signal_connect((gpointer) open, "button-press-event",
		   G_CALLBACK(on_open_activate),
		   NULL);

  g_signal_connect((gpointer) create, "button-press-event",
		   G_CALLBACK(on_create_activate),
		   NULL);

  g_signal_connect ((gpointer) icn_list, "item_activated",
		    G_CALLBACK (on_icn_list_item_activated),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "activate_cursor_item",
		    G_CALLBACK (on_icn_list_activate_cursor_item),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "select_cursor_item",
		    G_CALLBACK (on_icn_list_select_cursor_item),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_begin",
		    G_CALLBACK (on_icn_list_drag_begin),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_data_delete",
		    G_CALLBACK (on_icn_list_drag_data_delete),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_data_get",
		    G_CALLBACK (on_icn_list_drag_data_get),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_data_received",
		    G_CALLBACK (on_icn_list_drag_data_received),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_drop",
		    G_CALLBACK (on_icn_list_drag_drop),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_end",
		    G_CALLBACK (on_icn_list_drag_end),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_end",
		    G_CALLBACK (on_icn_list_drag_end),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_leave",
		    G_CALLBACK (on_icn_list_drag_leave),
		    NULL);
  g_signal_connect ((gpointer) icn_list, "drag_motion",
		    G_CALLBACK (on_icn_list_drag_motion),
		    NULL);
  /*  g_signal_connect_swapped ((gpointer) icn_list, "button_release_event",
      G_CALLBACK (my_popup_handler),
      menu);*/

  g_signal_connect_swapped (icn_list, "button_press_event",
			    G_CALLBACK (my_popup_handler), 
			    menu);

  

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (hbox1, hbox1, "hbox1");
  GLADE_HOOKUP_OBJECT (hbox1, icn_list, "icn_list");
  GLADE_HOOKUP_OBJECT (hbox1, label1, "label1");

 
  _plgn_icn = (GtkIconView *)icn_list;
 
  _plgn_lst_model = gtk_list_store_new(3, G_TYPE_STRING, GDK_TYPE_PIXBUF, G_TYPE_STRING);

  gtk_icon_view_set_model(GTK_ICON_VIEW(icn_list), GTK_TREE_MODEL(_plgn_lst_model));
  
  gtk_icon_view_set_text_column(GTK_ICON_VIEW(icn_list), 0);
  gtk_icon_view_set_pixbuf_column(GTK_ICON_VIEW(icn_list), 1);


  elog_sp_cat(&_plgn_path, elog_journ_current()->settings->path, "/cat/", NULL);

  
  return hbox1;
}
