/* AUTHOR:  Chris <MA_D> Hilton
 * PURPOSE:  a organizer plugin for eJourn
 * LICENSE:  GPLv2
 */

/*  FILE GUIDE:
 *  lst_plugin.c:  The file that takes the callbacks from eJourn
 *  actions.c:  Ths file that centralizes things like opening folders.
 *  gui_al.c:  Abstracts gtk calls.
 *  interface.c:  Builds the interface.  Also contains callbacks.
 *  All are presently build as one big source file. 
 *  Presently, as 1268 lines of code, this is ok.  But it's starting
 *  to become annoying even now for design purposes.
 *  All files are licensed under the GPL
 */


#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>


#include "defines.h"

#include "../../gui_al.h"
#include "../../plugins.h"
#include "../../journal.h"
#include "../../xml.h"
#include "../../io.h"
#include "../../prefix.h"
#include "../../tabs.h"



struct lst_clip_item *_lst_clipboard_item = NULL;


GtkIconView *_plgn_icn;
GtkListStore *_plgn_lst_model;

GtkWidget *_icn_menu;




GtkWidget *main_widget;


char *_plgn_folder_root = NULL;
char *_plgn_folder_cur = NULL;
char *_icn_cur; //guaranteed to be the selected icn
//when _icn_menu is displayed!


char *_plgn_path = NULL;

int _plgn_page;
char *_plgn_name;

void *_plgn_img_page=NULL;
void *_plgn_img_folder=NULL;
unsigned int _plgn_img_len_page=0;
unsigned int _plgn_img_len_folder=0;

#include "gui_al.c"
#include "actions.c"
#include "wizard.c"
#include "interface.c"



/*End gui stuff*/



/*Begin ejourn code:*/

/*  Compiling this file:
 *  gcc -shared -o modules/plgn_example.so -L. -lejourn modules/plgn_example.c
 *  The -shared is to make it loadable dynamically, and -L. -lejourn is to tell
 *  it to dynamically load the ejourn libraries.
 */


/* open(doc) is called each time a file is opened for the gui; not necessarily each
 * time it is opened period (that'd be quite silly and impossible).
 * doc is the same data as the program uses, it is the raw char of the file.
 * It can be accessed with elog_xml_scanf
 */
void ___open(struct elog_plgn_data_io *doc)
{

}
 /* save(doc,txt) is called on save events in the application.
  * Feel free to change the data, your changes will be saved.
  * It is recommended that you only use this to add to the data
  * and never remove from it.  Use elog_xml_printf to save to doc.
 */
void  ___save(struct elog_plgn_data_io *doc)
{

}
 
 /* init(gui) is called when the plugin is loaded.
  * gui will be NULL;
 */
void  ___init(char *name) //add in the gui struct once you've made it.
{
  elog_sp_cat(&_plgn_name, name, NULL);
  _plgn_page = elog_tab_register(name);

  create_window1();
  //tab created.



  lst_act_initialize(elog_journ_current()->settings->path);


}
 
/* end(void) is called when the program unloads your plugin.  Please clean
 * everything it's done up:  Including what it's added to the gui!
 * HINT:  You should have stored the gtk widgets you needed to delete them
 * later.
 */
void ___end(void *ignoreme)
{
  printf("Plugin was unloaded\n");
  gtk_widget_destroy(main_widget);
  elog_tab_unregister(_plgn_page);
}
/* ugly(void) is called when the program exits but your plugin is still loaded.
 * It means you don't need to bother cleaning up memory really:  the kernel should
 * handle that for you and we just want that derned window to get off the users
 * desk.  So clean up what you need, save what you love, and finish it quickly if 
 * you can.
 * HINT:  A few Global state variables won't destroy the world here ;). 
 */
void ___ugly(void *ignoreme)
{
  printf("Plugin saw that program closed.\n");
}
 
/* char *info returns user-level information about what the plugin does.
 */
char *___info()
{
  return "This plugin is not working, it was accidentally left in the makefile, sorry!";

} 
 
/* char *author returns the list of authors, please insert a \n after
 * each author for display purposes.
 */
char *___author()
{
  return "Chris <MA_D> Hilton";
}
/* journChange(char*) is called when a new journal load function happens, it is called at the
 * end of this function.  It is sent the name of the new journal, and of course you can use
 * elog_journ_current()-> to access its members since it's already loaded.
 */
void ___journChange(struct elog_plgn_data_journ *name)
{
  lst_act_initialize(elog_journ_current()->settings->path);
}
 
/* search(char*) is called when a search occurs.  You are sent the term that was searched for
 * immediately when the search is called:  So it may not yet be finished; in fact assume it 
 * hasn't even started yet!
 */
void ___search(struct elog_plgn_data_srch *term)
{

}

void ___cut(void *ignoreme)
{
  if (_lst_clipboard_item)
    {
      if (_lst_clipboard_item->name)
	free(_lst_clipboard_item->name);
      if (_lst_clipboard_item->loc)
	free(_lst_clipboard_item->loc);
      free(_lst_clipboard_item);
    }
  _lst_clipboard_item = malloc(sizeof *_lst_clipboard_item);
  

}
void ___copy(void *ignoreme)
{
  printf("lst_plugin.so:  Called copy\n");
}

void ___paste(void *ignoreme)
{
  printf("lst_plugin.so:  Called paste\n");
}

void ___focus(void *ignoreme)
{

}
void ___back(void *ignoreme)
{

}
void ___fwrd(void *ignoreme)
{

}

