#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include "../../error.h"


GtkWidget *_lst_cat_diag_viewport;

int _lst_cat_diag_mode = 0; //1 for dyamic, 0 for free form.


GtkEntry *_lst_cat_diag_search_text;
int _lst_cat_diag_lyrics;
int _lst_cat_diag_code;
GtkEntry *_lst_cat_folder_name;


void
on_wzrd_ok_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  const char *srch_text = (const char *)
    gtk_entry_get_text(_lst_cat_diag_search_text);
  const char *folderName = (const char *)
    gtk_entry_get_text(_lst_cat_folder_name);

  if (!(folderName[0]))
    {
      elog_wrn_ask("You didn't provide a name for the folder.",
		 ELOG_WRN_ASK_OKONLY);
      return;
    }

  if (_lst_cat_diag_mode)
    { //dynamic
      char *xml = elog_xml_start("<folder>", 32768);
      elog_xml_printf(xml, "<folder>.%s", "<type>", "0");
      if (srch_text[0])
	elog_xml_printf(xml, "<folder>.%s", "<term>", srch_text);
      char *lyric = elog_sp_shortToString(_lst_cat_diag_lyrics);
      elog_xml_printf(xml, "<folder>.%s", "<lyric>", lyric);
      free(lyric);
      char *code = elog_sp_shortToString(_lst_cat_diag_code);
      elog_xml_printf(xml, "<folder>.%s", "<code>", code);
      free(code);
     
      char *path;
      elog_sp_cat(&path, _plgn_folder_cur, "/", folderName, NULL);
      if (elog_io_mkdir(path))
	elog_err_print_console("Problem making directory...maybe it was already there?\n");
      char *fullPath;
      elog_sp_cat(&fullPath, path, "/folder.xml", NULL);
      free(path);
      struct elog_io_file *f = elog_io_initialize(fullPath, ELOG_IO_WRITE);
      if (f)
	{
	  elog_io_writeLine(f, xml, 0); 
	  elog_io_close(f);
	}
      else
	{
	  char *msg;
	  elog_sp_cat(&msg, "Error: Unable to open file: \n", fullPath, "\n for writing!");
	  elog_err_print(msg);
	}
      lst_act_refresh();

      free(xml);
    }
  else
    {//free form
     
    }

  gtk_widget_destroy((GtkWidget *)user_data);
  gtk_main_quit();
}
void
on_wzrd_cancel_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy((GtkWidget *)user_data);
  gtk_main_quit();
}

void on_wzrd_main_toggle (GtkToggleButton *togglebutton,
			  gpointer user_data)
{
  if (gtk_toggle_button_get_active(togglebutton) == TRUE)
    { //free form
      _lst_cat_diag_mode = 0;
      gtk_widget_set_sensitive(_lst_cat_diag_viewport, FALSE);
    }
  else
    { //dynamic
      _lst_cat_diag_mode = 1;
      gtk_widget_set_sensitive(_lst_cat_diag_viewport, TRUE);
    }

}

void on_wzrd_code_toggle       (GtkToggleButton *togglebutton,
				gpointer user_data)
{
  if (gtk_toggle_button_get_active(togglebutton) == TRUE)
    _lst_cat_diag_code = 1;
  else 
    _lst_cat_diag_code = 0;
}
void on_wzrd_lyric_toggle       (GtkToggleButton *togglebutton,
				gpointer user_data)
{
  if (gtk_toggle_button_get_active(togglebutton) == TRUE)
    _lst_cat_diag_lyrics = 1;
  else 
    _lst_cat_diag_lyrics = 0;
}
void on_wzrd_srch_toggle       (GtkToggleButton *togglebutton,
				gpointer user_data)
{
  if (gtk_toggle_button_get_active(togglebutton) == TRUE)
    gtk_widget_set_sensitive((GtkWidget *)user_data, TRUE);
  else 
    gtk_widget_set_sensitive((GtkWidget *)user_data, FALSE);
}
gboolean        on_wzrd_srch_keyword                 (GtkWidget *widget,
						  GdkEventButton *event,
						  gpointer user_data)
{
  printf("Keyword:%s\n", gtk_entry_get_text(GTK_ENTRY(widget)));
  return FALSE;
}



GtkWidget* create_lst_cat_dialog (void)
{
  GtkWidget *lst_cat_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *label1;
  GtkWidget *vbox3;
  GtkWidget *lst_cat_rad_free;
  GSList *lst_cat_rad_free_group = NULL;
  GtkWidget *lst_cat_rad_dynamic;
  GtkWidget *viewport1;
  GtkWidget *vbox4;
  GtkWidget *lst_cat_poet;
  GtkWidget *lst_cat_code;
  GtkWidget *hbox1;
  GtkWidget *lst_cat_srch;
  GtkWidget *lst_cat_srch_entry;
  //  GtkWidget *checkbutton6;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
  GtkWidget *foldName;
  GtkWidget *label;

  lst_cat_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (lst_cat_dialog), "eJourn::Create New Category");
  gtk_window_set_type_hint (GTK_WINDOW (lst_cat_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);



  dialog_vbox1 = GTK_DIALOG (lst_cat_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  label1 = gtk_label_new ("Create a Category:");
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (vbox1), label1, FALSE, FALSE, 0);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  gtk_box_pack_start (GTK_BOX (vbox1), vbox3, TRUE, TRUE, 0);

  lst_cat_rad_free = gtk_radio_button_new_with_mnemonic (NULL, "Free Form Category");
  gtk_widget_show (lst_cat_rad_free);
  gtk_box_pack_start (GTK_BOX (vbox3), lst_cat_rad_free, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (lst_cat_rad_free), lst_cat_rad_free_group);
  lst_cat_rad_free_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (lst_cat_rad_free));

  lst_cat_rad_dynamic = gtk_radio_button_new_with_mnemonic (NULL, "Dynamic Category");
  gtk_widget_show (lst_cat_rad_dynamic);
  gtk_box_pack_start (GTK_BOX (vbox3), lst_cat_rad_dynamic, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (lst_cat_rad_dynamic), lst_cat_rad_free_group);
  lst_cat_rad_free_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (lst_cat_rad_dynamic));

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (viewport1), 10);
  gtk_widget_set_sensitive (viewport1, FALSE);

  //  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  //  gtk_widget_show (scrolledwindow3);
  //  gtk_container_add (GTK_CONTAINER (viewport1), scrolledwindow3);
  //  gtk_widget_set_sensitive (scrolledwindow3, FALSE);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  gtk_container_add (GTK_CONTAINER (viewport1), vbox4);

  lst_cat_poet = gtk_check_button_new_with_mnemonic ("Entries that contain poetry....");
  gtk_widget_show (lst_cat_poet);
  gtk_box_pack_start (GTK_BOX (vbox4), lst_cat_poet, FALSE, FALSE, 0);

  lst_cat_code = gtk_check_button_new_with_mnemonic ("Entries that contain code....");
  gtk_widget_show (lst_cat_code);
  gtk_box_pack_start (GTK_BOX (vbox4), lst_cat_code, FALSE, FALSE, 0);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox4), hbox1, FALSE, FALSE, 0);

  lst_cat_srch = gtk_check_button_new_with_mnemonic ("Search:  ");
  gtk_widget_show (lst_cat_srch);
  gtk_box_pack_start (GTK_BOX (hbox1), lst_cat_srch, FALSE, FALSE, 0);

  lst_cat_srch_entry = gtk_entry_new ();
  gtk_widget_show (lst_cat_srch_entry);
  gtk_box_pack_start (GTK_BOX (hbox1), lst_cat_srch_entry, TRUE, TRUE, 0);
  gtk_widget_set_sensitive(lst_cat_srch_entry, FALSE);


  /*  checkbutton6 = gtk_check_button_new_with_mnemonic ("checkbutton6");
  gtk_widget_show (checkbutton6);
  gtk_box_pack_start (GTK_BOX (vbox4), checkbutton6, FALSE, FALSE, 0);
  */

  GtkWidget *hbox2 = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(hbox2);
  gtk_box_pack_start(GTK_BOX (vbox1), hbox2, FALSE, FALSE, 0);

  label = gtk_label_new("Folder Name:");
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 0);

  foldName = gtk_entry_new();
  gtk_widget_show(foldName);
  gtk_box_pack_start(GTK_BOX(hbox2), foldName, FALSE, FALSE, 0);


  dialog_action_area1 = GTK_DIALOG (lst_cat_dialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (lst_cat_dialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (lst_cat_dialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) cancelbutton1, "activate",
                    G_CALLBACK (on_wzrd_cancel_clicked),
                    lst_cat_dialog);
  g_signal_connect ((gpointer) cancelbutton1, "clicked",
                    G_CALLBACK (on_wzrd_cancel_clicked),
                    lst_cat_dialog);
  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_wzrd_ok_clicked),
                    lst_cat_dialog);
  g_signal_connect ((gpointer) okbutton1, "activate",
                    G_CALLBACK (on_wzrd_ok_clicked),
                    lst_cat_dialog);


  g_signal_connect ((gpointer) lst_cat_rad_free, "toggled",
                    G_CALLBACK (on_wzrd_main_toggle),
                    NULL);


  g_signal_connect ((gpointer) lst_cat_code, "toggled",
                    G_CALLBACK (on_wzrd_code_toggle),
                    NULL);

  g_signal_connect ((gpointer) lst_cat_poet, "toggled",
                    G_CALLBACK (on_wzrd_lyric_toggle),
                    NULL);

  g_signal_connect ((gpointer) lst_cat_srch, "toggled",
                    G_CALLBACK (on_wzrd_srch_toggle),
                    lst_cat_srch_entry);


  _lst_cat_diag_viewport = viewport1;

  _lst_cat_diag_search_text = (GtkEntry *)lst_cat_srch_entry;
  _lst_cat_folder_name = (GtkEntry *)foldName;

  gtk_widget_show_all( lst_cat_dialog);
  gtk_main();
  return NULL;
}

