#include <stdlib.h>
#include <stdio.h>
#include "../plugins.h"
#include "../gui_al.h"
#include "../journal.h"
#include "../defines.h"
#include "../gui_io.h"
#include "../journ_wzrd.h"
#include "../defines.h"
#include "../search.h"
#include "../second.h"
#include <gtk/gtk.h>


/* All of the functions contained in this example file exist as a template for you
 * to develop your plugin modules from.
 * The plugins system works by calling your plugin at specific times during the 
 * application.
 * These times are conveniently labeled with their respective functions, those
 * function names cannot be changed. *  
 * You should be fine adding functions, but unless you call them they will not
 * be called.
 * Feel free to add global variables.
 * 
 * Unless told otherwise, most data passed in is protected.  Don't change it
 * if you value your life, err I mean program stability.
 * Don't depend on it either, it may change: plugins don't exist to change
 * program behaviour so don't try.  They add.
 */


/*  Compiling this file:
 *  gcc -shared -o modules/plgn_example.so -L. -lejourn modules/plgn_example.c
 *  The -shared is to make it loadable dynamically, and -L. -lejourn is to tell
 *  it to dynamically load the ejourn libraries.
 */

GtkWidget *menu_journ_menu;
GtkWidget *__destroy_later;

/*Callbacks:*/
void on_item_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	if (elog_gui_io_save() > 1) {
		elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
		return;		//couldn't save, and not cause it was blank.
	}




	elog_journ_save();
	if (elog_journ_load((char *) user_data)) {
		elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
		return;
	}
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


void on_create_activate(GtkMenuItem * menuitem, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	printf("Create implemented!\n");
	char *name = create_dialog();
	if (name) {
		printf("Name:%s\n", name);
		printf("Path:%s\n", elog_journ_current()->settings->path);
		printf("Enc:%s\n",
		       elog_journ_current()->settings->encryption);

		GtkWidget *item = gtk_menu_item_new_with_mnemonic(name);
		gtk_widget_show(item);
		gtk_container_add(GTK_CONTAINER(menu_journ_menu), item);
		g_signal_connect((gpointer) item, "activate",
				 G_CALLBACK(on_item_activate), name);
	}
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}


/***************/




 /* init(gui) is called when the plugin is loaded.
  * gui will be NULL;
  */
void ___init(void *ignoreme)	//add in the gui struct once you've made it.
{
	GtkWidget *menu_journal =
	    gtk_menu_item_new_with_mnemonic("Journals");
	gtk_widget_show(menu_journal);
	gtk_container_add(GTK_CONTAINER(_mainMenuBar), menu_journal);

	__destroy_later = menu_journal;

	menu_journ_menu = gtk_menu_new();
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_journal),
				  menu_journ_menu);

	GtkWidget *new_journal =
	    gtk_menu_item_new_with_mnemonic("Create New Journal");
	gtk_widget_show(new_journal);
	gtk_container_add(GTK_CONTAINER(menu_journ_menu), new_journal);

	GtkWidget *sep = gtk_separator_menu_item_new();
	gtk_widget_show(sep);
	gtk_container_add(GTK_CONTAINER(menu_journ_menu), sep);


	g_signal_connect((gpointer) new_journal, "activate",
			 G_CALLBACK(on_create_activate), NULL);

	char *fileName;
	elog_sp_cat(&fileName, getenv("HOME"), "/", _ELOG_CONFIG,
		    "journals.conf", NULL);
	//elog_journ_initialize(fileName);

	char **list = elog_journ_list();
	if (list != NULL) {
		int c;
		for (c = 0; list[c] != NULL; ++c) {
			GtkWidget *item =
			    gtk_menu_item_new_with_mnemonic(list[c]);
			gtk_widget_show(item);
			gtk_container_add(GTK_CONTAINER(menu_journ_menu),
					  item);
			g_signal_connect((gpointer) item, "activate",
					 G_CALLBACK(on_item_activate),
					 list[c]);
		}
		free(list);
	}
	elog_journ_set(elog_set_get_str("path"));

	char *title;
	elog_sp_cat(&title, _ELOG_NAME, "::", elog_journ_current()->name,
		    NULL);

	gtk_window_set_title(GTK_WINDOW(_mainWindow), (gchar *) title);
	free(title);
}

 /* end(void) is called when the program unloads your plugin.  Please clean
  * everything it's done up:  Including what it's added to the gui!
  * HINT:  You should have stored the gtk widgets you needed to delete them
  * later.
  */
void ___end(void *ignoreme)
{
	gtk_widget_destroy(__destroy_later);
}

 /* ugly(void) is called when the program exits but your plugin is still loaded.
  * It means you don't need to bother cleaning up memory really:  the kernel should
  * handle that for you and we just want that derned window to get off the users
  * desk.  So clean up what you need, save what you love, and finish it quickly if 
  * you can.
  * HINT:  A few Global state variables won't destroy the world here ;). 
  */
void ___ugly(void *ignoreme)
{

}

/* char *info returns user-level information about what the plugin does.
 */
char *___info()
{
	return
	    "Multiple Journals -- Allows use of multiple seperate journals!";

}

/* char *author returns the list of authors, please insert a \n after
 * each author for display purposes.
 */
char *___author()
{
	return "Multiple Journals by Chris <MA_D> Hilton";
}
