/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>



#include "../gui_al.h"
#include "../plugins.h"
#include "../journal.h"
#include "../xml.h"
#include "../io.h"
#include "../prefix.h"
#include "../tabs.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

void
on_cal_day_selected_tool                    (GtkCalendar     *calendar,
                                        gpointer         user_data)
{

}


void
on_cal_month_changed_tool                   (GtkCalendar     *calendar,
                                        gpointer         user_data)
{
  
}


gboolean    on_calendar_select      (GtkWidget *widget,
                                            gpointer user_data)
{
  return FALSE; 
}

struct word
{
  char **word;
  //set so that word[0] is the word
  //and word[1] is the reply.
  //this is to avoid a char *** type.
};

struct msg_set
{//this exists to keep a set of message types.
  int rank;
  int num_words;
  struct word **words;
};


struct msg_set *_pronouns;
struct msg_set *_nouns;
struct msg_set *_verbs;

unsigned int _msgid = 0;


struct sentence
{
  char *sent;
  char **words;
};

struct sentence *_sentence_new()
{
  return malloc(sizeof (struct sentence));

}
void _sentence_free(struct sentence *dat)
{
  free(dat->sent);
  elog_sp_ArrFree(dat->words);
  free(dat);
}

//breaks up a string into sentences and words
struct sentence *__get_lex(const char *txt)
{
  int len = strlen(txt);
  if (len < 3)
    return NULL;
  int c;
  for (c=len-1; txt[c] != '.'
	 && txt[c] != '?'
	 && txt[c] != '!'
	 && txt[c] != ':'
	 && txt[c] != '\n'; --c) ;
  ++c;

  struct sentence *ret = _sentence_new();
  elog_sp_cat(&(ret->sent), &(txt[c]), NULL);
  ret->words = elog_sp_breakToArr(ret->sent, ' ');


 
  return ret;
}

int __search(char *word, struct msg_set *set)
{
  int res;
  int i;
  int s,e;
  s = 0;
  e = set->num_words-1;
  

  res = -1;
  while (s < e)
    {
      int cmp = strcmp(set->words[(e+s)/2]->word[0], word);
      if (cmp == 0)
	{
	  res = (e+s)/2;
	  break;
	}
      else if (cmp > 0)
	e = (e+s)/2;
      else
	s = (e+s)/2;
      
      
      if (1 == e-s)
	{
	  if (strcmp(set->words[e]->word[0], word) == 0)
	    {
	      res = e;
	      break;
	    }
	  else if (strcmp(set->words[s]->word[0], word) == 0)
	    {
	      res = s;
	      break;
	    }
	  else
	    break;
	}
      
    }
    
  return res;
}



char *__analyze(struct sentence *sents)
{
  char *ret;
  int verb=-1;
  int c=0;

  while (sents->words[c])
    {
      if ((verb = __search(sents->words[c], _verbs)) != -1)
	break;
      ++c;
    }
  

  int j=0;
  int subject = -1;

  while (j < c && (subject = __search(sents->words[j], _pronouns)) == -1)
    ++j;

  struct word *subj = NULL;
  if (subject == -1)
    {
      int j=0;
      int subject = -1;
      while (j < c && (subject = __search(sents->words[j], _nouns)) == -1)
	++j;
      if (subject > -1)
	subj = _nouns->words[subject];
    }
  else
    subj = _pronouns->words[subject];

  if (subj && verb > -1)
    {
      elog_sp_cat(&ret, subj->word[1], " ", _verbs->words[verb]->word[1], NULL);
    }
  else
    elog_sp_cat(&ret, "What are you blithering on about now?", NULL);
  
  return ret;
}


struct msg_set *__load(char *name)
{
  char *path;
  elog_sp_cat(&path, PLGN_DATADIR, "/ejourn/dict/", name, NULL);
  struct elog_io_file *f = elog_io_initialize(path, ELOG_IO_READ);
  if (f)
    {

      int len;
      char *dat = elog_io_readRestofFile(f, &len);
      
      elog_io_close(f);
      free(path);
      
      dat[len] = '\0'; 
      char **sets = elog_sp_breakToArr(dat, '\n');
      int c;
      for (c=0; sets[c]; ++c)
	; //intentional
      
      struct msg_set *nouns = malloc((sizeof *nouns));
      nouns->words = malloc((sizeof *nouns) * (c+1));
      for (c=0; sets[c]; ++c)
	{
	  nouns->words[c] = malloc(sizeof *(nouns->words[c]));
	  nouns->words[c]->word = elog_sp_breakToArr(sets[c], ':');
	}
      nouns->words[c] = NULL;
      nouns->num_words = c;
      
      elog_sp_ArrFree(sets);
      
      free(dat);
      return nouns;
    }
  return NULL;
}


/*Begin ejourn code:*/

/* All of the functions contained in this example file exist as a template for you
 * to develop your plugin modules from.
 * The plugins system works by calling your plugin at specific times during the 
 * application.
 * These times are conveniently labeled with their respective functions, those
 * function names cannot be changed. *  
 * You should be fine adding functions, but unless you call them they will not
 * be called.
 * Feel free to add global variables.
 * 
 * Unless told otherwise, most data passed in is protected.  Don't change it
 * if you value your life, err I mean program stability.
 * Don't depend on it either, it may change: plugins don't exist to change
 * program behaviour so don't try.  They add.
 */


/*  Compiling this file:
 *  gcc -shared -o modules/plgn_example.so -L. -lejourn modules/plgn_example.c
 *  The -shared is to make it loadable dynamically, and -L. -lejourn is to tell
 *  it to dynamically load the ejourn libraries.
 */


/* open(doc) is called each time a file is opened for the gui; not necessarily each
 * time it is opened period (that'd be quite silly and impossible).
 * doc is the same data as the program uses, it is the raw char of the file.
 * It can be accessed with elog_xml_scanf
 */
void ___open(struct elog_plgn_data_io *doc)
{
  if (_msgid)
    elog_gui_al_pop_status(_msgid);
  _msgid = 0;
}
 /* save(doc,txt) is called on save events in the application.
  * Feel free to change the data, your changes will be saved.
  * It is recommended that you only use this to add to the data
  * and never remove from it.  Use elog_xml_printf to save to doc.
  */
void  ___save(struct elog_plgn_data_io *doc)
{
  struct sentence *txt = __get_lex(doc->doc->text);
  if (txt)
    {
  
      char *result = __analyze(txt);
      
      if (_msgid)
	{
	  elog_gui_al_pop_status(_msgid);
	}
      
      _msgid = elog_gui_al_push_status(result);
      
      
      _sentence_free(txt);
    }
}
 
 /* init(gui) is called when the plugin is loaded.
  * gui will be NULL;
  */
void  ___init(char *name) //add in the gui struct once you've made it.
{
  _nouns = __load("nouns.dict");
  _pronouns = __load("pronoun.dict");
  _verbs = __load("verbs.dict");

}
 
 /* end(void) is called when the program unloads your plugin.  Please clean
  * everything it's done up:  Including what it's added to the gui!
  * HINT:  You should have stored the gtk widgets you needed to delete them
  * later.
  */
void ___end(void *ignoreme)
{
  int c;
  for (c=0; _nouns->words[c]; ++c)
    {
      elog_sp_ArrFree(_nouns->words[c]->word);
      free(_nouns->words[c]);
    }
  free(_nouns->words);
  free(_nouns);
  for (c=0; _pronouns->words[c]; ++c)
    {
      elog_sp_ArrFree(_pronouns->words[c]->word);
      free(_pronouns->words[c]);
    }
  free(_pronouns->words);
  free(_pronouns);
  for (c=0; _verbs->words[c]; ++c)
    {
      elog_sp_ArrFree(_verbs->words[c]->word);
      free(_verbs->words[c]);
    }
  free(_pronouns->words);
  free(_verbs);
  if (_msgid)
    elog_gui_al_pop_status(_msgid);
}
 /* ugly(void) is called when the program exits but your plugin is still loaded.
  * It means you don't need to bother cleaning up memory really:  the kernel should
  * handle that for you and we just want that derned window to get off the users
  * desk.  So clean up what you need, save what you love, and finish it quickly if 
  * you can.
  * HINT:  A few Global state variables won't destroy the world here ;). 
  */
void ___ugly(void *ignoreme)
{

}
 
/* char *info returns user-level information about what the plugin does.
 */
char *___info()
{
  return "The Doctor -- Adds a status bar sentence while you journal";

} 
 
/* char *author returns the list of authors, please insert a \n after
 * each author for display purposes.
 */
char *___author()
{
  return "Chris <MA_D> Hilton";
}
 /* journChange(char*) is called when a new journal load function happens, it is called at the
 * end of this function.  It is sent the name of the new journal, and of course you can use
 * elog_journ_current()-> to access its members since it's already loaded.
 */
void ___journChange(struct elog_plgn_data_journ *name)
{

}
 

