#include "months.h"
#include <stdlib.h>

char **_months = NULL;

void elog_mnth_init()
{
	_months = malloc((sizeof *_months) * 13);
	elog_sp_cat(&(_months[0]), "January", NULL);
	elog_sp_cat(&(_months[1]), "February", NULL);
	elog_sp_cat(&(_months[2]), "March", NULL);
	elog_sp_cat(&(_months[3]), "April", NULL);
	elog_sp_cat(&(_months[4]), "May", NULL);
	elog_sp_cat(&(_months[5]), "June", NULL);
	elog_sp_cat(&(_months[6]), "July", NULL);
	elog_sp_cat(&(_months[7]), "August", NULL);
	elog_sp_cat(&(_months[8]), "September", NULL);
	elog_sp_cat(&(_months[9]), "October", NULL);
	elog_sp_cat(&(_months[10]), "November", NULL);
	elog_sp_cat(&(_months[11]), "December", NULL);
	elog_sp_cat(&(_months[12]), "No Month", NULL);
}


const char *elog_mnth_str(int n)
{
	if (n > 11 || n < 0)
		return _months[12];
	return _months[n];
}

int elog_mnth_int(const char *month)
{
	//You're about to read a very confusticated code that just does a search for the month entered.
	//I could do one of three things:
	/*
	   1.)  Do a linear search of the defined str array.  SLOW!
	   2.)  Make another array that's sorted  and search.  Moderate.
	   3.)  Do a set of switches to hash which plays on me knowing the array data.  Complexity 2
	   - However, I have to make sure that month is "english", so it will have to be translated..

	   I chose 3 because it's a bit quicker.  I mean, we're talking about 2 verses 4 iterations...  Besides, this 
	   isn't that confusing once you realize what it's doing!
	 */
	switch (month[0]) {
	case 'J':
		{
			switch (month[3]) {
			case 'u':
				{
					return 0;	//January
					break;
				}
			case 'e':
				{
					return 5;	//June
					break;
				}
			case 'y':
				{
					return 6;	//July
					break;
				}
				break;
			}
		}
	case 'F':
		{
			return 1;	//February
			break;
		}
	case 'M':
		{
			switch (month[2]) {
			case 'r':
				{
					return 2;	//March
					break;
				}
			case 'y':
				{
					return 4;	//May
					break;
				}
			}

			break;
		}
	case 'A':
		{
			switch (month[1]) {
			case 'p':
				{
					return 3;	//April
					break;
				}
			case 'u':
				{
					return 7;	//August
					break;
				}
			}
			break;
		}
	case 'S':
		{
			return 8;	//September 
			break;
		}
	case 'N':
		{
			return 10;	//Author's birth month!
			break;
		}
	case 'O':
		{
			return 9;	//October
			break;
		}
	case 'D':
		{
			return 11;	//December
			break;
		}
	}
	return 0;
}

const char *elog_mnth_day(int day)
{
	if (day <= 20 && day >= 4)
		return "th";
	int last = day % 10;

	switch (last) {
	case 1:
		return "st";
	case 2:
		return "nd";
	case 3:
		return "rd";
	}
	return "th";

}
