#ifndef _PLUGINS_H_
#define _PLUGINS_H_


#include <stdlib.h>
#include <stdio.h>

#include "prefix.h"
#include "defines.h"
#include "simple.h"
#include "io.h"


/*symbol ints*/
#define ELOG_PLGN_SYM_INIT 0
#define ELOG_PLGN_SYM_UGLY 1
#define ELOG_PLGN_SYM_END 2
#define ELOG_PLGN_SYM_CUT 3
#define ELOG_PLGN_SYM_COPY 4
#define ELOG_PLGN_SYM_PASTE 5
#define ELOG_PLGN_SYM_OPEN 6
#define ELOG_PLGN_SYM_SAVE 7
#define ELOG_PLGN_SYM_INFO 8
#define ELOG_PLGN_SYM_AUTHOR 9
#define ELOG_PLGN_SYM_JOURNCHANGE 10
#define ELOG_PLGN_SYM_FOCUS 11
#define ELOG_PLGN_SYM_TAB 12
#define ELOG_PLGN_SYM_DELETE 13
#define ELOG_PLGN_SYM_BACK 14
#define ELOG_PLGN_SYM_FWD 15
#define ELOG_PLGN_SYM_UNDO 16
#define ELOG_PLGN_SYM_REDO 17
#define ELOG_PLGN_SYM_SRCH 18
#define ELOG_PLGN_SYM_RES 19

/*Here are the prefixes you MUST use in plugins:*/

#define PLGN_DATADIR elog_plgn_prefix_DATADIR()
const char *elog_plgn_prefix_DATADIR();


/************************/

struct elog_plgn_data_io
{
  const struct elog_xml_doc *doc;
  char *xml; //This is the files meta-contents.
  //it's ready for elog_xml_printf and elog_xml_scanf; but that's all.
  //don't try and change existing values, it may work but don't do it.
};

struct elog_plgn_data_journ
{
  const struct elog_journ_state *current;
};

struct elog_plgn_data_srch
{
  const char *term;
};

int elog_plgn_page();
//Pre: 
//Post:  Prints the current page and increments.  Only call this once!

int elog_plgn_page_decrement();
//INTERNAL USE ONLY!

void elog_plgn_initialize(const char *fileName);
//Pre:  
//Post:  All files listed in fileName are loaded.

void elog_plgn_save(const char *fileName);
//Pre:  initialize has been called
//Post:  fileName is updated with the current list of plugins.

int elog_plgn_check(const char *name);
//Pre:
//Post:  Checks if the plugin has been loaded.

int elog_plgn_open(const char *name);
//Pre:  plugin name exists.
//Post:  Loads and initializes plugin name.


int elog_plgn_close(const char *name);
//Pre:  plugin name closes.
//Post:  Closes name.

void elog_plgn_cleanup();
//Pre:
//Post:  Closes all running plugins,

int elog_plgn_call(const char *plgn, const char *func, void *dat);
//Pre:  plgn has been opened.  func exists withint plgn
//Post:  Calls the function, returns 0 on success.

int elog_plgn_eff_call(const char *plgn, int func, void *dat);
//Pre:
//Post:  calls the function in plgn.  Searches for plgn
//NOTE:  More efficient than plgn_call
//SECOND:  Implemented but untested.  Copy/Paste job, should work.

void elog_plgn_call_all(const char *func, void *dat);
//Pre: func is a valid function for plugins.
//Post:  All loaded plugins get func called in an orderly (linear) manner.
//NOTE:  This performs a linear search, avoid it.
//USE:  elog_plgn_eff_call_all

void elog_plgn_eff_call_all(int func, void *dat);
//Pre:  func is valid
//Post:  Calls the symbol on all plugins.
//NOTE:  This is far more efficient than call_all.

int elog_plgn_has(int func, const char *plgn);
//Pre:  plgn is the name of a plgn loaded
//Post:  returns 1 if the func is in it, 0 if it's not.

char **elog_plgn_list();
//Pre: 
//Post:  Lists available plugins.

char *elog_plgn_info(const char *name);
char *elog_plgn_author(const char *name);

#endif //_PLUGINS_H_
