/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "prefDialogue.h"
#include "settings.h"
#include "gui_al.h"
#include "journal.h"
#include "io.h"
#include "cryptography.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

/***********Extern tab callbacks...***********/

void on_web_entry_changed(GtkEditable * editable, gpointer user_data)
{
	elog_set_set_str("BROWSER", (const char *)
			 gtk_entry_get_text(GTK_ENTRY(editable)));
}

void on_vid_entry_changed(GtkEditable * editable, gpointer user_data)
{
	elog_set_set_str("VIDEO", (const char *)
			 gtk_entry_get_text(GTK_ENTRY(editable)));
}

void on_img_entry_changed(GtkEditable * editable, gpointer user_data)
{
	elog_set_set_str("IMGVIEW", (const char *)
			 gtk_entry_get_text(GTK_ENTRY(editable)));
}

/*******************************************************/





void pass_change_decrypt(const char *fileName, void *op1, void *op2)
{
	elog_gui_al_msg_win_pulse(op1);
	struct elog_xml_doc *doc = elog_xml_open(fileName, 0);
	unsigned int len;
	if (doc == NULL)
		return;
	else if (doc->handle == NULL) {
		elog_xml_doc_free(doc);
		return;
	}
	
	unsigned char *txt = elog_io_readRestofFile(doc->handle, &len);
	elog_io_close(doc->handle);
	if (elog_journ_current()->settings->encryption[0] == 'A') {
		decryptText(txt, len);
		if (doc->version >= 3)
			decryptText((unsigned char *) (doc->subject),
									   doc->lenSubject);
	}


	if (doc->file_info->encType != NULL)
		free(doc->file_info->encType);
	elog_sp_cat(&(doc->file_info->encType), "NONE", NULL);

	elog_xml_save(fileName, doc, txt, len);
	elog_xml_doc_free(doc);
	free(txt);
}
void pass_change_encrypt(const char *fileName, void *op1, void *op2)
{
	elog_gui_al_msg_win_pulse(op1);
	struct elog_xml_doc *doc = elog_xml_open(fileName, 0);
	if (doc == NULL)
		return;
	else if (doc->handle == NULL) {
		elog_xml_doc_free(doc);
		return;
	}

	doc->lenSubject = strlen(doc->subject)+1;
	unsigned int len;
	unsigned char *txt = elog_io_readRestofFile(doc->handle, &len);

	elog_io_close(doc->handle);
	if (elog_journ_current()->settings->encryption[0] == 'A') {
		encryptText(txt, len);
		encryptText((unsigned char *) (doc->subject),
			    doc->lenSubject);
	}

	if (doc->file_info->encType != NULL)
		free(doc->file_info->encType);
	elog_sp_cat(&(doc->file_info->encType), "AES", NULL);

	elog_xml_save(fileName, doc, txt, len);
	elog_xml_doc_free(doc);
	free(txt);
}




GtkWidget *elog_pref_dialog;

void set_crypto_sensitive(gboolean b)
{
	gtk_widget_set_sensitive(lookup_widget
				 (elog_pref_dialog, "pref_text"), b);
	gtk_widget_set_sensitive(lookup_widget
				 (elog_pref_dialog, "scrolledwindow1"), b);
	gtk_widget_set_sensitive(lookup_widget
				 (elog_pref_dialog, "pass_btn"), b);
	gtk_widget_set_sensitive(lookup_widget(elog_pref_dialog, "label4"),
				 b);
	gtk_widget_set_sensitive(lookup_widget(elog_pref_dialog, "label5"),
				 b);
	gtk_widget_set_sensitive(lookup_widget(elog_pref_dialog, "pass1"),
				 b);
	gtk_widget_set_sensitive(lookup_widget(elog_pref_dialog, "pass2"),
				 b);
}


GtkWidget *elog_pref_text;
GtkWidget *elog_pref_pass1;
GtkWidget *elog_pref_pass2;


GtkWidget *create_pref_window(void)
{
	GtkWidget *dialog1;
	GtkWidget *dialog_vbox1;
	GtkWidget *notebook1;
	GtkWidget *vbox1;
	GtkWidget *label3;
	GtkWidget *filechooserbutton1;
	GtkWidget *radio_aes;
	GSList *radio_aes_group = NULL;
	GtkWidget *radio_none;
	GtkWidget *vbox3;
	GtkWidget *scrolledwindow1;
	GtkWidget *pref_text;
	GtkWidget *hbox1;
	GtkWidget *label4;
	GtkWidget *pass1;
	GtkWidget *hbox2;
	GtkWidget *label5;
	GtkWidget *pass2;
	GtkWidget *pass_btn;
	GtkWidget *label1;
	GtkWidget *scrolledwindow2;
	GtkWidget *viewport1;
	GtkWidget *vbox4;
	GtkWidget *label6;
	GtkWidget *label2;
	GtkWidget *dialog_action_area1;
	GtkWidget *closebutton1;

	dialog1 = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialog1), "eJourn::Preferences");
	gtk_window_set_type_hint(GTK_WINDOW(dialog1),
				 GDK_WINDOW_TYPE_HINT_DIALOG);

	dialog_vbox1 = GTK_DIALOG(dialog1)->vbox;
	gtk_widget_show(dialog_vbox1);

	notebook1 = gtk_notebook_new();
	gtk_widget_show(notebook1);
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), notebook1, TRUE, TRUE,
			   0);

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(notebook1), vbox1);

	label3 = gtk_label_new("Journal Location:");
	gtk_widget_show(label3);
	gtk_box_pack_start(GTK_BOX(vbox1), label3, FALSE, FALSE, 0);

	filechooserbutton1 =
	    gtk_file_chooser_button_new("Select A File",
					GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	gtk_widget_show(filechooserbutton1);
	gtk_box_pack_start(GTK_BOX(vbox1), filechooserbutton1, TRUE, TRUE,
			   0);
	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(filechooserbutton1),
				      elog_journ_current()->settings->
				      path);


	radio_aes =
	    gtk_radio_button_new_with_mnemonic(NULL,
					       "AES256 Encryption (Strongest and Slowest)");
	gtk_widget_show(radio_aes);
	gtk_box_pack_start(GTK_BOX(vbox1), radio_aes, FALSE, FALSE, 0);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio_aes),
				   radio_aes_group);
	radio_aes_group =
	    gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio_aes));

	radio_none =
	    gtk_radio_button_new_with_mnemonic(NULL,
					       "No Encryption(Fastest, No Security)");
	gtk_widget_show(radio_none);
	gtk_box_pack_start(GTK_BOX(vbox1), radio_none, FALSE, FALSE, 0);
	gtk_radio_button_set_group(GTK_RADIO_BUTTON(radio_none),
				   radio_aes_group);
	radio_aes_group =
	    gtk_radio_button_get_group(GTK_RADIO_BUTTON(radio_none));

	vbox3 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox3);
	gtk_box_pack_start(GTK_BOX(vbox1), vbox3, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox3), 16);

	scrolledwindow1 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow1);
	gtk_box_pack_start(GTK_BOX(vbox3), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW
					    (scrolledwindow1),
					    GTK_SHADOW_IN);

	pref_text = gtk_text_view_new();
	gtk_widget_show(pref_text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow1), pref_text);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox1);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox1, TRUE, TRUE, 0);

	label4 = gtk_label_new("    Enter Password:");
	gtk_widget_show(label4);
	gtk_box_pack_start(GTK_BOX(hbox1), label4, FALSE, FALSE, 0);

	pass1 = gtk_entry_new();
	gtk_widget_show(pass1);
	gtk_box_pack_start(GTK_BOX(hbox1), pass1, TRUE, TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(pass1), FALSE);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox2);
	gtk_box_pack_start(GTK_BOX(vbox3), hbox2, TRUE, TRUE, 0);

	label5 = gtk_label_new("ReEnter Password:");
	gtk_widget_show(label5);
	gtk_box_pack_start(GTK_BOX(hbox2), label5, FALSE, FALSE, 0);

	pass2 = gtk_entry_new();
	gtk_widget_show(pass2);
	gtk_box_pack_start(GTK_BOX(hbox2), pass2, TRUE, TRUE, 0);
	gtk_entry_set_visibility(GTK_ENTRY(pass2), FALSE);

	pass_btn =
	    gtk_button_new_with_mnemonic("Commit Password Change Now");
	gtk_widget_show(pass_btn);
	gtk_box_pack_start(GTK_BOX(vbox3), pass_btn, FALSE, FALSE, 0);

	label1 = gtk_label_new(" General ");
	gtk_widget_show(label1);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (notebook1),
							     0), label1);

	scrolledwindow2 = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_show(scrolledwindow2);
	gtk_container_add(GTK_CONTAINER(notebook1), scrolledwindow2);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW
				       (scrolledwindow2), GTK_POLICY_NEVER,
				       GTK_POLICY_ALWAYS);

	viewport1 = gtk_viewport_new(NULL, NULL);
	gtk_widget_show(viewport1);
	gtk_container_add(GTK_CONTAINER(scrolledwindow2), viewport1);

	vbox4 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox4);
	gtk_container_add(GTK_CONTAINER(viewport1), vbox4);

	label6 =
	    gtk_label_new
	    ("Optional Features:\nCheck the features you wish to use...");
	gtk_widget_show(label6);
	gtk_box_pack_start(GTK_BOX(vbox4), label6, FALSE, FALSE, 0);

	label2 = gtk_label_new(" Optional Features ");
	gtk_widget_show(label2);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (notebook1),
							     1), label2);

	dialog_action_area1 = GTK_DIALOG(dialog1)->action_area;
	gtk_widget_show(dialog_action_area1);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area1),
				  GTK_BUTTONBOX_END);

	closebutton1 = gtk_button_new_from_stock("gtk-close");
	gtk_widget_show(closebutton1);
	gtk_dialog_add_action_widget(GTK_DIALOG(dialog1), closebutton1,
				     GTK_RESPONSE_CLOSE);
	GTK_WIDGET_SET_FLAGS(closebutton1, GTK_CAN_DEFAULT);


	/*image preferences: */
	/*
	   GtkWidget *hbox7;
	   GtkWidget *vbox7;
	   GtkWidget *label7;
	   GtkWidget *comboboxentry1;
	   GtkWidget *button7;
	   GtkWidget *image1;
	   GtkWidget *tab_lbl;




	   hbox7 = gtk_hbox_new (FALSE, 0);
	   gtk_widget_show (hbox7);


	   vbox7 = gtk_vbox_new (FALSE, 0);
	   gtk_widget_show (vbox7);
	   gtk_box_pack_start (GTK_BOX (hbox7), vbox7, FALSE, FALSE, 0);

	   label7 = gtk_label_new ("Choose a theme:");
	   gtk_widget_show (label7);
	   gtk_box_pack_start (GTK_BOX (vbox7), label7, FALSE, FALSE, 0);

	   comboboxentry1 = gtk_combo_box_new_text ();
	   gtk_widget_show (comboboxentry1);
	   gtk_box_pack_start (GTK_BOX (vbox7), comboboxentry1, FALSE, FALSE, 20);

	   button7 = gtk_button_new_with_mnemonic ("Load Theme....");
	   gtk_widget_show (button7);
	   gtk_box_pack_start (GTK_BOX (vbox7), button7, FALSE, FALSE, 0);

	   image1 = create_pixmap (dialog1, NULL);
	   gtk_widget_show (image1);
	   gtk_box_pack_start (GTK_BOX (hbox7), image1, TRUE, TRUE, 0);

	   tab_lbl = gtk_label_new (" Image Theme ");
	   gtk_widget_show (tab_lbl);



	   gtk_notebook_append_page(GTK_NOTEBOOK(notebook1), hbox7, tab_lbl);  
	 */

  /*************Extern Commands tab****************/

	GtkWidget *img_entry;
	GtkWidget *hseparator2;
	GtkWidget *vid_lbl;
	GtkWidget *vid_entry;
	GtkWidget *extern_lbl;
	GtkWidget *wbpage_lbl;
	GtkWidget *web_entry;
	GtkWidget *hseparator1;
	GtkWidget *img_lbl;

	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_widget_show(vbox1);
	gtk_container_add(GTK_CONTAINER(notebook1), vbox1);

	wbpage_lbl = gtk_label_new("Open Webpages with:");
	gtk_widget_show(wbpage_lbl);
	gtk_box_pack_start(GTK_BOX(vbox1), wbpage_lbl, FALSE, FALSE, 0);

	web_entry = gtk_entry_new();
	gtk_widget_show(web_entry);
	gtk_box_pack_start(GTK_BOX(vbox1), web_entry, FALSE, FALSE, 0);

	gtk_entry_set_text(GTK_ENTRY(web_entry),
			   (const gchar *) elog_set_get_str("BROWSER"));

	hseparator1 = gtk_hseparator_new();
	gtk_widget_show(hseparator1);
	gtk_box_pack_start(GTK_BOX(vbox1), hseparator1, FALSE, TRUE, 4);

	img_lbl = gtk_label_new("Open Images with:");
	gtk_widget_show(img_lbl);
	gtk_box_pack_start(GTK_BOX(vbox1), img_lbl, FALSE, FALSE, 0);

	img_entry = gtk_entry_new();
	gtk_widget_show(img_entry);
	gtk_box_pack_start(GTK_BOX(vbox1), img_entry, FALSE, FALSE, 0);

	gtk_entry_set_text(GTK_ENTRY(img_entry),
			   (const gchar *) elog_set_get_str("IMGVIEW"));


	hseparator2 = gtk_hseparator_new();
	gtk_widget_show(hseparator2);
	gtk_box_pack_start(GTK_BOX(vbox1), hseparator2, FALSE, TRUE, 4);

	vid_lbl = gtk_label_new("Open Videos with:");
	gtk_widget_show(vid_lbl);
	gtk_box_pack_start(GTK_BOX(vbox1), vid_lbl, FALSE, FALSE, 0);

	vid_entry = gtk_entry_new();
	gtk_widget_show(vid_entry);
	gtk_box_pack_start(GTK_BOX(vbox1), vid_entry, FALSE, FALSE, 0);
	gtk_entry_set_text(GTK_ENTRY(vid_entry),
			   (const gchar *) elog_set_get_str("VIDEO"));

	extern_lbl = gtk_label_new(" External Programs");
	gtk_widget_show(extern_lbl);
	gtk_notebook_set_tab_label(GTK_NOTEBOOK(notebook1),
				   gtk_notebook_get_nth_page(GTK_NOTEBOOK
							     (notebook1),
							     2),
				   extern_lbl);

	g_signal_connect((gpointer) web_entry, "changed",
			 G_CALLBACK(on_web_entry_changed), NULL);
	g_signal_connect((gpointer) img_entry, "changed",
			 G_CALLBACK(on_img_entry_changed), NULL);


  /*************************************************************/



	/*Find themes and list them */
	/*
	   char *path;
	   elog_sp_cat(&path, getenv("HOME"), "/.ejourn", NULL);
	   char **thms = elog_io_dirContents(path);
	   if (thms)
	   {
	   int c;
	   for (c=0; thms[c]; ++c)
	   {
	   char *full;
	   elog_sp_cat(&full, path, "/", thms[c], NULL);
	   if (elog_io_stat(full) == ELOG_IO_STAT_DIR)
	   {
	   char **content = elog_io_dirContents(full);
	   if (content)
	   {
	   int dirs = 0;
	   int j;
	   for (j=0; content[j]; ++j)
	   if (strcmp(content[j], "Landscapes") == 0 ||
	   strcmp(content[j], "Weathers") == 0 ||
	   strcmp(content[j], "Smilies") == 0)
	   ++dirs;
	   elog_sp_ArrFree(content);

	   if (dirs > 2)
	   {//now we know it's an image theme dir!
	   printf("Theme:%s\n", full);
	   elog_sp_removeRepeats(full, '/');
	   char **dirs = elog_sp_breakToArr(full, '/');
	   int i;
	   for (i=0; dirs[i]; ++i)
	   ;
	   --i;
	   gtk_combo_box_append_text(GTK_COMBO_BOX(comboboxentry1), (const gchar *)dirs[i]);
	   elog_sp_ArrFree(dirs);
	   }
	   }
	   }
	   free(full);
	   }
	   elog_sp_ArrFree(thms);
	   } */

	/*  g_signal_connect ((gpointer) comboboxentry1, "changed",
	   G_CALLBACK (on_img_thm_change),
	   NULL);  
	 */




  /*******************************************************/

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF(dialog1, dialog1, "dialog1");
	GLADE_HOOKUP_OBJECT_NO_REF(dialog1, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT(dialog1, notebook1, "notebook1");
	GLADE_HOOKUP_OBJECT(dialog1, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT(dialog1, label3, "label3");
	GLADE_HOOKUP_OBJECT(dialog1, filechooserbutton1,
			    "filechooserbutton1");
	GLADE_HOOKUP_OBJECT(dialog1, radio_aes, "radio_aes");
	GLADE_HOOKUP_OBJECT(dialog1, radio_none, "radio_none");
	GLADE_HOOKUP_OBJECT(dialog1, vbox3, "vbox3");
	GLADE_HOOKUP_OBJECT(dialog1, scrolledwindow1, "scrolledwindow1");
	GLADE_HOOKUP_OBJECT(dialog1, pref_text, "pref_text");
	GLADE_HOOKUP_OBJECT(dialog1, hbox1, "hbox1");
	GLADE_HOOKUP_OBJECT(dialog1, label4, "label4");
	GLADE_HOOKUP_OBJECT(dialog1, pass1, "pass1");
	GLADE_HOOKUP_OBJECT(dialog1, hbox2, "hbox2");
	GLADE_HOOKUP_OBJECT(dialog1, label5, "label5");
	GLADE_HOOKUP_OBJECT(dialog1, pass2, "pass2");
	GLADE_HOOKUP_OBJECT(dialog1, pass_btn, "pass_btn");
	GLADE_HOOKUP_OBJECT(dialog1, label1, "label1");
	GLADE_HOOKUP_OBJECT(dialog1, scrolledwindow2, "scrolledwindow2");
	GLADE_HOOKUP_OBJECT(dialog1, viewport1, "viewport1");
	GLADE_HOOKUP_OBJECT(dialog1, vbox4, "vbox4");
	GLADE_HOOKUP_OBJECT(dialog1, label6, "label6");
	GLADE_HOOKUP_OBJECT(dialog1, label2, "label2");
	GLADE_HOOKUP_OBJECT_NO_REF(dialog1, dialog_action_area1,
				   "dialog_action_area1");
	GLADE_HOOKUP_OBJECT(dialog1, closebutton1, "closebutton1");

	elog_pref_pass2 = pass2;
	elog_pref_pass1 = pass1;
	elog_pref_text = pref_text;

	int sens = 1;
	if (elog_journ_current()->settings->encryption[0] == 'N') {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_none),
					     TRUE);
		sens = 0;
	} else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio_aes),
					     TRUE);


	g_signal_connect((gpointer) radio_aes, "toggled",
			 G_CALLBACK(on_radio_aes_toggled), NULL);
	g_signal_connect((gpointer) pass_btn, "activate",
			 G_CALLBACK(on_pass_btn_pressed), NULL);
	g_signal_connect((gpointer) pass_btn, "pressed",
			 G_CALLBACK(on_pass_btn_pressed), NULL);
	g_signal_connect((gpointer) closebutton1, "clicked",
			 G_CALLBACK(on_close_btn_pressed), NULL);
	g_signal_connect((gpointer) closebutton1, "pressed",
			 G_CALLBACK(on_close_btn_pressed), NULL);




	/*now we will initialize plugins */


	char **list = elog_plgn_list();

	int c;
	for (c = 0; list[c] != NULL; ++c) {
		char *descr = elog_plgn_info(list[c]);

		char *pt = descr;
		while (pt != NULL) {
			int c;
			for (c = 0; c < 8; ++c)
				if (pt != NULL)
					pt = strchr(++pt, ' ');
			if (pt != NULL)
				pt[0] = '\n';
		}

		GtkWidget *sep = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(vbox4), sep, FALSE, FALSE, 0);

		GtkWidget *checkbox;
		checkbox = gtk_check_button_new_with_label(descr);
		gtk_box_pack_start(GTK_BOX(vbox4), checkbox, FALSE, FALSE,
				   0);

		gtk_widget_show(checkbox);
		if (elog_plgn_check(list[c]))
			gtk_button_clicked(GTK_BUTTON(checkbox));

		char *name;
		elog_sp_cat(&name, list[c], NULL);
		g_signal_connect((gpointer) checkbox, "toggled",
				 G_CALLBACK(on_option_toggled), name);

		free(descr);
	}

	elog_sp_ArrFree(list);

	/*Finished with plugins */



	gtk_widget_show_all(dialog1);

	elog_pref_dialog = dialog1;

	if (!sens)
		set_crypto_sensitive(FALSE);

	char *path;
	elog_sp_cat(&path, elog_set_get_str("path"), "/intro.dry", NULL);

	struct elog_io_file *f = elog_io_initialize(path, ELOG_IO_READ);

	if (f != NULL) {
		unsigned int len;
		unsigned char *txt = elog_io_readRestofFile(f, &len);

		if (elog_journ_current()->settings->encryption[0] != 'N')
			if (elog_crypt_decrypt(txt, len)) {
				free(path);
				elog_io_close(f);
				gtk_widget_destroy(dialog1);
				return NULL;
			}

		char *txt_c = elog_sp_toChar(txt, len);
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW(pref_text));
		gtk_text_buffer_set_text(buffer, txt_c, -1);

		free(txt_c);
		elog_io_close(f);
	}
	free(path);





	return dialog1;
}


void on_option_toggled(GtkToggleButton * togglebutton, gpointer user_data)
{
	printf("Toggled:%i\n", gtk_toggle_button_get_active(togglebutton));
	if (gtk_toggle_button_get_active(togglebutton)) {
		//load plugin
		elog_plgn_open((char *) user_data);
	} else {
		//remove plugin
		elog_plgn_close((char *) user_data);
	}
}

void
on_radio_aes_toggled(GtkToggleButton * togglebutton, gpointer user_data)
{
	printf("RADIO Toggled\n");
	if (gtk_toggle_button_get_active(togglebutton)) {
		set_crypto_sensitive(TRUE);
		printf("AES?\n");
		elog_set_set_str("encryption_method", "AES");
		elog_journ_save();
		//      if (elog_journ_load(elog_journ_current()->name))
		if (elog_gui_al_setKey(ELOG_LGN_MODE_SWITCH)) {
			printf("Cancel\n");
			gtk_toggle_button_set_active(togglebutton, FALSE);
			set_crypto_sensitive(FALSE);
			if (elog_journ_current()->settings->encryption)
				free(elog_journ_current()->settings->
				     encryption);
			elog_sp_cat(&
				    (elog_journ_current()->settings->
				     encryption), "NONE", NULL);
			elog_set_set_str("encryption_method", "NONE");

			gtk_widget_destroy(elog_pref_dialog);
			create_pref_window();

			return;	//checking if things are ok to proceed.
		}

		struct elog_gui_al_msg_win *win =
		    elog_gui_al_msg_win_create
		    ("Please Wait while eJourn encrypts all of your files");

		elog_func_apply_recursively(elog_set_get_str("path"),
					    pass_change_encrypt, NULL, win,
					    NULL);

		char *intro;
		elog_sp_cat(&intro, elog_set_get_str("path"), "/intro.dry",
			    NULL);
		struct elog_io_file *f =
		    elog_io_initialize(intro, ELOG_IO_READ);
		unsigned int len;
		unsigned char *file = elog_io_readRestofFile(f, &len);
		decryptText(file, len);
		elog_io_close(f);
		char *file_c = elog_sp_toChar(file, len);
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW
					     (elog_pref_text));
		gtk_text_buffer_set_text(buffer, file_c, -1);


		free(file_c);
		elog_gui_al_msg_win_destroy(win);
	} else {
		set_crypto_sensitive(FALSE);

		char *intro;
		elog_sp_cat(&intro, elog_set_get_str("path"), "/intro.dry",
			    NULL);
		struct elog_io_file *f =
		    elog_io_initialize(intro, ELOG_IO_READ);
		unsigned int len;
		unsigned char *file = elog_io_readRestofFile(f, &len);

		elog_io_close(f);


		if (elog_journ_load(elog_journ_current()->name)) {
			gtk_toggle_button_set_active(togglebutton, TRUE);
			free(intro);
			set_crypto_sensitive(TRUE);
			if (elog_journ_current()->settings->encryption)
				free(elog_journ_current()->settings->
				     encryption);
			elog_sp_cat(&
				    (elog_journ_current()->settings->
				     encryption), "AES", NULL);
			elog_set_set_str("encryption_method", "AES");
			return;	//making sure we're set.
		}
		f = elog_io_initialize(intro, ELOG_IO_WRITE);
		encryptText(file, len);
		elog_io_writeLine(f, file, len);
		elog_io_close(f);
		free(intro);
		free(file);

		struct elog_gui_al_msg_win *win =
		    elog_gui_al_msg_win_create
		    ("Please Wait while eJourn decrypts all of your files");

		elog_func_apply_recursively(elog_set_get_str("path"),
					    pass_change_decrypt, NULL, win,
					    NULL);



		elog_set_set_str("encryption_method", "NONE");
		elog_journ_save();
		elog_gui_al_msg_win_destroy(win);
	}
}




void on_pass_btn_pressed(GtkButton * button, gpointer user_data)
{
	char *pass1, *pass2;
	pass1 = (char *) gtk_entry_get_text(GTK_ENTRY(elog_pref_pass1));
	pass2 = (char *) gtk_entry_get_text(GTK_ENTRY(elog_pref_pass2));
	if (strcmp(pass1, pass2) == 0) {
		printf("Password:%s\n", pass1);

		char *intro;
		elog_sp_cat(&intro, elog_set_get_str("path"), "/intro.dry",
			    NULL);
		struct elog_io_file *f =
		    elog_io_initialize(intro, ELOG_IO_READ);
		int len;
		unsigned char *file = elog_io_readRestofFile(f, &len);

		elog_io_close(f);


		elog_journ_load(elog_journ_current()->name);	//making sure we're set.

		decryptText(file, len);



		struct elog_gui_al_msg_win *win =
		    elog_gui_al_msg_win_create
		    ("Please Wait while eJourn changes your password.");


		elog_func_apply_recursively(elog_set_get_str("path"),
					    pass_change_decrypt, NULL, win,
					    NULL);

		//decrypted
		createKey(pass1, 256);
		elog_journ_save();
		elog_func_apply_recursively(elog_set_get_str("path"),
					    pass_change_encrypt, NULL, win,
					    NULL);
		encryptText(file, len);
		f = elog_io_initialize(intro, ELOG_IO_WRITE);

		elog_io_writeLine(f, file, len);
		elog_io_close(f);
		free(intro);
		elog_gui_al_msg_win_destroy(win);

	} else
		elog_wrn_print("Passwords don't match\n");

}

void on_close_btn_pressed(GtkButton * button, gpointer user_data)
{
	//Affect changes in encryption text box
	if (elog_journ_current()->settings->encryption[0] == 'A') {
		GtkTextBuffer *buffer =
		    gtk_text_view_get_buffer(GTK_TEXT_VIEW
					     (elog_pref_text));
		GtkTextIter start, end;
		gtk_text_buffer_get_start_iter(buffer, &start);
		gtk_text_buffer_get_end_iter(buffer, &end);
		char *content =
		    (char *) gtk_text_buffer_get_text(buffer, &start, &end,
						      TRUE);
		int len = strlen(content) + 1;
		encryptText(content, len);
		char *path;
		elog_sp_cat(&path, elog_journ_current()->settings->path,
			    "/intro.dry", NULL);
		struct elog_io_file *f =
		    elog_io_initialize(path, ELOG_IO_WRITE);
		free(path);
		elog_io_writeLine(f, content, len);

		elog_io_close(f);
		free(content);
	}
	elog_journ_saveStates(ELOG_JOURN_CONF);
	gtk_widget_destroy(elog_pref_dialog);
}

void on_img_thm_change(GtkComboBox * widget, gpointer user_data)
{
	char *txt = gtk_combo_box_get_active_text(GTK_COMBO_BOX(widget));
	char *path;
	elog_sp_cat(&path, getenv("HOME"), "/.ejourn/", txt, NULL);

	elog_img_free();
	elog_img_init(path);

	free(path);
	free(txt);
}
