#include "search_tab.h"
#include <gtk/gtk.h>
#include "gui_al.h"
#include "settings.h"
#include "gui_io.h"
#include "search.h"
#include "second.h"
#include "srch_pane.h"
#include "cryptography.h"
#include "xml.h"
#include "journal.h"
#include "plugins.h"
#include "threads.h"
#include "tabs.h"

char **_srch_tab_list_res = NULL;
int _srch_tab_list_res_n = 0;


gboolean __srchtab_tree_foreach(GtkTreeModel * model, GtkTreePath * path,
				GtkTreeIter * iter, gpointer data)
{
	char *name;
	char *str_path;
	gtk_tree_model_get(model, iter, 2, &name, 4, &str_path, -1);
	if (!(str_path) || !(name))
		return TRUE;

	struct elog_xml_doc *doc = elog_crypt_open_dry(str_path);
	if (doc) {
		int *res = elog_srch_listResults(doc->text, (char *) data);
		if (res[0] >= 0) {
			elog_srch_pane_add_item(name,
						_srch_tab_list_res_n);
			if (_srch_tab_list_res_n < 127)
				_srch_tab_list_res[_srch_tab_list_res_n] =
				    str_path;
			++_srch_tab_list_res_n;
			if (_srch_tab_list_res_n >= 127) {
				free(name);
				free(res);
				return TRUE;
			}
		}
		free(res);
		elog_xml_doc_free(doc);
	}
	free(name);
	return FALSE;
}

int _elog_tab_srch_res(void *p)
{
	elog_gui_al_lock();
	elog_srch_pane_clear();
	_srch_tab_list_res_n = 0;
	int c;
	for (c = 0; _srch_tab_list_res[c]; ++c)
		free(_srch_tab_list_res[c]);

	gtk_tree_model_foreach(GTK_TREE_MODEL(_srchTree),
			       __srchtab_tree_foreach, p);
	_srch_tab_list_res[_srch_tab_list_res_n] = NULL;

	elog_gui_al_unlock();
	char *term = (char *) p;
	free(term);
	return 0;
}

int _tab_scnd_hide(void *p)
{ //this function is necessary to solve problems with searches
	//during collapses with gtk...
	gtk_widget_hide(_res_srch_window);
	return 0;
}

int elog_tab_srch_srch()
{
	const char *term = gtk_entry_get_text(GTK_ENTRY(_menu_srch_entry));
	if (term) {
		if (strlen(term) > 0) {
			gtk_widget_show(_res_srch_window);
		} else
			elog_scnd_run(_tab_scnd_hide, "hide");
	} else
		elog_scnd_run(_tab_scnd_hide, "hide");

	if (!(_srch_tab_list_res)) {
		_srch_tab_list_res =
		    malloc((sizeof *_srch_tab_list_res) * 128);
		_srch_tab_list_res[0] = NULL;
	}

	char *term1;
	elog_sp_cat(&term1, term, NULL);
	elog_scnd_run_arg(_elog_tab_srch_res, "srch tab", term1);

	return 0;
}
gboolean    _srch_list_foreach2		      (GtkTreeModel *model,
                                             GtkTreePath *path,
                                             GtkTreeIter *iter,
                                             gpointer data)
{
	char *p;
	char *check = (char *)data;
	gtk_tree_model_get(model, iter, 4, &p, -1);

	if (strcmp(p, check) == 0) {
		free(p);
		gtk_tree_view_set_cursor(GTK_TREE_VIEW(_srchTreeView),
								path, NULL, FALSE);
		return TRUE;
	}
	return FALSE;                                	
}


int elog_tab_srch_res(const char *name, int n)
{
	if (n < _srch_tab_list_res_n) {
		gtk_tree_model_foreach(GTK_TREE_MODEL(_srchTree),
							_srch_list_foreach2, (gpointer) _srch_tab_list_res[n]);

	}
	else
		return 1;
	return 0;
}

int elog_tab_srch_cut()
{
	if (gtk_widget_is_focus(_srchTxt)) {
		gtk_editable_cut_clipboard(GTK_EDITABLE(_srchTxt));
		return 0;
	}
	if (gtk_widget_is_focus(_srchTreeView))
		return elog_tab_srch_copy();

	return 1;
}

int elog_tab_srch_copy()
{
	if (gtk_widget_is_focus(_srchTxt)) {
		gtk_editable_copy_clipboard(GTK_EDITABLE(_srchTxt));
		return 0;
	}
	if (gtk_widget_is_focus(_srchTreeView)) {
		char *entry = elog_srch_tab_getDay();
		if (!entry)
			return 1;
		char *clip;
		elog_sp_cat(&clip, "LOCATION://", entry, NULL);
		free(entry);
		elog_gui_al_clipBoard(clip);
		free(clip);
		return 0;
	}

	return 1;
}

int elog_tab_srch_paste()
{
	if (gtk_widget_is_focus(_srchTxt)) {
		gtk_editable_paste_clipboard(GTK_EDITABLE(_srchTxt));
		return 0;
	}
	if (gtk_widget_is_focus(_srchTreeView)) {
		return 0;	//placeholder
	}

	return 1;
}

int elog_tab_srch_delete()
{
	return 0;
}

char *elog_srch_tab_getDay()
{
	GtkTreeModel *model = (GtkTreeModel *) _srchTree;
	GtkTreePath *tree_path;
	GtkTreeViewColumn *trash;
	gtk_tree_view_get_cursor(GTK_TREE_VIEW(_srchTreeView), &tree_path,
				 &trash);
	if (!tree_path)
		return NULL;

	char *str_path = (char *) gtk_tree_path_to_string(tree_path);
	gtk_tree_path_free(tree_path);
	GtkTreeIter iter;
	gtk_tree_model_get_iter_from_string(model, &iter, str_path);
	free(str_path);

	char *title;
	char *path;
	gtk_tree_model_get(model, &iter, 0, &title, 4, &path, -1);
	free(title);
	return path;
}

void __search_function(void *in)
{
	elog_gui_io_search(in);
}

void on_srch_lyric_change(GtkRange * range, gpointer user_data)
{
	//  if (elog_srch_status() != ELOG_SRCH_STAT_GO)
	//   return;

	elog_srch_lyric(elog_gui_al_lyric(-1));
	/*char *txt = elog_gui_al_searchText(NULL);
	   if (strlen(txt) > 0)
	   traverSearch(elog_set_get_str("path"), txt, __search_function); */

}

void on_search_btn_activate(GtkButton * button, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	if (elog_srch_status() != ELOG_SRCH_STAT_GO)
		return;

	elog_srch_lyric(elog_gui_al_lyric(-1));
	char *txt = elog_gui_al_searchText(NULL);
	if (strlen(txt) > 0)
		traverSearch(elog_set_get_str("path"), txt,
			     __search_function);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}



void on_srch_entry_activate(GtkEntry * entry, gpointer user_data)
{
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	if (elog_srch_status() != ELOG_SRCH_STAT_GO)
		return;
	elog_srch_accuracy(elog_gui_al_srchAccuracy(-1.0));
	elog_srch_caseSensitive(elog_gui_al_caseSensitive(-1));

	char *txt = (char *) gtk_entry_get_text(entry);
	if (strlen(txt) > 0)
		traverSearch(elog_set_get_str("path"), txt,
			     __search_function);
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
}

void on_srch_accuracy_change(GtkRange * range, gpointer user_data)
{
	//    if (elog_srch_status() != ELOG_SRCH_STAT_GO)
	//    return;
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_srch_accuracy(elog_gui_al_srchAccuracy(-1.0));
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);

	/*      char *txt = elog_gui_al_searchText(NULL);
	   if (strlen(txt) > 0)
	   traverSearch(elog_set_get_str("path"), txt, __search_function); */

}

void
on_srch_sensitivity_change(GtkToggleButton * togglebutton,
			   gpointer user_data)
{
	//if (elog_srch_status() != ELOG_SRCH_STAT_GO)
	//    return;
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCK_CALLBACK);
	elog_srch_caseSensitive(elog_gui_al_caseSensitive(-1));
	elog_gui_al_setLockMode(ELOG_GUI_AL_LOCKED);
	/*      char *txt = elog_gui_al_searchText(NULL);
	   if (strlen(txt) > 0)
	   traverSearch(elog_set_get_str("path"), txt, __search_function); */

}

char *_srch_last_term = NULL;
int _encrypt = 0;

struct elog_thread *_searchThread = NULL;
void (*_srch_tab_functor) (void *);

int __traverSearch(void *p)
{				//I'm called on the second thread.
	const char *term = (const char *) p;
	_encrypt =
	    strcmp(elog_journ_current()->settings->encryption, "NONE");

	elog_gui_al_lock();
	elog_gui_al_clearResults();


	elog_gui_io_view_clear_results();	//clearing gui_io's search result list.

	char *stat;
	elog_sp_cat(&stat, "Looking for ", term, " ...", NULL);
	unsigned int msg = elog_status_push_status(stat);
	free(stat);

	elog_gui_al_unlock();

	elog_srch_search(elog_srch_setDir(NULL), term, _srch_tab_functor);

	elog_gui_al_lock();
	elog_status_progress_set(0.0);
	elog_status_pop_status(msg);
	elog_gui_al_unlock();
	return 0;
}
int __srch_run_srch(void *p)
{
	if (elog_tab_current() == 2)
		elog_tab_srch_srch();
	return elog_scnd_still("search");
}
int __run_incr_srch(void *p)
{
	return elog_srch_incremental_search((struct elog_srch_instr *) p);
}
void traverSearch(const char *dir, const char *term,
		  void (*functor) (void *))
{
	elog_srch_setDir(dir);
	if (term) {
		if (_srch_last_term)
			free(_srch_last_term);

		elog_sp_cat(&_srch_last_term, term, NULL);
	}
	if (_srch_last_term) {
		_srch_tab_functor = functor;

		struct elog_srch_instr *i = elog_srch_instr_new();
		i->term = _srch_last_term;
		i->directory = elog_srch_setDir(NULL);
		i->func = _srch_tab_functor;
		//i->lyrical = _srch_lyrical;
		//  i->caseSensitive = _case_Sensitive;
		//i->accuracy = _allowed_diff;
		elog_gui_al_lock();
		elog_gui_al_clearResults();
		elog_gui_al_unlock();
		
		elog_gui_io_view_clear_results();
		elog_scnd_run_arg(__run_incr_srch, "search", i);

		elog_scnd_run(__srch_run_srch, "refresh");
		struct elog_plgn_data_srch *plgn = malloc(sizeof *plgn);
		plgn->term = _srch_last_term;
		elog_plgn_call_all("___search", plgn);
		free(plgn);
	}
}
int elog_srch_status()
{
	if (_searchThread == NULL)
		return ELOG_SRCH_STAT_GO;
	if (_searchThread->state == ELOG_THRD_STATE_BUSY)
		return ELOG_SRCH_STAT_BUSY;

	return ELOG_SRCH_STAT_GO;
}
