/* AUTHOR: Chris <MA_D> Hilton
 * LICENSE:  GPL Version 2
 *
 */
 
 /* Why me?
  * This file exists to wrap up typical tab operations for
  * the search tab, you'll find similar files for other tabs:
  * calendar.h and edit.h.  This one is named funny because
  * searching code is in search.h
  */
#ifndef SEARCH_TAB_H
#define SEARCH_TAB_H
#include <gtk/gtk.h>


int elog_tab_srch_srch();

int elog_tab_srch_res(const char *name, int n);
//Pre:  name is a c string
//Post:  Unsure..
  
int elog_tab_srch_cut();
//Pre:
//Post:  This will do a cut.  Which for search will grab
//  the current search items subject line.

int elog_tab_srch_copy();
//Pre:
//Post:  This is the same as cut.

int elog_tab_srch_paste();
//Pre:
//Post:  This does nothing.

int elog_tab_srch_delete();
//Pre:
//Post:  This will move the current item in the list to
//  the trash.

char *elog_srch_tab_getDay();
//Pre:
//Post:  returns the file for the selected search result.

int elog_srch_status();
//Pre:
//Post:  Returns whether or not it is currently searching.


void traverSearch(const char *dir, const char *term, void (*functor)(void*));
//Pre:  I run my own thread.
//Post:  Searches and calls functor


/*************CALLBACKS*********/
void
on_srch_entry_activate                 (GtkEntry        *entry,
                                        gpointer         user_data);

void       
on_srch_accuracy_change			(GtkRange *range,
                                            gpointer user_data);

void       
on_srch_lyric_change			(GtkRange *range,
                                            gpointer user_data);
											
void
on_srch_sensitivity_change      (GtkToggleButton *togglebutton,
                                            gpointer user_data);										
void
on_treeview1_row_activated             (GtkTreeView     *treeview,
                                        GtkTreePath     *path,
                                        GtkTreeViewColumn *column,
                                        gpointer         user_data);
#endif
