/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SETTINGS_H
#define SETTINGS_H

/*Why me?
I exist to store central program settings.
I have a lot of deprecated methods left because my author
doesn't feel like digging through and removing their uses.

Please use:
set_get_int, set_get_str, set_set_int, set_set_str; and no
other accessor functions.

Extensions code is unsupported and will be removed completely.

*/


#include "xml.h"

#define ELOG_SET_MODE_CONSOLE 1
#define ELOG_SET_MODE_GUI 2

//with all these, send NULL to recieve the current value, and send
//a pointer to a valid object to set the value.  It will use your object, 
//so make sure it's going to stay there!
const char *elog_set_encryptionMethod(char *method);
int elog_set_mainHeight(int *width);
int elog_set_mainWidth(int *height);
int elog_set_treeDivider(int *div);
const char *elog_set_confPath(char *confPath);
const char *elog_set_path(char *path);
const char *elog_set_currentFile(const char *name, struct elog_xml_doc** meta);
//Pre:
//Post if path == NULL returns _path, else sets it to path
 void elog_set_loadSettings(const char *fileName);
//pre: fileName exists and is a valid file location
//post:  Settings will be loaded into global variables
//		True is returned for success, false for any error
void elog_set_writeSettings(const char *fileName);
const char *elog_set_extAction(const char *extension);
void elog_set_extAdd(char *extension, char *action);
const char *elog_set_listExtensions(const char *ext);
//Pre: ext is a valid c string, or NULL for the first index
//Post: returns a char containing the next extension string, or null when none are left.
//#include "settings.cc"
int elog_set_mode(int *mode);
//Pre: if mode is not null it sets the mode to mode.  
//Post:  returns current mode



//***begin new system of functions:

const char *elog_set_get_str(const char *name);
//Pre:  a value must be named name
//Post:  a pointer to this stored value is returned, it must be a string

int elog_set_get_int(const char *name);
//Pre:  a value must be named name
//Post:  this value is returned, it must be an integer.

void elog_set_set_str(const char *name, const char *data);
//Pre:  a value must be named name
//Post:  This value's data will be deleted and replaces with data

void elog_set_set_int(const char *name, int data);
//Pre:  a value must be named name
//Post:  This value's data will be deleted and replaces with data




#endif
