/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 
 //this file is for simple functions, like translating simple data types.
 
#ifndef SIMPLE_H
#define SIMPLE_H
 
int elog_sp_power(int num, int exp);
//Pre:  num is the base, and exp is the exponent, both valid integers
//Post:  returns num^exp

char *elog_sp_shortToString(int num);
//Pre:	
//Post:  return a new char of value num, so 92 will return "93"

int elog_sp_stringToShort(const char *str);
//Pre:  str is a valid c string
//Post:  returns a short integer representing str

char *elog_sp_whiteSpaceRemove(const char *str);
//Pre:  str is a valid c string
//Post:  returns str with no whitespace on the end or at the beginning
 
char *elog_sp_toChar(unsigned char *in, unsigned int len);
//Pre:  in is a valid array of length len, in contains valid char sized numerals
//Post:  returns a c string containing the contents of in
//Note:  Depending on system, this function may or may not free in.
//Consider this conversion to be final, and in to be deleted!

unsigned char *elog_sp_toUnsignedChar(char *in, unsigned int *len);
//Pre:  in is a valid c string
//Post:  returns copy as unsigned char array of length len
//Note:  Depending on system, this function may or may not free in.
//Consider this conversion to be final, and in to be deleted!

char **elog_sp_breakToArr(const char *fileName, char seperator);
//Pre:  fileName is a complete path, formatted with seperator
//Post:  Seperates fileName into it's directories and finaly filename,
//		using seperator for seperation.  The final cell will point to NULL.
void elog_sp_ArrFree(char **);


void elog_sp_cat(char **dest, ...);
//Pre:  *dest will be the destination string, the last item given must be NULL.
//		Do not pass a dest and NULL!
//Post:  Allocates and concatenates all strings given

char *elog_sp_strReplace(const char *str, const char *old, const char *new);
//Pre:  str,old,new are all valid string.
//Post:  a new str is allocated, old occurences are replaced with new.
//new str is returned.

float elog_sp_stringToFloat(char *str);
//Pre:  str is a valid c string
//Post:  returns a float containing the number in str.

char *elog_sp_floatToString(float num);
//Pre:  num is a float
//Post:  returns the string containing this nunber.

void elog_sp_resizeArray(char ***array);
void elog_sp_resizeArrayInt(int **array, int *size);
void elog_sp_resizeArrayWSize(char ***array, int *size);

char * elog_sp_getLine(const char *data, int line);
//Post:  Returns the index of the beginning of line number $line

int elog_sp_removeRepeats(char *str, char item);
//Pre: str and item are c strings
//Post:  goes through str and removes consecutive occurances of item:
//Example: str = "dog/cat//loser/burgler/////tire" item="/"
//elog_sp_removeRepeats(str, item)
//str = "dog/cat/loser/burgler/tire"
//No memory allocations

#endif
