
#include <gtk/gtk.h>
#include "gui_al.h"

GtkTreeViewColumn *_srch_pane_col;


int elog_srch_pane_initialize()
{

	GtkCellRenderer *renderer;


	_srch_pane_col = gtk_tree_view_column_new();
	gtk_tree_view_column_set_title(_srch_pane_col, "");


	gtk_tree_view_column_set_reorderable(_srch_pane_col, TRUE);
	gtk_tree_view_append_column(GTK_TREE_VIEW(_res_srch_list),
				    _srch_pane_col);


	renderer = gtk_cell_renderer_text_new();

	gtk_tree_view_column_pack_start(_srch_pane_col, renderer, TRUE);
	gtk_tree_view_column_add_attribute(_srch_pane_col, renderer,
					   "text", 0);


	GtkListStore *list =
	    gtk_list_store_new(2, G_TYPE_STRING, G_TYPE_INT);
	gtk_tree_view_set_model(GTK_TREE_VIEW(_res_srch_list),
				GTK_TREE_MODEL(list));


	return 0;
}

int elog_srch_pane_set_title(const char *name)
{
	gtk_tree_view_column_set_title(_srch_pane_col, name);
	return 0;
}

int elog_srch_pane_add_item(const char *text, int n)
{
	GtkListStore *list =
	    GTK_LIST_STORE(gtk_tree_view_get_model
			   (GTK_TREE_VIEW(_res_srch_list)));
	if (list) {
		GtkTreeIter iter;
		gtk_list_store_append(GTK_LIST_STORE(list), &iter);
		gtk_list_store_set(GTK_LIST_STORE(list), &iter, 0, text, 1,
				   n, -1);
		return 0;
	}
	return 1;
}


int elog_srch_pane_clear()
{
	GtkListStore *list =
	    GTK_LIST_STORE(gtk_tree_view_get_model
			   (GTK_TREE_VIEW(_res_srch_list)));
	if (list) {
		gtk_list_store_clear(list);
		return 0;
	}
	return 1;
}
