/* AUTHOR:  Chris <MA_D> Hilton
 * LICENSE:  GPLv2
 * PURPOSE:  read the why me
 */


/* Why me?
 *  This file exists to add and remove and access things on the list
 * for the search pane.  This search pane is the widget which fills in
 * results when you type into the search box by the main menu.  A list then 
 * opens on the right.  This basically edits that list.
 * The actual widgets are in gui_al.h
 */


#include <stdio.h>
#include <stdlib.h>
#include "gui_al.h"

int elog_srch_pane_initialize();
//Pre: Make sure you've created the associated widgets!
//HINT:  The main window should be either viewable or totally made.
//Post:  initializes the storage for the search pane
//NOTE:  This function should only be called once, and there's a 99.99% 
//chance it was called in main.c.  Ignore it.

//Note:  Make sure you call initialize before any of these functions:

int elog_srch_pane_add_item(const char *text, int n);
//Pre:  text is a c string
//Post:  text and n are added.
// the user can see text, and n is a hidden element stored along with it.
//Returns 0 on ok, 1 on error

int elog_srch_pane_clear();
//Pre: Nothing, you can even call this when empty.
//Post:  This clears the pane
//Returns 0 on ok, 1 on error

int elog_srch_pane_set_title(const char *name);
//Pre:  name is a valid c string
//Post:  the displayed tree title will be name

