/*Copyright Chris <MA_D> Hilton see ../LICENSE for GPL details  */


#ifndef STATUS_H
#define STATUS_H
#include "gui_al.h"




void *elog_status_initialize();
//Returns the widget for the statusbar.

int elog_status_ready();
//Used by the program for errors during initialization.
//Tells if the statusbar can take messages yet.

/********Progress bar*********/
void elog_status_progress_pulse();
//Pre:  
//Post:  Sets progress bar to pulse mode, if needed, and pulses.

void elog_status_progress_set(float to);
//Pre:  to is between 0.0 and 1.0
//Post:  Sets progress bar.

/*****************************/

void elog_status_show_message_window();
//Show the window which shows all the messages in the queue.

void elog_status_color(int status, int color);
//Makes this status id marked for this color.


unsigned int elog_status_push_status(const char *status);

void elog_status_pop_status(unsigned int id);

void elog_status_color_warn();
//Turns the status bar a color to warn the user.


void elog_status_short_status(const char *status, int disp_time_mu, int flag);
//Pre: status is a c string
//flag: 0 for no change, 1 for color to attract user attention
//Post: status is displayed for disp_time_mu milliseconds.
// This function does not block
// 30000 is a good time delay to use.



#endif
