#include <stdlib.h>
#include <ctype.h>
#include "structure.h"
#include "simple.h"

int elog_strct_valid_subdir(const char *subdir)
{
	int c;
	for (c = 0; c < 4; ++c)
		if (!(isdigit(subdir[c])))
			return 0;
	if (subdir[c] != '\0')
		return 0;

	return 1;
}


int elog_strct_valid_subdir_with_path(const char *dir)
{
	char **arr = elog_sp_breakToArr(dir, '/');
	int c;
	for (c = 0; arr[c] != NULL; ++c);
	--c;
	c = elog_strct_valid_subdir(arr[c]);
	elog_sp_ArrFree(arr);
	return c;
}

int elog_strct_mode_subdir(const char *subdir)
{
	int c = 0;
	while (subdir[c] == '/')
		++c;

	int j;
	for (j = 0; j < 4; ++j)
		if (!(isdigit(subdir[c + j])))
			return ELOG_STRCT_MODE_OTHER;
	c += j;



	while (subdir[c] == '/')
		++c;

	if (subdir[c] == '\0')
		return ELOG_STRCT_MODE_YEAR;
	//got through the year test, and it's over, it must be a year.


	int store = c;
	while (isdigit(subdir[c]))
		++c;
	if (c - store > 2)
		return ELOG_STRCT_MODE_ERR;

	while (subdir[c] == '/')
		++c;
	if (subdir[c] == '\0')
		return ELOG_STRCT_MODE_MONTH;
	//Got through the month test, it must be a month

	store = c;
	while (isdigit(subdir[c]))
		++c;
	if (c - store > 2)
		return ELOG_STRCT_MODE_ERR;

	while (subdir[c] == '/')
		++c;

	if (subdir[c] == '\0')
		return ELOG_STRCT_MODE_DATE;

	return ELOG_STRCT_MODE_ERR;
}
