/*AUTHOR: Chris Hilton
 *LICENSE: GPL 2
 */

#ifndef STRUCTURE_H
#define STRUCTURE_H
int elog_strct_valid_subdir(const char *subdir);
//Pre:  Tells if the subdir is valid, subdir must be valid cstring
//Post:  checks if it's a directory that can contain entries within a $PATH
//      Returns 1 if it can contain entries.  otherwise 0.
//  2005 -- 1
//  1992 -- 1
//  cat  -- 0


int elog_strct_valid_subdir_with_path(const char *dir);
//same as elog_strct_valid_subdir, but it can include the full path to the dir.


#define ELOG_STRCT_MODE_MONTH 1
#define ELOG_STRCT_MODE_DATE 2
#define ELOG_STRCT_MODE_YEAR 3
#define ELOG_STRCT_MODE_OTHER 4  // This type means it can't contain entries
#define ELOG_STRCT_MODE_ERR 0

int elog_strct_mode_subdir(const char *subdir);
//Note:  This requires the full prefix from $PATH on
//  It expects a leading /, this is the full journal path:
//EX: /2005/3/17/2.dry  -- ERR
//EX: /2005/3  -- MONTH
//EX: /2005/3/17/ -- DATE
//
//Pre:subdir is a subdir in a path
//Post:  Returns the type as listed above.


#endif
