#include "tabs.h"
#include "plugins.h"
#include "gui_al.h"
#include "gui_io.h"
#include "calendar.h"
#include "search_tab.h"
#include "srch_pane.h"
#include "edit.h"
#include "settings.h"

#define MAX_TABS 32
#define FIRST_POSS_TAB 3

char *_tab_names[MAX_TABS];

int _last_reg = 0;
int _tab_open;			//the currently opened tab.

void *elog_tab_set_menu_0 = NULL;
void *elog_tab_set_menu_1 = NULL;
void *elog_tab_set_menu_2 = NULL;


int elog_tab_current()
{
	return _tab_open;
}

int elog_tab_num(const char *name)
{
	int c;
	for (c = FIRST_POSS_TAB; c < _last_reg; ++c)
		if (strcmp(_tab_names[c], name) == 0)
			return c;
	return -1;
}

const char *elog_tab_name(int tab)
{
	return _tab_names[tab];
}
int elog_tab_capable(int action, int tab)
{
	switch (tab) {
	case 0:
		{
			switch (action) {
			case ELOG_TAB_ACT_CUT:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_COPY:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_PASTE:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_DELETE:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_UNDO:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_REDO:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_SRCH:
				{
					return 1;
					break;
				}
			}
			break;
		}
	case 1:
		{
			switch (action) {
			case ELOG_TAB_ACT_CUT:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_COPY:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_PASTE:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_DELETE:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_UNDO:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_REDO:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_SRCH:
				{
					return 1;
					break;
				}
			}
			break;
		}
	case 2:
		{
			switch (action) {
			case ELOG_TAB_ACT_CUT:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_COPY:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_PASTE:
				{
					return 1;
					break;
				}
			case ELOG_TAB_ACT_DELETE:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_UNDO:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_REDO:
				{
					return 0;
					break;
				}
			case ELOG_TAB_ACT_SRCH:
				{
					return 1;
					break;
				}
			}
			break;
		}
	default:		//plugin tab
		{
			const char *plgn = elog_tab_name(tab);
			return elog_plgn_has(action, plgn);
			break;
		}
	}
	return 0;
}

void elog_tab_call_markCal()
{
	elog_gui_io_view_set_result_mode(0);
	elog_gui_io_markCalendar();
	elog_gui_io_dispDay(NULL);
}

void elog_tab_call_srchCal()
{
	elog_gui_io_view_set_result_mode(1);
	elog_gui_io_markCalendar();
	elog_gui_io_dispDay(NULL);
}

void elog_tab_call_jumpPrev()
{
	elog_edit_view_prev_result();
}

void elog_tab_call_jumpNext()
{
	elog_edit_view_next_result();
}

void elog_tab_set(int tab)
{
	_tab_open = tab;


	switch (tab) {
	case 0:
		{
			if (!(elog_tab_set_menu_0)) {
				elog_tab_set_menu_0 =
				    elog_gui_al_menu_new();
				elog_gui_al_view_add(elog_tab_set_menu_0,
						     "Days With Entries",
						     elog_tab_call_markCal,
						     1);
				elog_gui_al_view_add(elog_tab_set_menu_0,
						     "Days With Search Results",
						     elog_tab_call_srchCal,
						     1);
			}
			elog_gui_al_menu_attach_view(elog_tab_set_menu_0);


			elog_gui_io_markCalendar();
			elog_gui_io_dispDay(NULL);
			elog_tab_cal_srch();
			elog_srch_pane_set_title("Entries:");
			elog_gui_io_save();

			int n = elog_set_get_int("SEARCH_DIVIDE_0");
			if (n <= 0)
				n = elog_gui_al_width() - 128;
			elog_gui_al_srch_pane(n);
			break;
		}
	case 1:
		{
			if (!(elog_tab_set_menu_1)) {
				elog_tab_set_menu_1 =
				    elog_gui_al_menu_new();
				elog_gui_al_view_add(elog_tab_set_menu_1,
						     "Next Search Result",
						     elog_tab_call_jumpNext,
						     -1);
				elog_gui_al_view_add(elog_tab_set_menu_1,
						     "Previous Search Result",
						     elog_tab_call_jumpPrev,
						     -1);
			}
			int n = elog_set_get_int("SEARCH_DIVIDE_1");
			if (n <= 0)
				n = elog_gui_al_width() - 128;
			elog_gui_al_srch_pane(n);

			elog_gui_al_menu_attach_view(elog_tab_set_menu_1);
			elog_srch_pane_set_title("Occurances:");
			elog_tab_edit_srch();
			break;
		}
	case 2:
		{
			int n = elog_set_get_int("SEARCH_DIVIDE_2");
			if (n <= 0)
				n = elog_gui_al_width() - 128;
			elog_gui_al_srch_pane(n);
			elog_gui_al_menu_detach_view();
			elog_tab_srch_srch();
			elog_gui_io_save();

			break;
		}
	default:
		{
			elog_plgn_eff_call(_tab_names[tab],
					   ELOG_PLGN_SYM_FOCUS, NULL);
			break;
		}
	}
	elog_plgn_eff_call_all(ELOG_PLGN_SYM_TAB, &tab);
}

int elog_tab_register(const char *name)
{
	int current = elog_plgn_page();
	elog_sp_cat(&(_tab_names[current]), name, NULL);
	if (current < _last_reg)
		current = _last_reg;

	return current;
}
int elog_tab_unregister(int page)
{
	free(_tab_names[page]);
	_tab_names[page] = NULL;
	int c;
	for (c = page + 1; c <= _last_reg; ++c)
		_tab_names[c - 1] = _tab_names[c];
	--_last_reg;


	elog_plgn_page_decrement();
	return 0;
}

int elog_tab_act_cut()
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_cut();
		}
	case 1:
		{
			return elog_tab_edit_cut();
		}
	case 2:
		{
			return elog_tab_srch_cut();
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___cut", NULL);
}


int elog_tab_act_copy()
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_copy();
		}
	case 1:
		{
			return elog_tab_edit_copy();
		}
	case 2:
		{
			return elog_tab_srch_copy();
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___copy", NULL);
}

int elog_tab_act_paste()
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_paste();
		}
	case 1:
		{
			return elog_tab_edit_paste();
		}
	case 2:
		{
			return elog_tab_srch_paste();
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___paste", NULL);
}

int elog_tab_act_undo()
{
	switch (_tab_open) {
	case 1:
		{
			elog_gui_io_undo();
			return 0;
			break;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___undo", NULL);
}

int elog_tab_act_redo()
{

	switch (_tab_open) {
	case 1:
		{
			elog_gui_io_redo();
			return 0;
			break;
		}

	}
	return elog_plgn_call(_tab_names[_tab_open], "___redo", NULL);
}

int elog_tab_act_delete()
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_delete();
		}
	case 1:
		{
			return elog_tab_edit_delete();
		}
	case 2:
		{
			return 0;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___delete", NULL);
}

int elog_tab_act_back()
{
	switch (_tab_open) {
	case 0:
		{

			return 0;
		}
	case 1:
		{

			return 0;
		}
	case 2:
		{

			return 0;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___back", NULL);;
}

int elog_tab_act_forward()
{
	switch (_tab_open) {
	case 0:
		{

			break;
		}
	case 1:
		{
			break;
		}
	case 2:
		{
			break;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___fwrd", NULL);;
}

int elog_tab_act_search()
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_srch();
			break;
		}
	case 1:
		{
			return elog_tab_edit_srch();
			break;
		}
	case 2:
		{
			return elog_tab_srch_srch();
			break;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___srch", NULL);
}
int elog_tab_act_res(const char *name, int n)
{
	switch (_tab_open) {
	case 0:
		{
			return elog_tab_cal_res(name, n);
			break;
		}
	case 1:
		{
			return elog_tab_edit_res(name, n);
			break;
		}
	case 2:
		{
			return elog_tab_srch_res(name, n);
			break;
		}
	}
	return elog_plgn_call(_tab_names[_tab_open], "___res", &n);
}
