/*
 *AUTHOR: Chris <MA_D> Hilton
 *LICENSE:  GPLV2
 *Purpose:  This file stores the current tab, handles tab change events for
 *the program and calls appropriate plugins.
 */

#ifndef TABS_H
#define TABS_H
#include <stdlib.h>
#include "plugins.h"

//these are based on PLGN_SYM* in plugins.h
#define ELOG_TAB_ACT_CUT 3
#define ELOG_TAB_ACT_COPY 4
#define ELOG_TAB_ACT_PASTE 5
#define ELOG_TAB_ACT_DELETE 13
#define ELOG_TAB_ACT_UNDO 16
#define ELOG_TAB_ACT_REDO 17
#define ELOG_TAB_ACT_BACK 14
#define ELOG_TAB_ACT_FWRD 15
#define ELOG_TAB_ACT_SRCH 18
#define ELOG_TAB_ACT_RES 19

int elog_tab_current();
//Pre:
//Post:  spits out the current tab.

int elog_tab_register(const char *name);
//Pre:  name is the name of the plugin for its loadup.
//Post:  The plugin is registered to this tab, and it will be called
//       upon the correct events.

int elog_tab_unregister(int page);
//Pre:  page is the page of your tab
//Post:  Your registration is forwarded..

void elog_tab_set(int tab);
//Pre:
//Post:  Sets the current tab to tab.

int elog_tab_num(const char *name);
//Pre:  name is already registered
//Post:  returns the tab number you CURRENTLY possess
//Tab numbers can change over time...

const char *elog_tab_name(int tab);
//Pre:  
//Post:  returns the name of the tab, tab.

int elog_tab_capable(int action, int tab);
//Pre:  action is one of the list above
//Post:  returns 1 for it can, 0 for it can't.


/*Actions*/

int elog_tab_act_res(const char *name, int n);
//Pre:  name is the name of the search item, n is the number associated.
//Post:  The current tab is called for these results.

int elog_tab_act_cut();
//Pre:
//Post:  Determines the current tab.  Calls the appropriate functions.
//    Magic...

int elog_tab_act_copy();

int elog_tab_act_paste();

int elog_tab_act_delete();

int elog_tab_act_undo();

int elog_tab_act_redo();

int elog_tab_act_back();

int elog_tab_act_forward();

int elog_tab_act_search();



#endif

