/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 

#include "listen.h"
#include "xml.h"
#include "error.h"
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


int elog_tlk_say(const char *file, const char *msg);
//Pre:  msg is a free format string; file is a file being watched by listen
//Post:  Will be sent to another running instance

int elog_tlk_ask(const char *file, char **msg);
//Pre:  It will ask for a message via file
//Post:  Upon success, 0 is returned and your message lies in msg
//		Upon failure, non-zero is returnes and msg = NULL
//About:  This function is meant to get from the edit box.

int elog_tlk_reply(const char *file, char *msg);
//Pre:  For use in response to ask by other process
//Post:  Upon success, 0 is returned.
//Will send msg to file. as ELOG_LSN_TYPE_REPLY


