#ifndef ELOG_THREAD_H
#define ELOG_THREAD_H

/*Why me?
Threads exists to abstract the concept of threading as much as possible and 
to provide a common way to watch if threads finish (sync them in a sense).
This is intended to be a thin glue layer.

However, it may develop to something allowing more option passing
to functions called as threads.  Pthreads only allows one void pointer.

I can get around this with a struct and a set of semi-smart wrapper
functions.

*/


#include <stdlib.h>
#include <pthread.h>
#ifdef WIN32
#include <config.h>
#endif
#include <unistd.h>

#define ELOG_THRD_PAT_NONE 1        //as quick as possible
#define ELOG_THRD_PAT_LESS 10       // 1/1000000s
#define ELOG_THRD_PAT_LITTLE 100    // 1/100000s
#define ELOG_THRD_PAT_MID 1000      // 1/10000s
#define ELOG_THRD_PAT_PLENTY 100000 // 1/10s

#define ELOG_THRD_STATE_BUSY 1
#define ELOG_THRD_STATE_DONE 0

struct elog_thread
{
  int state; //0 for finished, 1 for running};
  pthread_t sysThread;
  pthread_mutex_t mutex;
  void *thread_data;
  void *(*func)(void *);
  void *(*func0)(void);
};



void elog_thrd_initialize();
//Pre:  Must be called by the main thread.
//Post:  You can run other functions
//This function is necessary to establish the thread of the main thread.


int elog_thrd_finger();
//Pre:
//Post:  This function returns 1 if threads have been compiled in.
//It will return 0 if they have not:  This keeps some of the #defines out
//because I find #defines confusing and refuse to use them if they
//don't provide a performance benefit.

struct elog_thread* elog_thr_thread_new();
void elog_thr_thread_free(struct elog_thread *th);


void elog_thrd_lock(struct elog_thread *th);
//Pre:  Warning, only use this if your thread is meant for it.
//If the other thread hasn't locked there's no point in this call.
//Post:  Waits for the thread mutex to be unlocked before resuming.
//Then locks and returns.  Make sure you unlock!

void elog_thrd_unlock(struct elog_thread *th);
//Pre:  Again, no point in using this if your thread isn't!
//Post:  Unlocks the thread, no wait.

int elog_thrd_trylock(struct elog_thread *th);
//Pre:
//Post:  Tries to lock, returns if it can't
//1 means no dice
//0 means you got the lock!

void elog_thrd_exit(struct elog_thread *th);
//Pre:  th is a running thread
//Post:  th will be killed.

void elog_thrd_finish(struct elog_thread *th, int patience);
//wait for thread to finish

struct elog_thread *elog_thrd_launch(void *(* func)(void*), void *func_data);
//Launch new thread as func.
//This will launch an internal function which launches the given function.  This

//function will handle making sure the thread is closed off while running and opened
//when finished.

	
struct elog_thread *elog_thrd_launch0(void *(* func)(void));


//Stuff for global application locking for non-thread safe libs...
//was under gui_al, moved here now because it's more approppriate.

#define ELOG_THREAD_MAIN 0
#define ELOG_THREAD_SECOND 1
#define ELOG_THREAD_OTHER 2
int elog_thrd_identify_me();
//Pre:
//Post:  tells you what thread you're in

void elog_glob_reg_scnd_thread(); 
//this is an internal function for the program.

void elog_glob_lock(); //locks, signed, your thread!
void elog_glob_unlock();
	
#endif
