#include "time.h"
#ifndef WIN32
Time_t _time = 0;

void elog_tm_set(unsigned int tm)
{
	_time = (Time_t) tm;
}

void elog_tm_reset()
{
	elog_tm_set(0);
}

Time_t elog_tm_time()
{
	return _time;
}

void *elog_tm_runClock()
{
	struct timespec tm;
	tm.tv_sec = 0;
	tm.tv_nsec = 200000000;	//1/5th of a second.

	struct timespec err;
	while (1) {
		if (nanosleep(&tm, &err) == -1)
			nanosleep(&err, NULL);	//try the error, give up if this fails.
		++_time;
	}
	return NULL;
}
#endif
