/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef UNDO_H
#define UNDO_H
 
#include "gui_io.h"
#include "gui_types.h" 
 

struct elog_gui_io_undoAction
{
  int action;
  unsigned int data;
  void *data2;
  int loc;
  int replace;
  struct elog_gui_io_undoAction *next;
};

//Actions:
#define ELOG_GUI_IO_ACTION_CHAR 1
#define ELOG_GUI_IO_ACTION_DEL 2
#define ELOG_GUI_IO_ACTION_CUT 4
#define ELOG_GUI_IO_ACTION_PASTE 5
#define ELOG_GUI_IO_ACTION_LINK 6
#define ELOG_GUI_IO_ACTION_UNLINK 7
//***

 
void elog_gui_io_printStat();
//For debugging


void elog_gui_io_addUndoAction(int action, unsigned int data, int loc);
//Pre:  action must be one of the actions defined in gui_io.h
//Post:  data must be valid data for the action, or -1

void elog_gui_io_addUndoActionPtr(int action, void *data, int loc);
//Pre: don't free data..  I'll handle that for you!
//Post: ditto

void elog_gui_io_markReplace();
//Marks the last added action as a replace.
//This means that when it's undone the next one will be done immediately.

void elog_gui_io_undo();
//Pre:
//Post:  Undoes an action if one exists to be undone.

void elog_gui_io_clearUndo(); 
//Pre:
//Post:  Clears the undo buffer.

void elog_gui_io_redo();
//Pre:
//Post:  Does a redo.

void elog_gui_io_addRedo(struct elog_gui_io_undoAction *item);
//Pre:  item is a valid undo item
//Post:  Item will be added to redo list.

void elog_gui_io_clearRedo();
//Clears redo list, should be called often.

#endif
