#include "error.h"
#include "xml.h"
#include "io.h"
#include "simple.h"
#include "plugins.h"
#include "crypt.h"


struct elog_xml_doc *_elog_xml_meta_data;



char *elog_xml_endTag(const char *tag);
// Returns the end tag version of the opening tag


char *xml__cat(char *dest, const char *x)
{
	while (*dest)
		dest++;
	while ((*dest++ = *x++));	// apparently this works?
	return --dest;
}

char *elog_xml_getTag(char *doc, char *tagName[])
{
	char *d_s = doc;
	int c = 0;
	while (d_s != NULL && tagName[c] != NULL) {
		char *g = d_s;
		d_s = elog_xml_tagCapture(d_s, tagName[c]);
		free(g);
		++c;
	}
	if (d_s == NULL)
		return NULL;
	else if (tagName[c] == NULL)
		return d_s;

	free(d_s);
	return NULL;
}
struct elog_xml_doc *elog_xml_doc_new()
{
	struct elog_xml_doc *doc = malloc(sizeof(struct elog_xml_doc));
	doc->ref = 1;		// this is a ref.
	doc->subject = NULL;
	doc->fileName = NULL;
	doc->mood = 0;
	doc->weather = 0;
	doc->day = 0;
	doc->month = 0;
	doc->year = 0;
	doc->links = NULL;
	doc->last_edit = NULL;
	doc->created = NULL;
	doc->handle = NULL;
	doc->text = NULL;
	doc->xml = NULL;
	doc->attchmnts = NULL;
	doc->file_info = elog_xml_file_info_new();

	return doc;
}
void elog_xml_doc_ref(struct elog_xml_doc *doc)
{
	++(doc->ref);
}

void elog_xml_doc_unref(struct elog_xml_doc *doc)
{
	--(doc->ref);
	// if (doc->ref <= 0)
	// elog_xml_doc_free(doc);
}

struct elog_xml_doc *elog_xml_doc_copy(struct elog_xml_doc *doc)
{
	struct elog_xml_doc *nue = elog_xml_doc_new();
	nue->subject = doc->subject;
	nue->subject = NULL;

	nue->fileName = doc->fileName;
	nue->fileName = NULL;

	nue->mood = doc->mood;
	nue->weather = doc->weather;
	nue->day = doc->day;
	nue->month = doc->month;
	nue->year = doc->year;

	nue->links = doc->links;
	nue->links = NULL;

	nue->last_edit = doc->last_edit;
	nue->last_edit = NULL;

	nue->file_info->encType = doc->file_info->encType;
	nue->file_info->encType = NULL;

	nue->file_info->media = doc->file_info->media;
	nue->file_info->media = NULL;

	nue->created = doc->created;
	nue->created = NULL;

	nue->handle = doc->handle;	// not freed anyway

	nue->text = doc->text;
	nue->text = NULL;

	nue->xml = doc->xml;
	nue->xml = NULL;

	nue->attchmnts = doc->attchmnts;
	nue->attchmnts = NULL;
	return nue;
}
struct elog_xml_link *elog_xml_link_new()
{
	return malloc(sizeof(struct elog_xml_link));
}
void elog_xml_file_info_free(struct elog_xml_file_info *del)
{
	if (del->media != NULL)
		free(del->media);
	if (del->encType != NULL)
		free(del->encType);
	free(del);
}
struct elog_xml_file_info *elog_xml_file_info_new()
{
	struct elog_xml_file_info *nue = malloc(sizeof *nue);
	nue->media = NULL;
	nue->encType = NULL;
	return nue;
}
char *elog_xml_tagCapture(const char *doc, char *tag)
{
	char *begin = strstr(doc, tag);
	if (begin != NULL) {
		char *tag_end = elog_xml_endTag(tag);

		if (tag_end == NULL)
			return NULL;
		char *end = strstr(begin, tag_end);

		if (end != NULL) {
			begin = &begin[strlen(tag)];	// removing opening tag
			int diff = end - begin;
			char *x;
			x = malloc((sizeof *x) * (diff + 1));
			memcpy(x, begin, diff);

			x[diff] = '\0';
			free(tag_end);
			return x;	// we got it!
		} else {
			free(tag_end);
			return NULL;
		}
		begin = strstr(doc, tag);
	}
	// it wasn't there, return null
	return NULL;
}

char *elog_xml_endTag(const char *tag)
{
	unsigned int len = strlen(tag);
	char *tag_end;
	tag_end = malloc((sizeof *tag_end) * (len + 2));	// remember, we
	// gotta include
	// the \0
	tag_end[len + 1] = '\0';
	tag_end[0] = '<';
	tag_end[1] = '/';
	strcpy(&(tag_end[2]), &(tag[1]));

	return tag_end;
}
void *_attchmnt_read(char *xml)
{
	struct elog_xml_attchmnt *ret = malloc(sizeof *ret);
	ret->name = NULL;
	ret->loc = NULL;
	ret->index = 0;
	elog_xml_scanf(xml, "<attchmnt>.<name>.%s", &(ret->name));
	elog_xml_scanf(xml, "<attchmnt>.<loc>.%s", &(ret->loc));
	elog_xml_scanf(xml, "<attchmnt>.<index>.%i", &(ret->index));

	return ret;
}

void *_lnk_read(char *xml)
{
	struct elog_xml_link *ret = malloc(sizeof *ret);
	char *name = NULL;
	elog_xml_scanf(xml, "<lnk>.<name>.%s", &name);
	char **arr = elog_sp_breakToArr(name, '-');
	if (arr == NULL) {
		if (name) free(name);
		return NULL;
	}
	if (arr[0] == NULL) {
		if (name) free(name);
		return NULL;
	}
	if (arr[1] == NULL) {
		if (name) free(name);
		return NULL;
	}
	// finished checking for errors.

	ret->start = elog_sp_stringToShort(arr[0]);
	ret->end = elog_sp_stringToShort(arr[1]);
	if (ret->end > ret->start) {	// swapping if they're backwards.
		unsigned int tmp = ret->end;
		ret->end = ret->start;
		ret->start = tmp;
	}
	free(arr[0]);
	free(arr[1]);
	free(arr);

	elog_xml_scanf(xml, "<lnk>.<href>.%s", &(ret->href));
	return ret;
}

void _xml_open3(char *meta, struct elog_xml_doc *document)
{				/* 
				 * This function is for current document
				 * files Version 3. Change: subject is now 
				 * encrypted. */

	// Due to the nature of the typical xml_doc file, all tags are unique; 
	// the structure is just to look pretty
	// and help documentation.  So, we're not going to cycle through each
	// one.
	// This makes this function a LOT faster..  

	elog_xml_scanf(meta, "<last-edit>.%s", &(document->last_edit));

	elog_xml_scanf(meta, "<creation date>.%s", &(document->created));

	elog_xml_scanf(meta, "<weather>.%i", &(document->weather));

	elog_xml_scanf(meta, "<mood>.%i", &(document->mood));
	int len = 0;
	elog_xml_scanf(meta, "<subject>.%i", &len);
	document->lenSubject = len;
	if (len) {
		document->subject =
		    malloc((sizeof *(document->subject)) * (len + 1));
		elog_io_readLine(document->subject, document->handle, len);
		document->subject[len] = '\0';
	} else
		elog_sp_cat(&(document->subject), "", NULL);
	// hopefully an empty string is safe to decrypt ;)


	elog_xml_scanf(meta, "<day>.%i", &(document->day));
	elog_xml_scanf(meta, "<month>.%i", &(document->month));
	elog_xml_scanf(meta, "<year>.%i", &(document->year));
	elog_xml_scanf(meta, "<encryption type>.%s",
		       &(document->file_info->encType));


	document->links =
	    (struct elog_xml_link **) elog_xml_scanl(meta,
						     "<meta>.<links>",
						     "<lnk>", _lnk_read);
	document->attchmnts =
	    (struct elog_xml_attchmnt **) elog_xml_scanl(meta,
							 "<meta>.<attachments>",
							 "<attchmnt>",
							 _attchmnt_read);
}


void _xml_open2(char *meta, struct elog_xml_doc *document)
{				/* 
				 * Version 2. Added: <attachments>
				 * Changed: <link num=#> is now <lnk> */

	// Due to the nature of the typical xml_doc file, all tags are unique; 
	// the structure is just to look pretty
	// and help documentation.  So, we're not going to cycle through each
	// one.
	// This makes this function a LOT faster..  

	elog_xml_scanf(meta, "<last-edit>.%s", &(document->last_edit));

	elog_xml_scanf(meta, "<creation date>.%s", &(document->created));

	elog_xml_scanf(meta, "<weather>.%i", &(document->weather));

	elog_xml_scanf(meta, "<mood>.%i", &(document->mood));
	elog_xml_scanf(meta, "<subject>.%s", &(document->subject));
	if (document->subject)
		document->lenSubject = strlen(document->subject);
	else
		document->lenSubject = 0;
	elog_xml_scanf(meta, "<day>.%i", &(document->day));
	elog_xml_scanf(meta, "<month>.%i", &(document->month));
	elog_xml_scanf(meta, "<year>.%i", &(document->year));
	elog_xml_scanf(meta, "<encryption type>.%s",
		       &(document->file_info->encType));

	document->links =
	    (struct elog_xml_link **) elog_xml_scanl(meta,
						     "<meta>.<links>",
						     "<lnk>", _lnk_read);
	document->attchmnts =
	    (struct elog_xml_attchmnt **) elog_xml_scanl(meta,
							 "<meta>.<attachments>",
							 "<attchmnt>",
							 _attchmnt_read);
}

void _xml_open01(char *meta, struct elog_xml_doc *document)
{				/* 
				 * This function is backward compatibility 
				 * for doc types 0 and 1 Don't update it,
				 * it works now ;). */

	// Due to the nature of the typical xml_doc file, all tags are unique; 
	// the structure is just to look pretty
	// and help documentation.  So, we're not going to cycle through each
	// one.
	// This makes this function a LOT faster..  

	elog_xml_scanf(meta, "<last-edit>.%s", &(document->last_edit));

	elog_xml_scanf(meta, "<creation date>.%s", &(document->created));

	elog_xml_scanf(meta, "<weather>.%i", &(document->weather));

	elog_xml_scanf(meta, "<mood>.%i", &(document->mood));
	elog_xml_scanf(meta, "<subject>.%s", &(document->subject));
	if (document->subject)
		document->lenSubject = strlen(document->subject);
	else
		document->lenSubject = 0;
	elog_xml_scanf(meta, "<day>.%i", &(document->day));
	elog_xml_scanf(meta, "<month>.%i", &(document->month));
	elog_xml_scanf(meta, "<year>.%i", &(document->year));
	elog_xml_scanf(meta, "<encryption type>.%s",
		       &(document->file_info->encType));

	int highLink;
	int cont = 1;
	for (highLink = 0; cont; ++highLink) {
		char *num = elog_sp_shortToString(highLink);
		char *tag;
		elog_sp_cat(&tag, "<link num=", num, ">", NULL);
		free(num);
		num = strstr(meta, tag);
		if (num == NULL)
			cont = 0;
		free(tag);
	}
	--highLink;
	// highLink is now the number of links

	document->links =
	    malloc((sizeof *(document->links)) * (highLink + 1));
	int c;
	for (c = 0; c < highLink; ++c) {
		document->links[c] = elog_xml_link_new();
		char *num = elog_sp_shortToString(c);
		char *tag;
		elog_sp_cat(&tag, "<meta>.<links>.<link num=", num,
			    ">.<href>.%s", NULL);
		elog_xml_scanf(meta, tag, &(document->links[c]->href));
		free(tag);
		elog_sp_cat(&tag, "<meta>.<links>.<link num=", num,
			    ">.<name>.%s", NULL);
		char *name;
		elog_xml_scanf(meta, tag, &name);
		free(tag);
		free(num);

		char **arr = elog_sp_breakToArr(name, '-');
		if (arr == NULL)
			break;
		if (arr[0] == NULL)
			break;
		if (arr[1] == NULL)
			break;
		// finished checking for errors.

		document->links[c]->start = elog_sp_stringToShort(arr[0]);
		document->links[c]->end = elog_sp_stringToShort(arr[1]);
		if (document->links[c]->end > document->links[c]->start) {	// swapping 
			// if 
			// they're 
			// backwards.
			unsigned int tmp = document->links[c]->end;
			document->links[c]->end =
			    document->links[c]->start;
			document->links[c]->start = tmp;
		}
		free(arr[0]);
		free(arr[1]);
		free(arr);
	}
	document->links[highLink] = NULL;

}

struct elog_xml_doc *elog_xml_open(const char *fileName, int plgns)
{

	struct elog_xml_doc *document = elog_xml_doc_new();
	/*
	 * document->fileName = malloc((sizeof *(document->fileName)) *
	 * strlen(fileName+1)); document->fileName[0] = '\0';
	 * strcat(document->fileName, fileName); 
	 */
	elog_sp_cat(&(document->fileName), fileName, NULL);
	document->handle = elog_io_initialize(fileName, ELOG_IO_READ);
	if (document->handle == NULL) {
		elog_xml_doc_free(document);
		return NULL;
	}

	char *meta = malloc((sizeof *meta) * 1024 * XML_DOC_SIZE);

	memset(meta, 0, 1024 * XML_DOC_SIZE * (sizeof *meta));


	elog_io_readLine(meta, document->handle, 1024 * XML_DOC_SIZE);	// reads 
	// first 
	// 1024*XML_DOC_SIZE 
	// bytes

	meta[1024 * XML_DOC_SIZE - 1] = '\0';

	if (strstr(meta, "</meta>") == NULL) {	// This isn't a valid
		// document.
		elog_io_close(document->handle);
		document->handle = NULL;
		free(meta);
		elog_xml_doc_free(document);
		return NULL;
	}

	elog_io_setHandle(document->handle,
			  (strstr(meta, "</meta>") + 8 * (sizeof(char))) -
			  meta);
	// ^^ setting handle to the actual end of the meta data, so that the
	// stream can be read to completion



	elog_xml_scanf(meta, "<version>.%i", &(document->version));


	switch (document->version) {
	case 3:
		{
			_xml_open3(meta, document);
			break;
		}
	case 2:
		{
			_xml_open2(meta, document);
			break;
		}
	default:
		{
			_xml_open01(meta, document);
			break;
		}
	}

	document->xml = meta;
	return document;
}
int _attchmnt_create(void *dat, char *xml, const char *tag)
{
	struct elog_xml_attchmnt *attchmnt =
	    (struct elog_xml_attchmnt *) dat;
	char *tmp;
	elog_sp_cat(&tmp, tag, ".%s", NULL);

	if (elog_xml_printf(xml, tmp, "<name>", attchmnt->name)) {
		free(tmp);
		return 1;
	}
	if (elog_xml_printf(xml, tmp, "<loc>", attchmnt->loc)) {
		free(tmp);
		return 1;
	}
	char *indx = elog_sp_shortToString(attchmnt->index);
	if (elog_xml_printf(xml, tmp, "<index>", indx)) {
		free(tmp);
		free(indx);
		return 1;
	}
	free(tmp);
	free(indx);
	return 0;
}
int _link_create(void *dat, char *xml, const char *tag)
{
	struct elog_xml_link *lnk = (struct elog_xml_link *) dat;
	char *temp;
	elog_sp_cat(&temp, tag, ".%s", NULL);
	char *name;
	char *st;
	char *nd;
	st = elog_sp_shortToString(lnk->start);
	nd = elog_sp_shortToString(lnk->end);
	elog_sp_cat(&name, st, "-", nd, NULL);
	free(st);
	free(nd);
	if (elog_xml_printf(xml, temp, "<name>", name)) {
		free(name);
		free(temp);
		return 1;
	}
	if (elog_xml_printf(xml, temp, "<href>", lnk->href)) {
		free(name);
		free(temp);
		return 1;
	}
	free(name);
	free(temp);
	return 0;
}

int
elog_xml_save(const char *fileName, const struct elog_xml_doc *meta,
	      const unsigned char *dat, unsigned int len)
{
	struct elog_io_file *file =
	    elog_io_initialize(fileName, ELOG_IO_WRITE);
	if (file == NULL) {
		elog_err_print_console
		    ("xml::save failed to open the file for reading..\n");
		return 1;
	}
	char *xml;
	xml = elog_xml_start("<meta>", 1024 * XML_DOC_SIZE);


	elog_xml_printf(xml, "<meta>.%s", "<version>", "3");

	elog_xml_printf(xml, "<meta>.%s", "<file data>", "");
	elog_xml_printf(xml, "<meta>.<file data>.%s", "<encryption type>",
			meta->file_info->encType);
	elog_xml_printf(xml, "<meta>.%s", "<timestamps>", "");
	elog_xml_printf(xml, "<meta>.<timestamps>.%s", "<last-edit>",
			meta->last_edit);
	elog_xml_printf(xml, "<meta>.<timestamps>.%s", "<creation data>",
			meta->created);
	elog_xml_printf(xml, "<meta>.%s", "<info>", "");
	char *n = elog_sp_shortToString(meta->weather);
	elog_xml_printf(xml, "<meta>.<info>.%s", "<weather>", n);
	free(n);
	n = elog_sp_shortToString(meta->mood);
	elog_xml_printf(xml, "<meta>.<info>.%s", "<mood>", n);

	free(n);
	n = elog_sp_shortToString(meta->lenSubject);
	elog_xml_printf(xml, "<meta>.%s", "<subject>", n);
	elog_xml_printf(xml, "<meta>.%s", "<links>", "");

	elog_xml_printf(xml, "<meta>.%s", "<date>", "");
	n = elog_sp_shortToString(meta->day);
	elog_xml_printf(xml, "<meta>.<date>.%s", "<day>", n);
	free(n);
	n = elog_sp_shortToString(meta->month);
	elog_xml_printf(xml, "<meta>.<date>.%s", "<month>", n);
	free(n);
	n = elog_sp_shortToString(meta->year);
	elog_xml_printf(xml, "<meta>.<date>.%s", "<year>", n);
	free(n);


	// need to use a printl for links.
	elog_xml_printl(xml, "<meta>", "<links>", "<lnk>", _link_create,
			(void **) meta->links, 1024);
	elog_xml_printl(xml, "<meta>", "<attachments>", "<attchmnt>",
			_attchmnt_create, (void **) meta->attchmnts, 1024);


	elog_io_writeLine(file, xml, strlen(xml));
	elog_io_writeLine(file, meta->subject, meta->lenSubject);
	elog_io_writeLine(file, dat, len);
	elog_io_close(file);
	free(xml);
	return 0;
}
char *elog_xml_start(const char *tag, unsigned int size)
{
	char *endTag = elog_xml_endTag(tag);
	char *ret = malloc((sizeof *ret) * (size + 1));
	ret[0] = '\0';
	strcat(ret, tag);
	strcat(ret, "\n");
	strcat(ret, endTag);
	strcat(ret, "\n");
	free(endTag);
	return ret;
}

int
elog_xml_printf(char *xml, char *template, const char *tag,
		const char *data)
{				// don't use me
	if (data == NULL)
		data = "";
	int len_ins = strlen(tag) * 2;
	int depth = 0;

	char **operations = elog_sp_breakToArr(template, '.');
	char *spot = xml;
	int c;
	for (c = 0; operations[c + 1] != NULL; ++c) {
		spot = &(strstr(spot, operations[c])[strlen(operations[c]) + 1]);	// seeking
		if (spot == NULL)
			return 1;
		++depth;
	}

	len_ins += depth * 3 + 1 + 3;	// for the tabs and returns
	char *endtag = elog_xml_endTag(tag);

	len_ins += strlen(data);

	char *final = malloc((sizeof *final) * (len_ins + 2));
	final[0] = '\0';

	char *space = "\t";

	char endline[2] = { '\n', '\0' };
	char *tmp = final;
	for (c = 0; c < depth; ++c)
		tmp = xml__cat(tmp, space);
	tmp = xml__cat(tmp, tag);
	tmp = xml__cat(tmp, endline);
	for (c = 0; c <= depth; ++c)
		tmp = xml__cat(tmp, space);
	tmp = xml__cat(tmp, data);	// copying in data
	tmp = xml__cat(tmp, endline);
	for (c = 0; c < depth; ++c)
		xml__cat(tmp, space);
	tmp = xml__cat(tmp, endtag);
	tmp = xml__cat(tmp, endline);

	char *save;
	elog_sp_cat(&save, spot, NULL);	// saving last half

	spot[0] = '\0';
	strcat(spot, final);	// assuming there is room!!!
	strcat(spot, save);

	free(save);
	free(final);
	free(endtag);
	elog_sp_ArrFree(operations);

	return 0;

}

void elog_xml_scanf(const char *meta, char *template, void *res)
{
	char **operations = elog_sp_breakToArr(template, '.');
	if (operations == NULL)
		return;		// error

	char *current = elog_xml_tagCapture(meta, operations[0]);
	free(operations[0]);
	int c;
	for (c = 1; operations[c] != NULL && operations[c][0] != '%'
	     && current != NULL; ++c) {
		char *tmp = elog_xml_tagCapture(current, operations[c]);
		free(current);
		current = tmp;
		free(operations[c]);
	}
	if (operations[c] == NULL || current == NULL) {
		if (current == NULL)
			for (; operations[c] != NULL; ++c)
				free(operations[c]);
		free(operations);
		return;
	}

	int l = c + 1;
	for (; operations[l] != NULL; ++l)
		free(operations[l]);


	switch (operations[c][1]) {
	case 's':
		{
			char *str = elog_sp_whiteSpaceRemove(current);
			char **ans = res;	// removing void pointer.
			*ans = str;
			break;
		}
	case 'i':
		{
			char *str = elog_sp_whiteSpaceRemove(current);
			int *i = res;
			*i = elog_sp_stringToShort(str);
			free(str);
			break;
		}
	}

	free(current);
	free(operations[c]);
	free(operations);

}


void elog_xml_doc_free(struct elog_xml_doc *meta)
{
	if (meta == NULL)
		return;
	if (meta->subject != NULL)
		free(meta->subject);
	if (meta->last_edit != NULL)
		free(meta->last_edit);
	if (meta->fileName != NULL)
		free(meta->fileName);
	if (meta->created != NULL)
		free(meta->created);
	if (meta->text)
		free(meta->text);

	if (meta->links != NULL) {
		int c;
		for (c = 0; meta->links[c] != NULL; ++c) {
			free(meta->links[c]->href);
			free(meta->links[c]);
		}
		free(meta->links);
	}
	if (meta->attchmnts) {
		int c;
		for (c = 0; meta->attchmnts[c]; ++c) {
			free(meta->attchmnts[c]->loc);
			free(meta->attchmnts[c]->name);
			free(meta->attchmnts[c]);
		}
		free(meta->attchmnts);
	}
	meta->weather = -1;
	meta->mood = -1;

	if (meta->xml)
		free(meta->xml);
	elog_xml_file_info_free(meta->file_info);

	free(meta);
}
unsigned int elog_xml_getShort(char *tag, char *doc)
{
	char *x = elog_xml_tagCapture(doc, tag);
	char *y = elog_sp_whiteSpaceRemove(x);
	free(x);
	unsigned int z = elog_sp_stringToShort(y);
	free(y);
	return z;
}

char *elog_xml_getChar(char *tag, char *doc)
{
	char *x = elog_xml_tagCapture(doc, tag);
	char *y = elog_sp_whiteSpaceRemove(x);
	free(x);
	return y;
}
const struct elog_xml_link *elog_xml_lnk_find(struct elog_xml_doc *doc,
					      const char *title)
{
	/*
	 * char **arr = elog_sp_breakToArr(title, '-'); int loc =
	 * elog_sp_stringToShort(arr[0]); int end =
	 * elog_sp_stringToShort(arr[1]); free(arr[0]); free(arr[1]);
	 * free(arr); int c; for (c=0; doc->links[c] != NULL; ++c) if
	 * (doc->links[c]->start == loc && doc->links[c]->end == end) return
	 * doc->links[c]; 
	 */
	int n = elog_sp_stringToShort(title);
	int c;
	for (c = 0; doc->links[c] != NULL; ++c)
		if (doc->links[c]->num == n)
			return doc->links[c];

	return NULL;
}

void elog_xml_lnk_free(struct elog_xml_link *lnk)
{
	if (lnk != NULL) {
		free(lnk->href);
		free(lnk);
	}
}
char *elog_xml_lnk_genTitle(struct elog_xml_link *lnk)
{
	char *st = elog_sp_shortToString(lnk->start);
	char *nd = elog_sp_shortToString(lnk->end);
	char *ret;
	elog_sp_cat(&ret, st, "-", nd, NULL);
	free(st);
	free(nd);
	return ret;
}
void **elog_xml_scanl(const char *meta, const char *template,
		      const char *tag, void *(*callback) (char *))
{
	void **ret = malloc((sizeof *ret) * 1024);
	// we have an inherant limit of one thousand attachments.
	// that should cover people well.

	char *xml = NULL;
	char *template2;
	char *end = elog_xml_endTag(tag);
	int end_len = strlen(end);

	// first, we'll add some necessary scanf syntax
	elog_sp_cat(&template2, template, ".%s", NULL);
	elog_xml_scanf(meta, template2, &xml);
	free(template2);
	if (!xml) {
		free(end);
		free(xml);
		free(ret);
		return NULL;
	}
	// now we have, in xml, the xml structure within template (which is an 
	// xml path).

	int c = 0;
	char *p = strstr(xml, tag);	// the beginning of one of 
	// our tags
	while (p) {
		if (c > 1024) {
			free(end);
			free(xml);
			return ret;	// nasty failsafe
		}

		char *p2 = strstr(p, end);
		if (!p2) {
			p = strstr(&(p[end_len - 1]), tag);
			continue;
		}
		char bk = p2[end_len];
		p2[end_len] = '\0';	// the end of one tag

		void *q = callback(p);


		p2[end_len] = bk;
		p = strstr(&(p[end_len - 1]), tag);
		if (q)
			ret[c] = q;
		else
			continue;	// callback failed, start
		// on next root tag
		++c;
	}
	ret[c] = NULL;


	free(xml);
	free(end);
	return ret;
}



void
elog_xml_printl(char *meta, const char *template, const char *tag,
		const char *subTag, int (*callback) (void *, char *,
						     const char *),
		void **data, int estDatSize)
{
	if (!data)
		return;

	int c;
	for (c = 0; data[c] != NULL; ++c);	// I wanna know how many items we
	// have.

	int items = c;
	char *set = malloc((sizeof *set) * (strlen(subTag) + 10 + estDatSize) * (c + 1) * 2);	// this 
	// will 
	// become 
	// a 
	// set 
	// of 
	// tags 
	// like 
	// this:
	/*
	 * <attchmnt> DATA </attchmnt> <attchmnt> DATA </attchmnt> 
	 */

	int depth = 1;
	const char *p1 = template;
	for (; p1; p1 = strstr(p1, "."))
		++depth;	// counting depth.



	set[0] = '\0';
	char *p = set;
	for (c = 0; c < items; ++c) {
		char *entry = elog_xml_start(subTag,
					     (strlen(subTag) + 10 +
					      estDatSize) *
					     (sizeof *entry));
		if (callback(data[c], entry, subTag)) {
			elog_err_print_console
			    ("Error creating a tag in a list\n");
			continue;
		}
		// update depth
		// the following code is essentially for pretty-ification.
		int tabs = 0;
		int d = depth;
		int j;
		for (j = 0; entry[j]; ++j) {
			if (entry[j] == '\n')
				tabs += d;
		}

		d = depth;
		for (; j; --j) {
			if (entry[j] == '\n') {
				int k;
				for (k = 0; k < d; ++k)
					entry[j + tabs - (k)] = '\t';
				entry[j + tabs - k] = entry[j];
				tabs -= d;
			} else
				entry[j + tabs] = entry[j];
		}
		p = xml__cat(p, entry);
		free(entry);
	}


	char *t;
	elog_sp_cat(&t, template, ".%s", NULL);
	elog_xml_printf(meta, t, tag, set);
	free(set);
	// ^ make our root tag, and dumping in data.
}
