#ifndef ELOG_THREAD_H
#define ELOG_THREAD_H

/*Why me?
Threads exists to abstract the concept of threading as much as possible and 
to provide a common way to watch if threads finish (sync them in a sense).
This is intended to be a thin glue layer.

However, it may develop to something allowing more option passing
to functions called as threads.  Pthreads only allows one void pointer.

I can get around this with a struct and a set of semi-smart wrapper
functions.

*/


#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>

#define ELOG_THRD_PAT_NONE 1        //as quick as possible
#define ELOG_THRD_PAT_LESS 10       // 1/1000000s
#define ELOG_THRD_PAT_LITTLE 100    // 1/100000s
#define ELOG_THRD_PAT_MID 1000      // 1/10000s
#define ELOG_THRD_PAT_PLENTY 100000 // 1/10s

#define ELOG_THRD_STATE_BUSY 1
#define ELOG_THRD_STATE_DONE 0

struct elog_thread
{
  int state; //0 for finished, 1 for running};
  pthread_t sysThread;
  void *thread_data;
  void *(*func)(void *);
  void *(*func0)(void);
};


int elog_thrd_finger();
//Pre:
//Post:  This function returns 1 if threads have been compiled in.
//It will return 0 if they have not:  This keeps some of the #defines out
//because I find #defines confusing and refuse to use them if they
//don't provide a performance benefit.

struct elog_thread* elog_thr_thread_new();
void elog_thr_thread_free(struct elog_thread *th);

void elog_thrd_exit(struct elog_thread *th);
//Pre:  th is a running thread
//Post:  th will be killed.

void elog_thrd_finish(struct elog_thread *th, int patience);
//wait for thread to finish

struct elog_thread *elog_thrd_launch(void *(* func)(void*), void *func_data);
//Launch new thread as func.
//This will launch an internal function which launches the given function.  This

//function will handle making sure the thread is closed off while running and opened
//when finished.

	
struct elog_thread *elog_thrd_launch0(void *(* func)(void));
	
#endif
