;; ===================================================================================
;; Italian FESTIVAL Modules(IFM)
;; Copyright (C) 2001-2005 by the IFM Development Team
;; at "ISTC-SPFD CNR" and at "ITC-Irst".
;; ===================================================================================
;;	ISTC-SPFD CNR
;;		Istituto di Scienze e Tecnologie della Cognizione
;;		Sezione di Padova "Fonetica e Dialettologia"
;;		Consiglio Nazionale delle Ricerche
;;		Via G. Anghinoni, 10 - 35121 Padova
;;		tel (+39) 049 8274418 - fax (+39) 049 8274416
;;		e-mail: segreteria@pd.istc.cnr.it 
;; 
;;	ITC-irst
;;		Istituto Trentino di Cultura
;;		Centro per la ricerca scientifica e tecnologica 
;;		Via Santa Croce 77 - 38100 Trento ITALIA
;;		tel (+39) 0461-210111 - fax (+39) 0461-980436
;;		e-mail: info@itc.it 
;; ===================================================================================
;; This file is part of IFM.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; ===================================================================================
;; Authors:	Piero COSI, ISTC-SPFD CNR, (cosi@pd.istc.cnr.it)
;; 		Carlo DRIOLI
;; 		Graziano TISATO
;; 		Roberto GRETTER, ITC-irst (SSI/MPA), (gretter@itc.it) 
;; 		Fabio TESSER
;; ===================================================================================
;;		WEB:  http://www.pd.istc.cnr.it/TTS/ItalianFESTIVAL
;; ===================================================================================
;;
;;  A voice using the Loredana Panato diphones (it4) database in MBROLA format
;;  Collected February 2000 at IRST
;;
;; ===================================================================================
;;
;;
;;  Note this requires MBROLA which has its own licence different
;;;  from the one above
;;;
;;;  To install
;;;  Get the mrbola programs and it4 database from 
;;;     http://tcts.fpms.ac.be/synthesis/mbrola.html
;;;  1) put the mbrola executable in festival/lib/etc/[OSTYPE]/
;;;     where [OSTYPE] is the os type of your installation, there
;;;     will already be a directory of the appropriate name in
;;;     festival/lib/etc/ after you have installed festival (if there
;;;     isn't just add mbrola to festival/lib/etc/ instead)
;;;     The directory you put it in should also contain audsp (the
;;;     the audio spooler) as that directory is already in Festival's
;;;     path.
;;;  2) Unpack it4-010926.zip in
;;;        festival/lib/voices/italian/lp_mbrola/
;;;     that should the directory above the directory where this file is
;;;
;;;  call (voice_lp_mbrola) in festival to select the voice or
;;;  add to siteinit.scm 
;;;     (set! voice_default 'voice_lp_mbrola)
;;;  to make it always select this voice as the default


;;; Add the directory contains general italian stuff to load-path

(defvar lp_mbrola_dir (cdr (assoc 'lp_mbrola voice-locations)))

(set! load-path (cons (path-append lp_mbrola_dir "festvox/") load-path))
;; for common italian modules
(set! load-path (cons (path-append libdir "italian_scm/") load-path))

;;; other files we need
(require 'italian_phoneset)
(require 'italian_duration)
(require 'ifd_diph_ds_dur)
(require 'italian_intonation)
(require 'italian_lts)
(require 'italian_lexicon)
(require 'italian_phrasing)
(require 'italian_token)
(require 'italian_oredatetel)
(require 'italian_gpos)
(require 'italian_module)
(require 'ita_map)

(require 'italian_mbrola_unix)

;;VOICE ResEt....
(define (italian_voice_reset)
  "(italian_voice_reset)
Reset global variables back to previous voice."
  (set! token.prepunctuation italian_previous_tok_prepunc)
  (set! token.punctuation italian_previous_tok_punc) ;F_MOD per l'italiano devo toglier l'accento ' dalla punteggiatura e non dalla prepunteggiatura
  (load (path-append libdir "synthesis.scm"));;per togliere i set dei moduli da noi utilizzati
  
)

;;;  Full voice definition 
(define (voice_lp_mbrola)
"(voice_italian_lp)
Set up synthesis for Male Italian speaker: Piero Cosi"
  (voice_reset)
  
  (Parameter.set 'Language 'italian)
  ;; Phone set
  (Parameter.set 'PhoneSet 'italian)
  (PhoneSet.select 'italian)

  ;; numeric expansion
  (Parameter.set 'Token_Method 'Token_Any)
  (set! token_to_words italian_token_to_words)

  ;; Because of use of ' for accents remove it from prepunctuation
  (set! italian_previous_tok_prepunc token.prepunctuation)
  (set! italian_previous_tok_punc token.punctuation)
  (set! token.prepunctuation "\"'`({[")  ;)F_MOD ;default "\"'`({[")
  (set! token.punctuation "\".,:;!?(){}[]") ;F_MOD ;default "\"'`.,:;!?(){}[]" ....fabio ho tolto '`
  (set! token.whitespace " \t\n\r") ;fabio ha tolto il meno da whithe space per i numeri
  
  ;;; Postlexical rules
  (set! postlex_vowel_reduce_cart_tree  nil)
  (set! postlex_rules_hooks nil)
 
  ;; No pos prediction (get it from lexicon)
  (set! pos_lex_name nil)
  ;; Phrase break prediction by punctuation
  (set! pos_supported nil) ;; well not real pos anyhow
  ;; Phrasing
  (set! phrase_cart_tree italian_phrase_cart_tree)
  (Parameter.set 'Phrase_Method 'cart_tree)
  
 ;; Lexicon selection
 ;(lex.select "italian")
 (lex.select "otherlex")

  
;;;;;;; F0 prediction ;;;;;;;;;;;;;;; 

;;;;;;TREEE;;;;
;; (set! F0start_tree ifd_diph_ds::start_f0)
;; (set! F0mid_tree ifd_diph_ds::mid_f0)
;; (set! F0end_tree ifd_diph_ds::end_f0)
;; (set! int_params
;; 	'((target_f0_mean 110) (target_f0_std 10)
;; 	  (model_f0_mean 147) (model_f0_std 34.76)))
;; (Parameter.set 'Int_Target_Method Int_Targets_Tree)
;;  (Parameter.set 'Int_Method 'General)
;; (set! int_accent_cart_tree italian_accent_cart_tree)
;;;;;;FINE TREEE;;;;

;;;;;;;;;;;;  LR  ;;;;;;;;;;;;;;;;;;;;;;
;  (set! f0_lr_start start_ols.f0_ols)
;  (set! f0_lr_mid mid_ols.f0_ols)
;  (set! f0_lr_end end_ols.f0_ols)

;  (set! int_lr_params
;  	'((target_f0_mean 110) (target_f0_std 10)
;  	  (model_f0_mean 147) (model_f0_std 34.76)))
;  (Parameter.set 'Int_Target_Method Int_Targets_LR)
;  (Parameter.set 'Int_Method 'General)
;  (set! int_accent_cart_tree italian_accent_cart_tree)
;;;;;;;;;;;;;;;;;;FINE LR  ;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;GENERAL;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
 ;; Accent and tone prediction
 (set! int_accent_cart_tree italian_accent_cart_tree)
 (Parameter.set 'Int_Target_Method 'Simple)
 (Parameter.set 'Int_Method 'General)
  ;;INTONAZIONE F_W+Question
  ;;targ_func_fw_q_fem
  (set! int_general_params (list (list 'targ_func targ_func_fw_q_fem)))
  
;;;;;;;;;;;;;;;;;;;;;;FINE GENERAL;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;Part of speech Function Word
 (set! guess_pos italian_guess_pos)

;; Pauses prediction
 (Parameter.set 'Pause_Method Classic_Pauses_mB)

;;;;;;;;;;;; Duration prediction ;;;;;;;;;;;;;;
;; David Sassoli ;;
 (set! duration_cart_tree ifd_diph_ds::zdurtree)
 (set! duration_ph_info ifd_diph_ds::phone_durs)
  (Parameter.set 'Duration_Method 'Tree_ZScores)

  ;; Waveform synthesizer: diphones
  ;; Waveform synthesizer: MBROLA it3 diphones
  (Parameter.set 'Synth_Method MBROLA_Synth)
  ;;  Because we need an extra parameter in the new version of mbrola
  ;;  we add that parameter to the database "name"
  (set! mbrola_progname "mbrola")
  ;;  Newer versions of mbrola require the -I flag
  ;(set! mbrola_database 
;	(format 
;	 nil
;	 "-I %s%s %s%s "
;         en1_mbrola_dir "en1mrpa"
;      	  en1_mbrola_dir "en1/en1" 
;	 ))
  ;; *OLD MBROLA* doesn't require the -I flag and does it by argumnent order
  ;; uncomment the following if you are using an older version of mbrola
  (set! mbrola_database 
	(format 
	 nil
	 "-e %s%s "
	 lp_mbrola_dir "it4/it4"
	 ))

  
  (require 'italian_module_flush)
  ;; set callback to restore some original values changed by the italian voice
  (set! current_voice_reset italian_voice_reset)
  (set! current-voice 'lp_mbrola)
)


(proclaim_voice
 'lp_mbrola
 '((language italian)
   (gender male)
   (dialect none)
   (description
    "This voice provides a Italian male voice using a MBROLA diphone synthesis method.  The lexicon
     is provived by a set of letter to sound rules producing pronunciation
     accents and syllabification.  The durations, intonation and
     prosodic phrasing are minimal but are acceptable for simple
     examples.")))

(provide 'lp_mbrola)