;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                         Copyright (c) 1998                            ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(set! polish_number_declensions

;Nominative - mianownik
;Genitive - dopel/niacz
;Dative - celownik
;Accusative - biernik
;Vocative - wol/acz(not included) 
;Instrumental - narze~dnik z
;Locative - miejscownik o

'((jeden                       ;1
    (card-nom-fem jedna)
    (card-gen-fem jednej)
    (card-dat-fem jednej)
    (card-acc-fem jedna)
    (card-inst-fem jedno~)
    (card-loc-fem jednej))
(jeden
    (card-nom-masc jeden)
    (card-gen-masc jednego)
    (card-dat-masc jednemu)
    (card-acc-masc jednego)
    (card-inst-masc jednym)
    (card-loc-masc jednym))
(jeden
    (card-nom-neut jedno)
    (card-gen-neut jednego)
    (card-dat-neut jednemu)
    (card-acc-neut jednego)
    (card-inst-neut jednym)
    (card-loc-neut jednym))
(dwa                          ;2
    (card-nom-fem dwie)
    (card-gen-fem dwu~ch)
    (card-dat-fem dwum)
    (card-acc-fem dwie)
    (card-inst-fem dwoma)
    (card-loc-fem dwu~ch))
(dwa
    (card-nom-masc dwu~ch)
    (card-gen-masc dwu~ch)
    (card-dat-masc dwum)
    (card-acc-masc dwu~ch)
    (card-inst-masc dwoma)
    (card-loc-masc dwu~ch))
(dwa
    (card-nom-neut dwa)
    (card-gen-neut dwu~ch)
    (card-dat-neut dwum)
    (card-acc-neut dwa)
    (card-inst-neut dwoma) 
    (card-loc-neut dwu~ch))
(trzy                        ;3
    (card-nom-fem trzy) 
    (card-gen-fem trzech)
    (card-dat-fem trzem)
    (card-acc-fem trzy)
    (card-inst-fem trzema)
    (card-loc-fem trzech))
(trzy
    (card-nom-masc trzech)
    (card-gen-masc trzech)
    (card-dat-masc trzem)
    (card-acc-masc trzech)
    (card-inst-masc trzema)
    (card-loc-masc trzech))
(trzy
    (card-nom-neut trzy)
    (card-gen-neut trzech)
    (card-dat-neut trzem)
    (card-acc-neut trzy)
    (card-inst-neut trzema)
    (card-loc-neut trzech))
(cztery                       ;4
    (card-nom-fem cztery) 
    (card-gen-fem czterech)
    (card-dat-fem czterem)
    (card-acc-fem cztery)
    (card-inst-fem czterema)
    (card-loc-fem czterech))
(cztery                       
    (card-nom-masc czterech) 
    (card-gen-masc czterech)
    (card-dat-masc czterem)
    (card-acc-masc czterech)
    (card-inst-masc czterema)
    (card-loc-masc czterech))
(cztery                       
    (card-nom-neut cztery) 
    (card-gen-neut czterech)
    (card-dat-neut czterem)
    (card-acc-neut cztery)
    (card-inst-neut czterema)
    (card-loc-neut czterech))
(pie~c~                         ;5
    (card-nom-fem pie~c~) 
    (card-gen-fem pie~ciu)
    (card-dat-fem pie~ciu)
    (card-acc-fem pie~c~)
    (card-inst-fem pie~cioma)
    (card-loc-fem pie~ciu))
(pie~c~                         
    (card-nom-masc pie~ciu) 
    (card-gen-masc pie~ciu)
    (card-dat-masc pie~ciu)
    (card-acc-masc pie~ciu)
    (card-inst-masc pie~cioma)
    (card-loc-masc pie~ciu))
(pie~c~ 
    (card-nom-neut pie~c~) 
    (card-gen-neut pie~ciu)
    (card-dat-neut pie~ciu)
    (card-acc-neut pie~c~)
    (card-inst-neut pie~cioma)
    (card-loc-neut pie~ciu))
(szes~c~                        ;6
    (card-nom-fem szes~c~) 
    (card-gen-fem szes~ciu)
    (card-dat-fem szes~ciu)
    (card-acc-fem szes~c~)
    (card-inst-fem szes~cioma)
    (card-loc-fem szes~ciu))
(szes~c~                         
    (card-nom-masc szes~ciu) 
    (card-gen-masc szes~ciu)
    (card-dat-masc szes~ciu)
    (card-acc-masc szes~ciu)
    (card-inst-masc szes~cioma)
    (card-loc-masc szes~ciu))
(szes~c~ 
    (card-nom-neut szes~c~) 
    (card-gen-neut szes~ciu)
    (card-dat-neut szes~ciu)
    (card-acc-neut szes~c~)
    (card-inst-neut szes~cioma)
    (card-loc-neut szes~ciu))
(siedem                             ;7
    (card-nom-fem siedem) 
    (card-gen-fem siedmiu)
    (card-dat-fem siedmiu)
    (card-acc-fem siedem)
    (card-inst-fem siedmioma)
    (card-loc-fem siedmiu))
(siedem                         
    (card-nom-masc siedmiu) 
    (card-gen-masc siedmiu)
    (card-dat-masc siedmiu)
    (card-acc-masc siedmiu)
    (card-inst-masc siedmioma)
    (card-loc-masc siedmiu))
(siedem 
    (card-nom-neut siedem) 
    (card-gen-neut siedmiu)
    (card-dat-neut siedmiu)
    (card-acc-neut siedem)
    (card-inst-neut siedmioma)
    (card-loc-neut siedmiu))
(osiem                           ;8
    (card-nom-fem osiem) 
    (card-gen-fem os~miu)
    (card-dat-fem os~miu)
    (card-acc-fem osiem)
    (card-inst-fem os~mioma)
    (card-loc-fem os~miu))
(osiem                         
    (card-nom-masc os~miu) 
    (card-gen-masc os~miu)
    (card-dat-masc os~miu)
    (card-acc-masc os~miu)
    (card-inst-masc os~mioma)
    (card-loc-masc os~miu))
(osiem                           
    (card-nom-neut osiem) 
    (card-gen-neut os~miu)
    (card-dat-neut os~miu)
    (card-acc-neut osiem)
    (card-inst-neut os~mioma)
    (card-loc-neut os~miu))
(dziewie~c~                      ;9
    (card-nom-fem dziewie~c~) 
    (card-gen-fem dziewie~ciu)
    (card-dat-fem dziewie~ciu)
    (card-acc-fem dziewie~c~)
    (card-inst-fem dziewie~cioma)
    (card-loc-fem dziewie~ciu))
(dziewie~c~                        
    (card-nom-masc dziewie~ciu) 
    (card-gen-masc dziewie~ciu)
    (card-dat-masc dziewie~ciu)
    (card-acc-masc dziewie~ciu)
    (card-inst-masc dziewie~cioma)
    (card-loc-masc dziewie~ciu))
(dziewie~c~                     
    (card-nom-neut dziewie~c~) 
    (card-gen-neut dziewie~ciu)
    (card-dat-neut dziewie~ciu)
    (card-acc-neut dziewie~c~)
    (card-inst-neut dziewie~cioma)
    (card-loc-neut dziewie~ciu))
(dziesie~c~                           ;10
    (card-nom-fem dziesie~c~) 
    (card-gen-fem dziesie~ciu)
    (card-dat-fem dziesie~ciu)
    (card-acc-fem dziesie~c~)
    (card-inst-fem dziesie~cioma)
    (card-loc-fem dziesie~ciu))
(dziesie~c~                        
    (card-nom-masc dziesie~ciu) 
    (card-gen-masc dziesie~ciu)
    (card-dat-masc dziesie~ciu)
    (card-acc-masc dziesie~ciu)
    (card-inst-masc dziesie~cioma)
    (card-loc-masc dziesie~ciu))
(dziesie~c~                     
    (card-nom-neut dziesie~c~) 
    (card-gen-neut dziesie~ciu)
    (card-dat-neut dziesie~ciu)
    (card-acc-neut dziesie~c~)
    (card-inst-neut dziesie~cioma)
    (card-loc-neut dziesie~ciu))
(jedenas~cie                          ;11
    (card-nom-fem jedenas~cie) 
    (card-gen-fem jedenastu)
    (card-dat-fem jedenastu)
    (card-acc-fem jedenas~cie)
    (card-inst-fem jedenastoma)
    (card-loc-fem jedenastu))
(jedenas~cie                        
    (card-nom-masc jedenastu) 
    (card-gen-masc jedenastu)
    (card-dat-masc jedenastu)
    (card-acc-masc jedenastu)
    (card-inst-masc jedenastoma)
    (card-loc-masc jedenastu))
(jedenas~cie                    
    (card-nom-neut jedenas~cie) 
    (card-gen-neut jedenastu)
    (card-dat-neut jedenastu)
    (card-acc-neut jedenas~cie)
    (card-inst-neut jedenastoma)
    (card-loc-neut jedenastu))
(trzynas~cie                          ;13
    (card-nom-fem trzynas~cie) 
    (card-gen-fem trzynastu)
    (card-dat-fem trzynastu)
    (card-acc-fem trzynas~cie)
    (card-inst-fem trzynastoma)
    (card-loc-fem trzynastu))
(trzynas~cie                       
    (card-nom-masc trzynastu) 
    (card-gen-masc trzynastu)
    (card-dat-masc trzynastu)
    (card-acc-masc trzynastu)
    (card-inst-masc trzynastoma)
    (card-loc-masc trzynastu))
(trzynas~cie                 
    (card-nom-neut trzynas~cie) 
    (card-gen-neut trzynastu)
    (card-dat-neut trzynastu)
    (card-acc-neut trzynas~cie)
    (card-inst-neut trzynastoma)
    (card-loc-neut trzynastu))
(czternas~cie                         ;14
    (card-nom-fem czternas~cie) 
    (card-gen-fem czternastu)
    (card-dat-fem czternastu)
    (card-acc-fem czternas~cie)
    (card-inst-fem czternastoma)
    (card-loc-fem czternastu))
(czternas~cie                     
    (card-nom-masc czternastu) 
    (card-gen-masc czternastu)
    (card-dat-masc czternastu)
    (card-acc-masc czternastu)
    (card-inst-masc czternastoma)
    (card-loc-masc czternastu))
(czternas~cie                
    (card-nom-neut czternas~cie) 
    (card-gen-neut czternastu)
    (card-dat-neut czternastu)
    (card-acc-neut czternas~cie)
    (card-inst-neut czternastoma)
    (card-loc-neut czternastu))
(pie~tnas~cie                         ;15
    (card-nom-fem pie~tnas~cie) 
    (card-gen-fem pie~tnastu)
    (card-dat-fem pie~tnastu)
    (card-acc-fem pie~tnas~cie)
    (card-inst-fem pie~tnastoma)
    (card-loc-fem pie~tnastu))
(pie~tnas~cie                     
    (card-nom-masc pie~tnastu) 
    (card-gen-masc pie~tnastu)
    (card-dat-masc pie~tnastu)
    (card-acc-masc pie~tnastu)
    (card-inst-masc pie~tnastoma)
    (card-loc-masc pie~tnastu))
(pie~tnas~cie               
    (card-nom-neut pie~tnas~cie) 
    (card-gen-neut pie~tnastu)
    (card-dat-neut pie~tnastu)
    (card-acc-neut pie~tnas~cie)
    (card-inst-neut pie~tnastoma)
    (card-loc-neut pie~tnastu))
(szesnas~cie                          ;16
    (card-nom-fem szesnas~cie) 
    (card-gen-fem szesnastu)
    (card-dat-fem szesnastu)
    (card-acc-fem szesnas~cie)
    (card-inst-fem szesnastoma)
    (card-loc-fem szesnastu))
(szesnas~cie                     
    (card-nom-masc szesnastu) 
    (card-gen-masc szesnastu)
    (card-dat-masc szesnastu)
    (card-acc-masc szesnastu)
    (card-inst-masc szesnastoma) 
    (card-loc-masc szesnastu))
(szesnas~cie               
    (card-nom-neut szesnas~cie) 
    (card-gen-neut szesnastu)
    (card-dat-neut szesnastu)
    (card-acc-neut szesnas~cie)
    (card-inst-neut szesnastoma)
    (card-loc-neut szesnastu))
(siedemnas~cie                        ;17
    (card-nom-fem siedemnas~cie) 
    (card-gen-fem siedemnastu)
    (card-dat-fem siedemnastu)
    (card-acc-fem siedemnas~cie)
    (card-inst-fem siedemnastoma)
    (card-loc-fem siedemnastu))
(siedemnas~cie                    
    (card-nom-masc siedemnastu) 
    (card-gen-masc siedemnastu)
    (card-dat-masc siedemnastu)
    (card-acc-masc siedemnastu)
    (card-inst-masc siedemnastoma) 
    (card-loc-masc siedemnastu))
(siedemnas~cie               
    (card-nom-neut siedemnas~cie) 
    (card-gen-neut siedemnastu)
    (card-dat-neut siedemnastu)
    (card-acc-neut siedemnas~cie)
    (card-inst-neut siedemnastoma)
    (card-loc-neut siedemnastu))
(osiemnas~cie                         ;18
    (card-nom-fem osiemnas~cie) 
    (card-gen-fem osiemnastu)
    (card-dat-fem osiemnastu)
    (card-acc-fem osiemnas~cie)
    (card-inst-fem osiemnastoma)
    (card-loc-fem osiemnastu))
(osiemnas~cie                   
    (card-nom-masc osiemnastu) 
    (card-gen-masc osiemnastu)
    (card-dat-masc osiemnastu)
    (card-acc-masc osiemnastu)
    (card-inst-masc osiemnastoma) 
    (card-loc-masc osiemnastu))
(osiemnas~cie              
    (card-nom-neut osiemnas~cie) 
    (card-gen-neut osiemnastu)
    (card-dat-neut osiemnastu)
    (card-acc-neut osiemnas~cie)
    (card-inst-neut osiemnastoma)
    (card-loc-neut osiemnastu))
(dziewie~tnas~cie                      ;19
    (card-nom-fem dziewie~tnas~cie) 
    (card-gen-fem dziewie~tnastu)
    (card-dat-fem dziewie~tnastu)
    (card-acc-fem dziewie~tnas~cie)
    (card-inst-fem dziewie~tnastoma)
    (card-loc-fem dziewie~tnastu))
(dziewie~tnas~cie                  
    (card-nom-masc dziewie~tnastu) 
    (card-gen-masc dziewie~tnastu)
    (card-dat-masc dziewie~tnastu)
    (card-acc-masc dziewie~tnastu)
    (card-inst-masc dziewie~tnastoma) 
    (card-loc-masc dziewie~tnastu))
(dziewie~tnas~cie            
    (card-nom-neut dziewie~tnas~cie) 
    (card-gen-neut dziewie~tnastu)
    (card-dat-neut dziewie~tnastu)
    (card-acc-neut dziewie~tnas~cie)
    (card-inst-neut dziewie~tnastoma)
    (card-loc-neut dziewie~tnastu))
(dwadzies~cia                         ;20
    (card-nom-fem dwadzies~cia) 
    (card-gen-fem dwudziestu)
    (card-dat-fem dwudziestu)
    (card-acc-fem dwadzies~cia)
    (card-inst-fem dwudziestoma)
    (card-loc-fem dwudziestu))
(dwadzies~cia                   
    (card-nom-masc dwudziestu) 
    (card-gen-masc dwudziestu)
    (card-dat-masc dwudziestu)
    (card-acc-masc dwudziestu)
    (card-inst-masc dwudziestoma) 
    (card-loc-masc dwudziestu))
( dwadzies~cia           
    (card-nom-neut dwadzies~cia) 
    (card-gen-neut dwudziestu)
    (card-dat-neut dwudziestu)
    (card-acc-neut dwadzies~cia)
    (card-inst-neut dwudziestoma)
    (card-loc-neut dwudziestu))
(trzydzies~ci                         ;30
    (card-nom-fem trzydzies~ci) 
    (card-gen-fem trzydziestu)
    (card-dat-fem trzydziestu)
    (card-acc-fem trzydzies~ci)
    (card-inst-fem trzydziestoma)
    (card-loc-fem trzydziestu))
(trzydzies~ci                  
    (card-nom-masc trzydziestu) 
    (card-gen-masc trzydziestu)
    (card-dat-masc trzydziestu)
    (card-acc-masc trzydziestu)
    (card-inst-masc trzydziestoma) 
    (card-loc-masc trzydziestu))
(trzydzies~ci            
    (card-nom-neut trzydzies~ci) 
    (card-gen-neut trzydziestu)
    (card-dat-neut trzydziestu)
    (card-acc-neut trzydzies~ci)
    (card-inst-neut trzydziestoma)
    (card-loc-neut trzydziestu))
(czterdzies~ci                        ;40
    (card-nom-fem czterdzies~ci) 
    (card-gen-fem czterdziestu)
    (card-dat-fem czterdziestu)
    (card-acc-fem czterdzies~ci)
    (card-inst-fem czterdziestoma)
    (card-loc-fem czterdziestu))
(czterdzies~ci                  
    (card-nom-masc czterdziestu) 
    (card-gen-masc czterdziestu)
    (card-dat-masc czterdziestu)
    (card-acc-masc czterdziestu)
    (card-inst-masc czterdziestoma) 
    (card-loc-masc czterdziestu))
(czterdzies~ci           
    (card-nom-neut czterdzies~ci) 
    (card-gen-neut czterdziestu)
    (card-dat-neut czterdziestu)
    (card-acc-neut czterdzies~ci)
    (card-inst-neut czterdziestoma)
    (card-loc-neut czterdziestu))
(pie~c~dziesio~t                      ;50
    (card-nom-fem pie~c~dziesio~t) 
    (card-gen-fem pie~c~dziesie~ciu)
    (card-dat-fem pie~c~dziesie~ciu)
    (card-acc-fem pie~c~dziesio~t)
    (card-inst-fem pie~c~dziesie~cioma)
    (card-loc-fem pie~c~dziesie~ciu))
(pie~c~dziesio~t                  
    (card-nom-masc pie~c~dziesie~ciu) 
    (card-gen-masc pie~c~dziesie~ciu)
    (card-dat-masc pie~c~dziesie~ciu)
    (card-acc-masc pie~c~dziesie~ciu)
    (card-inst-masc pie~c~dziesie~cioma) 
    (card-loc-masc pie~c~dziesie~ciu))
(pie~c~dziesio~t            
    (card-nom-neut pie~c~dziesio~t) 
    (card-gen-neut pie~c~dziesie~ciu)
    (card-dat-neut pie~c~dziesie~ciu)
    (card-acc-neut pie~c~dziesio~t)
    (card-inst-neut pie~c~dziesie~cioma)
    (card-loc-neut pie~c~dziesie~ciu))
(szes~c~dziesio~t                     ;60
    (card-nom-fem szes~c~dziesio~t) 
    (card-gen-fem szes~c~dziesie~ciu)
    (card-dat-fem szes~c~dziesie~ciu)
    (card-acc-fem szes~c~dziesio~t)
    (card-inst-fem szes~c~dziesie~cioma)
    (card-loc-fem szes~c~dziesie~ciu))
(szes~c~dziesio~t                   
    (card-nom-masc szes~c~dziesie~ciu) 
    (card-gen-masc szes~c~dziesie~ciu)
    (card-dat-masc szes~c~dziesie~ciu)
    (card-acc-masc szes~c~dziesie~ciu)
    (card-inst-masc szes~c~dziesie~cioma) 
    (card-loc-masc szes~c~dziesie~ciu))
( szes~c~dziesio~t            
    (card-nom-neut szes~c~dziesio~t) 
    (card-gen-neut szes~c~dziesie~ciu)
    (card-dat-neut szes~c~dziesie~ciu)
    (card-acc-neut szes~c~dziesio~t)
    (card-inst-neut szes~c~dziesie~cioma)
    (card-loc-neut szes~c~dziesie~ciu))
(siedemdziesio~t                      ;70
    (card-nom-fem siedemdziesio~t) 
    (card-gen-fem siedemdziesie~ciu)
    (card-dat-fem siedemdziesie~ciu)
    (card-acc-fem siedemdziesio~t)
    (card-inst-fem siedemdziesie~cioma)
    (card-loc-fem siedemdziesie~ciu))
(siedemdziesio~t                  
    (card-nom-masc siedemdziesie~ciu) 
    (card-gen-masc siedemdziesie~ciu)
    (card-dat-masc siedemdziesie~ciu)
    (card-acc-masc siedemdziesie~ciu)
    (card-inst-masc dziewie~tnastoma) 
    (card-loc-masc siedemdziesie~ciu))
(siedemdziesio~t            
    (card-nom-neut siedemdziesio~t) 
    (card-gen-neut siedemdziesie~ciu)
    (card-dat-neut siedemdziesie~ciu)
    (card-acc-neut siedemdziesio~t)
    (card-inst-neut siedemdziesie~cioma)
    (card-loc-neut siedemdziesie~ciu))
(osiemdziesio~t                       ;80
    (card-nom-fem osiemdziesio~t) 
    (card-gen-fem osiemdziesie~ciu)
    (card-dat-fem osiemdziesie~ciu)
    (card-acc-fem osiemdziesio~t)
    (card-inst-fem osiemdziesie~cioma)
    (card-loc-fem osiemdziesie~ciu))
( osiemdziesio~t                 
    (card-nom-masc osiemdziesie~ciu) 
    (card-gen-masc osiemdziesie~ciu)
    (card-dat-masc osiemdziesie~ciu)
    (card-acc-masc osiemdziesie~ciu)
    (card-inst-masc osiemdziesie~cioma) 
    (card-loc-masc osiemdziesie~ciu))
( osiemdziesio~t           
    (card-nom-neut osiemdziesio~t) 
    (card-gen-neut osiemdziesie~ciu)
    (card-dat-neut osiemdziesie~ciu)
    (card-acc-neut osiemdziesio~t)
    (card-inst-neut osiemdziesie~cioma)
    (card-loc-neut osiemdziesie~ciu))
(dziewie~c~dziesio~t                  ;90
    (card-nom-fem dziewie~c~dziesio~t) 
    (card-gen-fem dziewie~c~dziesie~ciu)
    (card-dat-fem dziewie~c~dziesie~ciu)
    (card-acc-fem dziewie~c~dziesio~t)
    (card-inst-fem dziewie~dziesie~cioma)
    (card-loc-fem dziewie~c~dziesie~ciu))
(dziewie~c~dziesio~t                  
    (card-nom-masc dziewie~c~dziesie~ciu) 
    (card-gen-masc dziewie~c~dziesie~ciu)
    (card-dat-masc dziewie~c~dziesie~ciu)
    (card-acc-masc dziewie~c~dziesie~ciu)
    (card-inst-masc dziewie~dziesie~cioma) 
    (card-loc-masc dziewie~c~dziesie~ciu))
(dziewie~c~dziesio~t            
    (card-nom-neut dziewie~c~dziesio~t) 
    (card-gen-neut dziewie~c~dziesie~ciu)
    (card-dat-neut dziewie~c~dziesie~ciu)
    (card-acc-neut dziewie~c~dziesio~t)
    (card-inst-neut dziewie~dziesie~cioma)
    (card-loc-neut dziewie~c~dziesie~ciu))
(sto                                  ;100
    (card-nom-fem sto)
    (card-gen-fem stu)
    (card-dat-fem stu)
    (card-acc-fem sto)
    (card-inst-fem stu)
    (card-loc-fem stu))
(sto                 
    (card-nom-masc stu) 
    (card-gen-masc stu)
    (card-dat-masc stu)
    (card-acc-masc stu)
    (card-inst-masc stu) 
    (card-loc-masc stu))
(sto           
    (card-nom-neut sto) 
    (card-gen-neut stu)
    (card-dat-neut stu)
    (card-acc-neut sto)
    (card-inst-neut stu)
    (card-loc-neut stu))
(dwies~cie                            ;200
    (card-nom-fem dwies~cie) 
    (card-gen-fem dwustu)
    (card-dat-fem dwustu)
    (card-acc-fem dwies~cie)
    (card-inst-fem dwustoma)
    (card-loc-fem dwustu))
(dwies~cie                   
    (card-nom-masc dwustu) 
    (card-gen-masc dwustu)
    (card-dat-masc dwustu)
    (card-acc-masc dwustu)
    (card-inst-masc dwustoma) 
    (card-loc-masc dwustu))
(dwies~cie             
    (card-nom-neut dwies~cie) 
    (card-gen-neut dwustu)
    (card-dat-neut dwustu)
    (card-acc-neut dwies~cie)
    (card-inst-neut dwustoma)
    (card-loc-neut dwustu))
(trzysta                              ;300
    (card-nom-fem trzysta) 
    (card-gen-fem trzystu)
    (card-dat-fem trzystu)
    (card-acc-fem trzysta)
    (card-inst-fem trzystu)
    (card-loc-fem trzystu))
(trzysta                  
    (card-nom-masc trzystu) 
    (card-gen-masc trzystu)
    (card-dat-masc trzystu)
    (card-acc-masc trzystu)
    (card-inst-masc trzystu) 
    (card-loc-masc trzystu))
(trzysta            
    (card-nom-neut trzysta) 
    (card-gen-neut trzystu)
    (card-dat-neut trzystu)
    (card-acc-neut trzysta)
    (card-inst-neuttrzystu )
    (card-loc-neut trzystu))
(czterysta                            ;400
    (card-nom-fem czterysta) 
    (card-gen-fem czterystu)
    (card-dat-fem czterystu)
    (card-acc-fem czterysta)
    (card-inst-fem czterystu)
    (card-loc-fem czterystu))
(czterysta                 
    (card-nom-masc czterystu) 
    (card-gen-masc czterystu)
    (card-dat-masc czterystu)
    (card-acc-masc czterystu)
    (card-inst-masc czterystu) 
    (card-loc-masc czterystu))
(czterysta           
    (card-nom-neut czterysta) 
    (card-gen-neut czterystu)
    (card-dat-neut czterystu)
    (card-acc-neut czterysta)
    (card-inst-neut czterysu)
    (card-loc-neut czterystu))
(pie~c~set                            ;500
    (card-nom-fem pie~c~set) 
    (card-gen-fem pie~ciuset)
    (card-dat-fem pie~ciuset)
    (card-acc-fem pie~c~set)
    (card-inst-fem pie~ciuset)
    (card-loc-fem pie~ciuset))
(pie~c~set                 
    (card-nom-masc pie~ciuset) 
    (card-gen-masc pie~ciuset)
    (card-dat-masc pie~ciuset)
    (card-acc-masc pie~ciuset)
    (card-inst-masc pie~ciuset) 
    (card-loc-masc pie~ciuset))
(pie~c~set          
    (card-nom-neut pie~c~set) 
    (card-gen-neut pie~ciuset)
    (card-dat-neut pie~ciuset)
    (card-acc-neut pie~c~set)
    (card-inst-neut pie~ciuset)
    (card-loc-neut pie~ciuset))
(szes~c~set                           ;600
    (card-nom-fem szes~c~set) 
    (card-gen-fem szes~ciuset)
    (card-dat-fem szes~ciuset)
    (card-acc-fem szes~c~set)
    (card-inst-fem szes~ciuset)
    (card-loc-fem szes~ciuset))
(szes~c~set               
    (card-nom-masc szes~ciuset) 
    (card-gen-masc szes~ciuset)
    (card-dat-masc szes~ciuset)
    (card-acc-masc szes~ciuset)
    (card-inst-masc szes~ciuset) 
    (card-loc-masc szes~ciuset))
(szes~c~set         
    (card-nom-neut szes~c~set) 
    (card-gen-neut szes~ciuset)
    (card-dat-neut szes~ciuset)
    (card-acc-neut szes~c~set)
    (card-inst-neut szes~ciuset)
    (card-loc-neut szes~ciuset))
(siedemset                            ;700
    (card-nom-fem siedemset) 
    (card-gen-fem siedmiuset)
    (card-dat-fem siedmiuset)
    (card-acc-fem siedemset)
    (card-inst-fem siedmiuset)
    (card-loc-fem siedmiuset))
(siedemset               
    (card-nom-masc siedmiuset) 
    (card-gen-masc siedmiuset)
    (card-dat-masc siedmiuset)
    (card-acc-masc siedmiuset)
    (card-inst-masc siedmiuset) 
    (card-loc-masc siedmiuset))
(siedemset         
    (card-nom-neut siedemset) 
    (card-gen-neut siedmiuset)
    (card-dat-neut siedmiuset)
    (card-acc-neut siedemset)
    (card-inst-neut siedmiuset)
    (card-loc-neut siedmiuset))
(osiemset                             ;800
    (card-nom-fem osiemset) 
    (card-gen-fem os~miuset)
    (card-dat-fem os~miuset)
    (card-acc-fem osiemset)
    (card-inst-fem os~miuset)
    (card-loc-fem os~miuset))
(osiemset               
    (card-nom-masc os~miuset) 
    (card-gen-masc os~miuset)
    (card-dat-masc os~miuset)
    (card-acc-masc os~miuset)
    (card-inst-masc os~miuset) 
    (card-loc-masc os~miuset))
(osiemset         
    (card-nom-neut osiemset) 
    (card-gen-neut os~miuset)
    (card-dat-neut os~miuset)
    (card-acc-neut osiemset)
    (card-inst-neut os~miuset)
    (card-loc-neut os~miuset))
(dziewie~c~set                        ;900
    (card-nom-fem dziewie~c~set) 
    (card-gen-fem dziewie~ciuset)
    (card-dat-fem dziewie~ciuset)
    (card-acc-fem dziewie~c~set)
    (card-inst-fem dziewie~ciuset)
    (card-loc-fem dziewie~ciuset))
(dziewie~c~set               
    (card-nom-masc dziewie~ciuset) 
    (card-gen-masc dziewie~ciuset)
    (card-dat-masc dziewie~ciuset)
    (card-acc-masc dziewie~ciuset)
    (card-inst-masc dziewie~ciuset) 
    (card-loc-masc dziewie~ciuset))
(dziewie~c~set         
    (card-nom-neut dziewie~c~set) 
    (card-gen-neut dziewie~ciuset)
    (card-dat-neut dziewie~ciuset)
    (card-acc-neut dziewie~c~set)
    (card-inst-neut dziewie~ciuset)
    (card-loc-neut dziewie~ciuset))
(jeden                                    ;1st
    (ord-nom-fem pierwsza)
    (ord-gen-fem pierwszej)
    (ord-dat-fem pierwszej)
    (ord-acc-fem pierwszo~)
    (ord-inst-fem pierwszo~)
    (ord-loc-fem pierwszej))
(jeden
    (ord-nom-masc pierwszy)
    (ord-gen-masc pierwszego)
    (ord-dat-masc pierwszemu)
    (ord-acc-masc pierwszego)
    (ord-inst-masc pierwszym)
    (ord-loc-masc pierwszym))
(jeden
    (ord-nom-neut pierwsze)
    (ord-gen-neut pierwszego)
    (ord-dat-neut pierwszemu)
    (ord-acc-neut pierwsze)
    (ord-inst-neut pierwszym)
    (ord-loc-neut pierwszym))
(dwa                                        ;2nd
    (ord-nom-fem druga)
    (ord-gen-fem drugiej)
    (ord-dat-fem drugiej)
    (ord-acc-fem drugo~)
    (ord-inst-fem drugo~)
    (ord-loc-fem drugiej))
(dwa
    (ord-nom-masc drugi)
    (ord-gen-masc drugiego)
    (ord-dat-masc drugiemu)
    (ord-acc-masc drugiego)
    (ord-inst-masc drugim)
    (ord-loc-masc drugim))
(dwa
    (ord-nom-neut drugie )
    (ord-gen-neut drugiego)
    (ord-dat-neut drugiemu)
    (ord-acc-neut drugie)
    (ord-inst-neut drugim)
    (ord-loc-neut drugim))
(trzy                                         ;3rd
    (ord-nom-fem trzecia)
    (ord-gen-fem trzeciej)
    (ord-dat-fem trzeciej)
    (ord-acc-fem trzecio~)
    (ord-inst-fem trzecio~)
    (ord-loc-fem trzeciej))
(trzy
    (ord-nom-masc trzeci)
    (ord-gen-masc trzeciego)
    (ord-dat-masc trzeciemu)
    (ord-acc-masc trzeciego)
    (ord-inst-masc trzecim)
    (ord-loc-masc trzecim))
(trzy
    (ord-nom-neut trzecie)
    (ord-gen-neut trzeciego)
    (ord-dat-neut trzeciemu)
    (ord-acc-neut trzecie)
    (ord-inst-neut trzecim)
    (ord-loc-neut trzecim))
(cztery                             ;4th
    (ord-nom-fem czwarta)
    (ord-gen-fem czwartej)
    (ord-dat-fem czwartej)
    (ord-acc-fem czwarto~)
    (ord-inst-fem czwarto~)
    (ord-loc-fem czwartej))
(cztery
    (ord-nom-masc czwarty)
    (ord-gen-masc czwartego)
    (ord-dat-masc czwartemu)
    (ord-acc-masc czwartego)
    (ord-inst-masc czwartym)
    (ord-loc-masc czwartym))
(cztery
    (ord-nom-neut czwarte)
    (ord-gen-neut czwartego)
    (ord-dat-neut czwartemu)
    (ord-acc-neut czwarte)
    (ord-inst-neut czwartym)
    (ord-loc-neut czwartym)) 
(pie~c~                                ;5th
    (ord-nom-fem pio~ta)
    (ord-gen-fem pio~tej)
    (ord-dat-fem pio~tej)
    (ord-acc-fem pio~to~)
    (ord-inst-fem pio~to~)
    (ord-loc-fem pio~tej))
(pie~c~
    (ord-nom-masc pio~ty)
    (ord-gen-masc pio~tego)
    (ord-dat-masc pio~temu)
    (ord-acc-masc pio~tego)
    (ord-inst-masc pio~tym)
    (ord-loc-masc pio~tym))
(pie~c~
    (ord-nom-neut pio~te)
    (ord-gen-neut pio~tego)
    (ord-dat-neut pio~temu)
    (ord-acc-neut pio~te)
    (ord-inst-neut pio~tym)
    (ord-loc-neut pio~tym))

(szes~c~                          ;6th
    (ord-nom-fem szu~sta)
    (ord-gen-fem szu~stej)
    (ord-dat-fem szu~stej)
    (ord-acc-fem szu~sto~)
    (ord-inst-fem szu~sto~)
    (ord-loc-fem szu~stej))
(szes~c~
    (ord-nom-masc szu~sty)
    (ord-gen-masc szu~stego)
    (ord-dat-masc szu~stemu)
    (ord-acc-masc szu~stego)
    (ord-inst-masc szu~stym)
    (ord-loc-masc szu~stym))
(szes~c~
    (ord-nom-neut szu~ste)
    (ord-gen-neut szu~stego)
    (ord-dat-neut szu~stemu)
    (ord-acc-neut szu~ste)
    (ord-inst-neut szu~stym)
    (ord-loc-neut szu~stym))
(siedem                              ;7th
    (ord-nom-fem siu~dma)
    (ord-gen-fem siu~dmej)
    (ord-dat-fem siu~dmej)
    (ord-acc-fem siu~dmo~)
    (ord-inst-fem siu~dmo~)
    (ord-loc-fem siu~dmej))
(siedem
    (ord-nom-masc siu~dmy)
    (ord-gen-masc siu~dmego)
    (ord-dat-masc siu~dmemu)
    (ord-acc-masc siu~dmego)
    (ord-inst-masc siu~dmym)
    (ord-loc-masc siu~dmym))
(siedem
    (ord-nom-neut siu~dme)
    (ord-gen-neut siu~dmego)
    (ord-dat-neut siu~dmemu)
    (ord-acc-neut siu~dme)
    (ord-inst-neut siu~dmym)
    (ord-loc-neut siu~dmym))
(osiem                                  ;8th
    (ord-nom-fem u~sma)
    (ord-gen-fem u~smej)
    (ord-dat-fem u~smej)
    (ord-acc-fem u~smo~)
    (ord-inst-fem u~smo~)
    (ord-loc-fem u~smej))
(osiem
    (ord-nom-masc u~smy)
    (ord-gen-masc u~smego)
    (ord-dat-masc u~smemu)
    (ord-acc-masc u~smego)
    (ord-inst-masc u~smym)
    (ord-loc-masc u~smym))
(osiem
    (ord-nom-neut u~sme)
    (ord-gen-neut u~smego)
    (ord-dat-neut u~smemu)
    (ord-acc-neut u~sme)
    (ord-inst-neut u~smym)
    (ord-loc-neut u~smym))
(dziewie~c~                              ;9th
    (ord-nom-fem dziewio~ta)
    (ord-gen-fem dziewio~tej)
    (ord-dat-fem dziewio~tej)
    (ord-acc-fem dziewio~to~)
    (ord-inst-fem dziewio~to~)
    (ord-loc-fem dziewio~tej))
(dziewie~c~
    (ord-nom-masc dziewio~ty)
    (ord-gen-masc dziewio~tego)
    (ord-dat-masc dziewio~temu)
    (ord-acc-masc dziewio~tego)
    (ord-inst-masc dziewio~tym)
    (ord-loc-masc dziewio~tym))
(dziewie~c~
    (ord-nom-neut dziewio~te)
    (ord-gen-neut dziewio~tego)
    (ord-dat-neut dziewio~temu)
    (ord-acc-neut dziewio~te)
    (ord-inst-neut dziewio~tym)
    (ord-loc-neut dziewio~tym))
(dziesie~c~                               ;10th
    (ord-nom-fem dziesio~ta)
    (ord-gen-fem dziesio~tej)
    (ord-dat-fem dziesio~tej)
    (ord-acc-fem dziesio~to~)
    (ord-inst-fem dziesio~to~)
    (ord-loc-fem dziesio~tej))
(dziesie~c~ 
    (ord-nom-masc dziesio~ty)
    (ord-gen-mas dziesio~tego)
    (ord-dat-masc dziesio~temu)
    (ord-acc-masc dziesio~tego)
    (ord-inst-masc dziesio~tym)
    (ord-loc-masc dziesio~tym))
(dziesie~c~ 
    (ord-nom-neut dziesio~te)
    (ord-gen-neut dziesio~tego)
    (ord-dat-neut dziesio~temu)
    (ord-acc-neut dziesio~te)
    (ord-inst-neut dziesio~tym)
    (ord-loc-neut dziesio~tym))
(jedenas~cie                                ;11th
    (ord-nom-fem jedenasta)
    (ord-gen-fem jedenastej)
    (ord-dat-fem jedenastej)
    (ord-acc-fem jedenasto~)
    (ord-inst-fem jedenasto~)
    (ord-loc-fem jedenastej))
(jedenas~cie   
    (ord-nom-masc jedenasty)
    (ord-gen-masc jedenastego)
    (ord-dat-masc jedenastemu)
    (ord-acc-masc jedenastego)
    (ord-inst-masc jedenastym)
    (ord-loc-masc jedenastym))
(jedenas~cie   
    (ord-nom-neut jedenaste)
    (ord-gen-neut jedenastego)
    (ord-dat-neut jedenastemu)
    (ord-acc-neut jedenaste)
    (ord-inst-neut jedenastym)
    (ord-loc-neut jedenastym))
(dwanas~cie                              ;12th
    (ord-nom-fem dwunasta)
    (ord-gen-fem dwunastej)
    (ord-dat-fem dwunastej)
    (ord-acc-fem dwunasto~)
    (ord-inst-fem dwunasto~)
    (ord-loc-fem dwunastej)
    (ord-nom-masc dwunasty)
    (ord-gen-masc dwunastego)
    (ord-dat-masc dwunastemu)
    (ord-acc-masc dwunastego)
    (ord-inst-masc dwunastym)
    (ord-loc-masc dwunastym)
    (card-nom-fem dwanas~cie) 
    (card-gen-fem dwunastu)
    (card-dat-fem dwunastu)
    (card-acc-fem dwanas~cie)
    (card-inst-fem dwunastoma)
    (card-loc-fem dwunastu)
    (card-nom-masc dwunastu) 
    (card-gen-masc dwunastu)
    (card-dat-masc dwunastu)
    (card-acc-masc dwunastu)
    (card-inst-masc dwunastoma)
    (card-loc-masc dwunastu)
    (card-nom-neut dwanas~cie) 
    (card-gen-neut dwunastu)
    (card-dat-neut dwunastu)
    (card-acc-neut dwanas~cie)
    (card-inst-neut dwunastoma)
    (card-loc-neut dwunastu)
    (ord-nom-neut dwunaste)
    (ord-gen-neut dwunastego)
    (ord-dat-neut dwunastemu)
    (ord-acc-neut dwunaste)
    (ord-inst-neut dwunastym)
    (ord-loc-neut dwunastym))
(trzynas~cie                            ;13th
    (ord-nom-fem trzynasta)
    (ord-gen-fem trzynastej)
    (ord-dat-fem trzynastej)
    (ord-acc-fem trzynasto~)
    (ord-inst-fem trzynasto~)
    (ord-loc-fem trzynastej))
(trzynas~cie 
    (ord-nom-masc trzynasty)
    (ord-gen-masc trzynastego)
    (ord-dat-masc trzynastemu)
    (ord-acc-masc trzynastego)
    (ord-inst-masc trzynastym)
    (ord-loc-masc trzynastym))
(trzynas~cie 
    (ord-nom-neut trzynaste)
    (ord-gen-neut trzynastego)
    (ord-dat-neut trzynastemu)
    (ord-acc-neut trzynaste)
    (ord-inst-neut trzynastym)
    (ord-loc-neut trzynastym))
(czternas~cie                                ;14th
    (ord-nom-fem czternasta)
    (ord-gen-fem czternastej)
    (ord-dat-fem czternastej)
    (ord-acc-fem czternasto~)
    (ord-inst-fem czternasto~)
    (ord-loc-fem czternastej))
(czternas~cie
    (ord-nom-masc czternasty)
    (ord-gen-masc czternastego)
    (ord-dat-masc czternastemu)
    (ord-acc-masc czternastego)
    (ord-inst-masc czternastym)
    (ord-loc-masc czternastym))
(czternas~cie
    (ord-nom-neut czternaste)
    (ord-gen-neut czternastego)
    (ord-dat-neut czternastemu)
    (ord-acc-neut czternaste)
    (ord-inst-neut czternastym)
    (ord-loc-neut czternastym))
(pie~tnas~cie                                 ;15th
    (ord-nom-fem pie~tnasta)
    (ord-gen-fem pie~tnastej)
    (ord-dat-fem pie~tnastej)
    (ord-acc-fem pie~tnasto~)
    (ord-inst-fem pie~tnasto~)
    (ord-loc-fem pie~tnastej))
(pie~tnas~cie 
    (ord-nom-masc pie~tnasty)
    (ord-gen-masc pie~tnastego)
    (ord-dat-masc pie~tnastemu)
    (ord-acc-masc pie~tnastego)
    (ord-inst-masc pie~tnastym)
    (ord-loc-masc pie~tnastym))
(pie~tnas~cie 
    (ord-nom-neut pie~tnaste)
    (ord-gen-neut pie~tnastego)
    (ord-dat-neut pie~tnastemu)
    (ord-acc-neut pie~tnaste)
    (ord-inst-neut pie~tnastym)
    (ord-loc-neut pie~tnastym))
(szesnas~cie                       ;16th
    (ord-nom-fem szesnasta)
    (ord-gen-fem szesnastej)
    (ord-dat-fem szesnastej)
    (ord-acc-fem szesnasto~)
    (ord-inst-fem szesnasto~)
    (ord-loc-fem szesnastej))
(szesnas~cie
    (ord-nom-masc szesnasty)
    (ord-gen-masc szesnastego)
    (ord-dat-masc szesnastemu)
    (ord-acc-masc szesnastego)
    (ord-inst-masc szesnastym)
    (ord-loc-masc szesnastym))
(szesnas~cie
    (ord-nom-neut szesnaste)
    (ord-gen-neut szesnastego)
    (ord-dat-neut szesnastemu)
    (ord-acc-neut szesnaste)
    (ord-inst-neut szesnastym)
    (ord-loc-neut szesnastym))
(siedemnas~cie                      ;17th
    (ord-nom-fem siedemnasta)
    (ord-gen-fem siedemnastej)
    (ord-dat-fem siedemnastej)
    (ord-acc-fem siedemnasto~)
    (ord-inst-fem siedemnasto~)
    (ord-loc-fem siedemnastej))
(siedemnas~cie 
    (ord-nom-masc siedemnasty)
    (ord-gen-masc siedemnastego)
    (ord-dat-masc siedemnastemu)
    (ord-acc-masc siedemnastego)
    (ord-inst-masc siedemnastym)
    (ord-loc-masc siedemnastym))
(siedemnas~cie 
    (ord-nom-neut siedemnaste)
    (ord-gen-neut siedemnastego)
    (ord-dat-neut siedemnastemu)
    (ord-acc-neut siedemnaste)
    (ord-inst-neut siedemnastym)
    (ord-loc-neut siedemnastym))
(osiemnas~cie                        ;18th                      
    (ord-nom-fem osiemnasta)
    (ord-gen-fem osiemnastej)
    (ord-dat-fem osiemnastej)
    (ord-acc-fem osiemnasto~)
    (ord-inst-fem osiemnasto~)
    (ord-loc-fem osiemnastej))
(osiemnas~cie
    (ord-nom-masc osiemnasty)
    (ord-gen-masc osiemnastego)
    (ord-dat-masc osiemnastemu)
    (ord-acc-masc osiemnastego)
    (ord-inst-masc osiemnastym)
    (ord-loc-masc osiemnastym))
(osiemnas~cie
    (ord-nom-neut osiemnaste)
    (ord-gen-neut osiemnastego)
    (ord-dat-neut osiemnastemu)
    (ord-acc-neut osiemnaste)
    (ord-inst-neut osiemnastym)
    (ord-loc-neut osiemnastym))
(dziewie~tnas~cie                      ;19th
    (ord-nom-fem dziewie~tnasta)
    (ord-gen-fem dziewie~tnastej)
    (ord-dat-fem dziewie~tnastej)
    (ord-acc-fem dziewie~tnasto~)
    (ord-inst-fem dziewie~tnasto~)
    (ord-loc-fem dziewie~tnastej))
(dziewie~tnas~cie 
    (ord-nom-masc dziewie~tnasty)
    (ord-gen-masc dziewie~tnastego)
    (ord-dat-masc dziewie~tnastemu)
    (ord-acc-masc dziewie~tnastego)
    (ord-inst-masc dziewie~tnastym)
    (ord-loc-masc dziewie~tnastym))
(dziewie~tnas~cie 
    (ord-nom-neut dziewie~tnaste)
    (ord-gen-neut dziewie~tnastego)
    (ord-dat-neut dziewie~tnastemu)
    (ord-acc-neut dziewie~tnaste)
    (ord-inst-neut dziewie~tnastym)
    (ord-loc-neut dziewie~tnastym))
(dwadzies~cia                               ;20th
    (ord-nom-fem dwudziesta)
    (ord-gen-fem dwudziestej)
    (ord-dat-fem dwudziestej)
    (ord-acc-fem dwudziesto~)
    (ord-inst-fem dwudziesto~)
    (ord-loc-fem dwudziestej))
(dwadzies~cia 
    (ord-nom-masc dwudziesty)
    (ord-gen-masc dwudziestego)
    (ord-dat-masc dwudziestemu)
    (ord-acc-masc dwudziestego)
    (ord-inst-masc dwudziestym)
    (ord-loc-masc dwudziestym))
(dwadzies~cia 
    (ord-nom-neut dwudzieste)
    (ord-gen-neut dwudziestego)
    (ord-dat-neut dwudziestemu)
    (ord-acc-neut dwudzieste)
    (ord-inst-neut dwudziestym)
    (ord-loc-neut dwudziestym))
(trzydzies~ci                        ;30th 
    (ord-nom-fem trzydziesta)
    (ord-gen-fem trzydziestej)
    (ord-dat-fem trzydziestej)
    (ord-acc-fem tzrydziesto~)
    (ord-inst-fem trzydziesto~)
    (ord-loc-fem trzydziestej))
(trzydzies~ci 
    (ord-nom-masc trzydziesty)
    (ord-gen-masc trzydziestego)
    (ord-dat-masc trzydziestemu)
    (ord-acc-masc trzydziestego)
    (ord-inst-masc trzydziestym)
    (ord-loc-masc trzydziestym))
(trzydzies~ci 
    (ord-nom-neut trzydzieste)
    (ord-gen-neut trzydziestego)
    (ord-dat-neut trzydziestemu)
    (ord-acc-neut trzydzieste)
    (ord-inst-neut trzydziestym)
    (ord-loc-neut trzydziestym))
(czterdzies~ci                         ;40th
    (ord-nom-fem czterdziesta)
    (ord-gen-fem czterdzistej)
    (ord-dat-fem czterdzistej)
    (ord-acc-fem czterdziesto~)
    (ord-inst-fem czterdziesto~)
    (ord-loc-fem czterdzistej))
(czterdzies~ci
    (ord-nom-masc czterdziesty)
    (ord-gen-masc czterdziestego)
    (ord-dat-masc czterdziestemu)
    (ord-acc-masc czterdziestego)
    (ord-inst-masc czterdziestym)
    (ord-loc-masc czterdziestym))
(czterdzies~ci
    (ord-nom-neut czterdzieste)
    (ord-gen-neut czterdziestego)
    (ord-dat-neut czterdziestemu)
    (ord-acc-neut czterdzieste)
    (ord-inst-neut czterdziestym)
    (ord-loc-neut czterdziestym))

(pie~c~dziesio~t                        ;50th 
    (ord-nom-fem pie~c~dziesio~ta)
    (ord-gen-fem pie~c~dziesio~tej)
    (ord-dat-fem pie~c~dziesio~tej)
    (ord-acc-fem pie~c~dziesio~to~)
    (ord-inst-fem pie~c~dziesio~to~)
    (ord-loc-fem pie~c~dziesio~tej))
(pie~c~dziesio~t
    (ord-nom-masc pie~c~dziesio~ty)
    (ord-gen-masc pie~c~dziesio~tego)
    (ord-dat-masc pie~c~dziesio~temu)
    (ord-acc-masc pie~c~dziesio~tego)
    (ord-inst-masc pie~c~dziesio~tym)
    (ord-loc-masc pie~c~dziesio~tym))
(pie~c~dziesio~t
    (ord-nom-neut pie~c~dziesio~te)
    (ord-gen-neut pie~c~dziesio~tego)
    (ord-dat-neut pie~c~dziesio~tego)
    (ord-acc-neut pie~c~dziesio~te)
    (ord-inst-neut pie~c~dziesio~tym)
    (ord-loc-neut pie~c~dziesio~tym))
(szes~c~dziesio~t                           ;60th 
    (ord-nom-fem szes~c~dziesio~ta)
    (ord-gen-fem szes~c~dziesio~tej)
    (ord-dat-fem szes~c~dziesio~tej)
    (ord-acc-fem szes~c~dziesio~to~)
    (ord-inst-fem szes~c~dziesio~to~)
    (ord-loc-fem szes~c~dziesio~tej))
(szes~c~dziesio~t 
    (ord-nom-masc szes~c~dziesio~ty)
    (ord-gen-masc szes~c~dziesio~tego)
    (ord-dat-masc szes~c~dziesio~temu)
    (ord-acc-masc szes~c~dziesio~tego)
    (ord-inst-masc szes~c~dziesio~tym)
    (ord-loc-masc szes~c~dziesio~tym))
(szes~c~dziesio~t 
    (ord-nom-neut szes~c~dziesio~te)
    (ord-gen-neut szes~c~dziesio~tego)
    (ord-dat-neut szes~c~dziesio~temu)
    (ord-acc-neut szes~c~dziesio~te)
    (ord-inst-neut szes~c~dziesio~tym)
    (ord-loc-neut szes~c~dziesio~tym))
(siedemdziesio~t                            ;70th 
    (ord-nom-fem siedemdziesio~ta)
    (ord-gen-fem siedemdziesio~tej)
    (ord-dat-fem siedemdziesio~tej)
    (ord-acc-fem siedemdziesio~to~)
    (ord-inst-fem siedemdziesio~to~)
    (ord-loc-fem siedemdziesio~tej))
(siedemdziesio~t
    (ord-nom-masc siedemdziesio~ty)
    (ord-gen-masc siedemdziesio~tego)
    (ord-dat-masc siedemdziesio~temu)
    (ord-acc-masc siedemdziesio~tego)
    (ord-inst-masc siedemdziesio~tym)
    (ord-loc-masc siedemdziesio~tym))
(siedemdziesio~t
    (ord-nom-neut siedemdziesio~te)
    (ord-gen-neut siedemdziesio~tego)
    (ord-dat-neut siedemdziesio~temu)
    (ord-acc-neut siedemdziesio~te)
    (ord-inst-neut siedemdziesio~tym)
    (ord-loc-neut siedemdziesio~tym))
(osiemdziesio~t                             ;80th  
    (ord-nom-fem osiemdziesio~ta)
    (ord-gen-fem osiemdziesio~tej)
    (ord-dat-fem osiemdziesio~tej)
    (ord-acc-fem osiemdziesio~to~)
    (ord-inst-fem osiemdziesio~to~)
    (ord-loc-fem osiemdziesio~tej))
(osiemdziesio~t
    (ord-nom-masc osiemdziesio~ty)
    (ord-gen-masc osiemdziesio~tego)
    (ord-dat-masc osiemdziesio~temu)
    (ord-acc-masc osiemdziesio~tego)
    (ord-inst-masc osiemdziesio~tym)
    (ord-loc-masc osiemdziesio~tym))
(osiemdziesio~t
    (ord-nom-neut osiemdziesio~te)
    (ord-gen-neut osiemdziesio~tego)
    (ord-dat-neut osiemdziesio~temu)
    (ord-acc-neut osiemdziesio~te)
    (ord-inst-neut osiemdziesio~tym)
    (ord-loc-neut osiemdziesio~tym))
(dziewie~c~dziesio~t                        ;90th 
    (ord-nom-fem dziewie~c~dziesio~ta)
    (ord-gen-fem dziewie~c~dziesio~tej)
    (ord-dat-fem dziewie~c~dziesio~tej)
    (ord-acc-fem dziewie~c~dziesio~to~)
    (ord-inst-fem dziewie~c~dziesio~to~)
    (ord-loc-fem dziewie~c~dziesio~tej))
(dziewie~c~dziesio~t
    (ord-nom-masc dziewie~c~dziesio~ty)
    (ord-gen-masc dziewie~c~dziesio~tego)
    (ord-dat-masc dziewie~c~dziesio~temu)
    (ord-acc-masc dziewie~c~dziesio~tego)
    (ord-inst-masc dziewie~c~dziesio~tym)
    (ord-loc-masc dziewie~c~dziesio~tym))
(dziewie~c~dziesio~t
    (ord-nom-neut dziewie~c~dziesio~te)
    (ord-gen-neut dziewie~c~dziesio~tego)
    (ord-dat-neut dziewie~c~dziesio~temu)

    (ord-acc-neut dziewie~c~dziesio~te)
    (ord-inst-neut dziewie~c~dziesio~tym)
    (ord-loc-neut dziewie~c~dziesio~tym))
(tysio~c                              ;1 000  singular             
    (card-nom-masc tysio~c) 
    (card-gen-masc tysio~ca)
    (card-dat-masc tysio~cowi)
    (card-acc-masc tysio~c)
    (card-inst-masc tysio~cem) 
    (card-loc-masc tysio~cu))
(tysio~c                              ;> 1 000 plural            
    (card-nom-masc tysio~ce) 
    (card-gen-masc tysie~cy)
    (card-dat-masc tysio~com)
    (card-acc-masc tysio~ce)
    (card-inst-masc tysio~cami) 
    (card-loc-masc tysio~cach))
(milion                               :1 000 000   singular            
    (card-nom-masc milion) 
    (card-gen-masc miliona)
    (card-dat-masc milionowi)
    (card-acc-masc milion)
    (card-inst-masc milionem) 
    (card-loc-masc milionie))
(milion                               :> 1 000 000   plural            
    (card-nom-masc miliony) 
    (card-gen-masc milionu~w)
    (card-dat-masc milionom)
    (card-acc-masc miliony)
    (card-inst-masc milionami) 
    (card-loc-masc milionach))
))

;;tysio~c and milion will decline only if they mean 1 000 or 1 000 000
;;otherwise only tens and units decline. 

(provide 'number_decl)
