;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                         Copyright (c) 1998                            ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission is hereby granted, free of charge, to use and distribute  ;;
;;;  this software and its documentation without restriction, including   ;;
;;;  without limitation the rights to use, copy, modify, merge, publish,  ;;
;;;  distribute, sublicense, and/or sell copies of this work, and to      ;;
;;;  permit persons to whom this work is furnished to do so, subject to   ;;
;;;  the following conditions:                                            ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;   4. The authors' names are not used to endorse or promote products   ;;
;;;      derived from this software without specific prior written        ;;
;;;      permission.                                                      ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Language and voice specific durations
;;;

(set! cstr_pl_em::zdur_tree 
 '
   ((R:SylStructure.parent.R:Syllable.p.syl_break > 1 ) ;; clause initial
    ((1.5))
    ((R:SylStructure.parent.syl_break > 1)   ;; clause final
     ((1.5))
     ((1.0)))))

(set! cstr_pl_em::phone_data
'(    ;; this should normall only take 2 numbers but the
      ;; way were using it we want the the mean as the second number
(#    0 0.200 0.100)
(a    0 0.100 0.040)
(e    0 0.100 0.040)
(i    0 0.100 0.040)
(I    0 0.100 0.040)
(o    0 0.100 0.040)
(u    0 0.100 0.040)
(e~   0 0.120 0.040)
(N   0 0.120 0.040)
(o~   0 0.120 0.040)

(p    0 0.101 0.032)
(b    0 0.073 0.021)
(t    0 0.070 0.034)
(d    0 0.048 0.021)
(k    0 0.089 0.034)
(g    0 0.064 0.021)

(f    0 0.095 0.033)
(v    0 0.051 0.019)
(s    0 0.102 0.037)
(z    0 0.072 0.029)
(S    0 0.108 0.031)
(Z    0 0.077 0.030)
(s+   0 0.102 0.037)
(z+   0 0.072 0.029)
(x    0 0.108 0.039)

(ts   0 0.128 0.039)
(dz   0 0.094 0.024)
(tS   0 0.128 0.039)
(dZ   0 0.094 0.024)
(ts+  0 0.128 0.039)
(dz+  0 0.094 0.024)
(m    0 0.063 0.021)
(n    0 0.059 0.025)
(n+   0 0.059 0.025)
(ng   0 0.064 0.024)
(l    0 0.056 0.026)
(r    0 0.053 0.025)
(w    0 0.054 0.023)
(y    0 0.048 0.025)
(j    0 0.048 0.025)
))

;;; Duration 
(set! polish_dur_tree
 '
   ((R:SylStructure.parent.R:Syllable.p.syl_break > 1 ) ;; clause initial
    ((R:SylStructure.parent.stress is 1)
     ((1.5))
     ((1.2)))
    ((R:SylStructure.parent.syl_break > 1)   ;; clause final
     ((R:SylStructure.parent.stress is 1)
      ((1.5))
      ((1.2)))
     ((R:SylStructure.parent.stress is 1)
      ((ph_vc is +)
       ((1.2))
       ((1.0)))
      ((1.0))))))

(provide 'cstr_pl_em_dur)
