;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                         Copyright (c) 1998                            ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission is hereby granted, free of charge, to use and distribute  ;;
;;;  this software and its documentation without restriction, including   ;;
;;;  without limitation the rights to use, copy, modify, merge, publish,  ;;
;;;  distribute, sublicense, and/or sell copies of this work, and to      ;;
;;;  permit persons to whom this work is furnished to do so, subject to   ;;
;;;  the following conditions:                                            ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;   4. The authors' names are not used to endorse or promote products   ;;
;;;      derived from this software without specific prior written        ;;
;;;      permission.                                                      ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; lexical look up, from words to pronunciations
;;;

;;;  Function called when word not found in lexicon
(define (cstr_pl_lts_function word features)
  "(cstr_pl_lts_function WORD FEATURES)
Return pronunciation of word not in lexicon."
  (let (phones syls letters)
    ;;; Here we can add multiple LTS sets if required e.g. down casing
    ;;; and normalisation of 7 bit represenations of accented characters
    (set! letters (lts.apply word 'pol_downcase))
    (set! phones (lts.apply letters 'polish))
    ;; Need to assign lexical stress
   (set! syls (polish_syllabification phones nil))
    (set! syls (polish_lex_stress syls))
    (list word nil syls)
    ))

(define (pol_contains_vowel phones)
  (cond
   ((null phones) nil)
   ((member_string (car phones) '("a" "e" "I" "i" "o" "u" "e~" "o~"))
    t)
   (t (pol_contains_vowel (cdr phones)))))

(define (polish_syllabification phones syls)
"(polish_syllabification phones syls)
Syllabify phones into syllables for Polish."
 (cond
  ((null phones)
   (mapcar
    (lambda (syl) (list (reverse syl) 0))
    (reverse syls)))
  ((and (member_string (car phones) '("a" "e" "I" "i" "o" "u" "e~" "o~"))
	(pol_contains_vowel (cdr phones)))
   (let ((nsyls (cons (cons (car phones) (car syls)) (cdr syls)))
	 (nphones (cdr phones)))
     (cond
      ((and (member_string (car nphones) '("m" "n" "n+" "N" "l" "j" "w"))
	    (not (member_string (car (cdr nphones)) 
				'("a" "e" "I" "i" "o" "u" "e~" "o~"))))
       (set! nsyls (cons (cons (car nphones) (car nsyls)) (cdr nsyls)))
       (set! nphones (cdr nphones))))
     (polish_syllabification nphones (cons nil nsyls))))
  (t
   (polish_syllabification
    (cdr phones)
    (cons (cons (car phones) (car syls)) (cdr syls))))))

(define (polish_lex_stress syls)
"(polish_lex_stress syls)
Add lexical stress to penultimate syllable."
  (if (> (length syls) 1)
      (set-car! (cdr (nth (- (length syls) 2) syls)) 1))
  syls)



(define (cstr_pl_addenda)
  "(pl_addenda)
Basic lexicon should (must ?) basic letters and punctuation."

;;; Polish lexicon
(lex.add.entry '("a" nn (((a) 0))))
(lex.add.entry '("" nn (((o~) 0))))
(lex.add.entry '("o~" nn (((o~) 0))))
(lex.add.entry '("b" nn (((b e) 0))))
(lex.add.entry '("c" nn (((ts e) 0))))
(lex.add.entry '("" nn (((ts+ e) 0))))
(lex.add.entry '("c~" nn (((ts+ e) 0))))
(lex.add.entry '("d" nn (((d e) 0))))
(lex.add.entry '("e" nn (((e) 0))))
(lex.add.entry '("" nn (((e~) 0))))
(lex.add.entry '("e~" nn (((e~) 0))))
(lex.add.entry '("f" nn (((e f) 0))))
(lex.add.entry '("g" nn (((g j e) 0))))
(lex.add.entry '("h" nn (((h a) 0))))
(lex.add.entry '("i" nn (((i) 0))))
(lex.add.entry '("j" nn (((j o t) 0))))
(lex.add.entry '("k" nn (((k a) 0))))
(lex.add.entry '("l" nn (((e l) 0))))
(lex.add.entry '("" nn (((e w) 0))))
(lex.add.entry '("l/" nn (((e w) 0))))
(lex.add.entry '("m" nn (((e m) 0))))
(lex.add.entry '("n" nn (((e n) 0))))
(lex.add.entry '("" nn (((e n+) 0))))
(lex.add.entry '("n~" nn (((e n+) 0))))
(lex.add.entry '("o" nn (((o) 0))))
(lex.add.entry 
'("" nn (((o) 0) ((k r e) 0) ((s k o) 0) ((v a) 1) ((n e) 0))))
(lex.add.entry 
'("u~" nn (((o) 0) ((k r e) 0) ((s k o) 0) ((v a) 1) ((n e) 0))))
(lex.add.entry '("p" nn (((p e) 0))))
(lex.add.entry '("r" nn (((e r) 0))))
(lex.add.entry '("s" nn (((e s) 0))))
(lex.add.entry '("" nn (((e s+) 0))))
(lex.add.entry '("s~" nn (((e s+) 0))))
(lex.add.entry '("t" nn (((t e) 0))))
(lex.add.entry '("u" nn (((u) 0))))
(lex.add.entry '("w" nn (((v u) 0)))) ;;homograph letter w & 'in' prep
(lex.add.entry '("y" nn (((i) 1)((g r e k) 0))))
(lex.add.entry '("z" nn (((z e t) 0))))
(lex.add.entry '("" nn (((z+ e t) 0))))
(lex.add.entry '("z~" nn (((z+ e t) 0))))
(lex.add.entry '("" nn (((Z e t) 0))))
(lex.add.entry '("z*" nn (((Z e t) 0))))
(lex.add.entry '("v" nn (((f a w) 0))))
(lex.add.entry '("x" nn (((i k s) 0))))
(lex.add.entry '("q" nn (((k u) 0))))
(lex.add.entry '("rz" nn (((e r) 0) ((z e t) 1))))
(lex.add.entry '("ch" nn (((ts e) 0) ((x a ) 1))))
(lex.add.entry '("sz" nn (((e S) 0))))


(lex.add.entry 
 '("*" n (((g v i a) 1) ((s t k a) 0))))
(lex.add.entry 
 '("%" n (((p r o) 1) ((ts e n t) 0))))
;;(lex.add.entry 
;; '("&" n
(lex.add.entry 
 '("$" n (((d o) 1) ((l a r) 0))))
;;(lex.add.entry 
;; '("#" n (((x a S) 0))))
(lex.add.entry 
 '("@" n (((e t) 0))))
(lex.add.entry 
 '("+" n (((p l u s) 0))))
(lex.add.entry 
 '("^" n (((k a) 0) ((r e) 1) ((t k a) 0))))
(lex.add.entry 
 '("~" n (((t y) 1) ((l d a) 0))))
(lex.add.entry 
 '("=" n (((r u) 1) (( v n a) 0) (( s+ e ) 0)))) 
;(lex.add.entry 
; '("/" n 
;(lex.add.entry 
; '("\\" n 
;(lex.add.entry 
; '("_" n 
;(lex.add.entry 
; '("|" n 
;(lex.add.entry 
; '(">" n 
;(lex.add.entry 
; '("<" n 
;(lex.add.entry 
; '("[" n 
;(lex.add.entry 
; '("]" n 
(lex.add.entry 
 '(" " n (((s p a) 1) (( ts j a) 0))))

(lex.add.entry '("." punc nil))
(lex.add.entry '("." nn (((k r o) 1) ((p k a) 0))))
(lex.add.entry '("'" punc nil))
(lex.add.entry '(":" punc nil))
(lex.add.entry '(";" punc nil))
(lex.add.entry '("," punc nil))
(lex.add.entry '("," nn (((p S e) 0) ((ts+ i) 1) ((n e k) 0))))
(lex.add.entry '("-" punc nil))
(lex.add.entry '("\"" punc nil))
(lex.add.entry '("`" punc nil))
(lex.add.entry '("?" punc nil))
(lex.add.entry '("!" punc nil))

(lex.add.entry '("r" nn (((r o k) 0))));; depends on number etc
(lex.add.entry '("w" nn (((s+ f j e n) 1) ((t I) 0))))
;(lex.add.entry '("s~w" nn (((s+ f j e n) 1) ((t I) 0))))
(lex.add.entry '("tzw" nn (((t a g) 0) ((z v a) 1) ((n I) 0))))
(lex.add.entry '("ds" nn (((d o) 0) ((s p r a f) 1))))
(lex.add.entry '("dr" nn (((d o) 1) ((k t o r) 0))))
(lex.add.entry '("prof" nn (((p r o) 0) ((f e) 1) ((s o r) 0))))
(lex.add.entry '("mgr" nn (((m a) 0) ((g i) 1) ((s t e r ) 0))))
(lex.add.entry '("Ks" nn (((k s+ o n ts) 0))))
(lex.add.entry '("godz" nn (((g o) 0) ((dz+ i) 1) ((n a) 0))))
(lex.add.entry '
("tys" nn (((t I) 0) ((s+ e n) 1) ((ts I) 0)))) ;; depends on number
(lex.add.entry '
("ha" nn (((x e) 0) ((k t a) 1) ((r u f) 0))));; depends on number
(lex.add.entry '
("mln" nn (((m i) 0) ((l j o) 1) ((n u f) 0))));; depends on number
(lex.add.entry '
("proc" nn (((p r o) 1) ((ts e n t) 0))));; depends on number
(lex.add.entry '
("pkt" nn (((p u n) 1) ((k t u f) 0))))
(lex.add.entry '("z" nn (((z w o) 1) ((t I x) 0))))
(lex.add.entry '("str" nn (((s t r o) 1) ((n a) 0))))
;;(lex.add.entry '("w." nn (((v j e k) 0))))
(lex.add.entry '
("itd" nn (((i) 0) ((t a k) 0) ((d a) 1) ((l e j) 0)))) 
(lex.add.entry 
'("itp" nn (((i) 0) (( t I m) 0) ((p o) 0) ((d o) 1) ((b n e) 0))))   
(lex.add.entry 
'("m#in" nn (((m j e n) 1) ((dz I) 0) ((#) 0) ((i n) 0) ((n I) 1) ((m i) 0))))
;; how to make sure these are two words
(lex.add.entry 
'("n.e" nn (((n a) 1) ((S e j) 0) ((e) 1) ((r I) 0))))
(lex.add.entry 
'("np" nn (((n a) 0) ((p S I) 1) ((k w a t) 0))))
(lex.add.entry 
'("ok" nn (((o) 0) ((k o) 1) ((w o) 0))))
(lex.add.entry 
'("p.n.e" nn (((p S e t) 0) ((n a) 1) ((S o~) 0) ((#) 0) ((e) 1) ((r o~) 0))))
(lex.add.entry 
'("fot" nn (((f o) 0) ((t o) 0) ((g r a 1)) ((f j a) 0))))
(lex.add.entry 
'("cstr" nn (((s i) 1) ((j e s) 1) ((t i) 0) ((j a r) 1)))) 
(lex.add.entry 
'("jabko" nn (((j a) 1) ((p k o) 0))))
(lex.add.entry 
'("jabl/ko" nn (((j a) 1) ((p k o) 0)))) 
(provide 'pollex)
;;exceptions : numbers
(lex.add.entry 
'("pidziesit" nn (((p j e n+) 0) ((dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry 
'("pie~c~dziesio~t" nn (((p j e n+) 0) ((dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry 
'("szedziesit" nn (((S e) 0) ((z+ dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry 
'("szes~c~dziesio~t" nn (((S e) 0) ((z+ dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry 
'("piset" nn (((p j e n+) 1) ((ts e t) 0))))
(lex.add.entry 
'("pie~c~set" nn (((p j e n+) 1) ((ts e t) 0))))
(lex.add.entry 
'("szeset" nn (((S e j) 1) ((s e t) 0))))
(lex.add.entry 
'("szes~c~set" nn (((S e j) 1) ((s e t) 0))))
(lex.add.entry
'("dziewidziesit" 
nn (((dz+ e) 0) ((v j e n+) 0) ((dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry
'("dziewiset" nn (((dz+ e) 1) ((v j e n+) 0) ((ts e t) 0))))
(lex.add.entry
'("dziewie~c~dziesio~t" 
nn (((dz+ e) 0) ((v j e n+) 0) ((dz+ e) 1) ((s+ o n t) 0))))
(lex.add.entry
'("dziewie~c~set" nn (((dz+ e) 1) ((v j e n+) 0) ((ts e t) 0))))
(lex.add.entry 
'("mikki" nn (((m j e N) 1) ((k i) 0))))
(lex.add.entry 
'("mie~kki" nn (((m j e N) 1) ((k i) 0))))

;;prepositions,

(lex.add.entry 
'("w" prep-acc (((f) 0))))                          ;denoting time
(lex.add.entry 
'("z" prep-loc (((s) 0))))                           ;with
(lex.add.entry 
'("okol/o" prep-gen (((o) 0) ((k o) 0) ((w o) 0))))  ;about 
(lex.add.entry 
'("okoo" prep-gen (((o) 0) ((k o) 0) ((w o) 0))))
(lex.add.entry 
'("o" prep-loc (((o) 0))))                            ;at
(lex.add.entry 
'("po" prep-loc (((p o) 0))))                         ;after
(lex.add.entry 
'("przy" prep-loc (((p S I) 0))))                     ; close to
(lex.add.entry 
'("na" prep-loc (((n a) 0))))                          ; in
(lex.add.entry 
'("u" prep-gen (((u) 0))))                            ; at somebody's house
(lex.add.entry 
'("do" prep-gen (((d o) 0))))                          ; to 
(lex.add.entry 
'("przez" prep-acc (((p S e s) 0))))                   ; by
(lex.add.entry 
'("przed" prep-inst (((p S e t) 0))))                  ; before
(lex.add.entry 
'("obok" prep-gen (((o) 0) ((b o k) 0))))              ; next to
(lex.add.entry 
'("dla" prep-gen (((d l a) 0))))                       ; for
(lex.add.entry 
'("ze" prep-inst (((z e) 0))))                          ; with
(lex.add.entry 
'("za" prep-acc (((z a) 0))))            ; buying for 'za 2 zote'
(lex.add.entry 
'("od" prep-gen (((o t) 0))))                             ;from
(lex.add.entry 
'("we" prep-acc (((v e) 0))))           ; in, with days of the week
(lex.add.entry 
'("poza" (((p o) 1) ((z a) 0))))                          ; beyond
(lex.add.entry 
'("bez" prep-gen (((b e s) 0))))                         ; without
(lex.add.entry 
'("ponad" prep-acc (((p o) 0) ((n a t) 0))))              ; more than
(lex.add.entry 
'("powyz*ej" prep-gen (((p o) 0) ((v I) 0) ((Z e j) 0))))  ; above
(lex.add.entry 
'("powyej" prep-gen (((p o) 0) ((v I) 0) ((Z e j) 0))))  ; above
(lex.add.entry 
'("ku" prep-dat (((k u) 0))))                              ; towards
(lex.add.entry 
'("wobec" prep-gen (((v o) 0) ((b e ts) 0))))             ;with regard to
(lex.add.entry 
'("wzgle~dem" prep-gen (((v z g l e~) 0) ((d e m) 0))))  ;with regard to
(lex.add.entry 
'("wzgldem" prep-gen (((v z g l e~) 0) ((d e m) 0))))   ;with regard to
(lex.add.entry 
'("poniz*ej" prep-gen (((p o) 0) ((n i) 0) ((Z e j) 0)))) ;less than
(lex.add.entry 
'("poniej" prep-gen (((p o) 0) ((n i) 0) ((Z e j) 0))))  ;less than

;pronouns,conjunctions etc (definitely unstressed)                                                                                             

(lex.add.entry 
'("sie~" pron (((s+ e) 0)))) ;reflexive pronoun
(lex.add.entry 
'("si" pron (((s+ e) 0))))  ;reflexive pronoun
;; demonstrative pronouns
(lex.add.entry 
'("ten" pron (((t e n) 0)))  ; demonstrative pronoun
(lex.add.entry 
'("ta" pron (((t a) 0))))    ; demonstrative pronoun
(lex.add.entry 
'("to" pron (((t o) 0))))    ; demonstrative pronoun
(lex.add.entry 
'("co" pron (((ts o) 0))))   ; relative pronoun
(lex.add.entry 
'("i" conj (((i) 0))))           ; conjunction
(lex.add.entry 
'("a" conj (((a) 0))))           ;conjunction
(lex.add.entry 
'("ale" conj (((a l e) 0))))     ;conjunction
(lex.add.entry 
'("oraz" conj (((o) 0) ((r a s) 0))))  ;conjunction
(lex.add.entry 
'("ani" conj (((a) 0) ((n i) 0)))) ;conjunction
(lex.add.entry 
'("tez*" conj (((t e S) 0))))     ;conjunction
(lex.add.entry 
'("te" conj (((t e S) 0))))      ;conjunction
(lex.add.entry 
'("lub" conj (((l u p) 0))))      ;conjunction
(lex.add.entry 
'("czy" conj (((tS I) 0))))       ;conjunction
(lex.add.entry 
'("lecz" conj (((l e tS) 0))))    ;conjunction
(lex.add.entry 
'("bo" conj ((((b o) 0))))        ;conjunction
(lex.add.entry 
'("z*e" conj (((Z e) 0))))        ;conjunction
(lex.add.entry 
'("e" conj (((Z e) 0))))         ;conjunction
(lex.add.entry 
'("niz*" conj (((n i S) 0))))     ;conjunction
(lex.add.entry 
'("ni" conj (((n i S) 0))))      ;conjunction

; monosyllabic forms of possessive pronouns 
(lex.add.entry 
'("mu~j" pron (((m u j) o))))
(lex.add.entry 
'("mj" pron (((m u j) o))))
(lex.add.entry 
'("twu~j" pron (((t f u j) 0)))) 
(lex.add.entry 
'("twj" pron (((t f u j) 0)))) 
(lex.add.entry 
'("nasz" pron (((n a S) 0))))
(lex.add.entry 
'("wasz" pron (((v a S) 0))))
(lex.add.entry 
'("jej" pron (((j e j) 0))))
(lex.add.entry 
'("ich" pron (((i x) 0))))
(lex.add.entry 
'("swu~j" pron (((s f u j) 0))))
(lex.add.entry 
'("swj" pron (((s f u j) 0))))
(lex.add.entry 

;;personal pronouns
'("ja" pron (((j a) 0))))
(lex.add.entry 
'("ty" pron (((t I) 0))))
(lex.add.entry 
'("on" pron (((o n) 0))))
(lex.add.entry 
'("ona" pron (((o) 0) ((n a) 0))))
(lex.add.entry 
'("ono" pron (((o) 0) ((n o) 0))))
(lex.add.entry 
'("my" pron (((m I) 0))))
(lex.add.entry 
'("wy" pron (((v I) 0))))
(lex.add.entry 
'("oni" pron (((o) 0) ((n i) 0))))
(lex.add.entry 
'("one" pron (((o) 0) ((n e) 0))))
(lex.add.entry 
'("mnie" pron (((m n+ e) 0))))
(lex.add.entry 
'("mno~" pron (((m n o~) 0))))
(lex.add.entry 
'("mn" pron (((m n o~) 0))))
(lex.add.entry 
'("mi" pron (((m i) 0))))
(lex.add.entry 
'("ciebie" pron (((ts+ e) 0) ((b j e) 0))))
(lex.add.entry 
'("ci" pron (((ts+ i) 0))))
(lex.add.entry 
'("cie~" pron (((ts+ e) 0))))
(lex.add.entry 
'("ci" pron (((ts+ e) 0)))) 
(lex.add.entry 
'("tobie" pron (((t o) 0) ((b j e) 0))))
(lex.add.entry 
'("tobo~" pron (((t o) 0) ((b o~) 0))))
(lex.add.entry 
'("tob" pron (((t o) 0) ((b o~) 0))))
(lex.add.entry 
'("jego" pron (((j e) 0) ((g o) 0))))
(lex.add.entry 
'("go" pron (((g o) 0))))
(lex.add.entry 
'("jemu" pron (((j e) 0) ((m u) 0))))
(lex.add.entry 
'("mu" pron (((m u) 0)))))
(lex.add.entry 
'("nim" pron (((n i m) 0))))
(lex.add.entry 
'("jej" pron (((j e j) 0))))
(lex.add.entry 
'("jo~" pron (((j o~) 0))))
(lex.add.entry 
'("j" pron (((j o~) 0))))
(lex.add.entry 
'("nio~" pron (((n+ j o~) 0))))
(lex.add.entry 
'("ni" pron  (((n+ j o~) 0))))
(lex.add.entry 
'("niej" pron (((n+ j e j) 0))))
(lex.add.entry 
'("je" pron (((j e) 0))))
(lex.add.entry 
'("nas" pron (((n a s) 0))))
(lex.add.entry 
'("nam" pron (((n a m) 0))))
(lex.add.entry 
'("nami" pron (((n a) 0) ((m i) 0))))
(lex.add.entry 
'("was" pron (((v a s) 0))))
(lex.add.entry 
'("wam" pron (((v a m) 0))))
(lex.add.entry 
'("wami" pron (((v a) 0) ((m i) 0))))
(lex.add.entry 
'("ich" pron (((i x) 0))))
(lex.add.entry 
'("im" pron (((i m) 0)))))
(lex.add.entry 
'("nich" pron (((n+ i x) 0))))
(lex.add.entry 
'("nimi" pron (((n+ i) 0) ((m i) 0))))
)

;; You may or may not be able to write a letter to sound rule set for
;; your language.  If its largely lexicon based learning a rule
;; set will be better and easier that writing one (probably).
(lts.ruleset
 cstr_pl
 (  (Vowel WHATEVER) )
 (
  ;; LTS rules 
  ))

;;; Lexicon definition

(lex.create "cstr_pl")
(lex.set.phoneset "cstr_pl")
(lex.set.lts.method 'cstr_pl_lts_function)
;(lex.set.compile.file (path-append cstr_pl_em_dir "cstr_pl_lex.out"))
(cstr_pl_addenda)

(provide 'cstr_pl_lex)
