/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include "gxmame.h"
#include "callbacks.h"
#include "about.h"
#include "gui.h"
#include "icones.h"


GtkWidget*
create_AboutWindow (void)
{
	GtkWidget *AboutWindow;
	GtkWidget *dialog_vbox;
	GtkWidget *pixmap1;
	GtkWidget *vbox2;
	GtkWidget *label2;
	GtkWidget *label3, *label4, *url_label;
	gchar *abouttitle, *text;
	GdkPixmap *testpix = NULL;
	GdkPixmap *testmask = NULL;
	GdkColor transparent;

	AboutWindow = gtk_dialog_new_with_buttons(_("About GXMame"),
			GTK_WINDOW(MainWindow), 
			GTK_DIALOG_NO_SEPARATOR|GTK_DIALOG_DESTROY_WITH_PARENT,
			_("Credits"), 1,
			GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			NULL);
	gtk_button_box_set_layout(GTK_BUTTON_BOX(GTK_DIALOG(AboutWindow)->action_area),GTK_BUTTONBOX_EDGE);
	gtk_window_set_resizable (GTK_WINDOW (AboutWindow), FALSE);

	dialog_vbox = GTK_DIALOG (AboutWindow)->vbox;
	g_object_set_data (G_OBJECT (AboutWindow), "dialog_vbox", dialog_vbox);
	gtk_widget_show (dialog_vbox);

	vbox2 = gtk_vbox_new (FALSE, 3);
	gtk_widget_ref (vbox2);
	g_object_set_data_full (G_OBJECT (AboutWindow), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox2, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox2), 10);

	testpix = gdk_pixmap_create_from_xpm_d(MainWindow->window,
					&testmask,
					&transparent,
					gxmame_xpm);
	pixmap1 = (GtkWidget *) gtk_image_new_from_pixmap (testpix,testmask);
	gtk_widget_ref (pixmap1);
	g_object_set_data_full (G_OBJECT (AboutWindow), "pixmap1", pixmap1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pixmap1);
	gtk_box_pack_start (GTK_BOX (vbox2), pixmap1, TRUE, TRUE, 0);

	abouttitle = g_strdup_printf("<big><b>%s %s</b></big>", _("GXMame"), VERSION);
	label2 = gtk_label_new(abouttitle);
	g_free(abouttitle);
	gtk_label_set_use_markup(GTK_LABEL(label2), TRUE);
	gtk_widget_ref (label2);
	g_object_set_data_full (G_OBJECT (AboutWindow), "label2", label2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label2);
	gtk_box_pack_start (GTK_BOX (vbox2), label2, TRUE, TRUE, 0);

	label3 = gtk_label_new (_("A GTK+ frontend for XMame"));
	gtk_widget_ref (label3);
	g_object_set_data_full (G_OBJECT (AboutWindow), "label3", label3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (vbox2), label3, TRUE, TRUE, 0);

	text = g_strdup_printf("<span size=\"small\">%s</span>", _("Copyright © 2002-2003 Stéphane Pontier"));
	label4 = gtk_label_new(text);
	g_free(text);
	gtk_label_set_use_markup(GTK_LABEL(label4), TRUE);
	gtk_widget_ref (label4);
	g_object_set_data_full (G_OBJECT (AboutWindow), "label4", label4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label4);
	gtk_box_pack_start (GTK_BOX (vbox2), label4, TRUE, TRUE, 0);

	
	url_label = gtk_label_new("http://gxmame.sourceforge.net");
	gtk_label_set_selectable(GTK_LABEL(url_label), TRUE);
	gtk_widget_ref (url_label);
	g_object_set_data_full (G_OBJECT (AboutWindow), "url_label", url_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (url_label);
	gtk_box_pack_end (GTK_BOX (vbox2), url_label, TRUE, TRUE, 10);

	g_signal_connect (G_OBJECT(AboutWindow), "delete_event",
			    G_CALLBACK(on_AboutWindow_delete_event),
			    G_OBJECT(AboutWindow));
	g_signal_connect (G_OBJECT(AboutWindow), "response",
			    G_CALLBACK(on_aboutWindow_response),
			    G_OBJECT(AboutWindow));

	return AboutWindow;
}

GtkWidget*
create_CreditsWindow (GtkWindow *parent)
{
	GtkWidget *creditsWindow;
	GtkNotebook *credits_notebook;
	GtkWidget *dialog_vbox;
	GtkWidget *translators;
	GtkWidget *developers;
	GtkWidget *developers_label;
	GtkWidget *translators_label;

	creditsWindow = gtk_dialog_new_with_buttons(_("Credits"),
			parent, 
			GTK_DIALOG_NO_SEPARATOR|GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			NULL);
	gtk_window_set_resizable (GTK_WINDOW (creditsWindow), FALSE);

	dialog_vbox = GTK_DIALOG (creditsWindow)->vbox;
	g_object_set_data (G_OBJECT (creditsWindow), "dialog_vbox", dialog_vbox);
	gtk_widget_show (dialog_vbox);

	credits_notebook = GTK_NOTEBOOK(gtk_notebook_new());
	gtk_widget_show(GTK_WIDGET(credits_notebook));

	gtk_box_pack_start (GTK_BOX (dialog_vbox), GTK_WIDGET(credits_notebook), FALSE, FALSE, 0);

	developers_label = gtk_label_new(_("Developers"));
	developers = gtk_label_new(
			_(
			"Stéphane Pontier (maintainer) <shadow_walker@users.sourceforge.net>\n"
			"Benoit Dumont (developer) <vertigo17@users.sourceforge.net>\n"
			"Nicos Panayides (developer) <anarxia@gmx.net>\n"
			"Priit Laes (developer) <x-laes@users.sourceforge.net>\n"
			));
	gtk_widget_show(developers);

	gtk_notebook_append_page(credits_notebook, developers, developers_label);

	translators_label = gtk_label_new(_("Translators"));
	translators = gtk_label_new(
		_(
		"German (de) - Tobias Wichtrey <tobias@tarphos.de>\n"
		"Greek (el) - Nicos Panayides <anarxia@gmx.net>\n"
		"Spanish (es) - Pablo Gonzalo del Campo <pablodc@bigfoot.com>\n"
		"French (fr) - Stéphane Pontier <shadow_walker@users.sourceforge.net>\n"
		"Italian (it) - Diego Apollonio <aposoft@tiscalinet.it>\n"
		"Dutch (nl) - Francois Duprez <duprez@planet.nl>\n"
		"Polish (pl) - Dawid Cierniak <cierny@poczta.fm>\n"
		"Simplified Chinese (zh_CN) - Andrew Wong <andrew@thizlinux.com>\n"
		"Traditional Chinese (zh_TW) - Jouston Huang <jouston@jouston.no-ip.com>\n"
		));
	gtk_widget_show(translators);
	gtk_notebook_append_page(credits_notebook, translators, translators_label);

	g_object_ref(credits_notebook);
	g_object_set_data_full (G_OBJECT (creditsWindow), "credits_notebook", credits_notebook,
				  (GtkDestroyNotify) gtk_widget_unref);
	
	g_object_ref(developers_label);
	g_object_set_data_full (G_OBJECT (creditsWindow), "developers_label", developers_label,
				  (GtkDestroyNotify) gtk_widget_unref);

	g_object_ref(developers);
	g_object_set_data_full (G_OBJECT (creditsWindow), "developers", developers,
				  (GtkDestroyNotify) gtk_widget_unref);

	g_object_ref(translators_label);
	g_object_set_data_full (G_OBJECT (creditsWindow), "translators_label", translators_label,
				  (GtkDestroyNotify) gtk_widget_unref);

	g_object_ref(translators);
	g_object_set_data_full (G_OBJECT (creditsWindow), "translators", translators,
				  (GtkDestroyNotify) gtk_widget_unref);


	g_signal_connect (G_OBJECT(creditsWindow), "delete_event",
			    G_CALLBACK(on_CreditsWindow_delete_event),
			    G_OBJECT(creditsWindow));
	g_signal_connect (G_OBJECT(creditsWindow), "response",
			    G_CALLBACK(on_CreditsWindow_response),
			    G_OBJECT(creditsWindow));

	gtk_widget_show_all(GTK_WIDGET(creditsWindow));
	return creditsWindow;
}
