/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "gxmame.h"
#include "gui.h"
#include "audit.h"
#include "interface.h"
#include "options.h"

#define BUFFER_SIZE 1000



GtkWidget *roms_check_progressbar;
GtkWidget *samples_check_progressbar;
GtkWidget *checking_games_window;
GtkWidget *details_check_text;
GtkTextBuffer *details_check_buffer;
GtkWidget *correct_roms_value;
GtkWidget *bestavailable_roms_value;
GtkWidget *notfound_roms_value;
GtkWidget *incorrect_roms_value;
GtkWidget *total_roms_value;
GtkWidget *correct_samples_value;
GtkWidget *incorrect_samples_value;
GtkWidget *total_samples_value;
GtkWidget *close_audit_button;
GtkWidget *stop_audit_button;

static int audit_cancelled, close_audit;

gboolean stop_audit(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	audit_cancelled = 1;
	if (event)
		close_audit = 1;
	else
	{
		gtk_widget_set_sensitive(widget, FALSE);
		close_audit = 0;
	}
	return TRUE;
}

GtkWidget*
create_checking_games_window (void)
{
	GtkWidget *table3;
/*  GtkWidget *pause_audit_button;*/
	GtkWidget *buttons_hbox;
	GtkWidget *details_frame;
	GtkWidget *scrolledwindow6;
	GtkWidget *ROMs_frame;
	GtkWidget *table4;
	GtkWidget *total_roms_label;
	GtkWidget *incorrect_roms_label;
	GtkWidget *correct_roms_label;
	GtkWidget *bestavailable_roms_label;
	GtkWidget *notfound_roms_label;
	GtkWidget *samples_frame;
	GtkWidget *table5;
	GtkWidget *incorrect_samples_label;
	GtkWidget *total_samples_label;
	GtkWidget *correct_samples_label;

	checking_games_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_set_data (G_OBJECT (checking_games_window), "checking_games_window", checking_games_window);
	gtk_container_set_border_width (GTK_CONTAINER (checking_games_window), 5);
	gtk_window_set_type_hint(GTK_WINDOW (checking_games_window), GDK_WINDOW_TYPE_HINT_UTILITY);
	gtk_window_set_title (GTK_WINDOW (checking_games_window), _("Checking Game"));
	gtk_window_set_transient_for(GTK_WINDOW(checking_games_window),GTK_WINDOW(MainWindow));
	gtk_window_set_modal(GTK_WINDOW(checking_games_window),TRUE);
	g_signal_connect(G_OBJECT(checking_games_window), "delete-event", 
		G_CALLBACK (stop_audit),
		G_OBJECT(checking_games_window));

	table3 = gtk_table_new (3, 4, FALSE);
	gtk_widget_ref (table3);
	g_object_set_data_full (G_OBJECT (checking_games_window), "table3", table3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table3);
	gtk_container_add (GTK_CONTAINER (checking_games_window), table3);
	gtk_table_set_row_spacings (GTK_TABLE (table3), 5);
	gtk_table_set_col_spacings (GTK_TABLE (table3), 5);

/*
	pause_audit_button = gtk_button_new_with_label (_("Pause"));
	gtk_widget_ref (pause_audit_button);
	g_object_set_data_full (G_OBJECT (checking_games_window), "pause_audit_button", pause_audit_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pause_audit_button);
	gtk_table_attach (GTK_TABLE (table3), pause_audit_button, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
*/

	/* Buttons */

	buttons_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (buttons_hbox);
	g_object_set_data_full (G_OBJECT (checking_games_window), "buttons_hbox", buttons_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (buttons_hbox);
	gtk_table_attach (GTK_TABLE (table3), buttons_hbox, 0, 4, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_box_set_homogeneous (GTK_BOX(buttons_hbox), FALSE);

	/* Stop Button */
	stop_audit_button = gtk_button_new_from_stock(GTK_STOCK_STOP);
	gtk_widget_ref (stop_audit_button);
	g_object_set_data_full (G_OBJECT (checking_games_window), "stop_audit_button", stop_audit_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	g_signal_connect(G_OBJECT (stop_audit_button), "clicked",
			    G_CALLBACK (stop_audit),
			    NULL);
	gtk_widget_show (stop_audit_button);
	gtk_widget_set_size_request (stop_audit_button, BUTTON_WIDTH, -1);
	gtk_box_pack_start (GTK_BOX(buttons_hbox), stop_audit_button, FALSE, TRUE, 3);

	/* Close Button */
	close_audit_button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	gtk_widget_ref (close_audit_button);
	g_object_set_data_full (G_OBJECT (checking_games_window), "close_audit_button", close_audit_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (close_audit_button);
	gtk_widget_set_size_request (close_audit_button, BUTTON_WIDTH, -1);
	/* only allows to clic it when the audit is done */
	gtk_widget_set_sensitive(close_audit_button,FALSE);
	gtk_box_pack_end (GTK_BOX (buttons_hbox), close_audit_button, FALSE, TRUE, 3);


	details_frame = gtk_frame_new (_("Details"));
	gtk_widget_ref (details_frame);
	g_object_set_data_full (G_OBJECT (checking_games_window), "details_frame", details_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (details_frame);
	gtk_table_attach (GTK_TABLE (table3), details_frame, 0, 4, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow6);
	g_object_set_data_full (G_OBJECT (checking_games_window), "scrolledwindow6", scrolledwindow6,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow6);
	gtk_container_add (GTK_CONTAINER (details_frame), scrolledwindow6);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow6), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	details_check_buffer = gtk_text_buffer_new (NULL);
	details_check_text = gtk_text_view_new_with_buffer (details_check_buffer);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW(details_check_text), FALSE);
	gtk_text_view_set_editable (GTK_TEXT_VIEW(details_check_text), FALSE);
	gtk_widget_ref (details_check_text);
	g_object_set_data_full (G_OBJECT (checking_games_window), "details_check_text", details_check_text,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (details_check_text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow6), details_check_text);

	ROMs_frame = gtk_frame_new (_("ROMs"));
	gtk_widget_ref (ROMs_frame);
	g_object_set_data_full (G_OBJECT (checking_games_window), "ROMs_frame", ROMs_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ROMs_frame);
	gtk_table_attach (GTK_TABLE (table3), ROMs_frame, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	table4 = gtk_table_new (4, 3, FALSE);
	gtk_widget_ref (table4);
	g_object_set_data_full (G_OBJECT (checking_games_window), "table4", table4,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table4);
	gtk_container_add (GTK_CONTAINER (ROMs_frame), table4);
	gtk_container_set_border_width (GTK_CONTAINER (table4), 5);
	gtk_table_set_row_spacings (GTK_TABLE (table4), 2);

	correct_roms_value = gtk_label_new ("0");
	gtk_widget_ref (correct_roms_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "correct_roms_value", correct_roms_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (correct_roms_value);
	gtk_table_attach (GTK_TABLE (table4), correct_roms_value, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (correct_roms_value), 0, 0.5);

	bestavailable_roms_value = gtk_label_new ("0");
	gtk_widget_ref (bestavailable_roms_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "bestavailable_roms_value", bestavailable_roms_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bestavailable_roms_value);
	gtk_table_attach (GTK_TABLE (table4), bestavailable_roms_value, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (bestavailable_roms_value), 0, 0.5);

	incorrect_roms_value = gtk_label_new ("0");
	gtk_widget_ref (incorrect_roms_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "incorrect_roms_value", incorrect_roms_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (incorrect_roms_value);
	gtk_table_attach (GTK_TABLE (table4), incorrect_roms_value, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (incorrect_roms_value), 0, 0.5);

	notfound_roms_value = gtk_label_new ("0");
	gtk_widget_ref (notfound_roms_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "notfound_roms_value", notfound_roms_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notfound_roms_value);
	gtk_table_attach (GTK_TABLE (table4), notfound_roms_value, 2, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (notfound_roms_value), 0, 0.5);

	total_roms_value = gtk_label_new ("0");
	gtk_widget_ref (total_roms_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "total_roms_value", total_roms_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (total_roms_value);
	gtk_table_attach (GTK_TABLE (table4), total_roms_value, 2, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (total_roms_value), 0, 0.5);

	total_roms_label = gtk_label_new (_("Total:"));
	gtk_widget_ref (total_roms_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "total_roms_label", total_roms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (total_roms_label);
	gtk_table_attach (GTK_TABLE (table4), total_roms_label, 1, 2, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (total_roms_label), 0, 0.5);

	notfound_roms_label = gtk_label_new (_("Not found:"));
	gtk_widget_ref (notfound_roms_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "notfound_roms_label", notfound_roms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notfound_roms_label);
	gtk_table_attach (GTK_TABLE (table4), notfound_roms_label, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (notfound_roms_label), 0, 0.5);

	incorrect_roms_label = gtk_label_new (_("Incorrect:"));
	gtk_widget_ref (incorrect_roms_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "incorrect_roms_label", incorrect_roms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (incorrect_roms_label);
	gtk_table_attach (GTK_TABLE (table4), incorrect_roms_label, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (incorrect_roms_label), 0, 0.5);

	bestavailable_roms_label = gtk_label_new (_("Best available:"));
	gtk_widget_ref (bestavailable_roms_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "bestavailable_roms_label", bestavailable_roms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bestavailable_roms_label);
	gtk_table_attach (GTK_TABLE (table4), bestavailable_roms_label, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (bestavailable_roms_label), 0, 0.5);

	correct_roms_label = gtk_label_new (_("Correct:"));
	gtk_widget_ref (correct_roms_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "correct_roms_label", correct_roms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (correct_roms_label);
	gtk_table_attach (GTK_TABLE (table4), correct_roms_label, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (correct_roms_label), 0, 0.5);

	roms_check_progressbar = gtk_progress_bar_new ();
	gtk_widget_ref (roms_check_progressbar);
	g_object_set_data_full (G_OBJECT (checking_games_window), "roms_check_progressbar", roms_check_progressbar,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (roms_check_progressbar);
	gtk_table_attach (GTK_TABLE (table4), roms_check_progressbar, 0, 3, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (roms_check_progressbar, -1, 13);

	samples_frame = gtk_frame_new (_("Samples"));
	gtk_widget_ref (samples_frame);
	g_object_set_data_full (G_OBJECT (checking_games_window), "samples_frame", samples_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samples_frame);
	gtk_table_attach (GTK_TABLE (table3), samples_frame, 2, 4, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	table5 = gtk_table_new (4, 3, FALSE);
	gtk_widget_ref (table5);
	g_object_set_data_full (G_OBJECT (checking_games_window), "table5", table5,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table5);
	gtk_container_add (GTK_CONTAINER (samples_frame), table5);
	gtk_container_set_border_width (GTK_CONTAINER (table5), 5);
	gtk_table_set_row_spacings (GTK_TABLE (table5), 2);

	correct_samples_value = gtk_label_new ("0");
	gtk_widget_ref (correct_samples_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "correct_samples_value", correct_samples_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (correct_samples_value);
	gtk_table_attach (GTK_TABLE (table5), correct_samples_value, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (correct_samples_value), 0, 0.5);

	incorrect_samples_value = gtk_label_new ("0");
	gtk_widget_ref (incorrect_samples_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "incorrect_samples_value", incorrect_samples_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (incorrect_samples_value);
	gtk_table_attach (GTK_TABLE (table5), incorrect_samples_value, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (incorrect_samples_value), 0, 0.5);

	incorrect_samples_label = gtk_label_new (_("Incorrect:"));
	gtk_widget_ref (incorrect_samples_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "incorrect_samples_label", incorrect_samples_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (incorrect_samples_label);
	gtk_table_attach (GTK_TABLE (table5), incorrect_samples_label, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (incorrect_samples_label), 0, 0.5);

	total_samples_label = gtk_label_new (_("Total:"));
	gtk_widget_ref (total_samples_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "total_samples_label", total_samples_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (total_samples_label);
	gtk_table_attach (GTK_TABLE (table5), total_samples_label, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (total_samples_label), 0, 0.5);

	total_samples_value = gtk_label_new ("0");
	gtk_widget_ref (total_samples_value);
	g_object_set_data_full (G_OBJECT (checking_games_window), "total_samples_value", total_samples_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (total_samples_value);
	gtk_table_attach (GTK_TABLE (table5), total_samples_value, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (total_samples_value), 0, 0.5);

	correct_samples_label = gtk_label_new (_("Correct:"));
	gtk_widget_ref (correct_samples_label);
	g_object_set_data_full (G_OBJECT (checking_games_window), "correct_samples_label", correct_samples_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (correct_samples_label);
	gtk_table_attach (GTK_TABLE (table5), correct_samples_label, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (correct_samples_label), 0, 0.5);

	samples_check_progressbar = gtk_progress_bar_new ();
	gtk_widget_ref (samples_check_progressbar);
	g_object_set_data_full (G_OBJECT (checking_games_window), "samples_check_progressbar", samples_check_progressbar,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samples_check_progressbar);
	gtk_table_attach (GTK_TABLE (table5), samples_check_progressbar, 0, 3, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (samples_check_progressbar, -1, 13);
	gtk_widget_show(checking_games_window);
	return checking_games_window;
}

/* due to the pipe buffer size,
   freeze the qui a moment before displaying results*/
void launch_checking_games_window(void)
{
	FILE *xmame_pipe;
	gchar line[BUFFER_SIZE];
	gchar title[BUFFER_SIZE];
	gchar numb[10];
	gfloat done;
	guint nb_checked = 1,nb_good = 0,nb_incorrect = 0,nb_bestavailable = 0,nb_notfound = 0;
	gboolean error_during_check=FALSE,game_found;
	gchar *command, *p, *name;
	gchar *rompath_option,*samplepath_option;
	GList *listpointer;
	RomEntry *tmprom = NULL;
	guint status;
	GtkTextIter text_iter;

	if(!xmame_executable_get_options(current_exec))
		return;

	audit_cancelled = 0;
	close_audit = 0;
	rompath_option = create_RomPath_Related_options_string();
	command = g_strdup_printf("%s -verifyroms %s 2>/dev/null",
			current_exec->path,
			rompath_option);
	g_free(rompath_option);
	GXMAME_DEBUG("running command %s",command);

	xmame_pipe = popen(command, "r");
	if (!xmame_pipe)
	{
		GXMAME_DEBUG("Could not run %s", command);
		g_free(command);
		return;
	}
	g_free(command);
	/* Loading */
	fflush(xmame_pipe);
	while (fgets(line, BUFFER_SIZE, xmame_pipe) && !audit_cancelled)
	{
		/* jump the last comments */
		if (line[0] == '\0' || line[1] == '\0')
			break;
		
		gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER(details_check_buffer), &text_iter);
		if (!strncmp(line,"romset",6))
		{
			for(p = name = line+7;(*p && (*p != ' ') && (*p != '\n'));p++);
			*p='\0';p++;
			done = (gfloat) ((gfloat) (nb_checked) /
					(gfloat) (supported_games));

			if (!strncmp(p,"correct",7))
			{
				nb_good++;
				g_snprintf(numb,10,"%d",nb_good);
				gtk_label_set_text(GTK_LABEL(correct_roms_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect+nb_notfound+nb_bestavailable);
				gtk_label_set_text(GTK_LABEL(total_roms_value),numb);
				status = 1;
			}
			else if (!strncmp(p,"incorrect",9) && error_during_check==TRUE)
			{
				nb_incorrect++;
				g_snprintf(numb,10,"%d",nb_incorrect);
				gtk_label_set_text(GTK_LABEL(incorrect_roms_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect+nb_notfound+nb_bestavailable);
				gtk_label_set_text(GTK_LABEL(total_roms_value),numb);
				sprintf(title,"%s: Incorrect\n",line);
				gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_check_buffer), &text_iter, title, -1);
				status = 0;
			}
			else if (!strncmp(p,"not found",9))
			{
				nb_notfound++;
				g_snprintf(numb,10,"%d",nb_notfound);
				gtk_label_set_text(GTK_LABEL(notfound_roms_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect+nb_notfound+nb_bestavailable);
				gtk_label_set_text(GTK_LABEL(total_roms_value),numb);
				sprintf(title,"%s: Not found\n",line);
				gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_check_buffer), &text_iter, title, -1);
				status = 0;
			}
			else if (!strncmp(p,"best available",14))
			{
				nb_bestavailable++;
				g_snprintf(numb,10,"%d",nb_bestavailable);
				gtk_label_set_text(GTK_LABEL(bestavailable_roms_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect+nb_notfound+nb_bestavailable);
				gtk_label_set_text(GTK_LABEL(total_roms_value),numb);
				status = 1;
			}
			else
			{
				printf("????\n");
				status = 2;
			}

			/* find the rom in the list */
			for(listpointer = g_list_first(roms), game_found = FALSE;
					(listpointer != NULL);
					listpointer = g_list_next(listpointer))
			{
				tmprom = (RomEntry *) listpointer->data;
				if (!strcmp(tmprom->romname,name))
				{
					game_found = TRUE;
					break;
				}
			}
			if (game_found)
			{
				tmprom->has_roms = status;
				if (tmprom->the_trailer && gui_prefs.ModifyThe)
					g_snprintf(title,BUFFER_SIZE,"Checking Game %s, The %s",tmprom->gamename,tmprom->gamenameext);
				else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
					g_snprintf(title,BUFFER_SIZE,"Checking Game The %s %s",tmprom->gamename,tmprom->gamenameext);
				else
					g_snprintf(title,BUFFER_SIZE,"Checking Game %s %s",tmprom->gamename,tmprom->gamenameext);
			}
			else
			{/* haven't found the game, just diplay the gamename */
				g_snprintf(title,BUFFER_SIZE,_("Checking Game %s"),name);
			}
			/*continue with the GUI */
			nb_checked++;
			error_during_check = FALSE;
			gtk_window_set_title (GTK_WINDOW (checking_games_window), title);
			gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR(roms_check_progressbar),done);
		}
		else
		{
			gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_check_buffer), &text_iter, line, -1);
			error_during_check = TRUE;
		}

		while (gtk_events_pending()) gtk_main_iteration();
		fflush(xmame_pipe);
	}
	pclose(xmame_pipe);

	if(audit_cancelled)
	{
		gtk_window_set_title (GTK_WINDOW (checking_games_window), _("Audit Stopped"));
		goto audit_finished;
	}
	/*Samples now*/
	nb_good = nb_incorrect = 0;
	nb_checked = 1;

	samplepath_option = create_SamplePath_Related_options_string();
	command = g_strdup_printf("%s -verifysamples %s 2>/dev/null",
			current_exec->path,
			samplepath_option);
	g_free(samplepath_option);

	GXMAME_DEBUG("running command %s",command);
	xmame_pipe = popen(command, "r");
	g_free(command);

	/* Loading */
	while (fgets(line, BUFFER_SIZE, xmame_pipe) && !audit_cancelled)
	{
		/* jump the last comments */
		if (line[0] == '\0' || line[1] == '\0')
			break;
		
		gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER(details_check_buffer), &text_iter);
		if (!strncmp(line,"sampleset",9))
		{
			for(p = name = line+10;(*p && (*p != ' ') && (*p != '\n'));p++);
			*p='\0';p++;
			done = (gfloat) ((gfloat) (nb_checked) /
					(gfloat) (supported_samples_games));
			if (!strncmp(p,"correct",7))
			{
				nb_good++;
				g_snprintf(numb,10,"%d",nb_good);
				gtk_label_set_text(GTK_LABEL(correct_samples_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect);
				gtk_label_set_text(GTK_LABEL(total_samples_value),numb);
				status = 1;
			}
			else if (!strncmp(p,"incorrect",9) && error_during_check==TRUE)
			{
				nb_incorrect++;
				g_snprintf(numb,10,"%d",nb_incorrect);
				gtk_label_set_text(GTK_LABEL(incorrect_samples_value),numb);
				g_snprintf(numb,10,"%d",nb_good+nb_incorrect);
				gtk_label_set_text(GTK_LABEL(total_samples_value),numb);
				status = 0;
			} else
				status = 2;
			/* find the rom in the list */
			for(listpointer = g_list_first(roms), game_found = FALSE;
					(listpointer != NULL);
					listpointer = g_list_next(listpointer))
			{
				tmprom = (RomEntry *) listpointer->data;
				if (!strcmp(tmprom->romname,name))
				{
					game_found = TRUE;
					break;
				}
			}
			if (game_found)
			{
				tmprom->has_samples = status;
				if (tmprom->the_trailer && gui_prefs.ModifyThe)
					g_snprintf(title,BUFFER_SIZE,"Checking Game %s, The %s",tmprom->gamename,tmprom->gamenameext);
				else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
					g_snprintf(title,BUFFER_SIZE,"Checking Game The %s %s",tmprom->gamename,tmprom->gamenameext);
				else
					g_snprintf(title,BUFFER_SIZE,"Checking Game %s %s",tmprom->gamename,tmprom->gamenameext);
			}
			/*continue with the GUI */
			nb_checked++;
			error_during_check = FALSE;
			g_snprintf(title,BUFFER_SIZE,_("Checking Game %s"),name);
			gtk_window_set_title (GTK_WINDOW (checking_games_window), title);
			gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR(samples_check_progressbar),done);
		}
		else
		{
			gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_check_buffer), &text_iter, line, -1);
			error_during_check = TRUE;
		}
		while (gtk_events_pending()) gtk_main_iteration();
		fflush(xmame_pipe);
	}
	pclose(xmame_pipe);

	if(audit_cancelled)
	{
		gtk_window_set_title (GTK_WINDOW (checking_games_window), _("Audit Stopped"));
		goto audit_finished;
	}

	gtk_window_set_title (GTK_WINDOW (checking_games_window), _("Audit done"));
	gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER(details_check_buffer), &text_iter);
	gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_check_buffer), &text_iter, _("Audit done"), -1);

audit_finished:
	gtk_widget_set_sensitive(stop_audit_button,FALSE);
	gtk_widget_set_sensitive(close_audit_button,TRUE);
	create_gamelist_content();
	g_signal_connect_swapped (G_OBJECT (close_audit_button), "clicked",
			    G_CALLBACK (gtk_widget_destroy),
			    G_OBJECT (checking_games_window));
	g_signal_connect (G_OBJECT (checking_games_window), "delete-event",
			    G_CALLBACK (gtk_widget_destroy),
			    G_OBJECT (checking_games_window));
	if(close_audit)
		gtk_widget_destroy(checking_games_window);
	audit_cancelled = 0;
	while (gtk_events_pending()) gtk_main_iteration();
}


