/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "gxmame.h"
#include "callbacks.h"
#include "gui.h"
#include "io.h"
#include "interface.h"
#include "general_properties.h"
#include "options.h"

#define BUFFER_SIZE 1000



void
on_general_properties_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);
void
on_general_properties_apply_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);

/*from the gui.c*/
void select_game(RomEntry *rom);



GtkWidget *notebook1;



GtkWidget*
create_general_properties_windows (void)
{
	GtkWidget *properties_windows;
	GtkWidget *vbox9;
	GtkWidget *hbox3;
  
	GtkWidget *properties_ok_button;
	GtkWidget *properties_apply_button;
	GtkWidget *properties_cancel_button;
	GtkAccelGroup *accel_group;


	accel_group = gtk_accel_group_new ();

	properties_windows = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_set_data (G_OBJECT (properties_windows), "properties_windows", properties_windows);
	gtk_window_set_title (GTK_WINDOW (properties_windows), _("Properties for default game"));
	gtk_window_set_position (GTK_WINDOW (properties_windows), GTK_WIN_POS_MOUSE);
	gtk_window_set_transient_for(GTK_WINDOW(properties_windows),GTK_WINDOW(MainWindow));
	gtk_window_set_modal(GTK_WINDOW(properties_windows),TRUE);
			
	vbox9 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox9);
	g_object_set_data_full (G_OBJECT (properties_windows), "vbox9", vbox9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox9);
	gtk_container_add (GTK_CONTAINER (properties_windows), vbox9);

	notebook1 = gtk_notebook_new ();
	gtk_widget_ref (notebook1);
	g_object_set_data_full (G_OBJECT (properties_windows), "notebook1", notebook1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notebook1);
	gtk_box_pack_start (GTK_BOX (vbox9), notebook1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (notebook1), 8);


	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	g_object_set_data_full (G_OBJECT (properties_windows), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox9), hbox3, FALSE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox3), 5);

	properties_cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	gtk_widget_ref (properties_cancel_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_cancel_button", properties_cancel_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_cancel_button);
	gtk_widget_set_size_request (properties_cancel_button, BUTTON_WIDTH, -1);

	properties_apply_button = gtk_button_new_from_stock (GTK_STOCK_APPLY);
	gtk_widget_ref (properties_apply_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_apply_button", properties_apply_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_apply_button);
	gtk_widget_set_sensitive (properties_apply_button,FALSE);
	gtk_widget_set_size_request (properties_apply_button, BUTTON_WIDTH, -1);

	properties_ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_ref (properties_ok_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_ok_button", properties_ok_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_ok_button);
	gtk_widget_set_size_request (properties_ok_button, BUTTON_WIDTH, -1);

	gtk_box_pack_end (GTK_BOX (hbox3), properties_ok_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox3), properties_apply_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox3), properties_cancel_button, FALSE, TRUE, 3);

	add_display_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 0);
	add_rendering_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 1);
	add_sound_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 2);
	add_controller_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 3);
	add_misc_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 4);
	add_vector_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 NULL,
				 properties_apply_button,
				 NULL,
				 5);

	/*temp, change as soon as preferences are implemented */
	g_signal_connect (G_OBJECT (properties_ok_button), "clicked",
			    G_CALLBACK (on_general_properties_ok_button_clicked),
			    G_OBJECT (properties_windows));
	g_signal_connect_swapped (G_OBJECT (properties_cancel_button), "clicked",
			           G_CALLBACK (gtk_widget_destroy),
			           G_OBJECT (properties_windows));
	g_signal_connect (G_OBJECT (properties_apply_button), "clicked",
			    G_CALLBACK (on_general_properties_apply_button_clicked),
			    NULL);
	g_signal_connect_swapped (G_OBJECT (properties_windows), "delete-event",
			           G_CALLBACK (gtk_widget_destroy),
			           G_OBJECT (properties_windows));

	gtk_window_add_accel_group (GTK_WINDOW (properties_windows), accel_group);

	return properties_windows;
}


void
on_general_properties_ok_button_clicked        (GtkButton       *button,
                                                gpointer         user_data)
{
	save_properties_options(NULL);
	save_options(NULL);
	gtk_widget_set_sensitive(GTK_WIDGET(button),FALSE);
	gtk_widget_destroy(GTK_WIDGET(user_data));
}

void
on_general_properties_apply_button_clicked     (GtkButton       *button,
                                                gpointer         user_data)
{
	save_properties_options(NULL);
	save_options(NULL);
	gtk_widget_set_sensitive(GTK_WIDGET(button),FALSE);
}

