/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Original code taken from:
 * gtkjoy.c
 *
 * general routines for handling joystick events
 *
 * Copyright 1999 David Boynton.
 * http://trylinux.com/projects/joystick/
 */
#ifndef __gtkjoy_h
#define __gtkjoy_h

#include <glib.h>

#define AXIS_MAX	32767
#define AXIS_MIN	-32768

#ifndef GXMAME_JOY_DEV
#define GXMAME_JOY_DEV	"/dev/js0"
#endif

typedef struct _JoyData {
	char *device_name;
	int num_axis;
	int *axis;
	int num_buttons;
	int *buttons;
	GIOChannel *io_channel;
	guint source_id;
} JoyData;

JoyData *
joystick_new (char * joystick);

void
joystick_close (JoyData *joydata);

void
joy_focus_on (void);

void
joy_focus_off (void);

const char *
get_joy_dev (void);

#endif
