/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"
#include <gtk/gtk.h>
#include <string.h>

#include "gxmame.h"
#include "gui.h"
#include "gtkjoy.h"
#include "callbacks.h"


void
on_gui_prefs_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);
void
on_gui_prefs_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
button_toggled2      (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(user_data),gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton)));
}

GtkWidget *gui_joy_entry;
GtkWidget *gui_joy_checkbutton;
GtkWidget *checkgames_checkbutton;
GtkWidget *VersionCheck_checkbutton;

GtkWidget*
create_gui_prefs_window (void)
{
	GtkWidget *gui_prefs_window;
	GtkWidget *gui_prefs_table;
	GtkWidget *gui_prefs_cancel_button;
	GtkWidget *gui_prefs_ok_button;
	GtkWidget *gui_joy_label;
	GtkWidget *hbox1;

	gui_prefs_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_set_data (G_OBJECT (gui_prefs_window), "gui_prefs_window", gui_prefs_window);
	gtk_window_set_title (GTK_WINDOW (gui_prefs_window), _("Startup Options"));
	gtk_window_set_position (GTK_WINDOW (gui_prefs_window), GTK_WIN_POS_MOUSE);
	gtk_window_set_transient_for(GTK_WINDOW(gui_prefs_window),GTK_WINDOW(MainWindow));
	gtk_window_set_modal(GTK_WINDOW(gui_prefs_window),TRUE);
	gtk_window_set_resizable(GTK_WINDOW(gui_prefs_window),FALSE);

	gui_prefs_table = gtk_table_new (4, 4, FALSE);
	gtk_widget_ref (gui_prefs_table);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_prefs_table", gui_prefs_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gui_prefs_table);
	gtk_container_add (GTK_CONTAINER (gui_prefs_window), gui_prefs_table);
	gtk_container_set_border_width (GTK_CONTAINER (gui_prefs_table), 5);
	gtk_table_set_row_spacings (GTK_TABLE (gui_prefs_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (gui_prefs_table), 3);

	hbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox1);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "hbox1", hbox1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox1);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), hbox1, 1, 4, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_box_set_homogeneous (GTK_BOX(hbox1), FALSE);

	/* Buttons */
	gui_prefs_cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	gtk_widget_ref (gui_prefs_cancel_button);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_prefs_cancel_button", gui_prefs_cancel_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gui_prefs_cancel_button);
	gtk_widget_set_size_request (gui_prefs_cancel_button, BUTTON_WIDTH, -1);

	gui_prefs_ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_ref (gui_prefs_ok_button);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_prefs_ok_button", gui_prefs_ok_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gui_prefs_ok_button);
	gtk_widget_set_size_request (gui_prefs_ok_button, BUTTON_WIDTH, -1);

	gtk_box_pack_end (GTK_BOX (hbox1), gui_prefs_ok_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox1), gui_prefs_cancel_button, FALSE, TRUE, 3);


	checkgames_checkbutton = gtk_check_button_new_with_mnemonic (_("_Search for new games"));
	gtk_widget_ref (checkgames_checkbutton);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "checkgames_checkbutton", checkgames_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (checkgames_checkbutton);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), checkgames_checkbutton, 0, 4, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	VersionCheck_checkbutton = gtk_check_button_new_with_mnemonic (_("_Enable version mismatch warning"));
	gtk_widget_ref (VersionCheck_checkbutton);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "VersionCheck_checkbutton", VersionCheck_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (VersionCheck_checkbutton);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), VersionCheck_checkbutton, 0, 4, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	gui_joy_checkbutton = gtk_check_button_new_with_mnemonic (_("Allow game selection by a _Joystick"));
	gtk_widget_ref (gui_joy_checkbutton);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_joy_checkbutton", gui_joy_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), gui_joy_checkbutton, 0, 4, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	gui_joy_label = gtk_label_new (_("Joystick Device :"));
	gtk_widget_ref (gui_joy_label);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_joy_label", gui_joy_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), gui_joy_label, 0, 4, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
	gtk_misc_set_alignment (GTK_MISC (gui_joy_label), 0, 0.5);

	gui_joy_entry = gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(gui_joy_entry), 20);
	gtk_widget_ref (gui_joy_entry);
	g_object_set_data_full (G_OBJECT (gui_prefs_window), "gui_joy_entry", gui_joy_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (gui_prefs_table), gui_joy_entry, 0, 4, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	g_signal_connect (G_OBJECT (gui_prefs_cancel_button), "clicked",
			    G_CALLBACK (on_gui_prefs_cancel_button_clicked),
			    G_OBJECT (gui_prefs_window));
	g_signal_connect (G_OBJECT (gui_prefs_ok_button), "clicked",
			    G_CALLBACK (on_gui_prefs_ok_button_clicked),
			    G_OBJECT (gui_prefs_window));

#ifdef ENABLE_JOYSTICK
	gtk_widget_show (gui_joy_checkbutton);
	gtk_widget_show (gui_joy_label);
	gtk_widget_show (gui_joy_entry);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gui_joy_checkbutton), gui_prefs.gui_joy);
	gtk_entry_set_text (GTK_ENTRY (gui_joy_entry), gui_prefs.Joystick_in_GUI);
	gtk_widget_set_sensitive(GTK_WIDGET(gui_joy_entry),gui_prefs.gui_joy);
	g_signal_connect_after (G_OBJECT (gui_joy_checkbutton), "toggled",
				  G_CALLBACK (button_toggled2),
				  G_OBJECT (gui_joy_entry));

	g_signal_connect_after (G_OBJECT (gui_joy_checkbutton), "toggled",
				  G_CALLBACK (button_toggled2),
				  G_OBJECT (gui_joy_label));

#endif
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkgames_checkbutton), gui_prefs.GameCheck);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (VersionCheck_checkbutton), gui_prefs.VersionCheck);
	
	return gui_prefs_window;
}


void
on_gui_prefs_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
#ifdef ENABLE_JOYSTICK
	gchar *used_text;
	gui_prefs.gui_joy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gui_joy_checkbutton));
	used_text = gtk_editable_get_chars(GTK_EDITABLE(gui_joy_entry),0,-1);
	strncpy(gui_prefs.Joystick_in_GUI,used_text,20);
	g_free(used_text);
	
	/* activate or desactivate joystick */
	if(gui_prefs.gui_joy)
	{
		if ((joydata=joystick_new(gui_prefs.Joystick_in_GUI)))
		{
			g_message(_("Joystick %s found"),joydata->device_name);
		} else
		{
			g_message(_("No Joystick found"));
		}
	}
	else
	{
		joystick_close(joydata);
		joydata=NULL;
	}
#endif
	gui_prefs.GameCheck = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkgames_checkbutton));
	gui_prefs.VersionCheck = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(VersionCheck_checkbutton));
	
	gtk_widget_destroy(user_data);
}


void
on_gui_prefs_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(user_data);
}
