/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __GXMAME_H__
#define __GXMAME_H__

#include "common.h"
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "gtkjoy.h"
#include "xmame_executable.h"

#define SELECT_TIMEOUT 110
#define ICON_TIMEOUT 100
#define SEARCH_TIMEOUT 1000

#define EXECUTABLE 1
#define GAMELIST 2

/* Maximum length of some strings */
#define MAX_ROMNAME 10
#define MAX_GAMENAME 100
#define MAX_MANU 50
#define MAX_YEAR 5
#define MAX_CPU 20
#define MAX_CONTROL 20
#define MAX_CATEGORY 40
#define MAX_MAMEVER 20
#define MAX_DRIVERSTATUS 20
/* Maximum number of CPUs/Sound CPUs per game
changing this will break the gamelist compatibility
*/
#define NB_CPU 4
#define MAX_OPTION_STRING 100
#define MAX_FONTNAME 100
#define BUTTON_WIDTH 90

typedef enum _Columns_type {
	GAMENAME,
	HAS_ROMS,
	HAS_SAMPLES,
	ROMNAME,
	VECTOR,
	CONTROL,
	TIMESPLAYED,
	MANU,
	YEAR,
	CLONE,
	DRIVER,
	STATUS,       /*  Available / Not Available */
	ROMOF,
	DRIVERSTATUS, /*  Working / Not Working */
	NUMPLAYERS,
	NUMBUTTONS,
	CPU1,
	CPU2,
	CPU3,
	CPU4,
	SOUND1,
	SOUND2,
	SOUND3,
	SOUND4,
	MAMEVER,
	CATEGORY,
	FAVORITE,
	CHANNELS,
	NUMBER_COLUMN
} Columns_type;

typedef enum _Columns_type_hidden {
	ROMENTRY,
	TEXTCOLOR,
	PIXBUF,
	NUMBER_COLUMN_HIDDEN
} Columns_type_hidden;


typedef enum _RomStatus {
	CORRECT,
	INCORRECT,
	PROBLEMS,
	UNKNOWN,
	NUMBER_STATUS
} RomStatus;

typedef enum _screenshot_type {
	SNAPSHOTS,
	FLYERS,
	CABINETS,
	MARQUEES,
	TITLES
} screenshot_type;

typedef enum _folder_filters_list {
	NULL_FOLDER_ID,	/* 0	just for the folderID compliance*/
	ALL,		/* 1 */
	AVAILABLE,	/* 2 */
	UNAVAILABLE,	/* 3 */
	NEOGEO,		/* 4 */
	CPS1,		/* 18 */
	CPS2,		/* 19 */
	MANUFACTURERS, 	/* 5 just for the folderID compliance*/
	YEARS, 		/* 6 just for the folderID compliance*/
	WORKING,	/* 7 */
	NONWORKING,	/* 8 */
	CUSTOMS, 	/* 9 just for the folderID compliance*/
	PLAYED,		/* 10 */
	FAVORITES,	/* 11 */
	ORIGINALS,	/* 12 */
	CLONES,		/* 13 */
	RASTERS,	/* 14 */
	VECTORS,	/* 15 */
	TRACKBALL,	/* 16 */
	STEREO,
	DRIVERS,
	CATEGORIES,
	VERSIONS,
	NUMBER_FOLDER
} folder_filters_list;

typedef enum _ListMode {
	LIST,
	LIST_TREE,
	DETAILS,
	DETAILS_TREE
} ListMode;


typedef struct _CPUInfo {
	gchar name[MAX_CPU];
	guint clock;
	gboolean sound_flag;
} CPUInfo;

typedef struct _SoundCPUInfo {
	gchar name[MAX_CPU];
	guint clock;
} SoundCPUInfo;

/* use free_rom_entry() to free this */
typedef struct _RomEntry {
	gchar romname[MAX_ROMNAME];
	gchar *gamename;
	gchar *gamenameext;
	gchar year[MAX_YEAR];
	gchar *manu;
	gchar *cloneof;
	gchar *romof;
	gchar *sampleof;
	gchar driver[MAX_ROMNAME];
	CPUInfo cpu_info[NB_CPU];
	SoundCPUInfo sound_info[NB_CPU];
	gchar control[MAX_CONTROL];
	gchar category[MAX_CATEGORY];
	gchar mame_ver_added[MAX_MAMEVER];
	gint num_players;
	gint num_buttons;
	gint channels;
	gboolean vector;
	gboolean status;

	gboolean horizontal;
	guint screen_x;
	guint screen_y;
	gfloat screen_freq;
	guint colors;

	gint nb_roms;
	gint nb_samples;
	gboolean the_trailer;

	gint timesplayed;
	gint has_roms;
	gint has_samples;
	gboolean favourite;

	/* position of the game in the GTKTreeView */
	GtkTreeIter position;
	gboolean is_in_list;
	/* string in order to sort the clones with the original */
	gchar clonesort[2*MAX_ROMNAME+1];
	/* store the icon of the game in the RomEntry struct
	   when game is visible on the list, used as cache  */
	GdkPixbuf *icon_pixbuf;
	/* Name in list */
	gchar *name_in_list;
} RomEntry;


struct gui_prefs_struct {
	gchar DefaultGame[MAX_GAMENAME];
	RomEntry *DefaultGame_p;
	/* 1:All, 2:available, 3=unavailable, 4=NeoGeo, 5:Manufacturers
	   6=Years, 7=Working, 8=NonWorking, 9=Custom, 10=Played, 11=Favorites
	   12=originals, 13=clones 14=Raster, 15=Vector, 16=Trackball, 17=Stereo
	   18=CPS1, 19=CPS2
	   Mame32K			| GXMame
	   20=Namco 21=hack...		| 22=3D Games
	   got the year in good order, just need to find the good ofsset given by the number of manufacturer
	   240=year>1980 		| 293=year>1980
	   ...				| ...
	   248=<U>			| 301=<U>
	   249=1986			| 302=1986
	   ...				| ...
	   266=2000			| 319=2000
	  will be able to stick with mame32k only with first folders or
	  I have to assign a folder ID to all manufacturer and year at
	  the condition that I got the same manufacturers list.*/
	folder_filters_list FolderID;
	/*Show screenshot panel*/
	gboolean ShowScreenShot;
	/* 0:Snaps, 1:Flyers, 2:Cabinets, 3:Marquees, 4:Titles?*/
	gboolean ShowScreenShotTab;
	screenshot_type ShowFlyer;
	gint ShowToolBar;
	gboolean ShowStatusBar;
	gboolean ShowFolderList;
	gboolean GameCheck;
	gboolean VersionCheck;
/*	gint MMXCheck;*/
	gboolean ModifyThe;
/*	gint UseFavoriteNetPlay;*/
/*	gint UseIMEInChat;*/
/*	gint ChatDrawMode;*/
	gint SortColumn;
	gboolean SortReverse;
	/* Link table between absolute column Id and displayed column number */
	gint ColumnShownId[NUMBER_COLUMN];
	gint ColumnHiddenId[NUMBER_COLUMN];  /* Only needed on column_layout */
	gint GUIPosX;
	gint GUIPosY;
	gint GUIWidth;
	gint GUIHeight;
/*set by local
	gchar *Language;*/
	ListMode current_mode;
	ListMode previous_mode;

	gint Splitters[2];
	gchar *ListFont;
	GdkFont *ListFontStruct;
	guint ListFontHeight;
	/* Width of each column ex: width of "game name" column is ColumnWidth[0] */
	gint ColumnWidth[NUMBER_COLUMN];
	/* Order of each column ex: "game name" column is the ColumnOrder[0] th column */
	gint ColumnOrder[NUMBER_COLUMN];
	/* ColumnShown[0]==true -> "game name" column is shown */
	gboolean ColumnShown[NUMBER_COLUMN];
	gchar *SaveVersion;
	GdkColor clone_color;
	gint ResetGUI;
	gint ResetGameDefaults;
	
	/* directories specification */
	gchar **RomPath;
	gchar **SamplePath;
	gchar *ArtworkDirectory;
	gchar *SnapshotDirectory;
	gchar *HiscoreDirectory;
	gchar *FlyerDirectory;
	gchar *CabinetDirectory;
	gchar *MarqueeDirectory;
	gchar *TitleDirectory;
	gchar *DiffDirectory;

	gchar *IconDirectory;

	gchar *InputDirectory;
	gchar *NVRamDirectory;
	gchar *MemCardDirectory;
	gchar *ConfigDirectory;
	gchar *StateDirectory;
	gchar *CtrlrDirectory;
	gchar *inipath;
	
	/* specifics option to GXMame (path to catver, common path...)
	   not in dir.ini */
	gchar *catverDirectory;
	gchar *CheatFile;
 	gchar *HiscoreFile;
 	gchar *HistoryFile;
 	gchar *MameInfoFile;
	
	gboolean gui_joy;
	gchar *Joystick_in_GUI;
};

typedef struct _xmame_game_options {
	/*** Video Related ***/
	guint bpp;			/* Specify the colordepth the core should render,one of:
					   auto(0), 8, 16 */
	guint arbheight;		/* Scale video to exactly this height (0 =
					   disable) (0-4096)*/
	guint heightscale;		/* Set Y-Scale aspect ratio (0-8)*/
	guint widthscale;		/* Set X-Scale aspect ratio (0-8)*/
	gfloat scale;			/* Set X-Y Scale to the same aspect ratio. For
					   vector games scale (and also width- and
					   heightscale) may have value's like 1.5 and even
					   0.5. For scaling of regular games this will be
					   rounded to an int*/
	guint effect;			/* Video effect:
						0 = none (default)
						1 = scale2x (smooth scaling effect)
						2 = scan2 (light scanlines)
						3 = rgbstripe (3x2 rgb vertical stripes)
						4 = rgbscan (2x3 rgb horizontal scanlines)
						5 = scan3 (3x3 deluxe scanlines)
						6 = 2x low  quality magnification filter
						7 = 2x high quality magnification filter
						*/
	gboolean autodouble;		/* Enable/disable automatic scale doubling for 1:2
					   pixel aspect ratio games*/
	gboolean dirty; 		/* Enable/disable use of dirty rectangles*/
	gboolean scanlines;		/* Enable/disable displaying simulated scanlines*/
	gboolean artwork;		/* Use/don't use artwork if available*/
	gboolean use_backdrops;		/* use backdrop artwork */
	gboolean use_overlays;		/* use overlay artwork */
	gboolean use_bezels;		/* use bezel artwork */
	gboolean artwork_crop;		/* crop artwork to game screen only */
	guint artwork_resolution;	/* artwork resolution (0 for auto) */
	guint frameskipper;		/* Select which autoframeskip and throttle
					   routines to use. Available choices are:
						0 Dos frameskip code
						1 Enhanced frameskip code by William A. Barath*/
	gboolean throttle;		/* Enable/disable throttle*/
	gboolean sleepidle;		/* Enable/disable sleep during idle*/
	gboolean autoframeskip; 	 /* Enable/disable autoframeskip*/
	guint maxautoframeskip; 	/* Set highest allowed frameskip for autoframeskip*/
	guint frameskip;		/* Set frameskip when not using autoframeskip (0 - 11)*/
	gfloat brightness;		/* Set the brightness (0.5-2.0) (old 0-100%)*/
	gfloat gamma_correction;	/* Set the gamma-correction (0.5-2.0)*/
	gboolean norotate;		/* Disable rotation*/
	gboolean ror;			/* Rotate display 90 degrees rigth*/
	gboolean rol;			/* Rotate display 90 degrees left*/
	gboolean flipx; 		/* Flip X axis*/
	gboolean flipy; 		/* Flip Y axis*/
	
	/*** Vector Games Related ***/
	gboolean vectorres_flag;	    
	gchar vectorres[10];   		/* Always scale vectorgames to XresxYres, keeping    
 			      		   their aspect ratio. This overrides the scale
 			      		   options  */  				    
	gfloat beam;	      		/* Set the beam size for vector games (1 - 15)*/
	gfloat flicker;       		/* Set the flicker for vector games*/		    
	gboolean antialias;   		/* Enable/disable antialiasing*/
	gboolean translucency;		/* Enable/disable tranlucency*/ 		    
	gfloat intensity;		/* set intensity in vector games */
			
	/*display_opts (depend target)*/
	/*** X11 Related ***/
	guint x11_mode;			/* Select x11 video mode: (if compiled in)
						0 Normal window  (hotkey left-alt + insert)
						1 Fullscreen DGA (hotkey left-alt + home)*/
	 /*** X11-window Related ***/
	gboolean cursor;		/* Show/don't show the cursor */		      
	gboolean mitshm;		/* Use/don't use MIT Shared Mem (if available and  
					   compiled in) */
	gboolean xvext;			/* Use/don't use Xv extension for hardware scaling
	                                   (if available and compiled in)) */			      
	gboolean vidix;			/* Use/don't use VIDIX for hardware scaling (if    
					   available and compiled in))*/
	gboolean xvfullscreen;		/* Start in fullscreen mode */
	gboolean yuv;			/* Force YUV mode (for video cards with broken RGB
					   overlays) */
	gboolean yv12;			/* Force YV12 mode (for video cards with broken RGB 
					   overlays) */
	gboolean xsync;			/* Use/don't use XSync instead of XFlush as screen 
					   refresh method */				      
	gboolean privatecmap;		/* Enable/disable use of private color map */	      
	gboolean xil;			/* Enable/disable use of XIL for scaling (if       
					   available and compiled in) */		      
	gboolean mtxil;			/* Enable/disable multi threading of XIL */	      
	gboolean run_in_root_window;	/* Enable/disable running in root window */	      
	gint root_window_id;		/* Create the xmame-window in an alternate	      
					   root-window, mostly usefull for frontends! */      
	gboolean xvgeom_flag;	        /* use geometry option for xv*/	      
	gchar geometry[10];	        /* Specify the location of the window (size with xv)*/	      

	 /*** X11-input related ***/
	 /* (X11 & GL Glide) */
	gboolean grabmouse;		/* Enable/disable mousegrabbing (also alt +        
					   pagedown) */ 				      
	gboolean grabkeyboard;		/* Enable/disable keyboardgrabbing (also alt +
					   pageup) */
	gboolean winkeys;		/* Enable/disable mapping of windowskeys under X */   
	gchar mapkey[14];		/* Set a specific key mapping, see xmamerc.dist
					   mapkey 0x0020,0x001d */   

	/*** OpenGL Related ***/
	gboolean glfullscreen;		/* Start at fullscreen (default: false) */
	gboolean gldblbuffer;		/* Enable/disable double buffering (default: true) */
	gint gltexture_size;		/* Force the max width and height of one texture
	 			           segment (default: autosize)  */
	gboolean glforceblitmode;	/* Force blitter for true color modes 15/32bpp
					   (default: true) */
	gboolean glext78;		/* Force the usage of the gl extension #78, if
	 	    			   available (paletted texture, default: true) */
	gboolean glbilinear;		/* Enable/disable bilinear filtering (default:
					   true) */
	gboolean gldrawbitmap;		/* Enable/Disable the drawing of the bitmap - e.g. 
					   disable it within vector games for a speedup
					   (default: true) */
	gboolean gldrawbitmapvec;	/* Enable/Disable the drawing of the bitmap only
					   for vector games - speedup (default: true) */
	gboolean glcolormod;		/* Enable/Disable color modulation
					  (intensity,gamma) (default: true) */
	gfloat glbeam;			/* Set the beam size for vector games (default:
					   1.0) */
	gboolean glalphablending;	/* Enable/disable alphablending if available
	 				  (default: true) */
	gboolean glantialias;		/* Enable/disable antialiasing (default: true) */
	gboolean glantialiasvec;	/* Enable/disable vector antialiasing (default:
					   true)  */
	gchar gllibname[20];		/* Choose the dynamically loaded OpenGL Library
	 			           (default libGL.so) */
	gchar glulibname[20];		/* Choose the dynamically loaded GLU Library
	 			           (default libGLU.so)*/
	gboolean cabview;		/* Start/Don't start in cabinet view mode
	 			           (default: false) */
	gchar cabinet[20];		/* Specify which cabinet model to use (default:
	 			           glmamejau) */
	gboolean glres_flag;
	gchar glres[10];			/* Always scale games to XresxYres, keeping their
					   aspect ratio. This overrides the scale options */  

	/*** SDL Related ***/
	/* gboolean listmodes;		   List all posible full-screen modes */
	gboolean fullscreen;		/* Start fullscreen  */
	gboolean sdl_auto_mode;		/* use auto mode (no modenumber option) */
	gint modenumber;		/* Try to use the 'n' possible full-screen mode */
	gchar sdlmapkey[14];		/* Set a specific key mapping, see xmamerc.dist */
	
	/*** GGI Related ***/
	gboolean ggilinear;		/* Enable/disable use of linear framebuffer (fast) */
	gboolean ggi_force_resolution;
	guint xres;			/* Force the X resolution */
	guint yres;			/* Force the Y resolution */

	/*** Svgalib Related ***/
	gboolean tweak;			/* Enable/disable svgalib tweaked video modes */      
	gboolean planar;		/* Enable/disable use of planar (modeX) modes      
					   (slow) */					      
	gboolean linear;		/* Enable/disable use of linear framebuffer (fast)  */
	gint centerx;			/* Adjust the horizontal center of tweaked vga     
					   modes */					      
	gint centery;			/* Adjust the vertical center of tweaked vga modes */ 

	/*** FX (Glide) Related ***/
	gchar resolution[10];		/* Specify the resolution/ windowsize to use in    
					   the form of XRESxYRES */			      
	gboolean fxgkeepaspect;		/* Try / don't try to keep the aspect ratio of a   
					   game */

	/*** Photon Related ***/
	guint render_mode;		/* Select Photon rendering video mode:
						0 Normal window  (hotkey left-alt + insert)
						1 Fullscreen Video Overlay (hotkey left-alt + 
						home) */

	 /*** Photon-window Related ***/
	gboolean phcursor;		/* Show / don't show the cursor. */
	                 
	 /*** Photon-input Related ***/
	gboolean phgrabmouse;		/* Enable/disable mousegrabbing (also alt + 
					  pagedown) */
	gboolean phwinkeys;		/* Enable/disable mapping of windowskeys under 
					   Photon */
	gchar phmapkey[14];		/* Set a specific key mapping, see phmamerc.dist */
 
	
	 /*** Video Mode Selection Related ***/
	 /* (SVGA, xf86_dga_opts, GGI) */
	gboolean keepaspect;		/* Try / don't try to keep the aspect ratio of a
					   game when selecting the best videomode */
	gfloat displayaspectratio;	/* Set the display aspect ratio of your monitor.
					   This is used for -keepaspect The default = 1.33
					   (4/3). Use 0.75 (3/4) for a portrait monitor */
	gchar disablemode[15];		/*Don't use mode XRESxYRESxDEPTH this can be used
					   to disable specific video modes which don't
					   work on your system. The xDEPTH part of the
					   string is optional. This option may be used
					   more then once */

	/*** Sound Related ***/
	gboolean sound;			/* Enable/disable sound (if available) */
	gboolean samples;		/* Use/don't use samples (if available) */
	gboolean fakesound;		/* Generate sound even when sound is disabled,
					   this is needed for some games which won't run
					   without sound */
	gint samplefre;			/* Set the playback sample-frequency/rate */
	gfloat bufsize;			/* Number of frames of sound to buffer */
	gint volume;			/* Set volume to <int> db, (-32 (soft) - 0(loud) ) */
	gchar audiodevice[20];		/* Use an alternative audiodevice */
	gchar mixerdevice[20];		/* Use an alternative mixerdevice */
	gchar soundfile[20];		/* audiodevice for waveout plugin */

	/*** Input Related ***/
	guint joytype;			/* Select type of joystick support to use:	      
					   0 No joystick
					   1 i386 style joystick driver (if compiled in)
					   2 Fm Town Pad support (if compiled in)
					   3 X11 input extension joystick (if compiled in)
					   4 new i386 linux 1.x.x joystick driver(if
					   compiled in)
					   5 NetBSD USB joystick driver (if compiled in)
					   6 PS2-Linux native pad (if compiled in)
					   7 SDL  (for use with patch from Yang Hyun)*/
	gboolean analogstick;		/* Use Joystick as analog for analog controls */

	gchar keymap[4];		/* Select layout type of keymap (fr,de, ...) */

	gboolean mouse;			/* Enable/disable mouse (if supported) */
	gboolean hotrod;		/* Enable HotRod joystick support */
	gboolean hotrodse;		/* Select HotRod SE joystick support */
	gboolean usbpspad;		/* The Joystick(s) are USB PS Game Pads */
	gboolean rapidfire;		/* Enable rapid-fire support for joysticks */

	 /*i386*/
	gchar joydevname[20];		/* Joystick device prefix
					   (defaults to /dev/joy) for bsd
					   (defaults to /dev/js) for linux */

	 /***joy_pad_opts***  *FM townpad*/
	gchar paddevname[20];		/* Name of pad device (defaults to /dev/pad00) */
	 /***joy_x11_opts***/
	gchar x11joyname[20];		/* Name of X-based joystick device (if compiled in) */
	 /***Xinput***/
	gchar XInput_trackball1[20];	/* Device name for trackball of player 1 */
	gchar XInput_trackball2[20];	/* Device name for trackball of player 2 */
	gchar XInput_trackball3[20];	/* Device name for trackball of player 3 */
	gchar XInput_trackball4[20];	/* Device name for trackball of player 4 */
	/* gchar XInput_joystick1[20]; */      /* Device name for joystick of player 1 */
	/* gchar XInput_joystick2[20]; */      /* Device name for joystick of player 2 */
	/* gchar XInput_joystick3[20]; */      /* Device name for joystick of player 3 */
	/* gchar XInput_joystick4[20]; */      /* Device name for joystick of player 4 */
	gchar ctrlr[20];		/* Control Panel Name */

	/*** Network Related ***/
	guint network_flag;		/* 0:none, 1:master, 2:slave */
	guint master;			/* Enable master mode. Set number of players */
	gchar slave[20];		/* Enable slave mode. Set master hostname */
	gboolean netmapkey;		/* When enabled all players use the player 1 keys.
					   For use with *real* multiplayer games
					   Makes player 1 keys control whichever player number
					   you're actually assigned by the master (for slave only)*/
	gboolean parallelsync;		/* Perform network input sync in advance:  Causes ~
					   16 ms input delay but more suitable for relatively
					   slow machines */
	gboolean bind_flag;
	guint bind;			/* Specify a UDP port on which to accept messages */
	gboolean statedebug;		/* Check complete machine state against slaves at
					   each frame -- extremely slow, for debugging 
					   (for master only) */		
	/*** Digital sound related ***/
	gchar dsp_plugin[20];		/* Select which plugin to use for digital sound    
	list-dsp-plugins		   List available sound-dsp plugins */
	gboolean timer;			/* Use / don't use timer based audio (normally it
					   will be used automagically when nescesarry) */
	
	/*** Sound mixer related ***/
	gchar sound_mixer_plugin[20];	/* Select which plugin to use for the sound mixer
	list-mixer-plugins		   List available sound-mixer plugins */
	
	 /***arts***/
	gint artsBufferTime;		/* aRts buffer delay time */

	 /*** Alsa Sound System 0.5***/
	/* list-alsa-cards		   List available sound cards */
	guint alsacard;			/* select card # or card id (0-32) */
	guint alsadevice;		/* select device # */
	        	       
	        /*** Alsa Sound System 0.9***/
	/* list-alsa-cards		   List available sound cards
	list-alsa-pcm			   List available pcm devices */
	gchar alsa_pcm[20];		/* Specify the PCM by name */
	guint alsa_buffer;		/* Set the buffer size [micro sec] (default: 250000) */
	        	       
	        /*** QNX Audio related ***/
	gboolean audio_preferred;	/* Use the preferred device or use the primary
					   device. */

	       /*** Display  Related ***/
	gchar display_plugin[20];	/* Select which plugin to use for the display
	list-display-plugins		   available display plugins */
	gint dwidthscale;		/* Set X-Scale aspect ratio */
	gint dheightscale;		/* Set Y-Scale aspect ratio */
	gboolean dscanlines;		/* Emulate / don't emulates scanlines when scaling 
					   allong the Y axis */
	gfloat display_aspect_ratio;	/* Set the aspect ratio of your monitor, this is   
					   used for mode selection calculations. Usually   
					   this is 4/3 (1.33) in some cases this is 3/4    
					   (0.75) or even 16/9 (1.77) (0.5 - 2.0)*/
	gboolean keep_aspect;		/* Try / don't try to keep the correct aspect ratio
					   when selecting the best mode */
	
		/*** Misc ***/
	gboolean cheat;
	gboolean keyboard_leds;
	gboolean debug;
	gchar debug_size[10];
	gboolean log_flag;
	gchar log[20];
	gboolean cfgname_flag;
	gchar cfgname[20];		/* Set the config name in case you use several
					   control panels */
	gboolean use_additional_options;
	gchar *additional_options;
	
	gboolean skip_disclaimer;	/* Skip the disclaimer info */
	gboolean skip_gameinfo;		/* Skip the game info */
	
	guint bios;			/* Change system bios */
	gboolean ugcicoin;		/* Enable/disable UGCI(tm) Coin/Play support */	
	
} xmame_game_options;

typedef struct _simple_filter {
	folder_filters_list FolderID;
	Columns_type type;
	gboolean is;
	const gchar *value;
	gint int_value; /* should be a union with value */
	gboolean update_list;
} simple_filter;

struct _list_version {
	gchar *name;
	gchar *version;
};

/* global variables */
XmameExecutable *current_exec; /* pointer in the xmame_table */
struct _list_version list_ver;
guint supported_games, visible_games, supported_samples_games;
GList *roms;
GList *years;
GList *manufacturers;
GList *categories;
GList *versions;
GList *drivers;
simple_filter *current_filter;
gboolean displayedlist_keypressed;
JoyData *joydata;
GdkPixbuf *Status_Icons[NUMBER_STATUS];

GList *not_checked_list;
struct gui_prefs_struct gui_prefs;
xmame_game_options default_options;
xmame_game_options *game_options;

gboolean dirty_icon_cache;

gchar **ctrlr_array;
/* Column number that is used in the gamelist popup menu */
gint ColumnHide_selected;

/* Debug Functions */
void
column_debug (void);

/* Others Functions */
gboolean
game_filtered (RomEntry * rom);

gchar**
get_manufacturers (RomEntry * rom);

void
launch_emulation (RomEntry *rom, const gchar *options);

void
play_game (RomEntry *rom);

void
exit_gxmame (void);

gint
compare_game_name (RomEntry *Rom1, RomEntry *Rom2);

void
playback_game (GtkButton *button, gpointer user_data);

void
record_game (GtkButton *button, gpointer user_data);

/* Columns management functions */
void
update_columns_tab (void);

GList*
get_columns_shown_list (void);

GList*
get_columns_hidden_list (void);

const char *
column_title (int column_num);

#endif /* __GXMAME_H__ */
