/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "gxmame.h"
#include "gui.h"


GtkWidget*
create_MainWindow (void)
{
  GtkWidget *MainWindow;
  GtkWidget *vbox1;
  GtkWidget *menubar1;
/* guint tmp_key;*/
  GtkWidget *file_menu;
  GtkWidget *file_menu_menu;
  GtkWidget *play;
  GtkWidget *separator9;
  GtkWidget *play_and_record_input;
  GtkWidget *playback_input;
  GtkWidget *separator3;
  GtkWidget *add_to_favorites;
  GtkWidget *remove_from_favorites;
  GtkWidget *separator2;
  GtkWidget *select_random_game;
  GtkWidget *separator14;
  GtkWidget *properties;
  GtkWidget *separator7;
  GtkWidget *audit_all_games;
  GtkWidget *separator8;
  GtkWidget *exit;
  GtkWidget *view_menu;
  GtkWidget *view_menu_menu;
  GtkWidget *toolbar_view_menu;
  GtkWidget *status_bar_view_menu;
  GtkWidget *folder_list;
  GtkWidget *screen_shot;
  GtkWidget *screen_shot_tab;
  GtkWidget *separator4;
  GSList *ViewMode_group = NULL;
/*  GtkWidget *large_icons_view_menu; */
/*  GtkWidget *small_icons_view_menu; */
  GtkWidget *list_view_menu;
  GtkWidget *list_tree_view_menu;
  GtkWidget *details_view_menu;
  GtkWidget *details_tree_view_menu;
  GtkWidget *separator13;
  GtkWidget *expand;
  GtkWidget *collapse;
  GtkWidget *separator5;
  GtkWidget *column_layout;
  GtkWidget *separator12;
  GtkWidget *the_prefix;
  GtkWidget *separator11;
  GtkWidget *refresh;
  GtkWidget *option_menu;
  GtkWidget *option_menu_menu;
  GtkWidget *clone_color_menu;
  GtkWidget *game_list_font;
  GtkWidget *rebuild_game_list_menu;
  GtkWidget *separator6;
  GtkWidget *directories_menu;
  GtkWidget *default_option_menu;
  GtkWidget *startup_option;
  GtkWidget *separator10;
  GtkWidget *executable_title;
  GtkWidget *help_menu;
  GtkWidget *help_menu_menu;
  GtkWidget *aboutMenu;
  GtkWidget *hseparator2;
  GtkWidget *toolbar1;
  GtkWidget *hseparator1;
  GtkWidget *hpanedLeft;
  GtkWidget *scrolledwindowFilters;
  GtkWidget *hpanedRight;
  GtkWidget *scrolledwindowGames;
  GtkWidget *ScreenShot_hist_frame;
  GtkWidget *ScreenShot_hist_vbox;
  GtkWidget *tri_status_bar;
  GtkWidget *statusbar1;
  GtkWidget *statusbar2;
  GtkWidget *statusbar3;
  GtkWidget *combo_progress_bar;
  GtkWidget *status_progress_bar;
  GtkWidget *progress_progress_bar;
  GtkAccelGroup *accel_group;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  accel_group = gtk_accel_group_new ();

  MainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  g_object_set_data (G_OBJECT (MainWindow), "MainWindow", MainWindow);
  gtk_window_set_title (GTK_WINDOW (MainWindow), _("GXMame"));
  gtk_window_set_default_size (GTK_WINDOW (MainWindow), 640, 400);

  vbox1 = gtk_vbox_new (FALSE, 1);
  gtk_widget_ref (vbox1);
  g_object_set_data_full (G_OBJECT (MainWindow), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (MainWindow), vbox1);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_ref (menubar1);
  g_object_set_data_full (G_OBJECT (MainWindow), "menubar1", menubar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox1), menubar1, FALSE, FALSE, 0);

  file_menu = gtk_menu_item_new_with_mnemonic (_("_File"));
  gtk_widget_ref (file_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "file_menu", file_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (file_menu);
  gtk_container_add (GTK_CONTAINER (menubar1), file_menu);
  gtk_tooltips_set_tip (tooltips, file_menu, _("Contains commands for working with the selected item"), NULL);

  file_menu_menu = gtk_menu_new ();
  gtk_widget_ref (file_menu_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "file_menu_menu", file_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file_menu), file_menu_menu);

  /* Play menu item */
  play = gtk_menu_item_new_with_mnemonic (_("_Play"));
  gtk_widget_ref (play);
  g_object_set_data_full (G_OBJECT (MainWindow), "play", play,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (play);
  main_gui.play_menu = GTK_MENU_ITEM(play);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), play);
  gtk_tooltips_set_tip (tooltips, play, _("Play currently selected game"), NULL);
  gtk_widget_add_accelerator (play, "activate", accel_group,
                              GDK_Return, 0,
                              GTK_ACCEL_VISIBLE);

  separator9 = gtk_menu_item_new ();
  gtk_widget_ref (separator9);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator9", separator9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator9);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator9);
  gtk_widget_set_sensitive (separator9, FALSE);

  play_and_record_input = gtk_image_menu_item_new_from_stock(GTK_STOCK_SAVE, accel_group);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (play_and_record_input)->child), _("Play and _Record Input..."));

  gtk_widget_ref (play_and_record_input);
  g_object_set_data_full (G_OBJECT (MainWindow), "play_and_record_input", play_and_record_input,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (play_and_record_input);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), play_and_record_input);
  gtk_tooltips_set_tip (tooltips, play_and_record_input, _("Record a game for later playback"), NULL);

  playback_input = gtk_image_menu_item_new_from_stock(GTK_STOCK_OPEN, accel_group);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (playback_input)->child), _("P_layback Input..."));

  gtk_widget_ref (playback_input);
  g_object_set_data_full (G_OBJECT (MainWindow), "playback_input", playback_input,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (playback_input);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), playback_input);
  gtk_tooltips_set_tip (tooltips, playback_input, _("Playback a recorded game"), NULL);

  separator3 = gtk_menu_item_new ();
  gtk_widget_ref (separator3);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator3", separator3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator3);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator3);
  gtk_widget_set_sensitive (separator3, FALSE);

  /* Add to favorites menu item */
  add_to_favorites = gtk_image_menu_item_new_from_stock(GTK_STOCK_ADD, NULL);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (add_to_favorites)->child), _("A_dd to 'Favorites'"));

  gtk_widget_ref (add_to_favorites);
  g_object_set_data_full (G_OBJECT (MainWindow), "add_to_favorites", add_to_favorites,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (add_to_favorites);
  main_gui.add_to_favorites = GTK_MENU_ITEM(add_to_favorites);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), add_to_favorites);
  gtk_tooltips_set_tip (tooltips, add_to_favorites, _("Add this game to your 'Favorites' game folder"), NULL);

  /* Remove from favorites menu item */
  remove_from_favorites = gtk_image_menu_item_new_from_stock(GTK_STOCK_REMOVE, NULL);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (remove_from_favorites)->child), _("R_emove from 'Favorites'"));

  gtk_widget_ref (remove_from_favorites);
  g_object_set_data_full (G_OBJECT (MainWindow), "remove_from_favorites", remove_from_favorites,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (remove_from_favorites);
  main_gui.remove_from_favorites = GTK_MENU_ITEM(remove_from_favorites);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), remove_from_favorites);
  gtk_tooltips_set_tip (tooltips, remove_from_favorites, _("Remove this game from your 'Favorites' game folder"), NULL);

  separator2 = gtk_menu_item_new ();
  gtk_widget_ref (separator2);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator2", separator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator2);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator2);
  gtk_widget_set_sensitive (separator2, FALSE);

  select_random_game = gtk_menu_item_new_with_mnemonic (_("_Select Random Game"));
  gtk_widget_ref (select_random_game);
  g_object_set_data_full (G_OBJECT (MainWindow), "select_random_game", select_random_game,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (select_random_game);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), select_random_game);
  gtk_tooltips_set_tip (tooltips, select_random_game, _("Randomly select a game"), NULL);

  separator14 = gtk_menu_item_new ();
  gtk_widget_ref (separator14);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator14", separator14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator14);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator14);
  gtk_widget_set_sensitive (separator14, FALSE);

  /* Properties Menu Item */
  /*properties = gtk_menu_item_new_with_mnemonic (_("Pr_operties"));*/
  properties = gtk_image_menu_item_new_from_stock(GTK_STOCK_PROPERTIES, accel_group);
  gtk_widget_ref (properties);
  g_object_set_data_full (G_OBJECT (MainWindow), "properties", properties,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (properties);
  main_gui.properties_menu = GTK_MENU_ITEM(properties);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), properties);
  gtk_tooltips_set_tip (tooltips, properties, _("Display the properties of the selected game"), NULL);

  separator7 = gtk_menu_item_new ();
  gtk_widget_ref (separator7);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator7", separator7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator7);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator7);
  gtk_widget_set_sensitive (separator7, FALSE);

  /* Audit all games menu item */
  audit_all_games = gtk_menu_item_new_with_mnemonic (_("_Audit All Games"));
  gtk_widget_ref (audit_all_games);
  g_object_set_data_full (G_OBJECT (MainWindow), "audit_all_games", audit_all_games,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (audit_all_games);
  main_gui.audit_all_games_menu = GTK_MENU_ITEM(audit_all_games);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), audit_all_games);
  gtk_tooltips_set_tip (tooltips, audit_all_games, _("Audit ROM and samples sets"), NULL);

  separator8 = gtk_menu_item_new ();
  gtk_widget_ref (separator8);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator8", separator8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator8);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), separator8);
  gtk_widget_set_sensitive (separator8, FALSE);

  exit = gtk_image_menu_item_new_from_stock(GTK_STOCK_QUIT, accel_group);
  /*exit = gtk_menu_item_new_with_mnemonic (_("E_xit"));*/
  gtk_widget_ref (exit);
  g_object_set_data_full (G_OBJECT (MainWindow), "exit", exit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (exit);
  gtk_container_add (GTK_CONTAINER (file_menu_menu), exit);
  gtk_tooltips_set_tip (tooltips, exit, _("Exit the application"), NULL);

  view_menu = gtk_menu_item_new_with_mnemonic (_("_View"));
  gtk_widget_ref (view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "view_menu", view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (view_menu);
  gtk_container_add (GTK_CONTAINER (menubar1), view_menu);
  gtk_tooltips_set_tip (tooltips, view_menu, _("Contains commands for manipulating the view"), NULL);

  view_menu_menu = gtk_menu_new ();
  gtk_widget_ref (view_menu_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "view_menu_menu", view_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (view_menu), view_menu_menu);


  toolbar_view_menu = gtk_check_menu_item_new_with_mnemonic (_("_Toolbar"));
  gtk_widget_ref (toolbar_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "toolbar_view_menu", toolbar_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar_view_menu);
  main_gui.toolbar_view_menu = GTK_CHECK_MENU_ITEM(toolbar_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), toolbar_view_menu);
  gtk_tooltips_set_tip (tooltips, toolbar_view_menu, _("Show or hide the toolbar"), NULL);
  gtk_widget_add_accelerator (toolbar_view_menu, "activate", accel_group,
                              GDK_T, GDK_MOD1_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (toolbar_view_menu), TRUE);


  status_bar_view_menu = gtk_check_menu_item_new_with_mnemonic (_("_Status Bar"));
  gtk_widget_ref (status_bar_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "status_bar_view_menu", status_bar_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (status_bar_view_menu);
  main_gui.status_bar_view_menu = GTK_CHECK_MENU_ITEM(status_bar_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), status_bar_view_menu);
  gtk_tooltips_set_tip (tooltips, status_bar_view_menu, _("Show or hide the status bar"), NULL);
  gtk_widget_add_accelerator (status_bar_view_menu, "activate", accel_group,
                              GDK_S, GDK_MOD1_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (status_bar_view_menu), TRUE);


  /* Folder List */
  folder_list = gtk_check_menu_item_new_with_mnemonic (_("Fold_er List"));
  gtk_widget_ref (folder_list);
  g_object_set_data_full (G_OBJECT (MainWindow), "folder_list", folder_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (folder_list);
  main_gui.folder_list_menu = GTK_CHECK_MENU_ITEM(folder_list);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), folder_list);
  gtk_tooltips_set_tip (tooltips, folder_list, _("Show or hide the folder list"), NULL);
  gtk_widget_add_accelerator (folder_list, "activate", accel_group,
                              GDK_D, GDK_MOD1_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (folder_list), TRUE);


  screen_shot = gtk_check_menu_item_new_with_mnemonic (_("Scree_nshot Panel"));
  gtk_widget_ref (screen_shot);
  g_object_set_data_full (G_OBJECT (MainWindow), "screen_shot", screen_shot,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (screen_shot);
  main_gui.screen_shot_menu = GTK_CHECK_MENU_ITEM(screen_shot);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), screen_shot);
  gtk_tooltips_set_tip (tooltips, screen_shot, _("Show or hide the screenshot panel"), NULL);
  gtk_widget_add_accelerator (screen_shot, "activate", accel_group,
                              GDK_N, GDK_MOD1_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (screen_shot), TRUE);


  screen_shot_tab = gtk_check_menu_item_new_with_mnemonic (_("Scree_nshot Panel Tab"));
  gtk_widget_ref (screen_shot_tab);
  g_object_set_data_full (G_OBJECT (MainWindow), "screen_shot_tab", screen_shot_tab,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (screen_shot_tab);
  main_gui.screen_shot_tab_menu = GTK_CHECK_MENU_ITEM(screen_shot_tab);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), screen_shot_tab);
  gtk_tooltips_set_tip (tooltips, screen_shot_tab, _("Show or hide the screenshot panel tabulation"), NULL);
  gtk_widget_add_accelerator (screen_shot_tab, "activate", accel_group,
                              GDK_O, GDK_MOD1_MASK,
                              GTK_ACCEL_VISIBLE);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (screen_shot_tab), TRUE);


  separator4 = gtk_menu_item_new ();
  gtk_widget_ref (separator4);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator4", separator4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator4);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), separator4);
  gtk_widget_set_sensitive (separator4, FALSE);

  /* List */
  list_view_menu = gtk_radio_menu_item_new_with_mnemonic (ViewMode_group, _("_List"));
  ViewMode_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (list_view_menu));
  gtk_widget_ref (list_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "list_view_menu", list_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list_view_menu);
  main_gui.list_view_menu = GTK_CHECK_MENU_ITEM(list_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), list_view_menu);
  gtk_tooltips_set_tip (tooltips, list_view_menu, _("Displays items in a list."), NULL);

  /* List Tree */
  list_tree_view_menu = gtk_radio_menu_item_new_with_mnemonic(ViewMode_group, _("List _Tree"));
  ViewMode_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (list_tree_view_menu));
  gtk_widget_ref (list_tree_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "list_tree_view_menu", list_tree_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (list_tree_view_menu);
  main_gui.list_tree_view_menu = GTK_CHECK_MENU_ITEM(list_tree_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), list_tree_view_menu);
  gtk_tooltips_set_tip (tooltips, list_tree_view_menu, _("Displays items in a tree list with clones indented."), NULL);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (list_tree_view_menu), TRUE);


  /* Details */
  details_view_menu = gtk_radio_menu_item_new_with_mnemonic (ViewMode_group, _("_Details"));
  ViewMode_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (details_view_menu));
  gtk_widget_ref (details_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "details_view_menu", details_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_view_menu);
  main_gui.details_view_menu = GTK_CHECK_MENU_ITEM(details_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), details_view_menu);
  gtk_tooltips_set_tip (tooltips, details_view_menu, _("Displays detailed information about each item."), NULL);

  /* Details Tree */
  details_tree_view_menu = gtk_radio_menu_item_new_with_mnemonic (ViewMode_group, _("Detai_ls Tree"));
  ViewMode_group = gtk_radio_menu_item_get_group (GTK_RADIO_MENU_ITEM (details_tree_view_menu));
  gtk_widget_ref (details_tree_view_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "details_tree_view_menu", details_tree_view_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (details_tree_view_menu);
  main_gui.details_tree_view_menu = GTK_CHECK_MENU_ITEM(details_tree_view_menu);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), details_tree_view_menu);
  gtk_tooltips_set_tip (tooltips, details_tree_view_menu, _("Displays detailed information about each item with clones indented."), NULL);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (details_tree_view_menu), TRUE);

  separator13 = gtk_menu_item_new ();
  gtk_widget_ref (separator13);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator13", separator13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator13);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), separator13);
  gtk_widget_set_sensitive (separator13, FALSE);

  expand = gtk_menu_item_new_with_mnemonic (_("Expand All"));
  gtk_widget_ref (expand);
  g_object_set_data_full (G_OBJECT (MainWindow), "expand", expand,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (expand);
  main_gui.expand_all_menu = GTK_MENU_ITEM(expand);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), expand);
  gtk_tooltips_set_tip (tooltips, expand, _("Expand all rows"), NULL);

  collapse = gtk_menu_item_new_with_mnemonic (_("Collapse All"));
  gtk_widget_ref (collapse);
  g_object_set_data_full (G_OBJECT (MainWindow), "collapse", collapse,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (collapse);
  main_gui.collapse_all_menu = GTK_MENU_ITEM(collapse);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), collapse);
  gtk_tooltips_set_tip (tooltips, collapse, _("Collapse all rows"), NULL);

  separator5 = gtk_menu_item_new ();
  gtk_widget_ref (separator5);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator5", separator5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator5);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), separator5);
  gtk_widget_set_sensitive (separator5, FALSE);

  column_layout = gtk_menu_item_new_with_mnemonic (_("_Column Layout..."));
  gtk_widget_ref (column_layout);
  g_object_set_data_full (G_OBJECT (MainWindow), "column_layout", column_layout,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (column_layout);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), column_layout);
  gtk_tooltips_set_tip (tooltips, column_layout, _("Set column layout"), NULL);

  separator12 = gtk_menu_item_new ();
  gtk_widget_ref (separator12);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator12", separator12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator12);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), separator12);
  gtk_widget_set_sensitive (separator12, FALSE);

  the_prefix = gtk_check_menu_item_new_with_mnemonic (_("The _Prefix"));
  gtk_widget_ref (the_prefix);
  g_object_set_data_full (G_OBJECT (MainWindow), "the_prefix", the_prefix,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (the_prefix);
  main_gui.modify_the_menu = GTK_CHECK_MENU_ITEM(the_prefix);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), the_prefix);
  gtk_tooltips_set_tip (tooltips, the_prefix, _("Show \"The\" at the end."), NULL);
  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (the_prefix), TRUE);


  separator11 = gtk_menu_item_new ();
  gtk_widget_ref (separator11);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator11", separator11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator11);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), separator11);
  gtk_widget_set_sensitive (separator11, FALSE);

  refresh = gtk_image_menu_item_new_from_stock(GTK_STOCK_REFRESH, NULL);
  gtk_widget_ref (refresh);
  g_object_set_data_full (G_OBJECT (MainWindow), "refresh", refresh,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (refresh);
  main_gui.refresh_menu = GTK_MENU_ITEM(refresh);
  gtk_container_add (GTK_CONTAINER (view_menu_menu), refresh);
  gtk_tooltips_set_tip (tooltips, refresh, _("Refresh game list"), NULL);
  gtk_widget_add_accelerator (refresh, "activate", accel_group,
                              GDK_F5, 0,
                              GTK_ACCEL_VISIBLE);

  option_menu = gtk_menu_item_new_with_mnemonic (_("_Option"));
  gtk_widget_ref (option_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "option_menu", option_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (option_menu);
  gtk_container_add (GTK_CONTAINER (menubar1), option_menu);
  gtk_tooltips_set_tip (tooltips, option_menu, _("Contains commands for user interface options"), NULL);

  option_menu_menu = gtk_menu_new ();
  gtk_widget_ref (option_menu_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "option_menu_menu", option_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (option_menu), option_menu_menu);


  clone_color_menu = gtk_image_menu_item_new_from_stock(GTK_STOCK_SELECT_COLOR, accel_group);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (clone_color_menu)->child), _("Clone _Color..."));
  gtk_widget_ref (clone_color_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "clone_color_menu", clone_color_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (clone_color_menu);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), clone_color_menu);
  gtk_tooltips_set_tip (tooltips, clone_color_menu, _("Set clones color in gamelist"), NULL);

  game_list_font = gtk_image_menu_item_new_from_stock(GTK_STOCK_SELECT_FONT, accel_group);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (game_list_font)->child), _("Game List _Font..."));
  gtk_widget_ref (game_list_font);
  g_object_set_data_full (G_OBJECT (MainWindow), "game_list_font", game_list_font,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (game_list_font);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), game_list_font);
  gtk_tooltips_set_tip (tooltips, game_list_font, _("Set game list and folder font"), NULL);

  rebuild_game_list_menu = gtk_menu_item_new_with_mnemonic (_("_Rebuild Game List"));
  gtk_widget_ref (rebuild_game_list_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "rebuild_game_list_menu", rebuild_game_list_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rebuild_game_list_menu);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), rebuild_game_list_menu);
  gtk_tooltips_set_tip (tooltips, rebuild_game_list_menu, _("Rebuild the game list from executable information"), NULL);

  separator6 = gtk_menu_item_new ();
  gtk_widget_ref (separator6);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator6", separator6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator6);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), separator6);
  gtk_widget_set_sensitive (separator6, FALSE);

  directories_menu = gtk_menu_item_new_with_mnemonic (_("_Directories..."));
  gtk_widget_ref (directories_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "directories_menu", directories_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (directories_menu);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), directories_menu);
  gtk_tooltips_set_tip (tooltips, directories_menu, _("Set directory configuration"), NULL);

  default_option_menu = gtk_menu_item_new_with_mnemonic (_("Default _Option..."));
  gtk_widget_ref (default_option_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "default_option_menu", default_option_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (default_option_menu);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), default_option_menu);
  gtk_tooltips_set_tip (tooltips, default_option_menu, _("Set default game options"), NULL);

  startup_option = gtk_image_menu_item_new_from_stock(GTK_STOCK_PREFERENCES, accel_group);
  gtk_label_set_text_with_mnemonic (GTK_LABEL (GTK_BIN (startup_option)->child), _("_Startup Option..."));
  gtk_widget_ref (startup_option);
  g_object_set_data_full (G_OBJECT (MainWindow), "startup_option", startup_option,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (startup_option);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), startup_option);
  gtk_tooltips_set_tip (tooltips, startup_option, _("Set startup options"), NULL);

  separator10 = gtk_menu_item_new ();
  gtk_widget_ref (separator10);
  g_object_set_data_full (G_OBJECT (MainWindow), "separator10", separator10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (separator10);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), separator10);
  gtk_widget_set_sensitive (separator10, FALSE);

  executable_title = gtk_menu_item_new_with_mnemonic (_("_Executable"));
  gtk_widget_ref (executable_title);
  g_object_set_data_full (G_OBJECT (MainWindow), "executable_title", executable_title,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (executable_title);
  main_gui.executables_title = GTK_MENU_ITEM(executable_title);
  gtk_container_add (GTK_CONTAINER (option_menu_menu), executable_title);

  help_menu = gtk_menu_item_new_with_mnemonic (_("_Help"));
  gtk_widget_ref (help_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "help_menu", help_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_menu);
  gtk_container_add (GTK_CONTAINER (menubar1), help_menu);
  gtk_tooltips_set_tip (tooltips, help_menu, _("Contains commands for displaying help"), NULL);

  help_menu_menu = gtk_menu_new ();
  gtk_widget_ref (help_menu_menu);
  g_object_set_data_full (G_OBJECT (MainWindow), "help_menu_menu", help_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help_menu), help_menu_menu);

  aboutMenu = gtk_menu_item_new_with_mnemonic (_("_About..."));
  gtk_widget_ref (aboutMenu);
  g_object_set_data_full (G_OBJECT (MainWindow), "aboutMenu", aboutMenu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (aboutMenu);
  gtk_container_add (GTK_CONTAINER (help_menu_menu), aboutMenu);
  gtk_tooltips_set_tip (tooltips, aboutMenu, _("Displays program and Copyright information"), NULL);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  g_object_set_data_full (G_OBJECT (MainWindow), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  main_gui.hseparator2 = hseparator2;
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator2, FALSE, TRUE, 0);

  toolbar1 = gtk_toolbar_new ();
  gtk_toolbar_set_orientation (GTK_TOOLBAR (toolbar1),GTK_ORIENTATION_HORIZONTAL);
  gtk_toolbar_set_style (GTK_TOOLBAR (toolbar1),GTK_TOOLBAR_ICONS);
  gtk_widget_ref (toolbar1);
  g_object_set_data_full (G_OBJECT (MainWindow), "toolbar1", toolbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar1);
  main_gui.toolbar = GTK_TOOLBAR(toolbar1);
  gtk_box_pack_start (GTK_BOX (vbox1), toolbar1, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator1);
  g_object_set_data_full (G_OBJECT (MainWindow), "hseparator1", hseparator1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator1);
  main_gui.hseparator1 = hseparator1;
  gtk_box_pack_start (GTK_BOX (vbox1), hseparator1, FALSE, TRUE, 0);

  hpanedLeft = gtk_hpaned_new ();
  gtk_widget_ref (hpanedLeft);
  g_object_set_data_full (G_OBJECT (MainWindow), "hpanedLeft", hpanedLeft,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpanedLeft);
  main_gui.hpanedLeft = GTK_PANED(hpanedLeft);
  gtk_box_pack_start (GTK_BOX (vbox1), hpanedLeft, TRUE, TRUE, 0);
  gtk_paned_set_position (GTK_PANED (hpanedLeft), 150);
  scrolledwindowFilters = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindowFilters);
  g_object_set_data_full (G_OBJECT (MainWindow), "scrolledwindowFilters", scrolledwindowFilters,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindowFilters);
  main_gui.scrolled_window_filters = scrolledwindowFilters;
  gtk_paned_pack1 (GTK_PANED (hpanedLeft), scrolledwindowFilters, FALSE, FALSE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindowFilters), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  hpanedRight = gtk_hpaned_new ();
  gtk_widget_ref (hpanedRight);
  g_object_set_data_full (G_OBJECT (MainWindow), "hpanedRight", hpanedRight,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpanedRight);
  main_gui.hpanedRight = GTK_PANED(hpanedRight);
  gtk_paned_pack2 (GTK_PANED (hpanedLeft), hpanedRight, TRUE, FALSE);
  gtk_paned_set_position (GTK_PANED (hpanedRight), 300);

  scrolledwindowGames = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindowGames);
  g_object_set_data_full (G_OBJECT (MainWindow), "scrolledwindowGames", scrolledwindowGames,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindowGames);
  main_gui.scrolled_window_games = scrolledwindowGames;
  gtk_paned_pack1 (GTK_PANED (hpanedRight), scrolledwindowGames, TRUE, TRUE);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindowGames), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  ScreenShot_hist_frame = gtk_frame_new (NULL);
  gtk_widget_ref (ScreenShot_hist_frame);
  g_object_set_data_full (G_OBJECT (MainWindow), "ScreenShot_hist_frame", ScreenShot_hist_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ScreenShot_hist_frame);
  main_gui.screenshot_hist_frame = GTK_FRAME(ScreenShot_hist_frame);
  gtk_paned_pack2 (GTK_PANED (hpanedRight), ScreenShot_hist_frame, FALSE, FALSE);

  ScreenShot_hist_vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_ref (ScreenShot_hist_vbox);
  g_object_set_data_full (G_OBJECT (MainWindow), "ScreenShot_hist_vbox", ScreenShot_hist_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (ScreenShot_hist_vbox);
  main_gui.screenshot_hist_vbox = GTK_BOX(ScreenShot_hist_vbox);
  gtk_container_add (GTK_CONTAINER (ScreenShot_hist_frame), ScreenShot_hist_vbox);
  gtk_container_set_border_width (GTK_CONTAINER (ScreenShot_hist_vbox), 5);

  tri_status_bar = gtk_hbox_new (FALSE, 2);
  gtk_widget_ref (tri_status_bar);
  g_object_set_data_full (G_OBJECT (MainWindow), "tri_status_bar", tri_status_bar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (tri_status_bar);
  main_gui.tri_status_bar = tri_status_bar;
  gtk_box_pack_start (GTK_BOX (vbox1), tri_status_bar, FALSE, FALSE, 0);

  statusbar1 = gtk_statusbar_new ();
  gtk_widget_ref (statusbar1);
  g_object_set_data_full (G_OBJECT (MainWindow), "statusbar1", statusbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (statusbar1);
  main_gui.statusbar1 = GTK_STATUSBAR(statusbar1);
  gtk_box_pack_start (GTK_BOX (tri_status_bar), statusbar1, TRUE, TRUE, 0);

  statusbar2 = gtk_statusbar_new ();
  gtk_widget_ref (statusbar2);
  g_object_set_data_full (G_OBJECT (MainWindow), "statusbar2", statusbar2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (statusbar2);
  main_gui.statusbar2 = GTK_STATUSBAR(statusbar2);
  gtk_box_pack_start (GTK_BOX (tri_status_bar), statusbar2, FALSE, FALSE, 0);
  gtk_widget_set_size_request (statusbar2, 100, -1);

  statusbar3 = gtk_statusbar_new ();
  gtk_widget_ref (statusbar3);
  g_object_set_data_full (G_OBJECT (MainWindow), "statusbar3", statusbar3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (statusbar3);
  main_gui.statusbar3 = GTK_STATUSBAR(statusbar3);
  gtk_box_pack_end (GTK_BOX (tri_status_bar), statusbar3, FALSE, FALSE, 0);
  gtk_widget_set_size_request (statusbar3, 100, -1);

  combo_progress_bar = gtk_hbox_new (FALSE, 2);
  gtk_widget_ref (combo_progress_bar);
  g_object_set_data_full (G_OBJECT (MainWindow), "combo_progress_bar", combo_progress_bar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_progress_bar);
  main_gui.combo_progress_bar = combo_progress_bar;
  gtk_box_pack_start (GTK_BOX (vbox1), combo_progress_bar, FALSE, FALSE, 0);

  status_progress_bar = gtk_statusbar_new ();
  gtk_widget_ref (status_progress_bar);
  g_object_set_data_full (G_OBJECT (MainWindow), "status_progress_bar", status_progress_bar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (status_progress_bar);
  main_gui.status_progress_bar = GTK_STATUSBAR(status_progress_bar);
  gtk_box_pack_start (GTK_BOX (combo_progress_bar), status_progress_bar, TRUE, TRUE, 0);

  progress_progress_bar = gtk_progress_bar_new ();
  gtk_widget_ref (progress_progress_bar);
  g_object_set_data_full (G_OBJECT (MainWindow), "progress_progress_bar", progress_progress_bar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (progress_progress_bar);
  main_gui.progress_progress_bar = GTK_PROGRESS_BAR(progress_progress_bar);
  gtk_box_pack_end (GTK_BOX (combo_progress_bar), progress_progress_bar, TRUE, TRUE, 0);

  g_signal_connect (G_OBJECT (MainWindow), "delete_event",
                      G_CALLBACK (on_MainWindow_delete_event),
                      NULL);
  g_signal_connect (G_OBJECT (play), "activate",
                      G_CALLBACK (on_play_activate),
                      NULL);
  g_signal_connect (G_OBJECT (play_and_record_input), "activate",
                      G_CALLBACK (on_play_and_record_input_activate),
                      NULL);
  g_signal_connect (G_OBJECT (playback_input), "activate",
                      G_CALLBACK (on_playback_input_activate),
                      NULL);
  g_signal_connect (G_OBJECT (select_random_game), "activate",
                      G_CALLBACK (on_select_random_game_activate),
                      NULL);
  g_signal_connect (G_OBJECT (add_to_favorites), "activate",
                      G_CALLBACK (on_add_to_favorites_activate),
                      NULL);
  g_signal_connect (G_OBJECT (remove_from_favorites), "activate",
                      G_CALLBACK (on_remove_from_favorites_activate),
                      NULL);
  g_signal_connect (G_OBJECT (properties), "activate",
                      G_CALLBACK (on_properties_activate),
                      NULL);
  g_signal_connect (G_OBJECT (audit_all_games), "activate",
                      G_CALLBACK (on_audit_all_games_activate),
                      NULL);
  g_signal_connect (G_OBJECT (exit), "activate",
                      G_CALLBACK (on_exit_activate),
                      NULL);
  g_signal_connect (G_OBJECT (toolbar_view_menu), "activate",
                      G_CALLBACK (on_toolbar_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (status_bar_view_menu), "activate",
                      G_CALLBACK (on_status_bar_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (folder_list), "activate",
                      G_CALLBACK (on_folder_list_activate),
                      NULL);
  g_signal_connect (G_OBJECT (screen_shot), "activate",
                      G_CALLBACK (on_screen_shot_activate),
                      NULL);
  g_signal_connect (G_OBJECT (screen_shot_tab), "activate",
                      G_CALLBACK (on_screen_shot_tab_activate),
                      NULL);
  g_signal_connect (G_OBJECT (list_view_menu), "activate",
                      G_CALLBACK (on_list_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (list_tree_view_menu), "activate",
                      G_CALLBACK (on_list_tree_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (details_view_menu), "activate",
                      G_CALLBACK (on_details_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (details_tree_view_menu), "activate",
                      G_CALLBACK (on_details_tree_view_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (expand), "activate",
                      G_CALLBACK (on_expand_all_activate),
                      NULL);
  g_signal_connect (G_OBJECT (collapse), "activate",
                      G_CALLBACK (on_collapse_all_activate),
                      NULL);
  g_signal_connect (G_OBJECT (column_layout), "activate",
                      G_CALLBACK (on_column_layout_activate),
                      NULL);
  g_signal_connect (G_OBJECT (the_prefix), "activate",
                      G_CALLBACK (on_the_prefix_activate),
                      NULL);
  g_signal_connect (G_OBJECT (refresh), "activate",
                      G_CALLBACK (on_refresh_activate),
                      NULL);
  g_signal_connect (G_OBJECT (clone_color_menu), "activate",
                      G_CALLBACK (on_clone_color_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (game_list_font), "activate",
                      G_CALLBACK (on_game_list_font_activate),
                      NULL);
  g_signal_connect (G_OBJECT (rebuild_game_list_menu), "activate",
                      G_CALLBACK (on_rebuild_game_list_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (directories_menu), "activate",
                      G_CALLBACK (on_directories_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (default_option_menu), "activate",
                      G_CALLBACK (on_default_option_menu_activate),
                      NULL);
  g_signal_connect (G_OBJECT (startup_option), "activate",
                      G_CALLBACK (on_startup_option_activate),
                      NULL);
  g_signal_connect (G_OBJECT (aboutMenu), "activate",
                      G_CALLBACK (on_about_activate),
                      NULL);

  g_object_set_data (G_OBJECT (MainWindow), "tooltips", tooltips);

  gtk_window_add_accel_group (GTK_WINDOW (MainWindow), accel_group);

  return MainWindow;
}

