/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __IO_H__
#define __IO_H__

#include <gtk/gtk.h>
#include "gxmame.h"

/* Separator for game list fields.
* This avoids problems when source
* files are saved in different encodings.
*/
#define SEP "\xAC"

#define FLOAT_BUF_SIZE G_ASCII_DTOSTR_BUF_SIZE
const gchar *
my_dtostr(char* buf, gdouble d);

void
free_rom_entry(gpointer *rom_entry);

gboolean
load_games_list(void);

gboolean
load_games_ini(void);

gboolean
load_gxmame_ini(void);

gboolean
load_dirs_ini(void);

gboolean
load_catver_ini(void);

gboolean
load_gxmamerc(void);

void
quick_check(void);

gboolean
save_games_ini(void);

gboolean
save_gxmame_ini(void);

gboolean
save_dirs_ini(void);

gboolean
save_gxmamerc(void);

gboolean
load_options(RomEntry *rom);

gboolean
save_options(RomEntry *rom);

GList *
get_ctrlr_list (void);

#endif /* __IO_H__ */
