/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "gxmame.h"
#include "mameio.h"
#include "progression_window.h"
#include "io.h"
#include "gui.h"
#include "options.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <ctype.h>
#define BUFFER_SIZE 1000

gboolean create_game_list_file(void)
{
	FILE *xmame_pipe=NULL;
	FILE *gamelistfile=NULL;
	gchar *filename;
	gchar line[BUFFER_SIZE];

	gchar *romname;
	gchar *gamename;
	gchar *gamenameext;
	gchar *year;
	gchar *manu;
	gchar *cloneof;
	gchar *romof;
	gchar *sampleof;
	gchar *input;
	gchar *video;
	gchar *channels;
	gchar *chip[16];
	gchar *driver_status;
	gchar *control;
	gchar *cpu[NB_CPU];
	gchar *cpu_clock[NB_CPU];
	gchar *sound[NB_CPU];
	gchar *sound_clock[NB_CPU];
	gchar *num_players;
	gchar *num_buttons;
	gint nb_roms;
	gint nb_samples;
	gboolean the_trailer;
	
	gchar *driver = NULL;
	gchar *status = NULL;

	gchar *p = NULL, *p2 = NULL;
	gchar *keyword = NULL;
	gchar *value = NULL;
	gchar **tmp_array;

	gchar *opt;

	gint i = 0;
	gint tmp_counter = 0;
	gint done_roms = 0;
	gfloat done;

	GHashTable *driver_htable=NULL;
	gchar *driverkey,*drivervalue;
	gchar *driverkey2,*drivervalue2;
	
	GtkWidget *progress_window;
	xmame_available_options *available_options;

	if (!current_exec)
	{
		gxmame_message(ERROR, NULL, _("xmame not found"));
		return FALSE;
	}
	
	available_options = xmame_executable_get_options(current_exec);
	/* Generate the table for drivers */
	/* without including neither history nor mameinfo to have less to parse after*/
	opt=g_strdup_printf("%s -listsourcefile -%s /dev/null -%s /dev/null 2>/dev/null",
			current_exec->path,
			available_options->mameinfo_file_option,
			available_options->history_file_option);

	xmame_pipe = popen(opt, "r");
	g_free(opt);
	if (!xmame_pipe)
	{
		gxmame_message(ERROR, NULL, _("Error executing %s"), current_exec->path);
		return FALSE;
	}	

	if (list_ver.name)
		g_free(list_ver.name);
	if (list_ver.version)
		g_free(list_ver.version);

	list_ver.name = g_strdup(current_exec->name);
	list_ver.version = g_strdup(current_exec->version);

	romname = g_malloc0(MAX_ROMNAME);
	gamename = g_malloc0(MAX_GAMENAME);
	gamenameext = g_malloc0(MAX_GAMENAME);
	year = g_malloc0(MAX_YEAR);
	manu = g_malloc0(MAX_MANU);
	cloneof = g_malloc0(MAX_ROMNAME);
	romof = g_malloc0(MAX_ROMNAME);
	sampleof = g_malloc0(MAX_ROMNAME);
	input = g_malloc0(200);
	status = g_malloc0(200);
	channels = g_malloc0(200);
	driver = g_malloc0(MAX_ROMNAME);

	for (i = 0; i < NB_CPU; i++)
	{
		cpu[i] = g_malloc0(MAX_CPU);
		cpu_clock[i] = g_malloc0(MAX_CPU);
		sound[i] = g_malloc0(MAX_CPU);
		sound_clock[i] = g_malloc0(MAX_CPU);
	}

	control = g_malloc0(MAX_CONTROL);
	num_players = g_malloc0(MAX_ROMNAME);
	num_buttons = g_malloc0(MAX_ROMNAME);
	
	for (tmp_counter = 0; tmp_counter < 16; tmp_counter++) {
		chip[tmp_counter] = NULL;
	}
	driver_status = g_malloc0(200);
	video = g_malloc0(200);

	/* display the progression window */
	progress_window = create_loading_progress_window(FALSE);
	gtk_window_set_title(GTK_WINDOW(progress_window),_("Creating game list..."));
	gtk_widget_show(progress_window);
	update_loading_progress_window(0,_("receiving data, please wait"));
	while (gtk_events_pending()) gtk_main_iteration();

	/* Generate the table for drivers */
	/* without including neither history nor mameinfo to have less to parse after*/
	opt=g_strdup_printf("%s -listsourcefile -%s /dev/null -%s /dev/null 2>/dev/null",
			current_exec->path,
			available_options->mameinfo_file_option,
			available_options->history_file_option);

	xmame_pipe = popen(opt, "r");
	g_free(opt);

	driver_htable = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	
	/*why the hell there is a delay when we reach the end of this loop???
	  Probably because XMame <0.61 didn't flushed out the buffer */
	while (fgets(line, BUFFER_SIZE, xmame_pipe))
	{
		driverkey = p = p2 = line;
		for(i = 0;(*p && (*p != '/') && (*p != ':') && (*p != '\n'));i++,p++);
		/* we should got the total supported games*/
		if (*p == '/')
		{
			for(p2++;(*p2 && (*p2++ != ' ')););
			*p2 = '\0';
			for(p++;(*p && (*p++ != '/')););
			drivervalue = p;
			for(i=0,p++;(*p && (*p != '.') && (*p != '\n'));i++,p++);
			*p = '\0';

			if (i > 0)
			{
				/* need to remove the null character otherwise, the g_str_equal does work 
				   at the next stage */
				driverkey2=g_strndup(driverkey,strlen(driverkey)-1);
				drivervalue2=g_strdup(drivervalue);
				g_hash_table_insert(driver_htable,driverkey2,drivervalue2);
			}
			
		} else if (*p == ':')
		{
			p[0]='\0';
			if (!strcmp(driverkey,"Total Supported"))
			{
				p = p+2;
				for(drivervalue = p;(*p && (*p != '\n'));p++);
				*p = '\0';
				supported_games = atoi(drivervalue);
				GXMAME_DEBUG("total games supported=:%d",supported_games);
			}
		}
	/* need to update here otherwise, the progress window stay blanc until 
	   we exit this loop */
	while (gtk_events_pending()) gtk_main_iteration();
	}
	GXMAME_DEBUG("drivers list loaded");
	g_message(_("creating game list, Please wait:"));
	pclose(xmame_pipe);
	g_snprintf(line,BUFFER_SIZE ,_("Creating game list (%d games)..."), supported_games);
	gtk_window_set_title(GTK_WINDOW(progress_window),line);
	while (gtk_events_pending()) gtk_main_iteration();
		
	/* Generate the list */
	/* without including neither history nor mameinfo to have less to parse after*/
	opt=g_strdup_printf("%s -listinfo -%s /dev/null -%s /dev/null 2>/dev/null",
			current_exec->path,
			available_options->mameinfo_file_option,
			available_options->history_file_option);
	
	xmame_pipe = popen(opt, "r");
	g_free(opt);
	
	filename = g_build_filename(g_get_home_dir(), ".gxmame", "gamelist", NULL);
	gamelistfile = fopen(filename, "w");
	g_free(filename);

	if (!gamelistfile)
		return FALSE;

	fputs("# GXMame 0.7",gamelistfile);
	fputs("\n# Name ",gamelistfile);
	fputs(list_ver.name,gamelistfile);
	/*fputs("\n# Target ",gamelistfile);
	fputs(list_version.target,gamelistfile);*/
	fputs("\n# Version ",gamelistfile);
	fputs(list_ver.version, gamelistfile);
	fputs("\n# list of xmame games for GXMame front-end\n# The fileformat is: romnamegamenamegamenameextthe_traileryearmanufacturercloneofromofdriverstatuscolorscpu1cpu1_clockcpu2cpu2_clockcpu3cpu3_clockcpu4cpu4_clocksound1sound1_clocksound2sound2_clocksound3sound3_clocksound4sound4_clocknum_playersnum_buttonscontrolvectorscreen_xscreen_yscreen_freqhorizontalchannelsnb_romsnb_samplessampleof\n",
		gamelistfile);

	while (fgets(line, BUFFER_SIZE, xmame_pipe))
	{
		line[strlen(line) - 1] = 0;
		nb_roms = 0;
		/*the game begin here*/
		if (!strcmp(line, "game (")) {
			strcpy(romname, "Unknown");
			strcpy(gamename, "Unknown");
			strcpy(gamenameext, "Unknown");
			strcpy(year, "-");
			strcpy(manu, "<unknown>");
			strcpy(cloneof, "-");
			strcpy(romof, "-");
			strcpy(sampleof, "-");
			nb_samples = 0;
			the_trailer=FALSE;
			while (fgets(line, BUFFER_SIZE, xmame_pipe)) {
				/* the game ends here */
				if (line[0] == ')')
					break;
				/* find the keyword separated by a space */
				for (i=0,keyword = p = line + 1;(*p && (*p++ != ' '));i++);

				keyword[i] = '\0';

				if (p[0] == '\"')
					p++;

				for (i=0, value = p;(*p && (*p++ != '\n'));i++);

				if (value[i - 1] == '\"')
					i--;
				value[i] = '\0';

				if (!strcmp(keyword, "name"))
					g_snprintf(romname, MAX_ROMNAME, value);
				else if (!strcmp(keyword, "description"))
				{
					if (!g_strncasecmp(value,"The ",4))
					{
						value = value+4;
						the_trailer=TRUE;
					}
					for (i=0,p=value;(*p && (*p != '/') && (*p++ != '('));i++);
					if (*p=='/')
					{	/*Fix for F/A (Japan)*/
						if (value[i-1]=='F')
						{
							value[i+2] = '\0';
							p = p+3;
						}
						else
							value[i-1] = '\0';
						g_snprintf(gamenameext, MAX_GAMENAME, p);
/*						printf("%s separator / and %s\n",value,p);*/
					}
					else if(*--p=='(')
					{
						value[i-1] = '\0';
						g_snprintf(gamenameext, MAX_GAMENAME, p);
/*						printf("%s separator ( and %s\n",value,p);*/
					}
					g_snprintf(gamename, MAX_GAMENAME, value);
				}
				else if (!strcmp(keyword, "year"))
					g_snprintf(year, MAX_YEAR, value);
				else if (!strcmp(keyword, "manufacturer"))
				{
					if(strncmp(value, "???", 3))
						g_snprintf(manu, MAX_MANU, value);
				}
				else if (!strcmp(keyword, "rom"))
					nb_roms++;
				else if (!strcmp(keyword, "sample"))
					nb_samples++;
				else if (!strcmp(keyword, "cloneof"))
					g_snprintf(cloneof, MAX_ROMNAME, value);
				else if (!strcmp(keyword, "romof"))
					g_snprintf(romof, MAX_ROMNAME, value);
				else if (!strcmp(keyword, "sampleof"))
					g_snprintf(sampleof, MAX_ROMNAME, value);
				else if (!strcmp(keyword, "chip")) {
					tmp_counter = 0;
					/* Put it in the next free chip[] slot */
					while ((chip[tmp_counter] != NULL)
					       && tmp_counter < 16)
						tmp_counter++;
					if ((chip[tmp_counter] == NULL))
						chip[tmp_counter] = g_strdup(value);
				}
				else if (!strcmp(keyword, "video"))
					g_snprintf(video, 200, value);
				else if (!strcmp(keyword, "input"))
					g_snprintf(input, 200, value);
				else if (!strcmp(keyword, "driver"))
					g_snprintf(driver_status, 200, value);
				else if (!strcmp(keyword, "sound"))
				{
					tmp_array = g_strsplit(value, " ",3);
					if (!strcmp(tmp_array[1], "channels"))
						g_snprintf(channels,200,tmp_array[2]);
					g_strfreev(tmp_array);
				}

			}

			
			/*write directly in the file*/
			fputs(romname, gamelistfile);
			fputs(SEP, gamelistfile);
			fputs(gamename, gamelistfile);
			fputs(SEP, gamelistfile);
			if(strcmp(gamenameext,"Unknown"))
				fputs(gamenameext, gamelistfile);
			if (the_trailer)
				fputs(SEP "true" SEP, gamelistfile);
			else
				fputs(SEP "false" SEP, gamelistfile);
			fputs(year, gamelistfile);
			fputs(SEP, gamelistfile);
			fputs(manu, gamelistfile);
			fputs(SEP, gamelistfile);
			fputs(cloneof, gamelistfile);
			fputs(SEP, gamelistfile);
			fputs(romof, gamelistfile);
			fputs(SEP, gamelistfile);

			/* the driver name already obtained before */
			drivervalue = g_hash_table_lookup (driver_htable,romname);
			fputs(drivervalue, gamelistfile);

			/* now the status driver,
			   true when good false when preliminary
			   (is there any other option?)

			   status *** color *** sound *** palettesize *** blit *** */
			tmp_array =
			    g_strsplit(driver_status, " ", 10);
			if ((tmp_array[2]) && !strcmp(tmp_array[2], "good"))
			{
				fputs(SEP "true" SEP, gamelistfile);
			} else {
				fputs(SEP "false" SEP, gamelistfile);
			}
			fputs(tmp_array[8],gamelistfile);
			fputs(SEP,gamelistfile);
			g_strfreev(tmp_array);

			/* find the chip name and type (CPU or Sound) 
			type *** name *** clock *** ) */
			for(i=0; i < NB_CPU; i++)
			{
				strcpy(cpu[i], "-");
				strcpy(sound[i], "-");
				strcpy(cpu_clock[i], "-");
				strcpy(sound_clock[i], "-");
			}
			strcpy(control, "-");
		
			tmp_counter = 0;
			while ((chip[tmp_counter] != NULL)
			       && (tmp_counter < 16))
			{
				tmp_array = g_strsplit(chip[tmp_counter], " ",0);
				/* pure cpu*/
				if (!strcmp(tmp_array[2], "cpu"))
				{
					if (!strcmp(tmp_array[3], "name"))
					{
						for (i = 0; i < NB_CPU; i++)
						{
							if (!strcmp(cpu[i], "-"))
							{
								g_snprintf(cpu[i],
								   MAX_CPU,"%s",
								   tmp_array[4]);
								g_snprintf(cpu_clock[i],
								   MAX_CPU,"%s",
								   tmp_array[6]);
				
								break;
							}
						}
					}
					else if (!strcmp(tmp_array[3], "flags"))
					{
						for (i = 0; i < NB_CPU; i++)
						{
							if (!strcmp(cpu[i], "-"))
							{
								g_snprintf(cpu[i],
								   MAX_CPU,"(sound)%s",
								   tmp_array[6]);
								g_snprintf(cpu_clock[i],
								   MAX_CPU,"%s",
								   tmp_array[8]);
								break;
							}
						}
					}
				}
				else if (!strcmp(tmp_array[2], "audio"))
				{
					for (i = 0; i < NB_CPU; i++)
					{
						if (!strcmp(sound[i], "-"))
						{
							g_snprintf(sound[i],
								MAX_CPU,"%s",
								tmp_array[4]);
							if (!strcmp(tmp_array[5], "clock"))
						 		g_snprintf(sound_clock[i],
									MAX_CPU,"%s",
									tmp_array[6]);
							break;
						}
					}
				}

				g_strfreev(tmp_array);
				tmp_counter++;
			}

			tmp_counter = 0;
			while ((chip[tmp_counter] != NULL) && (tmp_counter<16)) {
				g_free(chip[tmp_counter]);
				chip[tmp_counter] = NULL;
				tmp_counter++;
			}
			/* write these value in good order in the file */
			for (i=0; i < NB_CPU; i++)
			{
				fputs(cpu[i], gamelistfile);
				fputs(SEP, gamelistfile);
				fputs(cpu_clock[i], gamelistfile);
				fputs(SEP, gamelistfile);
			}

			for (i=0; i < NB_CPU; i++)
			{
				fputs(sound[i], gamelistfile);
				fputs(SEP, gamelistfile);
				fputs(sound_clock[i], gamelistfile);
				fputs(SEP, gamelistfile);
			}
			
			/* same to extract different info from input field */
			tmp_array = g_strsplit(input, " ", 0);
			tmp_counter = 0;
			while ((tmp_array[tmp_counter + 1] != NULL)) {
				if (!strcmp
				    (tmp_array[tmp_counter], "players"))
					g_snprintf(num_players,
						MAX_ROMNAME,tmp_array[tmp_counter + 1]);
				if (!strcmp
				    (tmp_array[tmp_counter], "control"))
					g_snprintf(control,
						MAX_CONTROL,tmp_array[tmp_counter + 1]);
				if (!strcmp
				    (tmp_array[tmp_counter], "buttons"))
					g_snprintf(num_buttons,
						MAX_ROMNAME,tmp_array[tmp_counter + 1]);
				tmp_counter++;
			}
			g_strfreev(tmp_array);

			/* and write it in the file*/
			if (num_players)
				fputs(num_players, gamelistfile);
			fputs(SEP, gamelistfile);
			if (strlen(num_buttons))
				fputs(num_buttons, gamelistfile);
/* zero button ?? maybe could find something else empty string could be fine also*/
			else
				fputs("0", gamelistfile);
			fputs(SEP, gamelistfile);
			if (control)
				fputs(control, gamelistfile);
			fputs(SEP, gamelistfile);
			
			/* here we have the video section 
			video ( screen *** orientation *** x *** y *** aspectx * aspecty * freq *** ) */
			/* Vector or raster 
			   vector games dont have resolution */
 			tmp_array = g_strsplit(video, " ", 0);
			if (!strcmp(tmp_array[2], "vector")) {
				/* vector  x resolution  y resolution */
				fputs("true" SEP "0" SEP"0" SEP, gamelistfile);
				/* Frequence */
				fputs(tmp_array[10], gamelistfile);
				fputs(SEP, gamelistfile);
			} else {
				fputs("false" SEP, gamelistfile);
				/* x resolution */
				fputs(tmp_array[6], gamelistfile);
				fputs(SEP, gamelistfile);
				/* y resolution */
				fputs(tmp_array[8], gamelistfile);
				fputs(SEP, gamelistfile);
				/* Frequence */
				fputs(tmp_array[14], gamelistfile);
				fputs(SEP, gamelistfile);
			}
			
			/* Orientation */
			fputs(tmp_array[4], gamelistfile);
			fputs(SEP, gamelistfile);

			g_strfreev(tmp_array);

			fputs(channels, gamelistfile);

			fprintf(gamelistfile, SEP "%i", nb_roms);
			fprintf(gamelistfile, SEP "%i", nb_samples);

			fputs(SEP, gamelistfile);
			fputs(sampleof, gamelistfile);

			fputs("\n", gamelistfile);

			done_roms++;
			done = (gfloat) ((gfloat) (done_roms) /
					 (gfloat) (supported_games));

			update_loading_progress_window(done,gamename);
			while (gtk_events_pending()) gtk_main_iteration();
		}
	}
	
	pclose(xmame_pipe);
	
	g_free(romname);
	g_free(gamename);
	g_free(year);
	g_free(manu);
	g_free(cloneof);
	g_free(romof);
	g_free(sampleof);
	g_free(input);
	g_free(video);
	g_free(status);
	for(i=0; i < NB_CPU; i++)
	{
		g_free(cpu[i]);
		g_free(cpu_clock[i]);
		g_free(sound[i]);
		g_free(sound_clock[i]);
	}
	g_free(control);
	
	g_hash_table_destroy(driver_htable);
	
	tmp_counter = 0;
	while ((chip[tmp_counter] != NULL)) {
		g_free(chip[tmp_counter]);
		tmp_counter++;
	}
	g_free(driver_status);
                

	fclose(gamelistfile);
	gtk_widget_destroy(progress_window);
	return TRUE;
}
