/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <string.h>
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "gxmame.h"
#include "options.h"
#include "io.h"
#include "callbacks.h"
#include "interface.h"
#include "gui.h"
#include "keyboard.h"
#include "icones.h"

#define BUFFER_SIZE 1000

static gboolean dirty_options_flag;

/* display */
GtkWidget *frameskip_combo;
GtkWidget *frameskipper_combo;
GtkWidget *maxautoframeskip_combo;
GtkWidget *effect_entry;
GtkWidget *arbheight_entry;
GtkWidget *arbheight_checkbutton;
GtkWidget *heightscale_spinbutton;
GtkObject *heightscale_spinbutton_adj;
GtkWidget *widthscale_spinbutton;
GtkObject *widthscale_spinbutton_adj;
GtkWidget *autodouble_checkbutton;
GtkWidget *dirty_checkbutton;
GtkWidget *scanlines_checkbutton;
GtkWidget *throttle_checkbutton;
GtkWidget *sleepidle_checkbutton;
GtkWidget *frameskippercombo_entry;
GtkWidget *frameskip_entry;
GtkWidget *brightness_hscale;
GtkWidget *gamma_hscale;
GtkWidget *rotation_combo_entry;
GtkWidget *norotate_checkbutton;
GtkWidget *flipx_checkbutton;
GtkWidget *flipy_checkbutton;
GtkWidget *autoframeskip_checkbutton;
GtkWidget *maxautoframeskip_entry;
GtkWidget *bpp_combo_entry;
GtkWidget *fts_label;
GtkWidget *fs_method_label;
GtkWidget *maxfs_label;
/* misc */
GtkWidget *artwork_checkbutton;
/* Renderer */
GtkObject *gamma_hscale_adj;
GtkObject *brightness_hscale_adj;
 /* svga */
GtkWidget *svga_tweak_table;
 /* xfx */
GtkWidget *fxgkeepaspect_checkbutton;
GtkWidget *fx_entry;
GtkWidget *planar_checkbutton;
GtkWidget *linear_checkbutton;
GtkWidget *tweaked_mode_checkbutton;
GtkWidget *centerx_spinbutton;
GtkObject *centerx_spinbutton_adj;
GtkWidget *centery_spinbutton;
GtkObject *centery_spinbutton_adj;
 /* SDL */
GtkWidget *render_mode_checkbutton;
GtkWidget *phcursor_checkbutton;
GtkWidget *sdl_modes_label;
GtkWidget *sdl_modes_combo;
GtkWidget *sdl_modes_spinbutton;
GtkObject *sdl_modes_spinbutton_adj;
GtkWidget *fullscreen_checkbutton;
GtkWidget *sdl_modes_checkbutton;
GtkWidget *sdl_modes_entry;
 /* Open GL */
GtkWidget *glfullscreen_checkbutton;
GtkWidget *gltexture_size_spinbutton;
GtkObject *gltexture_size_spinbutton_adj;
GtkWidget *glext78_checkbutton;
GtkWidget *glbilinear_checkbutton;
GtkWidget *gldrawbitmap_checkbutton;
GtkWidget *glantialias_checkbutton;
GtkWidget *glalphablending_checkbutton;
GtkWidget *gldblbuffer_checkbutton;
GtkWidget *glforceblitmode_checkbutton;
GtkWidget *cabview_checkbutton;
GtkWidget *cabinet_entry;
GtkWidget *glres_checkbutton;
GtkWidget *glres_combo;
GtkWidget *glres_combo_entry;
GtkWidget *gllib_entry;
GtkWidget *glulib_entry;
GtkWidget *glcolormod_checkbutton;
 /* X11 */
GtkWidget *x11_mode_checkbutton;
GtkWidget *xvext_checkbutton;
GtkWidget *vidix_checkbutton;
GtkWidget *xsync_checkbutton;
GtkWidget *privatecmap_checkbutton;
GtkWidget *xil_checkbutton;
GtkWidget *mtxil_checkbutton;
GtkWidget *cursor_checkbutton;
GtkWidget *mitshm_checkbutton;
GtkWidget *xv_table2;
GtkWidget *xvgeom_checkbutton;
GtkWidget *xvgeom_entry;
GtkWidget *xvgeom_combo;
GtkWidget *yuv_checkbutton;
GtkWidget *yv12_checkbutton;
GtkWidget *xvfullscreen_checkbutton;
GtkWidget *displayaspectratio_entry;
GtkWidget *disable_mode_entry;
GtkWidget *keepaspect_checkbutton;
 /* ggi */
GtkWidget *ggi_res_table;
GtkWidget *ggilinear_checkbutton;
GtkWidget *ggi_force_resolution_checkbutton;
GtkWidget *ggix_spinbutton;
GtkObject *ggix_spinbutton_adj;
GtkWidget *ggiy_spinbutton;
GtkObject *ggiy_spinbutton_adj;
/* Sound */
GtkWidget *alsa_buffer_label;
GtkWidget *alsacard_label;
GtkWidget *alsadevice_label;
GtkWidget *alsa_frame;
GtkWidget *arts_frame;
GtkWidget *qnx_frame;
GtkWidget *PCM_label;
GtkWidget *audiodevice_combo;
GtkWidget *mixerdevice_label;
GtkWidget *mixerdevice_combo;
GtkWidget *samplefreq_label;
GtkWidget *audiodevice_label;
GtkWidget *samplefreq_combo;
GtkWidget *volume_frame;
GtkWidget *bufsize_frame;
GtkWidget *sound_checkbutton;
GtkWidget *samples_checkbutton;
GtkWidget *samplefreq_entry;
GtkWidget *db_hscale;
GtkObject *db_hscale_adj;
GtkWidget *bufsize_hscale;
GtkObject *bufsize_hscale_adj;
GtkWidget *audiodevice_combo_entry;
GtkWidget *mixerdevice_entry;
GtkWidget *fakesound_checkbutton;
GtkWidget *mixer_plugin_entry;
GtkWidget *dsp_plugin_entry;
GtkWidget *timer_checkbutton;
GtkWidget *audio_preferred_checkbutton;
GtkWidget *arts_spinbutton;
GtkObject *arts_spinbutton_adj;
GtkWidget *alsa_buffer_spinbutton;
GtkObject *alsa_buffer_spinbutton_adj;
GtkWidget *alsacard_spinbutton;
GtkObject *alsacard_spinbutton_adj;
GtkWidget *alsadevice_spinbutton;
GtkObject *alsadevice_spinbutton_adj;
GtkWidget *pcm_entry;
GtkWidget *soundfile_entry;
GtkWidget *soundfile_hbox;
GtkWidget *audiodevice_hbox;
/* Controllers*/
GtkWidget *Xinput_joy_frame;
GtkWidget *joydevname_label;
GtkWidget *paddevname_label;
GtkWidget *x11joyname_label;
GtkWidget *winkeys_checkbutton;
GtkWidget *mouse_checkbutton;
GtkWidget *grabmouse_checkbutton;
GtkWidget *grabkeyboard_checkbutton;
GtkWidget *XInput_trackball1_entry;
GtkWidget *XInput_trackball3_entry;
GtkWidget *XInput_trackball2_entry;
GtkWidget *XInput_trackball4_entry;
GtkWidget *usbpspad_checkbutton;
GtkWidget *hotrod_checkbutton;
GtkWidget *rapidfire_checkbutton;
GtkWidget *analogstick_checkbutton;
GtkWidget *XInput_joystick1_entry;
GtkWidget *XInput_joystick3_entry;
GtkWidget *XInput_joystick2_entry;
GtkWidget *XInput_joystick4_entry;
GtkWidget *paddevname_entry;
GtkWidget *x11joyname_entry;
GtkWidget *hotrodse_checkbutton;
GtkWidget *joytype_combo_entry;
GtkWidget *joydevname_entry;
GtkWidget *config_name_checkbutton;
GtkWidget *config_name_entry;
GtkWidget *ctrlr_combo;
GtkWidget *ctrlr_combo_entry;
GtkWidget *keymaptype_combo_entry;
GtkWidget *ugcicoin_checkbutton;
/* Misc */
GtkWidget *slave_label;
GtkWidget *master_label;
GtkWidget *network_frame;
GtkWidget *log_label;
GtkWidget *debug_size_label;
GtkWidget *debug_size_combo;
GtkWidget *bios_label;
GtkWidget *bios_combo;
GtkWidget *artcrop_frame;
GtkWidget *artwork_resolution_frame;
GtkWidget *artwork_frame;
GtkObject *master_spinbutton_adj;
GtkObject *bind_spinbutton_adj;
GtkWidget *use_backdrops_checkbutton;
GtkWidget *use_bezels_checkbutton;
GtkWidget *use_overlays_checkbutton;
GtkWidget *artcrop_checkbutton;
GtkWidget *artwork_resolution_combo_entry;
GtkWidget *keyboard_leds_checkbutton;
GtkWidget *cheat_checkbutton;
GtkWidget *debug_checkbutton;
GtkWidget *debug_size_combo_entry;
GtkWidget *log_flag_checkbutton;
GtkWidget *log_entry;
GtkWidget *additional_options_checkbutton;
GtkWidget *additional_options_entry;
GtkWidget *network_option_checkbutton;
GtkWidget *netmapkey_checkbutton;
GtkWidget *parallelsync_checkbutton;
GtkWidget *client_mode_radiobutton;
GtkWidget *server_mode_radiobutton;
GtkWidget *slave_entry;
GtkWidget *master_spinbutton;
GtkWidget *bind_flag_checkbutton;
GtkWidget *bind_spinbutton;
GtkWidget *statedebug_checkbutton;
GtkWidget *bios_combo_entry;

/* Vector */
GtkWidget *translucency_checkbutton;
GtkWidget *beam_hscale;
GtkWidget *flicker_hscale;
GtkWidget *intensity_hscale;
GtkWidget *gldrawbitmapvec_checkbutton;
GtkWidget *glantialiasvec_checkbutton;
GtkWidget *antialias_checkbutton;
GtkWidget *vectorres_entry;
GtkWidget *vector_fixed_resolution_checkbutton;
GtkWidget *disclaimer_checkbutton;
GtkWidget *gameinfo_checkbutton;

GList *dsp_plugin_combo_items = NULL;
GList *mixer_plugin_combo_items = NULL;
GList *sdl_modes_combo_items = NULL;

const char *bios_version[] = {
	N_("Europe, 1 Slot (also been seen on a 4 slot)"),
	N_("Europe, 4 Slot"),
	N_("US, 2 Slot"),
	N_("US, 6 Slot (V5?)"),
	N_("Asia S3 Ver 6"),
	N_("Japan, Ver 6 VS Bios"),
	N_("Japan, Older"),
	N_("Universe Bios v1.0 (hack)"),
	N_("Universe Bios v1.1 (hack)"),
	N_("Debug (Development) Bios"),
	N_("AES Console (Asia?) Bios"),
	N_("Universe Bios v1.2 (hack)"),
	NULL
};

const char *joytype_name[] = {
/*0*/	N_("No joystick"),
/*1*/	N_("i386 style"),
/*2*/	N_("Fm Town Pad"),
/*3*/	N_("X11 input extension"),
/*4*/	N_("new i386 linux 1.x.x driver"),
/*5*/	N_("NetBSD USB joystick"),
/*6*/	N_("PS2-Linux native pad"),
/*7*/	N_("SDL"),
		NULL
};

const char *effect_name[] = {
	N_("None"),
	N_("Smooth scaling effect"),
	N_("Light scanlines"),
	N_("3x2 RGB vertical stripes"),
	N_("2x3 RGB horizontal scanlines"),
	N_("3x3 deluxe scanlines"),
	N_("2x low quality magnification filter"),
	N_("2x high quality magnification filter"),
	NULL
};

/* used for xv and vidix check button and options */
void
newext_toggled      (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	xmame_available_options *available_options = xmame_executable_get_options(current_exec);
	if ((gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xvext_checkbutton)) &&
	     gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mitshm_checkbutton)) &&
		available_options->xvext && available_options->mitshm) ||
	    (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vidix_checkbutton)) && available_options->vidix))
		gtk_widget_set_sensitive(GTK_WIDGET(user_data),TRUE);
	else
		gtk_widget_set_sensitive(GTK_WIDGET(user_data),FALSE);
}
void
button_toggled      (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(user_data),gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton)));
}
void
not_button_toggled  (GtkObject       *checkbutton,
                     gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(user_data),!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton)));
}
void unactivate_checkbutton  (GtkObject       *checkbutton,
                         gpointer         user_data)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(checkbutton)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (user_data), FALSE);
}


void
autoframeskip_toggled   (GtkObject       *autoframeskip_checkbutton,
                         gpointer         user_data)
{
	gtk_widget_set_sensitive(frameskip_combo,!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(frameskipper_combo,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(maxautoframeskip_combo,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(fts_label,!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(fs_method_label,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(maxfs_label,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
}
void
joystick_choosen      (GtkObject       *combo_entry,
                       gpointer         user_data)
{
	gchar *used_text;
	int i;
	used_text = gtk_editable_get_chars(GTK_EDITABLE(combo_entry),0,-1);

	for (i=0; joytype_name[i];i++) {
		if (!strcmp(used_text,_(joytype_name[i])))
			break;
	}
		
	if (i == 0) /* No joystick */
	{
			gtk_widget_set_sensitive(analogstick_checkbutton,FALSE);
			gtk_widget_set_sensitive(usbpspad_checkbutton,FALSE);
			gtk_widget_set_sensitive(rapidfire_checkbutton,FALSE);
	} else
	{
		gtk_widget_set_sensitive(analogstick_checkbutton,TRUE);
		gtk_widget_set_sensitive(usbpspad_checkbutton,TRUE);
		gtk_widget_set_sensitive(rapidfire_checkbutton,TRUE);
	}

	if (i == 2 ) /* Fm Town Pad */
	{
		gtk_widget_set_sensitive(paddevname_label,TRUE);
		gtk_widget_set_sensitive(paddevname_entry,TRUE);
	} else
	{
		gtk_widget_set_sensitive(paddevname_label,FALSE);
		gtk_widget_set_sensitive(paddevname_entry,FALSE);
	}

	if (i == 3)  /* X11 input extension */
	{
		gtk_widget_set_sensitive(x11joyname_label,TRUE);
		gtk_widget_set_sensitive(x11joyname_entry,TRUE);
	} else
	{
		gtk_widget_set_sensitive(x11joyname_label,FALSE);
		gtk_widget_set_sensitive(x11joyname_entry,FALSE);
	}
	if (i == 1 || i == 4)  /* i386 style or new i386 linux 1.x.x driver */
	{
		gtk_widget_set_sensitive(joydevname_label,TRUE);
		gtk_widget_set_sensitive(joydevname_entry,TRUE);
	} else
	{
		gtk_widget_set_sensitive(joydevname_label,FALSE);
		gtk_widget_set_sensitive(joydevname_entry,FALSE);
	}

	g_free(used_text);

}


void
on_dirty_option     (GtkObject       *object,
                     gpointer         user_data)
{
	dirty_options_flag = TRUE;
	if (user_data)
		gtk_widget_set_sensitive(GTK_WIDGET(user_data),TRUE);
}


/* add dsp choices to dsp dropbox option */
void
dsp_combo_add (gchar *key,gchar *value)
{
	 dsp_plugin_combo_items = g_list_append (dsp_plugin_combo_items, (gpointer)g_strdup(value));
	 GXMAME_DEBUG("\t %s added",value);
}
/* select the user value in the dropbox */
void
dsp_combo_comp (gchar *key,gchar *value,xmame_game_options *target)
{
	if (!strcmp(key,(target->dsp_plugin)))
	{
		gtk_entry_set_text (GTK_ENTRY (dsp_plugin_entry), value);	
	}	
}
/* save user value */
void
dsp_combo_comp_inv (gchar *key,gchar *value,xmame_game_options *target)
{
	gchar *used_text;
	used_text = gtk_editable_get_chars(GTK_EDITABLE(dsp_plugin_entry),0,-1);
	if (!strcmp(value,used_text))
	{
		strncpy(target->dsp_plugin,key,20);
	}	
	g_free(used_text);
}
/* add mixer choices to mixer dropbox option */
void
mixer_combo_add (gchar *key,gchar *value)
{
	mixer_plugin_combo_items = g_list_append (mixer_plugin_combo_items, (gpointer)g_strdup(value));
	GXMAME_DEBUG("\t %s added",value);
}
/* select the user value in the dropbox */
void
mixer_combo_comp (gchar *key,gchar *value,xmame_game_options *target)
{
	if (!strcmp(key,(target->sound_mixer_plugin)))
	{
		gtk_entry_set_text (GTK_ENTRY (mixer_plugin_entry), value);	
	}	
}
/* save user value */
void
mixer_combo_comp_inv (gchar *key,gchar *value,xmame_game_options *target)
{
	gchar *used_text;
	used_text = gtk_editable_get_chars(GTK_EDITABLE(mixer_plugin_entry),0,-1);
	if (!strcmp(value,used_text))
	{
		strncpy(target->sound_mixer_plugin,key,20);
	}	
	g_free(used_text);
}

/* select the user value in the dropbox */
void
sdl_modes_combo_comp (gchar *key,gchar *value,xmame_game_options *target)
{
	if (atoi(key)==target->modenumber)
	{
		gtk_entry_set_text (GTK_ENTRY (sdl_modes_entry), value);	
	}	
}
/* save user value */
void
sdl_modes_combo_comp_inv (gchar *key,gchar *value,xmame_game_options *target)
{
	gchar *used_text;
	used_text = gtk_editable_get_chars(GTK_EDITABLE(sdl_modes_entry),0,-1);
	if (!strcmp(value,used_text))
	{
		target->modenumber = atoi(key);
	}	
	g_free(used_text);
}

/* get the plugin value to test if we are writing in a file or in a device */		
void
dsp_combo_comp_inv2 (gchar *key,gchar *value,gchar *plugin)
{
	gchar *used_text2;
	used_text2 = gtk_editable_get_chars(GTK_EDITABLE(dsp_plugin_entry),0,-1);
	if (!strcmp(value,used_text2))
	{
		strncpy(plugin,key,20);
	}	
	g_free(used_text2);
}
void file_or_device(void)
{
	gchar plugin[20],*used_text;
	used_text = gtk_editable_get_chars(GTK_EDITABLE(dsp_plugin_entry),0,-1);
	strncpy(plugin,used_text,20);
	g_free(used_text);
	if(current_exec->mixer_plugin_hash_table)
	{
		g_hash_table_foreach(current_exec->dsp_plugin_hash_table,
        	           	  (GHFunc)dsp_combo_comp_inv2,
				   plugin);
	}
	if(!strcmp(plugin,"waveout"))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),FALSE);
	}
	else
	{
		gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),TRUE);
	}
}
	 
     
void add_display_options_tab (GtkWidget    *properties_windows,
			      GtkNotebook  *target_notebook,
			      RomEntry     *rom,
			      GtkWidget    *apply_button,
			      GtkWidget    *reset_button,
			      guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;
	
	GtkWidget *display_table;
	GtkWidget *hseparator16;
	GtkWidget *display_hbox;
	GtkWidget *display_pixmap;
	GtkWidget *display_rom_title_label;
	GtkWidget *effects_frame;
	GtkWidget *effects_vbox;
	GtkWidget *effect_combo;
	GList *effect_combo_items = NULL;
	GtkWidget *corrections_frame;
	GtkWidget *correction_vbox;
	GtkWidget *gamma_label;
	GtkWidget *brightness_label;
	GtkWidget *diplay_general_vbox;
	GtkWidget *skipping_frame;
	GtkWidget *frameskip_table;
	GList *frameskip_combo_items = NULL;
	GList *frameskipper_combo_items = NULL;
	GList *maxautoframeskip_combo_items = NULL;
	GtkWidget *resolution_frame;
	GtkWidget *table11;
	GtkWidget *heightscale_label;
	GtkWidget *widthscale_label;
	GtkWidget *bpp_label;
/*	GtkObject *heightscale_spinbutton_adj; */
	GtkWidget *bpp_combo;
	GList *bpp_combo_items = NULL;
/*	GtkObject *widthscale_spinbutton_adj; */
	GtkWidget *rotation_frame;
	GtkWidget *vbox12;
	GtkWidget *combo;
	GList *combo_items = NULL;
	GtkWidget *display_label;
	GtkWidget *percent_label;
	GtkWidget *hbox7;
	gchar title[BUFFER_SIZE];
	gchar *used_text;
	int nb_effects, i;

	xmame_game_options *target;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(current_exec);

	dirty_options_flag = FALSE;
			
	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	display_table = gtk_table_new (6, 2, FALSE);
	gtk_widget_ref (display_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "display_table", display_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (display_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), display_table);
	gtk_container_set_border_width (GTK_CONTAINER (display_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (display_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (display_table), 5);

	hseparator16 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator16);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator16", hseparator16,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator16);
	gtk_table_attach (GTK_TABLE (display_table), hseparator16, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	display_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (display_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "display_hbox", display_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (display_hbox);
	gtk_table_attach (GTK_TABLE (display_table), display_hbox, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);


	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				display_xpm);
	display_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (display_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);
	
	g_object_set_data_full (G_OBJECT (properties_windows), "display_pixmap", display_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (display_pixmap);
	gtk_box_pack_start (GTK_BOX (display_hbox), display_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (display_pixmap), 10, 0);

	if (rom)
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		display_rom_title_label = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		display_rom_title_label = gtk_label_new (_("Global game options\nDefault options used by all games"));
	
	gtk_widget_ref (display_rom_title_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "display_rom_title_label", display_rom_title_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (display_rom_title_label);
	gtk_box_pack_start (GTK_BOX (display_hbox), display_rom_title_label, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (display_rom_title_label), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (display_rom_title_label), TRUE);
	gtk_misc_set_padding (GTK_MISC (display_rom_title_label), 10, 0);

	effects_frame = gtk_frame_new (_("Effects"));
	gtk_widget_ref (effects_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "effects_frame", effects_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (effects_frame);
	gtk_table_attach (GTK_TABLE (display_table), effects_frame, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	effects_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (effects_vbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "effects_vbox", effects_vbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (effects_vbox);
	gtk_container_add (GTK_CONTAINER (effects_frame), effects_vbox);

	effect_combo = gtk_combo_new ();
	gtk_widget_ref (effect_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "effect_combo", effect_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (effect_combo);
	gtk_box_pack_start (GTK_BOX (effects_vbox), effect_combo, FALSE, FALSE, 0);
	gtk_combo_set_value_in_list (GTK_COMBO (effect_combo), TRUE, FALSE);

	for (nb_effects=0; effect_name[nb_effects]; nb_effects++)
	{
		effect_combo_items = g_list_append (effect_combo_items, (gpointer) _(effect_name[nb_effects]));
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (effect_combo), effect_combo_items);
	g_list_free (effect_combo_items);

	effect_entry = GTK_COMBO (effect_combo)->entry;
	gtk_widget_ref (effect_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "effect_entry", effect_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (effect_entry);

	if (target->effect > nb_effects)
		target->effect = 0;
	
	gtk_entry_set_text (GTK_ENTRY (effect_entry), _(effect_name[target->effect]));

	scanlines_checkbutton = gtk_check_button_new_with_label (_("Use Scanlines"));
	gtk_widget_ref (scanlines_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "scanlines_checkbutton", scanlines_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scanlines_checkbutton);
	gtk_box_pack_start (GTK_BOX (effects_vbox), scanlines_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scanlines_checkbutton), target->scanlines);

	corrections_frame = gtk_frame_new (_("Corrections"));
	gtk_widget_ref (corrections_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "corrections_frame", corrections_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (corrections_frame);
	gtk_table_attach (GTK_TABLE (display_table), corrections_frame, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	correction_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (correction_vbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "correction_vbox", correction_vbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (correction_vbox);
	gtk_container_add (GTK_CONTAINER (corrections_frame), correction_vbox);

	gamma_label = gtk_label_new (_("Gamma correction"));
	gtk_widget_ref (gamma_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "gamma_label", gamma_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gamma_label);
	gtk_box_pack_start (GTK_BOX (correction_vbox), gamma_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (gamma_label), 0, 0.5);

	gamma_hscale_adj = gtk_adjustment_new (target->gamma_correction, 0.5, 2, 0.05, 0.05, 0);
	gamma_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gamma_hscale_adj));
	gtk_widget_ref (gamma_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "gamma_hscale", gamma_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gamma_hscale);
	gtk_box_pack_start (GTK_BOX (correction_vbox), gamma_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (gamma_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (gamma_hscale), 2);

	brightness_label = gtk_label_new (_("Brightness correction"));
	gtk_widget_ref (brightness_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "brightness_label", brightness_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (brightness_label);
	gtk_box_pack_start (GTK_BOX (correction_vbox), brightness_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (brightness_label), 0, 0.5);

	hbox7 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox7);
	g_object_set_data_full (G_OBJECT (properties_windows), "hbox7", hbox7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox7);
	gtk_box_pack_start (GTK_BOX (correction_vbox), hbox7, TRUE, TRUE, 0);


	if (available_options->dos_brightness)
	{
		brightness_hscale_adj = gtk_adjustment_new (target->brightness, 0.5, 2, 0.05, 0.05, 0);
		brightness_hscale = gtk_hscale_new (GTK_ADJUSTMENT (brightness_hscale_adj));
		gtk_scale_set_digits (GTK_SCALE (brightness_hscale), 2);
	}
	else
	{
		brightness_hscale_adj = gtk_adjustment_new (((target->brightness)-0.5)*(100/1.5), 0, 100, 1, 1, 0);
		brightness_hscale = gtk_hscale_new (GTK_ADJUSTMENT (brightness_hscale_adj));
		gtk_scale_set_digits (GTK_SCALE (brightness_hscale), 0);
	}
	gtk_widget_ref (brightness_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "brightness_hscale", brightness_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (brightness_hscale);
	gtk_box_pack_start (GTK_BOX (hbox7), brightness_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (brightness_hscale), GTK_POS_RIGHT);

	if (!available_options->dos_brightness)
	{
		percent_label = gtk_label_new ("%");
		gtk_widget_ref (percent_label);
		g_object_set_data_full (G_OBJECT (properties_windows), "percent_label", percent_label,
					  (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (percent_label);
		gtk_box_pack_start (GTK_BOX (hbox7), percent_label, FALSE, FALSE, 0);
	}

	diplay_general_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (diplay_general_vbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "diplay_general_vbox", diplay_general_vbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (diplay_general_vbox);
	gtk_table_attach (GTK_TABLE (display_table), diplay_general_vbox, 0, 1, 2, 4,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	dirty_checkbutton = gtk_check_button_new_with_label (_("Draw only changes"));
	gtk_widget_ref (dirty_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "dirty_checkbutton", dirty_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dirty_checkbutton);
	gtk_box_pack_start (GTK_BOX (diplay_general_vbox), dirty_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dirty_checkbutton), target->dirty);

	throttle_checkbutton = gtk_check_button_new_with_label (_("Throttle"));
	gtk_widget_ref (throttle_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "throttle_checkbutton", throttle_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (throttle_checkbutton);
	gtk_box_pack_start (GTK_BOX (diplay_general_vbox), throttle_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (throttle_checkbutton), target->throttle);

	sleepidle_checkbutton = gtk_check_button_new_with_label (_("Sleep when idle"));
	gtk_widget_ref (sleepidle_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "sleepidle_checkbutton", sleepidle_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sleepidle_checkbutton);
	gtk_box_pack_start (GTK_BOX (diplay_general_vbox), sleepidle_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sleepidle_checkbutton), target->sleepidle);

	skipping_frame = gtk_frame_new (_("Frame skipping"));
	gtk_widget_ref (skipping_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "skipping_frame", skipping_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (skipping_frame);
	gtk_table_attach (GTK_TABLE (display_table), skipping_frame, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	frameskip_table = gtk_table_new (4, 2, FALSE);
	gtk_widget_ref (frameskip_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "frameskip_table", frameskip_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frameskip_table);
	gtk_container_add (GTK_CONTAINER (skipping_frame), frameskip_table);

	frameskip_combo = gtk_combo_new ();
	gtk_widget_ref (frameskip_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "frameskip_combo", frameskip_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frameskip_combo);
	gtk_table_attach (GTK_TABLE (frameskip_table), frameskip_combo, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	frameskip_combo_items = g_list_append (frameskip_combo_items, (gpointer) _("Draw every frame"));

	for (i =1; i < 12; i++)
	{
		g_snprintf(title,BUFFER_SIZE,_("Skip %i of 12 frames"), i);
		frameskip_combo_items = g_list_append (frameskip_combo_items, (gpointer) title);
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (frameskip_combo), frameskip_combo_items);
	g_list_free (frameskip_combo_items);

	frameskip_entry = GTK_COMBO (frameskip_combo)->entry;
	gtk_widget_ref (frameskip_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "frameskip_entry", frameskip_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frameskip_entry);
	gtk_widget_set_size_request (frameskip_entry, 90, -1);
	gtk_editable_set_editable (GTK_EDITABLE (frameskip_entry), FALSE);

	if (target->frameskip == 0 || target->frameskip > 11)
		g_snprintf(title,BUFFER_SIZE,"%s",_("Draw every frame"));
	else
		g_snprintf(title,BUFFER_SIZE,_("Skip %i of 12 frames"), target->frameskip);

	gtk_entry_set_text (GTK_ENTRY (frameskip_entry), title);
	gtk_widget_set_sensitive (frameskip_combo, !(target->autoframeskip));

	fts_label = gtk_label_new (_("Frames to skip :"));
	gtk_widget_ref (fts_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "fts_label", fts_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fts_label);
	gtk_table_attach (GTK_TABLE (frameskip_table), fts_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (fts_label), 0, 0.5);

	maxfs_label = gtk_label_new (_("Max frameskip :"));
	gtk_widget_ref (maxfs_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "maxfs_label", maxfs_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (maxfs_label);
	gtk_table_attach (GTK_TABLE (frameskip_table), maxfs_label, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (maxfs_label), 0, 0.5);

	fs_method_label = gtk_label_new (_("Method :"));
	gtk_widget_ref (fs_method_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "fs_method_label", fs_method_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fs_method_label);
	gtk_table_attach (GTK_TABLE (frameskip_table), fs_method_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (fs_method_label), 0, 0.5);

	frameskipper_combo = gtk_combo_new ();
	gtk_widget_ref (frameskipper_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "frameskipper_combo", frameskipper_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frameskipper_combo);
	gtk_table_attach (GTK_TABLE (frameskip_table), frameskipper_combo, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	frameskipper_combo_items = g_list_append (frameskipper_combo_items, (gpointer) _("DOS frameskip code"));
	frameskipper_combo_items = g_list_append (frameskipper_combo_items, (gpointer) _("Enhanced frameskip code"));
	gtk_combo_set_popdown_strings (GTK_COMBO (frameskipper_combo), frameskipper_combo_items);
	g_list_free (frameskipper_combo_items);

	frameskippercombo_entry = GTK_COMBO (frameskipper_combo)->entry;
	gtk_widget_ref (frameskippercombo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "frameskippercombo_entry", frameskippercombo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frameskippercombo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (frameskippercombo_entry), FALSE);
	if (target->frameskipper == 1)
	      gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), _("Enhanced frameskip code"));
	else
	      gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), _("DOS frameskip code"));
	gtk_widget_set_sensitive(frameskipper_combo,target->autoframeskip);

	autoframeskip_checkbutton = gtk_check_button_new_with_label (_("Automatic"));
	gtk_widget_ref (autoframeskip_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "autoframeskip_checkbutton", autoframeskip_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (autoframeskip_checkbutton);
	gtk_table_attach (GTK_TABLE (frameskip_table), autoframeskip_checkbutton, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autoframeskip_checkbutton), target->autoframeskip);

	maxautoframeskip_combo = gtk_combo_new ();
	gtk_widget_ref (maxautoframeskip_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "maxautoframeskip_combo", maxautoframeskip_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (maxautoframeskip_combo);
	gtk_table_attach (GTK_TABLE (frameskip_table), maxautoframeskip_combo, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND), 0, 0);
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "0");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "1");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "2");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "3");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "4");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "5");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "6");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "7");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "8");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "9");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "10");
	maxautoframeskip_combo_items = g_list_append (maxautoframeskip_combo_items, (gpointer) "11");
	gtk_combo_set_popdown_strings (GTK_COMBO (maxautoframeskip_combo), maxautoframeskip_combo_items);
	g_list_free (maxautoframeskip_combo_items);

	maxautoframeskip_entry = GTK_COMBO (maxautoframeskip_combo)->entry;
	gtk_widget_ref (maxautoframeskip_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "maxautoframeskip_entry", maxautoframeskip_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (maxautoframeskip_entry);
	gtk_widget_set_size_request (maxautoframeskip_entry, 90, -1);
	gtk_editable_set_editable (GTK_EDITABLE (maxautoframeskip_entry), FALSE);
	g_snprintf(title,BUFFER_SIZE,"%i",target->maxautoframeskip);
	gtk_entry_set_text (GTK_ENTRY (maxautoframeskip_entry), title);
	gtk_widget_set_sensitive (maxautoframeskip_combo, target->autoframeskip);

	resolution_frame = gtk_frame_new (_("Resolution"));
	gtk_widget_ref (resolution_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "resolution_frame", resolution_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (resolution_frame);
	gtk_table_attach (GTK_TABLE (display_table), resolution_frame, 0, 2, 5, 6,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	table11 = gtk_table_new (3, 4, FALSE);
	gtk_widget_ref (table11);
	g_object_set_data_full (G_OBJECT (properties_windows), "table11", table11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (table11);
	gtk_container_add (GTK_CONTAINER (resolution_frame), table11);
	gtk_table_set_row_spacings (GTK_TABLE (table11), 1);
	gtk_table_set_col_spacings (GTK_TABLE (table11), 1);

	heightscale_label = gtk_label_new (_("Heightscale"));
	gtk_widget_ref (heightscale_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "heightscale_label", heightscale_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (heightscale_label);
	gtk_table_attach (GTK_TABLE (table11), heightscale_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (heightscale_label), 1, 0.5);

	widthscale_label = gtk_label_new (_("Widthscale"));
	gtk_widget_ref (widthscale_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "widthscale_label", widthscale_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (widthscale_label);
	gtk_table_attach (GTK_TABLE (table11), widthscale_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (widthscale_label), 1, 0.5);

	bpp_label = gtk_label_new (_("Bit per pixels"));
	gtk_widget_ref (bpp_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "bpp_label", bpp_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bpp_label);
	gtk_table_attach (GTK_TABLE (table11), bpp_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (bpp_label), 0, 0.5);

	heightscale_spinbutton_adj = gtk_adjustment_new (target->heightscale, 1, 8, 1, 10, 10);
	heightscale_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (heightscale_spinbutton_adj), 1, 0);
	gtk_widget_ref (heightscale_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "heightscale_spinbutton", heightscale_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (heightscale_spinbutton);
	gtk_table_attach (GTK_TABLE (table11), heightscale_spinbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 11, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (heightscale_spinbutton), TRUE);

	bpp_combo = gtk_combo_new ();
	gtk_widget_ref (bpp_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "bpp_combo", bpp_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bpp_combo);
	gtk_table_attach (GTK_TABLE (table11), bpp_combo, 1, 2, 2, 3,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 10, 0);
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("Auto"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("8 bits"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("16 bits"));
	bpp_combo_items = g_list_append (bpp_combo_items, (gpointer) _("32 bits"));
	gtk_combo_set_popdown_strings (GTK_COMBO (bpp_combo), bpp_combo_items);
	g_list_free (bpp_combo_items);

	bpp_combo_entry = GTK_COMBO (bpp_combo)->entry;
	gtk_widget_ref (bpp_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "bpp_combo_entry", bpp_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bpp_combo_entry);
	gtk_widget_set_size_request (bpp_combo_entry, 40, -1);
	gtk_editable_set_editable (GTK_EDITABLE (bpp_combo_entry), FALSE);
	switch(target->bpp)
	{
		case(8):
		case(16):
		case(32):
			g_snprintf(title,BUFFER_SIZE,_("%i bits"), target->bpp);
			break;
		/* case(0): or*/
		default:
			g_snprintf(title,BUFFER_SIZE,"%s",_("Auto"));
			break;

	}

	gtk_entry_set_text (GTK_ENTRY (bpp_combo_entry), title);

	widthscale_spinbutton_adj = gtk_adjustment_new (target->widthscale, 1, 8, 1, 10, 10);
	widthscale_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (widthscale_spinbutton_adj), 1, 0);
	gtk_widget_ref (widthscale_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "widthscale_spinbutton", widthscale_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (widthscale_spinbutton);
	gtk_table_attach (GTK_TABLE (table11), widthscale_spinbutton, 1, 2, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 10, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (widthscale_spinbutton), TRUE);

	arbheight_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(arbheight_entry), 4);
	gtk_widget_ref (arbheight_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "arbheight_entry", arbheight_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (arbheight_entry);
	gtk_table_attach (GTK_TABLE (table11), arbheight_entry, 3, 4, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (arbheight_entry, 40, -1);
	g_snprintf(title,BUFFER_SIZE,"%i",target->arbheight);
	gtk_entry_set_text (GTK_ENTRY(arbheight_entry), title);
	gtk_widget_set_sensitive (arbheight_entry, target->arbheight);

	arbheight_checkbutton = gtk_check_button_new_with_label (_("scale video to exactly this height"));
	gtk_widget_ref (arbheight_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "arbheight_checkbutton", arbheight_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (arbheight_checkbutton);
	gtk_table_attach (GTK_TABLE (table11), arbheight_checkbutton, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (arbheight_checkbutton), target->arbheight);

	autodouble_checkbutton = gtk_check_button_new_with_label (_("Autodouble"));
	gtk_widget_ref (autodouble_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "autodouble_checkbutton", autodouble_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (autodouble_checkbutton);
	gtk_table_attach (GTK_TABLE (table11), autodouble_checkbutton, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (autodouble_checkbutton), target->autodouble);

	rotation_frame = gtk_frame_new (_("Rotation"));
	gtk_widget_ref (rotation_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "rotation_frame", rotation_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rotation_frame);
	gtk_table_attach (GTK_TABLE (display_table), rotation_frame, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	vbox12 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox12);
	g_object_set_data_full (G_OBJECT (properties_windows), "vbox12", vbox12,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox12);
	gtk_container_add (GTK_CONTAINER (rotation_frame), vbox12);

	combo = gtk_combo_new ();
	gtk_widget_ref (combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "combo", combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (combo);
	gtk_box_pack_start (GTK_BOX (vbox12), combo, FALSE, FALSE, 0);
	combo_items = g_list_append (combo_items, (gpointer) _("None"));
	combo_items = g_list_append (combo_items, (gpointer) _("Clockwise"));
	combo_items = g_list_append (combo_items, (gpointer) _("Anti-clockwise"));
	gtk_combo_set_popdown_strings (GTK_COMBO (combo), combo_items);
	g_list_free (combo_items);

	rotation_combo_entry = GTK_COMBO (combo)->entry;
	gtk_widget_ref (rotation_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "rotation_combo_entry", rotation_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rotation_combo_entry);
	gtk_widget_set_size_request (rotation_combo_entry, 90, -1);
	gtk_editable_set_editable (GTK_EDITABLE (rotation_combo_entry), FALSE);

	if (target->ror)
		g_snprintf(title,BUFFER_SIZE,"%s",_("Clockwise"));
	else if (target->rol)
		g_snprintf(title,BUFFER_SIZE,"%s",_("Anti-clockwise"));
	else
		g_snprintf(title,BUFFER_SIZE,"%s",_("None"));
	gtk_entry_set_text (GTK_ENTRY (rotation_combo_entry), title);

	norotate_checkbutton = gtk_check_button_new_with_label (_("Do not apply rotation"));
	gtk_widget_ref (norotate_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "norotate_checkbutton", norotate_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (norotate_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), norotate_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (norotate_checkbutton), target->norotate);

	flipx_checkbutton = gtk_check_button_new_with_label (_("Flip screen upside-down"));
	gtk_widget_ref (flipx_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "flipx_checkbutton", flipx_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (flipx_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), flipx_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipx_checkbutton), target->flipx);

	flipy_checkbutton = gtk_check_button_new_with_label (_("Flip screen left-right"));
	gtk_widget_ref (flipy_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "flipy_checkbutton", flipy_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (flipy_checkbutton);
	gtk_box_pack_start (GTK_BOX (vbox12), flipy_checkbutton, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipy_checkbutton), target->flipy);

	display_label = gtk_label_new (_("Display"));
	gtk_widget_ref (display_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "display_label", display_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (display_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), display_label);

		
	gtk_widget_set_sensitive ( GTK_WIDGET(dirty_checkbutton), available_options->dirty);
	gtk_widget_set_sensitive(fts_label,!gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(fs_method_label,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));
	gtk_widget_set_sensitive(maxfs_label,gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton)));

	g_signal_connect (G_OBJECT (dirty_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (dirty_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (throttle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (throttle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (sleepidle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sleepidle_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (scanlines_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (scanlines_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (norotate_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (norotate_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (flipx_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (flipx_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (flipy_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (flipy_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (autodouble_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (autodouble_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (autoframeskip_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (autoframeskip_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arbheight_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arbheight_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (autoframeskip_checkbutton), "toggled",
				  G_CALLBACK (autoframeskip_toggled),
				  NULL);
	g_signal_connect_after (G_OBJECT (arbheight_checkbutton), "toggled",
			          G_CALLBACK (button_toggled),
			          G_OBJECT (arbheight_entry));

	g_signal_connect (G_OBJECT (effect_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (effect_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (rotation_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (rotation_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (frameskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (frameskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (maxautoframeskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (maxautoframeskip_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (bpp_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (bpp_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arbheight_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arbheight_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (frameskippercombo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (frameskippercombo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(brightness_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(brightness_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(gamma_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(gamma_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (widthscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (widthscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (heightscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (heightscale_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

}


void add_rendering_options_tab (GtkWidget    *properties_windows,
		               GtkNotebook  *target_notebook,
			       RomEntry     *rom,
			       GtkWidget    *apply_button,
			       GtkWidget    *reset_button,
			       guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;

	GtkWidget *rendering_table;
	GtkWidget *xfx_frame;
	GtkWidget *fxglide_table;
	GtkWidget *fxresolution_label;
	GtkWidget *fx_combo;
	GList *fx_combo_items = NULL;
	GtkWidget *svga_frame;
	GtkWidget *svga_table;
	GtkWidget *centery_label;
	GtkWidget *centerx_label;
	GtkWidget *photon_frame;
	GtkWidget *photon_table;
	GtkWidget *sdl_frame;
	GtkWidget *sdl_table;
	GtkWidget *gl_frame;
	GtkWidget *ogl_table;
	GtkWidget *gltexture_size_label;
	GtkWidget *cabinet_hbox;
	GtkWidget *glres_hbox;
	GList *glres_combo_items = NULL;
	GtkWidget *gllib_hbox;
	GtkWidget *gllib_label;
	GtkWidget *glulib_hbox;
	GtkWidget *glulib_label;
	GtkWidget *x11_frame;
	GtkWidget *x11_table;
	GtkWidget *video_mode_frame;
	GtkWidget *video_mode_table;
	GtkWidget *disablemode_label;
	GtkWidget *ggi_frame;
	GtkWidget *ggi_table;
	GtkWidget *ggix_label;
	GtkWidget *ggiy_label;
	GtkWidget *rendering_title_hbox;
	GtkWidget *rendering_pixmap;
	GtkWidget *rendering_title;
	GtkWidget *rendering_hseparator;
	GtkWidget *rendering_label;
	GtkWidget *yuv_yv12_label;
	GtkWidget *yuv_yv12_hbox;
	GtkWidget *xil_hbox;
	GList *xvgeom_combo_items = NULL;
	
	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;
	
	available_options = xmame_executable_get_options(current_exec);
	dirty_options_flag = FALSE;

	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	rendering_table = gtk_table_new (7, 9, FALSE);
	gtk_widget_ref (rendering_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_table", rendering_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), rendering_table);
	gtk_container_set_border_width (GTK_CONTAINER (rendering_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (rendering_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (rendering_table), 5);

/* X11 */
	x11_frame = gtk_frame_new (_("x11 options"));
	gtk_widget_ref (x11_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "x11_frame", x11_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (x11_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), x11_frame, 0, 3, 2, 6,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	x11_table = gtk_table_new (9, 1, FALSE);
	gtk_widget_ref (x11_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "x11_table", x11_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (x11_table);
	gtk_container_add (GTK_CONTAINER (x11_frame), x11_table);

	x11_mode_checkbutton = gtk_check_button_new_with_label (_("DGA fullscreen"));
	gtk_widget_ref (x11_mode_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "x11_mode_checkbutton", x11_mode_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (x11_mode_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), x11_mode_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cursor_checkbutton = gtk_check_button_new_with_label (_("Show cursor"));
	gtk_widget_ref (cursor_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "cursor_checkbutton", cursor_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cursor_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), cursor_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	mitshm_checkbutton = gtk_check_button_new_with_label (_("use MIT shared memory"));
	gtk_widget_ref (mitshm_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "mitshm_checkbutton", mitshm_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mitshm_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), mitshm_checkbutton, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	xvext_checkbutton = gtk_check_button_new_with_label (_("xv extension"));
	gtk_widget_ref (xvext_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xvext_checkbutton", xvext_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xvext_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), xvext_checkbutton, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);

	vidix_checkbutton = gtk_check_button_new_with_label (_("Vidix"));
	gtk_widget_ref (vidix_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "vidix_checkbutton", vidix_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vidix_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), vidix_checkbutton, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	xv_table2 = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (xv_table2);
	g_object_set_data_full (G_OBJECT (properties_windows), "xv_table2", xv_table2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xv_table2);
	gtk_table_attach (GTK_TABLE (x11_table), xv_table2, 0, 1, 5, 6,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);

	xvfullscreen_checkbutton = gtk_check_button_new_with_label (_("Fullscreen"));
	gtk_widget_ref (xvfullscreen_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xvfullscreen_checkbutton", xvfullscreen_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xvfullscreen_checkbutton);
	gtk_table_attach (GTK_TABLE (xv_table2), xvfullscreen_checkbutton, 0, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	xvgeom_checkbutton = gtk_check_button_new_with_label (_("Geometry : "));
	gtk_widget_ref (xvgeom_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xvgeom_checkbutton", xvgeom_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xvgeom_checkbutton);
	gtk_table_attach (GTK_TABLE (xv_table2), xvgeom_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	xvgeom_combo = gtk_combo_new ();
	gtk_widget_ref (xvgeom_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "xvgeom_combo", xvgeom_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xvgeom_combo);
	gtk_table_attach (GTK_TABLE (xv_table2), xvgeom_combo, 1, 2, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (xvgeom_combo, 100, -1);
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "320x200");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "640x480");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "800x600");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1024x768");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1280x1024");
	xvgeom_combo_items = g_list_append (xvgeom_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (xvgeom_combo), xvgeom_combo_items);
	g_list_free (xvgeom_combo_items);

	xvgeom_entry = GTK_COMBO (xvgeom_combo)->entry;
	gtk_widget_ref (xvgeom_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "xvgeom_entry", xvgeom_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xvgeom_entry);
	gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), "640x480");

	yuv_yv12_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (yuv_yv12_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "yuv_yv12_hbox", yuv_yv12_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yuv_yv12_hbox);
	gtk_table_attach (GTK_TABLE (xv_table2), yuv_yv12_hbox, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	yuv_yv12_label = gtk_label_new (_("Force "));
	gtk_widget_ref (yuv_yv12_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "yuv_yv12_label", yuv_yv12_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yuv_yv12_label);
	gtk_box_pack_start (GTK_BOX (yuv_yv12_hbox), yuv_yv12_label, FALSE, FALSE, 0);
	gtk_misc_set_alignment (GTK_MISC (yuv_yv12_label), 0, 0.5);

	yuv_checkbutton = gtk_check_button_new_with_label (_("YUV"));
	gtk_widget_ref (yuv_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "yuv_checkbutton", yuv_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yuv_checkbutton);
	gtk_box_pack_start (GTK_BOX (yuv_yv12_hbox), yuv_checkbutton, FALSE, FALSE, 0);

	yv12_checkbutton = gtk_check_button_new_with_label (_("YV12 mode"));
	gtk_widget_ref (yv12_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "yv12_checkbutton", yv12_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (yv12_checkbutton);
	gtk_box_pack_start (GTK_BOX (yuv_yv12_hbox), yv12_checkbutton, FALSE, FALSE, 0);

	xsync_checkbutton = gtk_check_button_new_with_label (_("X Synch"));
	gtk_widget_ref (xsync_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xsync_checkbutton", xsync_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xsync_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), xsync_checkbutton, 0, 1, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	privatecmap_checkbutton = gtk_check_button_new_with_label (_("Private colormap"));
	gtk_widget_ref (privatecmap_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "privatecmap_checkbutton", privatecmap_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (privatecmap_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), privatecmap_checkbutton, 0, 1, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
/*
	xil_checkbutton = gtk_check_button_new_with_label (_("use XIL for scaling"));
	gtk_widget_ref (xil_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xil_checkbutton", xil_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xil_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), xil_checkbutton, 0, 1, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	mtxil_checkbutton = gtk_check_button_new_with_label (_("multi threading of XIL"));
	gtk_widget_ref (mtxil_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "mtxil_checkbutton", mtxil_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mtxil_checkbutton);
	gtk_table_attach (GTK_TABLE (x11_table), mtxil_checkbutton, 0, 1, 9, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
*/
	xil_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (xil_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "xil_hbox", xil_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xil_hbox);
	gtk_table_attach (GTK_TABLE (x11_table), xil_hbox, 0, 1, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	xil_checkbutton = gtk_check_button_new_with_label (_("XIL scaling"));
	gtk_widget_ref (xil_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "xil_checkbutton", xil_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xil_checkbutton);
	/*gtk_table_attach (GTK_TABLE (xil_hbox), xil_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);*/
	gtk_box_pack_start (GTK_BOX (xil_hbox), xil_checkbutton, FALSE, FALSE, 0);

	mtxil_checkbutton = gtk_check_button_new_with_label (_("multi threading"));
	gtk_widget_ref (mtxil_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "mtxil_checkbutton", mtxil_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mtxil_checkbutton);
	/*gtk_table_attach (GTK_TABLE (xil_hbox), mtxil_checkbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);*/
	gtk_box_pack_start (GTK_BOX (xil_hbox),mtxil_checkbutton , FALSE, FALSE, 0);
		
/* Open GL */
	gl_frame = gtk_frame_new (_("Open GL options"));
	gtk_widget_ref (gl_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "gl_frame", gl_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gl_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), gl_frame, 3, 6, 2, 5,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	ogl_table = gtk_table_new (9, 4, FALSE);
	gtk_widget_ref (ogl_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "ogl_table", ogl_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ogl_table);
	gtk_container_add (GTK_CONTAINER (gl_frame), ogl_table);

	glfullscreen_checkbutton = gtk_check_button_new_with_label (_("Full Screen"));
	gtk_widget_ref (glfullscreen_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glfullscreen_checkbutton", glfullscreen_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glfullscreen_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glfullscreen_checkbutton, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	gltexture_size_spinbutton_adj = gtk_adjustment_new (target->gltexture_size, 0, 1000, 1, 10, 10);
	gltexture_size_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (gltexture_size_spinbutton_adj), 1, 0);
	gtk_widget_ref (gltexture_size_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "gltexture_size_spinbutton", gltexture_size_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gltexture_size_spinbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), gltexture_size_spinbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	glext78_checkbutton = gtk_check_button_new_with_label (_("GL extension #78"));
	gtk_widget_ref (glext78_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glext78_checkbutton", glext78_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glext78_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glext78_checkbutton, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), TRUE);

	glbilinear_checkbutton = gtk_check_button_new_with_label (_("Bilinear filtering"));
	gtk_widget_ref (glbilinear_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glbilinear_checkbutton", glbilinear_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glbilinear_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glbilinear_checkbutton, 2, 4, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), TRUE);

	gldrawbitmap_checkbutton = gtk_check_button_new_with_label (_("Draw bitmap"));
	gtk_widget_ref (gldrawbitmap_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "gldrawbitmap_checkbutton", gldrawbitmap_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gldrawbitmap_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), gldrawbitmap_checkbutton, 0, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), TRUE);

	glantialias_checkbutton = gtk_check_button_new_with_label (_("Antialiasing"));
	gtk_widget_ref (glantialias_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glantialias_checkbutton", glantialias_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glantialias_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glantialias_checkbutton, 0, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), TRUE);

	glalphablending_checkbutton = gtk_check_button_new_with_label (_("Alphablending"));
	gtk_widget_ref (glalphablending_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glalphablending_checkbutton", glalphablending_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glalphablending_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glalphablending_checkbutton, 2, 4, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), TRUE);

	gldblbuffer_checkbutton = gtk_check_button_new_with_label (_("Double buffering"));
	gtk_widget_ref (gldblbuffer_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "gldblbuffer_checkbutton", gldblbuffer_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gldblbuffer_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), gldblbuffer_checkbutton, 2, 4, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), TRUE);

	gltexture_size_label = gtk_label_new (_("texture size"));
	gtk_widget_ref (gltexture_size_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "gltexture_size_label", gltexture_size_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gltexture_size_label);
	gtk_table_attach (GTK_TABLE (ogl_table), gltexture_size_label, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (gltexture_size_label), 0, 0.5);

	glforceblitmode_checkbutton = gtk_check_button_new_with_label (_("True color blitter"));
	gtk_widget_ref (glforceblitmode_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glforceblitmode_checkbutton", glforceblitmode_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glforceblitmode_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glforceblitmode_checkbutton, 2, 4, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cabinet_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (cabinet_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "cabinet_hbox", cabinet_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cabinet_hbox);
	gtk_table_attach (GTK_TABLE (ogl_table), cabinet_hbox, 0, 4, 5, 6,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	cabview_checkbutton = gtk_check_button_new_with_label (_("Cabinet model : "));
	gtk_widget_ref (cabview_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "cabview_checkbutton", cabview_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cabview_checkbutton);
	gtk_box_pack_start (GTK_BOX (cabinet_hbox), cabview_checkbutton, FALSE, FALSE, 0);

	cabinet_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(cabinet_entry), 20);
	gtk_widget_ref (cabinet_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "cabinet_entry", cabinet_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cabinet_entry);
	gtk_box_pack_start (GTK_BOX (cabinet_hbox), cabinet_entry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (cabinet_entry, 115, -1);

	glres_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (glres_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "glres_hbox", glres_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glres_hbox);
	gtk_table_attach (GTK_TABLE (ogl_table), glres_hbox, 0, 4, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	glres_checkbutton = gtk_check_button_new_with_label (_("Resolution"));
	gtk_widget_ref (glres_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glres_checkbutton", glres_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glres_checkbutton);
	gtk_box_pack_start (GTK_BOX (glres_hbox), glres_checkbutton, FALSE, FALSE, 0);

	glres_combo = gtk_combo_new ();
	gtk_widget_ref (glres_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "glres_combo", glres_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glres_combo);
	gtk_box_pack_start (GTK_BOX (glres_hbox), glres_combo, FALSE, FALSE, 0);
	gtk_widget_set_size_request (glres_combo, 95, -1);
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "320x200");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "640x480");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "800x600");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1024x768");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1280x1024");
	glres_combo_items = g_list_append (glres_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (glres_combo), glres_combo_items);
	g_list_free (glres_combo_items);

	glres_combo_entry = GTK_COMBO (glres_combo)->entry;
	gtk_widget_ref (glres_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "glres_combo_entry", glres_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glres_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (glres_combo_entry), "640x480");

	gllib_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (gllib_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "gllib_hbox", gllib_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gllib_hbox);
	gtk_table_attach (GTK_TABLE (ogl_table), gllib_hbox, 0, 4, 7, 8,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	gllib_label = gtk_label_new (_("OpenGL Library : "));
	gtk_widget_ref (gllib_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "gllib_label", gllib_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gllib_label);
	gtk_box_pack_start (GTK_BOX (gllib_hbox), gllib_label, FALSE, FALSE, 0);

	gllib_entry = gtk_entry_new ();
	gtk_widget_ref (gllib_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "gllib_entry", gllib_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gllib_entry);
	gtk_box_pack_start (GTK_BOX (gllib_hbox), gllib_entry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (gllib_entry, 121, -1);
	gtk_entry_set_text (GTK_ENTRY (gllib_entry), "libGL.so");

	glulib_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (glulib_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "glulib_hbox", glulib_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glulib_hbox);
	gtk_table_attach (GTK_TABLE (ogl_table), glulib_hbox, 0, 4, 8, 9,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	glulib_label = gtk_label_new (_("GLU Library : "));
	gtk_widget_ref (glulib_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "glulib_label", glulib_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glulib_label);
	gtk_box_pack_start (GTK_BOX (glulib_hbox), glulib_label, FALSE, FALSE, 0);

	glulib_entry = gtk_entry_new ();
	gtk_widget_ref (glulib_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "glulib_entry", glulib_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glulib_entry);
	gtk_box_pack_start (GTK_BOX (glulib_hbox), glulib_entry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (glulib_entry, 145, -1);
	gtk_entry_set_text (GTK_ENTRY (glulib_entry), "libGLU.so");

	glcolormod_checkbutton = gtk_check_button_new_with_label (_("Color modulation"));
	gtk_widget_ref (glcolormod_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glcolormod_checkbutton", glcolormod_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glcolormod_checkbutton);
	gtk_table_attach (GTK_TABLE (ogl_table), glcolormod_checkbutton, 2, 4, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), TRUE);

/* SDL */
	sdl_frame = gtk_frame_new (_("SDL options"));
	gtk_widget_ref (sdl_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_frame", sdl_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sdl_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), sdl_frame, 6, 9, 2, 3,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	sdl_table = gtk_table_new (3, 2, FALSE);
	gtk_widget_ref (sdl_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_table", sdl_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sdl_table);
	gtk_container_add (GTK_CONTAINER (sdl_frame), sdl_table);

	fullscreen_checkbutton = gtk_check_button_new_with_label (_("Full Screen"));
	gtk_widget_ref (fullscreen_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "fullscreen_checkbutton", fullscreen_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fullscreen_checkbutton);
	gtk_table_attach (GTK_TABLE (sdl_table), fullscreen_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	sdl_modes_checkbutton = gtk_check_button_new_with_label (_("Auto Resolution"));
	gtk_widget_ref (sdl_modes_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_modes_checkbutton", sdl_modes_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sdl_modes_checkbutton);
	gtk_table_attach (GTK_TABLE (sdl_table), sdl_modes_checkbutton, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	sdl_modes_label = gtk_label_new (_("SDL Modes:"));
	gtk_widget_ref (sdl_modes_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_modes_label", sdl_modes_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sdl_modes_label);
	gtk_table_attach (GTK_TABLE (sdl_table), sdl_modes_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (sdl_modes_label), 0.9, 0.5);

	sdl_modes_spinbutton_adj = gtk_adjustment_new (target->modenumber, 0, 15, 1, 10, 10);
	sdl_modes_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (sdl_modes_spinbutton_adj), 1, 0);
	gtk_widget_ref (sdl_modes_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_modes_spinbutton", sdl_modes_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (sdl_table), sdl_modes_spinbutton, 1, 2, 2, 3,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	
	sdl_modes_combo = gtk_combo_new ();
	gtk_widget_ref (sdl_modes_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_mode_combo", sdl_modes_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_table_attach (GTK_TABLE (sdl_table), sdl_modes_combo, 1, 2, 2, 3,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (sdl_modes_combo, 90, -1);
	/* need to set the glist null here otherwise, got an strange element that will crach the app */
	sdl_modes_combo_items = NULL;
	if(current_exec->sdl_modes_hash_table) 
	{
		/*g_hash_table_foreach(sdl_modes_hash_table,
        	                     (GHFunc)sdl_modes_combo_add,
        	                     NULL);*/
		/* we are using this funtion instead of the previous one like mixer and dsp because we want sdlmodes ordered. */
		gint k;
		gchar *clef;
		gpointer *sdl_mode;
		k=0;
		clef = g_strdup_printf("%i",k);
		while ((sdl_mode = g_hash_table_lookup(current_exec->sdl_modes_hash_table,clef)))
		{
			sdl_modes_combo_items = g_list_append (sdl_modes_combo_items, sdl_mode);
			GXMAME_DEBUG("\t %s added",(gchar *)sdl_mode);
			k++;
			g_free(clef);
			clef = g_strdup_printf("%i",k);
		}
		g_free(clef);

		gtk_combo_set_popdown_strings (GTK_COMBO (sdl_modes_combo), sdl_modes_combo_items);
		g_list_free (sdl_modes_combo_items);
	}
		
	sdl_modes_entry = GTK_COMBO (sdl_modes_combo)->entry;
	gtk_widget_ref (sdl_modes_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "sdl_modes_entry", sdl_modes_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sdl_modes_entry);

/* FX Glide */
	xfx_frame = gtk_frame_new (_("FX (Glide) options"));
	gtk_widget_ref (xfx_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "xfx_frame", xfx_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xfx_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), xfx_frame, 6, 9, 3, 4,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	fxglide_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (fxglide_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "fxglide_table", fxglide_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fxglide_table);
	gtk_container_add (GTK_CONTAINER (xfx_frame), fxglide_table);

	fxresolution_label = gtk_label_new (_("Resolution : "));
	gtk_widget_ref (fxresolution_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "fxresolution_label", fxresolution_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fxresolution_label);
	gtk_table_attach (GTK_TABLE (fxglide_table), fxresolution_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (fxresolution_label), 0, 0.5);

	fxgkeepaspect_checkbutton = gtk_check_button_new_with_label (_("keep aspect ratio"));
	gtk_widget_ref (fxgkeepaspect_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "fxgkeepaspect_checkbutton", fxgkeepaspect_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fxgkeepaspect_checkbutton);
	gtk_table_attach (GTK_TABLE (fxglide_table), fxgkeepaspect_checkbutton, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	fx_combo = gtk_combo_new ();
	gtk_widget_ref (fx_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "fx_combo", fx_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fx_combo);
	gtk_table_attach (GTK_TABLE (fxglide_table), fx_combo, 1, 2, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (fx_combo, 90, -1);
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "320x200");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "640x480");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "800x600");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1024x768");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1280x1024");
	fx_combo_items = g_list_append (fx_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (fx_combo), fx_combo_items);
	g_list_free (fx_combo_items);

	fx_entry = GTK_COMBO (fx_combo)->entry;
	gtk_widget_ref (fx_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "fx_entry", fx_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fx_entry);
	gtk_entry_set_text (GTK_ENTRY (fx_entry), "640x480");

/* Photon */
	photon_frame = gtk_frame_new (_("Photon options"));
	gtk_widget_ref (photon_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "photon_frame", photon_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (photon_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), photon_frame, 6, 9, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	photon_table = gtk_table_new (2, 1, FALSE);
	gtk_widget_ref (photon_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "photon_table", photon_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (photon_table);
	gtk_container_add (GTK_CONTAINER (photon_frame), photon_table);

	render_mode_checkbutton = gtk_check_button_new_with_label (_("Full Screen"));
	gtk_widget_ref (render_mode_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "render_mode_checkbutton", render_mode_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (render_mode_checkbutton);
	gtk_table_attach (GTK_TABLE (photon_table), render_mode_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	phcursor_checkbutton = gtk_check_button_new_with_label (_("Show cursor"));
	gtk_widget_ref (phcursor_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "phcursor_checkbutton", phcursor_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (phcursor_checkbutton);
	gtk_table_attach (GTK_TABLE (photon_table), phcursor_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Video Mode */
	video_mode_frame = gtk_frame_new (_("Video Mode"));
	gtk_widget_ref (video_mode_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "video_mode_frame", video_mode_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (video_mode_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), video_mode_frame, 0, 3, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	video_mode_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (video_mode_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "video_mode_table", video_mode_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (video_mode_table);
	gtk_container_add (GTK_CONTAINER (video_mode_frame), video_mode_table);

	keepaspect_checkbutton = gtk_check_button_new_with_label (_("Keep aspect ratio"));
	gtk_widget_ref (keepaspect_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "keepaspect_checkbutton", keepaspect_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keepaspect_checkbutton);
	gtk_table_attach (GTK_TABLE (video_mode_table), keepaspect_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	displayaspectratio_entry = gtk_entry_new ();
	gtk_widget_ref (displayaspectratio_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "displayaspectratio_entry", displayaspectratio_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (displayaspectratio_entry);
	gtk_table_attach (GTK_TABLE (video_mode_table), displayaspectratio_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (displayaspectratio_entry, 72, -1);
	gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), "1.33");

	disablemode_label = gtk_label_new (_("Disable mode : "));
	gtk_widget_ref (disablemode_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "disablemode_label", disablemode_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (disablemode_label);
	gtk_table_attach (GTK_TABLE (video_mode_table), disablemode_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (disablemode_label), 0, 0.5);

	disable_mode_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(disable_mode_entry), 14);
	gtk_widget_ref (disable_mode_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "disable_mode_entry", disable_mode_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (disable_mode_entry);
	gtk_table_attach (GTK_TABLE (video_mode_table), disable_mode_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (disable_mode_entry, 72, -1);

/* ggi */
	ggi_frame = gtk_frame_new (_("GGI options"));
	gtk_widget_ref (ggi_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggi_frame", ggi_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggi_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), ggi_frame, 3, 5, 5, 7,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	ggi_table = gtk_table_new (3, 1, FALSE);
	gtk_widget_ref (ggi_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggi_table", ggi_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggi_table);
	gtk_container_add (GTK_CONTAINER (ggi_frame), ggi_table);

	ggilinear_checkbutton = gtk_check_button_new_with_label (_("linear framebuffer (fast)"));
	gtk_widget_ref (ggilinear_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggilinear_checkbutton", ggilinear_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggilinear_checkbutton);
	gtk_table_attach (GTK_TABLE (ggi_table), ggilinear_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	ggi_force_resolution_checkbutton = gtk_check_button_new_with_label (_("Force resolutions"));
	gtk_widget_ref (ggi_force_resolution_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggi_force_resolution_checkbutton", ggi_force_resolution_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggi_force_resolution_checkbutton);
	gtk_table_attach (GTK_TABLE (ggi_table), ggi_force_resolution_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	ggi_res_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (ggi_res_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggi_res_table", ggi_res_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggi_res_table);
	gtk_table_attach (GTK_TABLE (ggi_table), ggi_res_table, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 5, 0);

	ggix_label = gtk_label_new ("X : ");
	gtk_widget_ref (ggix_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggix_label", ggix_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggix_label);
	gtk_table_attach (GTK_TABLE (ggi_res_table), ggix_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
	gtk_misc_set_alignment (GTK_MISC (ggix_label), 0, 0.5);

	ggix_spinbutton_adj = gtk_adjustment_new (target->xres, 320, 2048, 128, 128, 10);
	ggix_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (ggix_spinbutton_adj), 1, 0);
	gtk_widget_ref (ggix_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggix_spinbutton", ggix_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggix_spinbutton);
	gtk_table_attach (GTK_TABLE (ggi_res_table), ggix_spinbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (ggix_spinbutton, 60, -1);

	ggiy_label = gtk_label_new ("Y : ");
	gtk_widget_ref (ggiy_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggiy_label", ggiy_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggiy_label);
	gtk_table_attach (GTK_TABLE (ggi_res_table), ggiy_label, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 4, 0);
	gtk_misc_set_alignment (GTK_MISC (ggiy_label), 0, 0.5);

	ggiy_spinbutton_adj = gtk_adjustment_new (target->yres, 200, 2048, 1, 256, 10);
	ggiy_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (ggiy_spinbutton_adj), 1, 0);
	gtk_widget_ref (ggiy_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "ggiy_spinbutton", ggiy_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ggiy_spinbutton);
	gtk_table_attach (GTK_TABLE (ggi_res_table), ggiy_spinbutton, 3, 4, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (ggiy_spinbutton, 60, -1);

/* SVGA */
	svga_frame = gtk_frame_new (_("SVGA options"));
	gtk_widget_ref (svga_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "svga_frame", svga_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (svga_frame);
	gtk_table_attach (GTK_TABLE (rendering_table), svga_frame, 5, 9, 5, 7,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL), 0, 0);

	svga_table = gtk_table_new (4, 1, FALSE);
	gtk_widget_ref (svga_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "svga_table", svga_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (svga_table);
	gtk_container_add (GTK_CONTAINER (svga_frame), svga_table);

	planar_checkbutton = gtk_check_button_new_with_label (_("planar (modeX) modes"));
	gtk_widget_ref (planar_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "planar_checkbutton", planar_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (planar_checkbutton);
	gtk_table_attach (GTK_TABLE (svga_table), planar_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	linear_checkbutton = gtk_check_button_new_with_label (_("linear framebuffer (fast)"));
	gtk_widget_ref (linear_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "linear_checkbutton", linear_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (linear_checkbutton);
	gtk_table_attach (GTK_TABLE (svga_table), linear_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	tweaked_mode_checkbutton = gtk_check_button_new_with_label (_("Use tweaked VGA modes"));
	gtk_widget_ref (tweaked_mode_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "tweaked_mode_checkbutton", tweaked_mode_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (tweaked_mode_checkbutton);
	gtk_table_attach (GTK_TABLE (svga_table), tweaked_mode_checkbutton, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	svga_tweak_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (svga_tweak_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "svga_tweak_table", svga_tweak_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (svga_tweak_table);
	gtk_table_attach (GTK_TABLE (svga_table), svga_tweak_table, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 5, 0);

	centerx_label = gtk_label_new (_("Center X : "));
	gtk_widget_ref (centerx_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "centerx_label", centerx_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (centerx_label);
	gtk_table_attach (GTK_TABLE (svga_tweak_table), centerx_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (centerx_label), 0, 0.5);

	centerx_spinbutton_adj = gtk_adjustment_new (target->centerx, -1000, 1000, 1, 10, 10);
	centerx_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (centerx_spinbutton_adj), 1, 0);
	gtk_widget_ref (centerx_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "centerx_spinbutton", centerx_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (centerx_spinbutton);
	gtk_table_attach (GTK_TABLE (svga_tweak_table), centerx_spinbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	centery_label = gtk_label_new (_("Center Y : "));
	gtk_widget_ref (centery_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "centery_label", centery_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (centery_label);
	gtk_table_attach (GTK_TABLE (svga_tweak_table), centery_label, 2, 3, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (centery_label), 0, 0.5);

	centery_spinbutton_adj = gtk_adjustment_new (target->centery, -500, 500, 1, 10, 10);
	centery_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (centery_spinbutton_adj), 1, 0);
	gtk_widget_ref (centery_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "centery_spinbutton", centery_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (centery_spinbutton);
	gtk_table_attach (GTK_TABLE (svga_tweak_table), centery_spinbutton, 3, 4, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

/*end modes*/
	rendering_title_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (rendering_title_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_title_hbox", rendering_title_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_title_hbox);
	gtk_table_attach (GTK_TABLE (rendering_table), rendering_title_hbox, 0, 7, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				display_xpm);
	rendering_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (rendering_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_pixmap", rendering_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_pixmap);
	gtk_box_pack_start (GTK_BOX (rendering_title_hbox), rendering_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (rendering_pixmap), 10, 0);

	if (rom) 
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		rendering_title = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		rendering_title = gtk_label_new (_("Global game options\nDefault options used by all games"));
	gtk_widget_ref (rendering_title);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_title", rendering_title,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_title);
	gtk_box_pack_start (GTK_BOX (rendering_title_hbox), rendering_title, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (rendering_title), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (rendering_title), TRUE);
	gtk_misc_set_padding (GTK_MISC (rendering_title), 10, 0);

	rendering_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (rendering_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_hseparator", rendering_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_hseparator);
	gtk_table_attach (GTK_TABLE (rendering_table), rendering_hseparator, 0, 7, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	rendering_label = gtk_label_new (_("Rendering"));
	gtk_widget_ref (rendering_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "rendering_label", rendering_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rendering_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), rendering_label);

	/* set sensitive only the good target frame */
	gtk_widget_set_sensitive(GTK_WIDGET(x11_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(svga_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(ggi_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(gl_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(xfx_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(sdl_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(photon_frame),FALSE);
	gtk_widget_set_sensitive(GTK_WIDGET(video_mode_frame),FALSE);
	if(!strcmp(current_exec->target,"x11"))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(x11_frame), TRUE);
		if(available_options->video_mode)
			gtk_widget_set_sensitive(GTK_WIDGET(video_mode_frame),TRUE);
	}
	else if(!strcmp(current_exec->target,"svgalib"))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(svga_frame),TRUE);
		if(available_options->video_mode)
			gtk_widget_set_sensitive(GTK_WIDGET(video_mode_frame),TRUE);
	}
	else if(!strcmp(current_exec->target,"ggi"))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(ggi_frame),TRUE);
		if(available_options->video_mode)
			gtk_widget_set_sensitive(GTK_WIDGET(video_mode_frame),TRUE);
	}
	else if(!strcmp(current_exec->target,"xgl"))
		gtk_widget_set_sensitive(GTK_WIDGET(gl_frame),TRUE);
	else if(!strcmp(current_exec->target,"xfx"))
		gtk_widget_set_sensitive(GTK_WIDGET(xfx_frame),TRUE);
	else if(!strcmp(current_exec->target,"svgafx"))
		gtk_widget_set_sensitive(GTK_WIDGET(xfx_frame),TRUE);
	else if(!strcmp(current_exec->target,"SDL"))
		gtk_widget_set_sensitive(GTK_WIDGET(sdl_frame),TRUE);
	else if(!strcmp(current_exec->target,"photon2"))
		gtk_widget_set_sensitive(GTK_WIDGET(photon_frame),TRUE);
	
	/* Open GL frame */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glfullscreen_checkbutton), target->glfullscreen);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), target->gldblbuffer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), target->glbilinear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), target->glext78);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glforceblitmode_checkbutton), target->glforceblitmode);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), target->gldrawbitmap);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), target->glcolormod);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), target->glantialias);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), target->glalphablending);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cabview_checkbutton), target->cabview);
	gtk_widget_set_sensitive(GTK_WIDGET(cabinet_entry),target->cabview);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glres_checkbutton), target->glres_flag);
	gtk_entry_set_text (GTK_ENTRY (cabinet_entry), target->cabinet);
	gtk_widget_set_sensitive(GTK_WIDGET(glres_combo),target->glres_flag);
	gtk_entry_set_text (GTK_ENTRY (gllib_entry), target->gllibname);
	gtk_entry_set_text (GTK_ENTRY (glulib_entry), target->glulibname);

	g_signal_connect (G_OBJECT (glfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gldblbuffer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldblbuffer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gltexture_size_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gltexture_size_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glbilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glbilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glext78_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glext78_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glforceblitmode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glforceblitmode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gldrawbitmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldrawbitmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glcolormod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glcolormod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glantialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glantialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glalphablending_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glalphablending_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cabview_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cabview_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (cabview_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (cabinet_entry));
	g_signal_connect (G_OBJECT (cabinet_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cabinet_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glres_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glres_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (glres_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (glres_combo));
	g_signal_connect (G_OBJECT (glres_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glres_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gllib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gllib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glulib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glulib_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	/* x11 frame */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (x11_mode_checkbutton), target->x11_mode);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cursor_checkbutton), target->cursor);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mitshm_checkbutton), target->mitshm);
	gtk_widget_set_sensitive (GTK_WIDGET(mitshm_checkbutton), available_options->mitshm);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvext_checkbutton), target->xvext);
	gtk_widget_set_sensitive (GTK_WIDGET(vidix_checkbutton), available_options->vidix);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vidix_checkbutton), target->vidix);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvgeom_checkbutton), target->xvgeom_flag);
	gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), target->geometry);
	gtk_widget_set_sensitive (GTK_WIDGET(xvext_checkbutton), available_options->xvext &&
								available_options->mitshm && 
								target->mitshm);
	gtk_widget_set_sensitive(GTK_WIDGET(xv_table2), (target->xvext &&
								available_options->xvext && 
								available_options->mitshm &&
								target->mitshm) ||
								(available_options->vidix &&
								target->vidix));
	gtk_widget_set_sensitive(GTK_WIDGET(xvgeom_combo), target->xvgeom_flag /*&& 
								available_options.xvext
								available_options.mitshm && 
								target->mitshm &&
								target->xvext && 
								*/);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (yuv_checkbutton), target->yuv);
	gtk_widget_set_sensitive(GTK_WIDGET(yuv_checkbutton),available_options->yuv);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (yv12_checkbutton), target->yv12);
	gtk_widget_set_sensitive(GTK_WIDGET(yv12_checkbutton),available_options->yv12);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvfullscreen_checkbutton), target->xvfullscreen);
	gtk_widget_set_sensitive(GTK_WIDGET(xvfullscreen_checkbutton),available_options->fullscreen);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xsync_checkbutton), target->xsync);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (privatecmap_checkbutton), target->privatecmap);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xil_checkbutton), target->xil);
	gtk_widget_set_sensitive(GTK_WIDGET(mtxil_checkbutton),target->xil);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mtxil_checkbutton), target->mtxil);
	g_signal_connect (G_OBJECT (x11_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (x11_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (mitshm_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mitshm_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	if(available_options->xvext)
	{
		g_signal_connect_after (G_OBJECT (mitshm_checkbutton), "toggled",
				    G_CALLBACK (button_toggled),
				    xvext_checkbutton);
	}
	g_signal_connect_after (G_OBJECT (xvext_checkbutton), "toggled",
			    G_CALLBACK (newext_toggled),
			    xv_table2);
	g_signal_connect_after (G_OBJECT (vidix_checkbutton), "toggled",
			    G_CALLBACK (newext_toggled),
			    xv_table2);
	/* xvext exclude x11 and vidix */
	g_signal_connect_after (G_OBJECT (xvext_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    x11_mode_checkbutton);
	g_signal_connect_after (G_OBJECT (xvext_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    vidix_checkbutton);
	/* vidix exclude xvext and x11 */
	g_signal_connect_after (G_OBJECT (vidix_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    xvext_checkbutton);
	g_signal_connect_after (G_OBJECT (vidix_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    x11_mode_checkbutton);
	/* x11 exclude xvext and vidix */
	g_signal_connect_after (G_OBJECT (x11_mode_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    xvext_checkbutton);
	g_signal_connect_after (G_OBJECT (x11_mode_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    vidix_checkbutton);

	g_signal_connect (G_OBJECT (xvext_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvext_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (vidix_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (vidix_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xvgeom_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvgeom_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (yuv_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (yuv_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (yv12_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (yv12_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xvfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xvfullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (yuv_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			   yv12_checkbutton );
	g_signal_connect_after (G_OBJECT (yv12_checkbutton), "toggled",
			    G_CALLBACK (unactivate_checkbutton),
			    yuv_checkbutton);
	g_signal_connect_after (G_OBJECT (xvgeom_checkbutton), "toggled",
			    G_CALLBACK (button_toggled),
			    xvgeom_combo);

	g_signal_connect (G_OBJECT (xsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (privatecmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (privatecmap_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (xil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (xil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (xil_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mtxil_checkbutton));
	g_signal_connect (G_OBJECT (mtxil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mtxil_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	/*** FX glide related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fxgkeepaspect_checkbutton), target->fxgkeepaspect);
	gtk_entry_set_text (GTK_ENTRY (fx_entry), target->resolution);
	gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_label),!(target->sdl_auto_mode));

	g_signal_connect (G_OBJECT (fxgkeepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fxgkeepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (fx_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fx_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	/*** SDL related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fullscreen_checkbutton), target->fullscreen);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sdl_modes_checkbutton), (target->sdl_auto_mode));

	g_signal_connect (G_OBJECT (fullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fullscreen_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (sdl_modes_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sdl_modes_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
				  G_CALLBACK (not_button_toggled),
				  sdl_modes_label);

	/* only show the combobox if sdl_modes_hash_table exist */
	if (current_exec->sdl_modes_hash_table)
	{
		g_hash_table_foreach(current_exec->sdl_modes_hash_table,
             	                (GHFunc)sdl_modes_combo_comp,
             	                target);
		gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_combo),!(target->sdl_auto_mode));
		gtk_widget_show (sdl_modes_combo);
		g_signal_connect (G_OBJECT (sdl_modes_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (sdl_modes_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
					  G_CALLBACK (not_button_toggled),
					  sdl_modes_combo);
	}
	else
	{
		gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_spinbutton),!(target->sdl_auto_mode));
		gtk_widget_show (sdl_modes_spinbutton);
		g_signal_connect (G_OBJECT (sdl_modes_spinbutton), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (sdl_modes_spinbutton), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (sdl_modes_checkbutton), "toggled",
					  G_CALLBACK (not_button_toggled),
					  sdl_modes_spinbutton);
	}
	
	
	/*** Photon2 related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (render_mode_checkbutton), target->render_mode);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (phcursor_checkbutton), !(target->phcursor));

	g_signal_connect (G_OBJECT (render_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (render_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (phcursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (phcursor_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	
	/*** SVGA related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (planar_checkbutton), target->planar);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (linear_checkbutton), target->linear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tweaked_mode_checkbutton), target->tweak);
	gtk_widget_set_sensitive(GTK_WIDGET(svga_tweak_table),target->tweak);

	g_signal_connect (G_OBJECT (planar_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (planar_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (linear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (linear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (tweaked_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (tweaked_mode_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (tweaked_mode_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  svga_tweak_table);
	g_signal_connect (G_OBJECT (centerx_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (centerx_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (centery_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (centery_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);


	/*** GGI related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggilinear_checkbutton), target->ggilinear);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggi_force_resolution_checkbutton), target->ggi_force_resolution);
	gtk_widget_set_sensitive(GTK_WIDGET(ggi_res_table),target->ggi_force_resolution);

	g_signal_connect (G_OBJECT (ggilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggilinear_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (ggi_force_resolution_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				 ggi_res_table );
	g_signal_connect (G_OBJECT (ggix_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggix_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ggiy_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ggiy_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	/*** Video Mode related ***/
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keepaspect_checkbutton), target->keepaspect);
	gtk_widget_set_sensitive(GTK_WIDGET(displayaspectratio_entry),(target->keepaspect));
	used_text = g_strdup_printf ("%f",target->displayaspectratio);
	gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), used_text);
	g_free(used_text);
	gtk_entry_set_text (GTK_ENTRY (disable_mode_entry), target->disablemode);

	g_signal_connect (G_OBJECT (keepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keepaspect_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (keepaspect_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  displayaspectratio_entry);
	g_signal_connect (G_OBJECT (displayaspectratio_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (displayaspectratio_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (disable_mode_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (disable_mode_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);



}


void add_sound_options_tab (GtkWidget    *properties_windows,
			    GtkNotebook  *target_notebook,
			    RomEntry     *rom,
			    GtkWidget    *apply_button,
			    GtkWidget    *reset_button,
			    guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;

	GtkWidget *sound_table;
	GtkWidget *sound_hseparator;
	GtkWidget *sound_hbox;
	GtkWidget *sound_pixmap;
	GtkWidget *sound_title;
	GtkWidget *samplerate_hbox;
	GList *samplefreq_combo_items = NULL;
	GList *audiodevice_combo_items = NULL;
	GtkWidget *mixerdevice_hbox;
	GList *mixerdevice_combo_items = NULL;
	GtkWidget *mixer_plugin_hbox;
	GtkWidget *mixer_plugin_label;
	GtkWidget *mixer_plugin_combo;
	GtkWidget *dsp_plugin_hbox;
	GtkWidget *dsp_plugin_label;
	GtkWidget *dsp_plugin_combo;
	GtkWidget *arts_table;
	GtkWidget *artsBufferTime_label;
	GtkWidget *qnx_vbox;
	GtkWidget *bufsize_hbox;
	GtkWidget *ms_label;
	GtkWidget *volume_hbox;
	GtkWidget *db_label;
	GtkWidget *dsp_sound_hseparator;
	GtkWidget *alsa_table;
	GtkWidget *alsa_hseparator;
	GtkWidget *sound_label;
	GtkWidget *soundfile_label;
	GtkWidget *soundfile_button;

	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;

	available_options = xmame_executable_get_options(current_exec);
	dirty_options_flag = FALSE;
	
	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	sound_table = gtk_table_new (13, 2, FALSE);
	gtk_widget_ref (sound_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_table", sound_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), sound_table);
	gtk_container_set_border_width (GTK_CONTAINER (sound_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (sound_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (sound_table), 5);

	sound_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (sound_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_hseparator", sound_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_hseparator);
	gtk_table_attach (GTK_TABLE (sound_table), sound_hseparator, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	sound_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (sound_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_hbox", sound_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), sound_hbox, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				samples_xpm);
	sound_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (sound_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "sound_pixmap", sound_pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_pixmap);
	gtk_box_pack_start (GTK_BOX (sound_hbox), sound_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (sound_pixmap), 10, 0);

	if (rom) 
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		sound_title = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		sound_title = gtk_label_new (_("Global game options\nDefault options used by all games"));
	gtk_widget_ref (sound_title);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_title", sound_title,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_title);
	gtk_box_pack_start (GTK_BOX (sound_hbox), sound_title, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (sound_title), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (sound_title), TRUE);
	gtk_misc_set_padding (GTK_MISC (sound_title), 10, 0);

/* Sound enable */
	sound_checkbutton = gtk_check_button_new_with_label (_("Enable sound"));
	gtk_widget_ref (sound_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_checkbutton", sound_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_checkbutton);
	gtk_table_attach (GTK_TABLE (sound_table), sound_checkbutton, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), TRUE);

/* Samples enable */
	samples_checkbutton = gtk_check_button_new_with_label (_("Use samples"));
	gtk_widget_ref (samples_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "samples_checkbutton", samples_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samples_checkbutton);
	gtk_table_attach (GTK_TABLE (sound_table), samples_checkbutton, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), TRUE);

/* Fake Sound enable */
	fakesound_checkbutton = gtk_check_button_new_with_label (_("Fake sound"));
	gtk_widget_ref (fakesound_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "fakesound_checkbutton", fakesound_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fakesound_checkbutton);
	gtk_table_attach (GTK_TABLE (sound_table), fakesound_checkbutton, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Samplerate */
	samplerate_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (samplerate_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "samplerate_hbox", samplerate_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samplerate_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), samplerate_hbox, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	samplefreq_label = gtk_label_new (_("Samplerate : "));
	gtk_widget_ref (samplefreq_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "samplefreq_label", samplefreq_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samplefreq_label);
	gtk_box_pack_start (GTK_BOX (samplerate_hbox), samplefreq_label, FALSE, FALSE, 6);
	gtk_misc_set_alignment (GTK_MISC (samplefreq_label), 0, 0.5);

	samplefreq_combo = gtk_combo_new ();
	gtk_widget_ref (samplefreq_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "samplefreq_combo", samplefreq_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samplefreq_combo);
	gtk_box_pack_start (GTK_BOX (samplerate_hbox), samplefreq_combo, FALSE, FALSE, 0);
	gtk_widget_set_size_request (samplefreq_combo, 85, -1);
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "8000");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "11025");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "16000");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "22050");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "44100");
	samplefreq_combo_items = g_list_append (samplefreq_combo_items, (gpointer) "48000");
	gtk_combo_set_popdown_strings (GTK_COMBO (samplefreq_combo), samplefreq_combo_items);
	g_list_free (samplefreq_combo_items);

	samplefreq_entry = GTK_COMBO (samplefreq_combo)->entry;
	gtk_widget_ref (samplefreq_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "samplefreq_entry", samplefreq_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (samplefreq_entry);
	gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), "22050");

/* Volume */
	volume_frame = gtk_frame_new (_("Volume attenuation"));
	gtk_widget_ref (volume_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "volume_frame", volume_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (volume_frame);
	gtk_table_attach (GTK_TABLE (sound_table), volume_frame, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	volume_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (volume_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "volume_hbox", volume_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (volume_hbox);
	gtk_container_add (GTK_CONTAINER (volume_frame), volume_hbox);

	db_hscale_adj = gtk_adjustment_new (target->volume, -32, 0, 1, 1, 0);
	db_hscale = gtk_hscale_new (GTK_ADJUSTMENT (db_hscale_adj));
	gtk_widget_ref (db_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "db_hscale", db_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (db_hscale);
	gtk_box_pack_start (GTK_BOX (volume_hbox), db_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (db_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (db_hscale), 0);

	db_label = gtk_label_new ("dB");
	gtk_widget_ref (db_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "db_label", db_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (db_label);
	gtk_box_pack_start (GTK_BOX (volume_hbox), db_label, FALSE, FALSE, 0);

/* Buffer Size */
	bufsize_frame = gtk_frame_new (_("Buffer size"));
	gtk_widget_ref (bufsize_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "bufsize_frame", bufsize_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bufsize_frame);
	gtk_table_attach (GTK_TABLE (sound_table), bufsize_frame, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	bufsize_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (bufsize_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "bufsize_hbox", bufsize_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bufsize_hbox);
	gtk_container_add (GTK_CONTAINER (bufsize_frame), bufsize_hbox);

	bufsize_hscale_adj = gtk_adjustment_new (target->bufsize, 1, 30, 1, 1, 0);
	bufsize_hscale = gtk_hscale_new (GTK_ADJUSTMENT (bufsize_hscale_adj));
	gtk_widget_ref (bufsize_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "bufsize_hscale", bufsize_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bufsize_hscale);
	gtk_box_pack_start (GTK_BOX (bufsize_hbox), bufsize_hscale, TRUE, TRUE, 0);
	gtk_scale_set_value_pos (GTK_SCALE (bufsize_hscale), GTK_POS_RIGHT);

	ms_label = gtk_label_new (_("frames"));
	gtk_widget_ref (ms_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "ms_label", ms_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ms_label);
	gtk_box_pack_start (GTK_BOX (bufsize_hbox), ms_label, FALSE, FALSE, 0);

/* Audio device  */
	audiodevice_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (audiodevice_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "audiodevice_hbox", audiodevice_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audiodevice_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), audiodevice_hbox, 0, 1, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	audiodevice_label = gtk_label_new (_("Audio device : "));
	gtk_widget_ref (audiodevice_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "audiodevice_label", audiodevice_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audiodevice_label);
	gtk_box_pack_start (GTK_BOX (audiodevice_hbox), audiodevice_label, FALSE, FALSE, 0);

	audiodevice_combo = gtk_combo_new ();
	gtk_widget_ref (audiodevice_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "audiodevice_combo", audiodevice_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audiodevice_combo);
	gtk_box_pack_start (GTK_BOX (audiodevice_hbox), audiodevice_combo, FALSE, FALSE, 0);
	gtk_widget_set_size_request (audiodevice_combo, 100, -1);
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp0");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp1");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp2");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/dsp3");
	audiodevice_combo_items = g_list_append (audiodevice_combo_items, (gpointer) "/dev/audio");
	gtk_combo_set_popdown_strings (GTK_COMBO (audiodevice_combo), audiodevice_combo_items);
	g_list_free (audiodevice_combo_items);

	audiodevice_combo_entry = GTK_COMBO (audiodevice_combo)->entry;
	gtk_widget_ref (audiodevice_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "audiodevice_combo_entry", audiodevice_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audiodevice_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), "/dev/dsp");

/* Mixer device */
	mixerdevice_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (mixerdevice_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixerdevice_hbox", mixerdevice_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixerdevice_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), mixerdevice_hbox, 1, 2, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	mixerdevice_label = gtk_label_new (_("Mixer device : "));
	gtk_widget_ref (mixerdevice_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixerdevice_label", mixerdevice_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixerdevice_label);
	gtk_box_pack_start (GTK_BOX (mixerdevice_hbox), mixerdevice_label, FALSE, FALSE, 0);

	mixerdevice_combo = gtk_combo_new ();
	gtk_widget_ref (mixerdevice_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixerdevice_combo", mixerdevice_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixerdevice_combo);
	gtk_box_pack_start (GTK_BOX (mixerdevice_hbox), mixerdevice_combo, FALSE, FALSE, 0);
	gtk_widget_set_size_request (mixerdevice_combo, 100, -1);
	mixerdevice_combo_items = g_list_append (mixerdevice_combo_items, (gpointer) "/dev/mixer");
	gtk_combo_set_popdown_strings (GTK_COMBO (mixerdevice_combo), mixerdevice_combo_items);
	g_list_free (mixerdevice_combo_items);

	mixerdevice_entry = GTK_COMBO (mixerdevice_combo)->entry;
	gtk_widget_ref (mixerdevice_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixerdevice_entry", mixerdevice_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixerdevice_entry);
	gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), "/dev/mixer");

/* Separator */
	dsp_sound_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (dsp_sound_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "dsp_sound_hseparator", dsp_sound_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dsp_sound_hseparator);
	gtk_table_attach (GTK_TABLE (sound_table), dsp_sound_hseparator, 0, 2, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

/* DSP plugin */
	dsp_plugin_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (dsp_plugin_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "dsp_plugin_hbox", dsp_plugin_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dsp_plugin_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), dsp_plugin_hbox, 0, 2, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	dsp_plugin_label = gtk_label_new (_("DSP Plugin : "));
	gtk_widget_ref (dsp_plugin_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "dsp_plugin_label", dsp_plugin_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dsp_plugin_label);
	gtk_box_pack_start (GTK_BOX (dsp_plugin_hbox), dsp_plugin_label, FALSE, FALSE, 0);

	dsp_plugin_combo = gtk_combo_new ();
	gtk_widget_ref (dsp_plugin_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "dsp_plugin_combo", dsp_plugin_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dsp_plugin_combo);
	gtk_box_pack_start (GTK_BOX (dsp_plugin_hbox), dsp_plugin_combo, TRUE, TRUE, 0);
	/* need to set the glist null here otherwise, got an strange element that will crach the app */
	dsp_plugin_combo_items = NULL;
	if (g_hash_table_size(current_exec->dsp_plugin_hash_table)>0)
	{
		g_hash_table_foreach(current_exec->dsp_plugin_hash_table,
        	                     (GHFunc)dsp_combo_add,
        	                     NULL);
		gtk_combo_set_popdown_strings (GTK_COMBO (dsp_plugin_combo), dsp_plugin_combo_items);
		g_list_free (dsp_plugin_combo_items);
	}
		
	dsp_plugin_entry = GTK_COMBO (dsp_plugin_combo)->entry;
	gtk_widget_ref (dsp_plugin_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "dsp_plugin_entry", dsp_plugin_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dsp_plugin_entry);

/* Mixer plugin */
	mixer_plugin_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (mixer_plugin_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixer_plugin_hbox", mixer_plugin_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixer_plugin_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), mixer_plugin_hbox, 0, 2, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	mixer_plugin_label = gtk_label_new (_("Mixer plugin : "));
	gtk_widget_ref (mixer_plugin_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixer_plugin_label", mixer_plugin_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixer_plugin_label);
	gtk_box_pack_start (GTK_BOX (mixer_plugin_hbox), mixer_plugin_label, FALSE, FALSE, 0);

	mixer_plugin_combo = gtk_combo_new ();
	gtk_widget_ref (mixer_plugin_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixer_plugin_combo", mixer_plugin_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixer_plugin_combo);
	gtk_box_pack_start (GTK_BOX (mixer_plugin_hbox), mixer_plugin_combo, TRUE, TRUE, 0);
	/* need to set the glist null here otherwise, got an strange element that will crach the app */
	mixer_plugin_combo_items = NULL;
	if (g_hash_table_size(current_exec->mixer_plugin_hash_table)>0)
	{
		g_hash_table_foreach(current_exec->mixer_plugin_hash_table,
        	                     (GHFunc)mixer_combo_add,
        	                     NULL);
		gtk_combo_set_popdown_strings (GTK_COMBO (mixer_plugin_combo), mixer_plugin_combo_items);
		g_list_free (mixer_plugin_combo_items);
	}

	mixer_plugin_entry = GTK_COMBO (mixer_plugin_combo)->entry;
	gtk_widget_ref (mixer_plugin_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "mixer_plugin_entry", mixer_plugin_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mixer_plugin_entry);

/* soundfile */
	soundfile_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (soundfile_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "soundfile_hbox", soundfile_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (soundfile_hbox);
	gtk_table_attach (GTK_TABLE (sound_table), soundfile_hbox, 0, 2, 9, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	soundfile_label = gtk_label_new (_("Sound file name : "));
	gtk_widget_ref (soundfile_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "soundfile_label", soundfile_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (soundfile_label);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_label, FALSE, FALSE, 0);

	soundfile_entry = gtk_entry_new ();
	gtk_widget_ref (soundfile_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "soundfile_entry", soundfile_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (soundfile_entry);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_entry, FALSE, TRUE, 0);

	soundfile_button = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_ref (soundfile_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "soundfile_button", soundfile_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (soundfile_button);
	gtk_box_pack_start (GTK_BOX (soundfile_hbox), soundfile_button, FALSE, FALSE, 0);

/* timer */
	timer_checkbutton = gtk_check_button_new_with_label (_("timer based audio"));
	gtk_widget_ref (timer_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "timer_checkbutton", timer_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (timer_checkbutton);
	gtk_table_attach (GTK_TABLE (sound_table), timer_checkbutton, 0, 1, 10, 11,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* aRTs options */
	arts_frame = gtk_frame_new (_("aRts options"));
	gtk_widget_ref (arts_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "arts_frame", arts_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (arts_frame);
	gtk_table_attach (GTK_TABLE (sound_table), arts_frame, 0, 1, 11, 12,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	arts_table = gtk_table_new (1, 2, FALSE);
	gtk_widget_ref (arts_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "arts_table", arts_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (arts_table);
	gtk_container_add (GTK_CONTAINER (arts_frame), arts_table);

	arts_spinbutton_adj = gtk_adjustment_new (target->artsBufferTime, 0, 1000, 1, 100, 10);
	arts_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (arts_spinbutton_adj), 1, 0);
	gtk_widget_ref (arts_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "arts_spinbutton", arts_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (arts_spinbutton);
	gtk_table_attach (GTK_TABLE (arts_table), arts_spinbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	artsBufferTime_label = gtk_label_new (_("aRts buffer delay time : "));
	gtk_widget_ref (artsBufferTime_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "artsBufferTime_label", artsBufferTime_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artsBufferTime_label);
	gtk_table_attach (GTK_TABLE (arts_table), artsBufferTime_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (artsBufferTime_label), 0, 0.5);

/* QNX options */
	qnx_frame = gtk_frame_new (_("QNX options"));
	gtk_widget_ref (qnx_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "qnx_frame", qnx_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (qnx_frame);
	gtk_table_attach (GTK_TABLE (sound_table), qnx_frame, 0, 1, 12, 13,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	qnx_vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (qnx_vbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "qnx_vbox", qnx_vbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (qnx_vbox);
	gtk_container_add (GTK_CONTAINER (qnx_frame), qnx_vbox);

	audio_preferred_checkbutton = gtk_check_button_new_with_label (_("use preferred device"));
	gtk_widget_ref (audio_preferred_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "audio_preferred_checkbutton", audio_preferred_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audio_preferred_checkbutton);
	gtk_box_pack_start (GTK_BOX (qnx_vbox), audio_preferred_checkbutton, FALSE, FALSE, 0);

/* Alsa options */
	alsa_frame = gtk_frame_new (_("Alsa Sound System Options"));
	gtk_widget_ref (alsa_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsa_frame", alsa_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsa_frame);
	gtk_table_attach (GTK_TABLE (sound_table), alsa_frame, 1, 2, 10, 13,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	alsa_table = gtk_table_new (5, 2, FALSE);
	gtk_widget_ref (alsa_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsa_table", alsa_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsa_table);
	gtk_container_add (GTK_CONTAINER (alsa_frame), alsa_table);

	PCM_label = gtk_label_new (_("PCM : "));
	gtk_widget_ref (PCM_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "PCM_label", PCM_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (PCM_label);
	gtk_table_attach (GTK_TABLE (alsa_table), PCM_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (PCM_label), 0, 0.5);
	
	/*workaround to allow correct translation of "" with gettext */
	used_text = g_strdup_printf(_("buffer size %s"),"(s) : ");
	alsa_buffer_label = gtk_label_new (used_text);
	g_free(used_text);
	gtk_widget_ref (alsa_buffer_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsa_buffer_label", alsa_buffer_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsa_buffer_label);
	gtk_table_attach (GTK_TABLE (alsa_table), alsa_buffer_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (alsa_buffer_label), 0, 0.5);

	alsa_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (alsa_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsa_hseparator", alsa_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsa_hseparator);
	gtk_table_attach (GTK_TABLE (alsa_table), alsa_hseparator, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	alsacard_label = gtk_label_new (_("Card ID : "));
	gtk_widget_ref (alsacard_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsacard_label", alsacard_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsacard_label);
	gtk_table_attach (GTK_TABLE (alsa_table), alsacard_label, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (alsacard_label), 0, 0.5);

	alsadevice_label = gtk_label_new (_("device # : "));
	gtk_widget_ref (alsadevice_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsadevice_label", alsadevice_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsadevice_label);
	gtk_table_attach (GTK_TABLE (alsa_table), alsadevice_label, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (alsadevice_label), 0, 0.5);

	alsa_buffer_spinbutton_adj = gtk_adjustment_new (target->alsa_buffer, 0, 5e+06, 1, 500, 10);
	alsa_buffer_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsa_buffer_spinbutton_adj), 1, 0);
	gtk_widget_ref (alsa_buffer_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsa_buffer_spinbutton", alsa_buffer_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsa_buffer_spinbutton);
	gtk_table_attach (GTK_TABLE (alsa_table), alsa_buffer_spinbutton, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	alsacard_spinbutton_adj = gtk_adjustment_new (target->alsacard, 0, 32, 1, 10, 10);
	alsacard_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsacard_spinbutton_adj), 1, 0);
	gtk_widget_ref (alsacard_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsacard_spinbutton", alsacard_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsacard_spinbutton);
	gtk_table_attach (GTK_TABLE (alsa_table), alsacard_spinbutton, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	alsadevice_spinbutton_adj = gtk_adjustment_new (target->alsadevice, 0, 32, 1, 10, 10);
	alsadevice_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (alsadevice_spinbutton_adj), 1, 0);
	gtk_widget_ref (alsadevice_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "alsadevice_spinbutton", alsadevice_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alsadevice_spinbutton);
	gtk_table_attach (GTK_TABLE (alsa_table), alsadevice_spinbutton, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	pcm_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(pcm_entry), 20);
	gtk_widget_ref (pcm_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "pcm_entry", pcm_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (pcm_entry);
	gtk_table_attach (GTK_TABLE (alsa_table), pcm_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (pcm_entry, 100, -1);

/* end sound options */
	sound_label = gtk_label_new (_("Sound"));
	gtk_widget_ref (sound_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_label", sound_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), sound_label);


	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(samples_checkbutton),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(volume_frame),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(bufsize_frame),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(samplefreq_combo),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_label),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(samplefreq_label),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(mixerdevice_label),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_combo),target->sound);
	gtk_widget_set_sensitive(GTK_WIDGET(mixerdevice_combo),target->sound);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), target->samples);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fakesound_checkbutton), target->fakesound);
	used_text = g_strdup_printf ("%i",target->samplefre);
	gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), used_text);
	gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), target->audiodevice);
	gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), target->mixerdevice);

	gtk_entry_set_text (GTK_ENTRY (soundfile_entry), target->soundfile);
	if(!strcmp(target->dsp_plugin,"waveout"))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),TRUE);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),FALSE);
	}
	else
	{
		gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),FALSE);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),TRUE);
	}

	gtk_entry_set_text (GTK_ENTRY (dsp_plugin_entry), target->dsp_plugin);
	if (current_exec->dsp_plugin_hash_table)
	{
		g_hash_table_foreach(current_exec->dsp_plugin_hash_table,
             	                (GHFunc)dsp_combo_comp,
             	                target);
	}

	gtk_entry_set_text (GTK_ENTRY (mixer_plugin_entry), target->sound_mixer_plugin);
	if(current_exec->mixer_plugin_hash_table)
	{
		g_hash_table_foreach(current_exec->mixer_plugin_hash_table,
        	                     (GHFunc)mixer_combo_comp,
                	             target);
	}

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timer_checkbutton), target->timer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (audio_preferred_checkbutton), target->audio_preferred);
	gtk_entry_set_text (GTK_ENTRY (pcm_entry), target->alsa_pcm);

	gtk_widget_set_sensitive (GTK_WIDGET(qnx_frame), available_options->audio_preferred);
	gtk_widget_set_sensitive (GTK_WIDGET(alsa_frame), available_options->list_alsa_cards);
	gtk_widget_set_sensitive (GTK_WIDGET(arts_frame), available_options->artsBufferTime);
	gtk_widget_set_sensitive (GTK_WIDGET(alsacard_label), available_options->alsacard);
	gtk_widget_set_sensitive (GTK_WIDGET(alsacard_spinbutton), available_options->alsacard);
	gtk_widget_set_sensitive (GTK_WIDGET(alsadevice_label), available_options->alsadevice);
	gtk_widget_set_sensitive (GTK_WIDGET(alsadevice_spinbutton), available_options->alsadevice);
	gtk_widget_set_sensitive (GTK_WIDGET(alsa_buffer_label), available_options->alsa_buffer);
	gtk_widget_set_sensitive (GTK_WIDGET(alsa_buffer_spinbutton), available_options->alsa_buffer);
	gtk_widget_set_sensitive (GTK_WIDGET(PCM_label), available_options->alsa_pcm);
	gtk_widget_set_sensitive (GTK_WIDGET(pcm_entry), available_options->alsa_pcm);

	g_signal_connect (G_OBJECT (sound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (sound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samples_checkbutton));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (volume_frame));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (bufsize_frame));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samplefreq_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (audiodevice_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mixerdevice_combo));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (samplefreq_label));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (audiodevice_label));
	g_signal_connect_after (G_OBJECT (sound_checkbutton), "toggled",
				  G_CALLBACK (button_toggled),
				  G_OBJECT (mixerdevice_label));
	g_signal_connect (G_OBJECT (samples_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (samples_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (fakesound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (fakesound_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (samplefreq_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (samplefreq_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(db_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(db_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(bufsize_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(bufsize_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (audiodevice_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (audiodevice_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (soundfile_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (soundfile_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (mixerdevice_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mixerdevice_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (dsp_plugin_entry), "changed",
			    G_CALLBACK (file_or_device),
			    NULL);
	g_signal_connect (G_OBJECT (mixer_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mixer_plugin_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (timer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (timer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (arts_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (arts_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (audio_preferred_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (audio_preferred_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (pcm_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (pcm_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsa_buffer_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsa_buffer_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsacard_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsacard_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (alsadevice_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (alsadevice_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	}


void add_controller_options_tab (GtkWidget    *properties_windows,
				 GtkNotebook  *target_notebook,
				 RomEntry     *rom,
				 GtkWidget    *apply_button,
				 GtkWidget    *reset_button,
				 guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;

	GtkWidget *controllers_table;
	GtkWidget *controller_hseparator;
	GtkWidget *controllers_hbox;
	GtkWidget *controllers_pixmap;
	GtkWidget *controllers_title;
	GtkWidget *keyboard_frame;
	GtkWidget *keyboard_table;
	GtkWidget *keyboard_pixmap;
	GtkWidget *keymapping_frame;
	GtkWidget *keymapping_table;
	GtkWidget *ctrlr_frame;
	GtkWidget *ctrlr_table;
	GtkWidget *ctrlr_label;
	GList *ctrlr_combo_items = NULL;
	GList *ctrlr_list = NULL;
	GList *my_list = NULL;
	GtkWidget *keymaptype_label;
	GtkWidget *keymaptype_combo;
	GList *keymaptype_combo_items = NULL;
	GtkWidget *mouse_frame;
	GtkWidget *mouse_table;
	GtkWidget *mouse_pixmap;
	GtkWidget *Xinput_trackball_frame;
	GtkWidget *Xinput_trackball_table;
	GtkWidget *XInput_trackball1_label;
	GtkWidget *XInput_trackball2_label;
	GtkWidget *XInput_trackball3_label;
	GtkWidget *XInput_trackball4_label;
	GtkWidget *joystick_frame;
	GtkWidget *joystick_table;
	GtkWidget *joytype_label;
	GtkWidget *joystick_pixmap;
	GtkWidget *xinput_joy_table;
	GtkWidget *XInput_joystick1_label;
	GtkWidget *XInput_joystick2_label;
	GtkWidget *XInput_joystick3_label;
	GtkWidget *XInput_joystick4_label;
	GtkWidget *joytype_combo;
	GList *joytype_combo_items = NULL;
	GtkWidget *control_label;
	GtkWidget *joy_vseparator;
	int i;

	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;

	available_options = xmame_executable_get_options(current_exec);
	dirty_options_flag = FALSE;
  
	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	controllers_table = gtk_table_new (5, 2, FALSE);
	gtk_widget_ref (controllers_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "controllers_table", controllers_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (controllers_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), controllers_table);
	gtk_container_set_border_width (GTK_CONTAINER (controllers_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (controllers_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (controllers_table), 5);

	controller_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (controller_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "controller_hseparator", controller_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (controller_hseparator);
	gtk_table_attach (GTK_TABLE (controllers_table), controller_hseparator, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	controllers_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (controllers_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "controllers_hbox", controllers_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (controllers_hbox);
	gtk_table_attach (GTK_TABLE (controllers_table), controllers_hbox, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				joystick_xpm);
	controllers_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (controllers_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "controllers_pixmap", controllers_pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (controllers_pixmap);
	gtk_box_pack_start (GTK_BOX (controllers_hbox), controllers_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (controllers_pixmap), 10, 0);

	if (rom) 
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		controllers_title = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		controllers_title = gtk_label_new (_("Global game options\nDefault options used by all games"));
	gtk_widget_ref (controllers_title);
	g_object_set_data_full (G_OBJECT (properties_windows), "controllers_title", controllers_title,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (controllers_title);
	gtk_box_pack_start (GTK_BOX (controllers_hbox), controllers_title, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (controllers_title), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (controllers_title), TRUE);
	gtk_misc_set_padding (GTK_MISC (controllers_title), 10, 0);

/*** Joystick ***/
	joystick_frame = gtk_frame_new (_("Joystick"));
	gtk_widget_ref (joystick_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "joystick_frame", joystick_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joystick_frame);
	gtk_table_attach (GTK_TABLE (controllers_table), joystick_frame, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	joystick_table = gtk_table_new (5, 7, FALSE);
	gtk_widget_ref (joystick_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "joystick_table", joystick_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joystick_table);
	gtk_container_add (GTK_CONTAINER (joystick_frame), joystick_table);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				joystick_xpm);
	joystick_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (joystick_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "joystick_pixmap", joystick_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joystick_pixmap);
	gtk_table_attach (GTK_TABLE (joystick_table), joystick_pixmap, 0, 1, 0, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (joystick_pixmap), 0.5, 0.1);
	gtk_misc_set_padding (GTK_MISC (joystick_pixmap), 5, 5);

/* Joytype */
	joytype_label = gtk_label_new (_("Joystick type : "));
	gtk_widget_ref (joytype_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "joytype_label", joytype_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joytype_label);
	gtk_table_attach (GTK_TABLE (joystick_table), joytype_label, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (joytype_label), 0, 0.5);

	joytype_combo = gtk_combo_new ();
	gtk_widget_ref (joytype_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "joytype_combo", joytype_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joytype_combo);
	gtk_table_attach (GTK_TABLE (joystick_table), joytype_combo, 2, 4, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	i = 0;
	do {
		joytype_combo_items = g_list_append (joytype_combo_items, (gpointer) _(joytype_name[i]));
		i++;
	} while (joytype_name[i]);
	gtk_combo_set_popdown_strings (GTK_COMBO (joytype_combo), joytype_combo_items);
	g_list_free (joytype_combo_items);

	joytype_combo_entry = GTK_COMBO (joytype_combo)->entry;
	gtk_widget_ref (joytype_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "joytype_combo_entry", joytype_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_editable_set_editable (GTK_EDITABLE (joytype_combo_entry), FALSE);
	gtk_widget_show (joytype_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), _("No joystick"));

/* joystick prefix */
	joydevname_label = gtk_label_new (_("Joystick device prefix : "));
	gtk_widget_ref (joydevname_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "joydevname_label", joydevname_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joydevname_label);
	gtk_table_attach (GTK_TABLE (joystick_table), joydevname_label, 1, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (joydevname_label), 0, 0.5);

	joydevname_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(joydevname_entry), 20);
	gtk_widget_ref (joydevname_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "joydevname_entry", joydevname_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joydevname_entry);
	gtk_table_attach (GTK_TABLE (joystick_table), joydevname_entry, 3, 4, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (joydevname_entry), "/dev/joy");

/* FM Townpad */
	paddevname_label = gtk_label_new (_("Name of pad device :\n(FM townpad)"));
	gtk_widget_ref (paddevname_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "paddevname_label", paddevname_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (paddevname_label);
	gtk_table_attach (GTK_TABLE (joystick_table), paddevname_label, 1, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (paddevname_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (paddevname_label), 0, 0.5);

	paddevname_entry = gtk_entry_new ();
	gtk_widget_ref (paddevname_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "paddevname_entry", paddevname_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (paddevname_entry);
	gtk_table_attach (GTK_TABLE (joystick_table), paddevname_entry, 3, 4, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_entry_set_text (GTK_ENTRY (paddevname_entry), "/dev/pad00");

/* X-based joy */
	x11joyname_label = gtk_label_new (_("X-based device"));
	gtk_widget_ref (x11joyname_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "x11joyname_label", x11joyname_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (x11joyname_label);
	gtk_table_attach (GTK_TABLE (joystick_table), x11joyname_label, 1, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (x11joyname_label), 0, 0.5);

	x11joyname_entry = gtk_entry_new ();
	gtk_widget_ref (x11joyname_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "x11joyname_entry", x11joyname_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (x11joyname_entry);
	gtk_table_attach (GTK_TABLE (joystick_table), x11joyname_entry, 3, 4, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* separator */
	joy_vseparator = gtk_vseparator_new ();
	gtk_widget_ref (joy_vseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "joy_vseparator", joy_vseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (joy_vseparator);
	gtk_table_attach (GTK_TABLE (joystick_table), joy_vseparator, 4, 5, 0, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 5, 0);

/* analogic joystick */
	analogstick_checkbutton = gtk_check_button_new_with_label (_("Analog joystick"));
	gtk_widget_ref (analogstick_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "analogstick_checkbutton", analogstick_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (analogstick_checkbutton);
	gtk_table_attach (GTK_TABLE (joystick_table), analogstick_checkbutton, 5, 6, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* rapid fire */
	rapidfire_checkbutton = gtk_check_button_new_with_label (_("Rapid-fire"));
	gtk_widget_ref (rapidfire_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "rapidfire_checkbutton", rapidfire_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rapidfire_checkbutton);
	gtk_table_attach (GTK_TABLE (joystick_table), rapidfire_checkbutton, 5, 6, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* USB PAD*/
	usbpspad_checkbutton = gtk_check_button_new_with_label (_("USB PS Game Pads"));
	gtk_widget_ref (usbpspad_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "usbpspad_checkbutton", usbpspad_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (usbpspad_checkbutton);
	gtk_table_attach (GTK_TABLE (joystick_table), usbpspad_checkbutton, 5, 6, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Xinput */
	Xinput_joy_frame = gtk_frame_new (_("Xinput joystick"));
	gtk_widget_ref (Xinput_joy_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "Xinput_joy_frame", Xinput_joy_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (Xinput_joy_frame);
	gtk_table_attach (GTK_TABLE (joystick_table), Xinput_joy_frame, 1, 7, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	xinput_joy_table = gtk_table_new (2, 4, FALSE);
	gtk_widget_ref (xinput_joy_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "xinput_joy_table", xinput_joy_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (xinput_joy_table);
	gtk_container_add (GTK_CONTAINER (Xinput_joy_frame), xinput_joy_table);

	XInput_joystick1_label = gtk_label_new (" 1 : ");
	gtk_widget_ref (XInput_joystick1_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick1_label", XInput_joystick1_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick1_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick1_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick1_label), 0, 0.5);

	XInput_joystick1_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_joystick1_entry), 20);
	gtk_widget_ref (XInput_joystick1_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick1_entry", XInput_joystick1_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick1_entry);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick1_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_joystick2_label = gtk_label_new (" 2 : ");
	gtk_widget_ref (XInput_joystick2_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick2_label", XInput_joystick2_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick2_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick2_label, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick2_label), 0, 0.5);

	XInput_joystick3_label = gtk_label_new (" 3 : ");
	gtk_widget_ref (XInput_joystick3_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick3_label", XInput_joystick3_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick3_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick3_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick3_label), 0, 0.5);

	XInput_joystick4_label = gtk_label_new (" 4 : ");
	gtk_widget_ref (XInput_joystick4_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick4_label", XInput_joystick4_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick4_label);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick4_label, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_joystick4_label), 0, 0.5);

	XInput_joystick3_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_joystick3_entry), 20);
	gtk_widget_ref (XInput_joystick3_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick3_entry", XInput_joystick3_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick3_entry);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick3_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_joystick2_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_joystick2_entry), 20);
	gtk_widget_ref (XInput_joystick2_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick2_entry", XInput_joystick2_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick2_entry);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick2_entry, 3, 4, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_joystick4_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_joystick4_entry), 20);
	gtk_widget_ref (XInput_joystick4_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_joystick4_entry", XInput_joystick4_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_joystick4_entry);
	gtk_table_attach (GTK_TABLE (xinput_joy_table), XInput_joystick4_entry, 3, 4, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/*** Mouse ***/
	mouse_frame = gtk_frame_new (_("Mouse / Trackball"));
	gtk_widget_ref (mouse_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "mouse_frame", mouse_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mouse_frame);
	gtk_table_attach (GTK_TABLE (controllers_table), mouse_frame, 0, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	mouse_table = gtk_table_new (2, 3, FALSE);
	gtk_widget_ref (mouse_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "mouse_table", mouse_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mouse_table);
	gtk_container_add (GTK_CONTAINER (mouse_frame), mouse_table);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				mouse_xpm);
	mouse_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (mouse_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "mouse_pixmap", mouse_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mouse_pixmap);
	gtk_table_attach (GTK_TABLE (mouse_table), mouse_pixmap, 0, 1, 0, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (mouse_pixmap), 0.5, 0.1);
	gtk_misc_set_padding (GTK_MISC (mouse_pixmap), 5, 5);

/* use mouse */
	mouse_checkbutton = gtk_check_button_new_with_label (_("use mouse"));
	gtk_widget_ref (mouse_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "mouse_checkbutton", mouse_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (mouse_checkbutton);
	gtk_table_attach (GTK_TABLE (mouse_table), mouse_checkbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* grab mouse */
	grabmouse_checkbutton = gtk_check_button_new_with_label (_("Grab mouse"));
	gtk_widget_ref (grabmouse_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "grabmouse_checkbutton", grabmouse_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (grabmouse_checkbutton);
	gtk_table_attach (GTK_TABLE (mouse_table), grabmouse_checkbutton, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* Xinput */
	Xinput_trackball_frame = gtk_frame_new (_("Xinput trackball"));
	gtk_widget_ref (Xinput_trackball_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "Xinput_trackball_frame", Xinput_trackball_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (Xinput_trackball_frame);
	gtk_table_attach (GTK_TABLE (mouse_table), Xinput_trackball_frame, 1, 3, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	Xinput_trackball_table = gtk_table_new (2, 4, FALSE);
	gtk_widget_ref (Xinput_trackball_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "Xinput_trackball_table", Xinput_trackball_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (Xinput_trackball_table);
	gtk_container_add (GTK_CONTAINER (Xinput_trackball_frame), Xinput_trackball_table);

	XInput_trackball1_label = gtk_label_new (" 1 : ");
	gtk_widget_ref (XInput_trackball1_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball1_label", XInput_trackball1_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball1_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball1_label, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball1_label), 0, 0.5);

	XInput_trackball1_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_trackball1_entry), 20);
	gtk_widget_ref (XInput_trackball1_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball1_entry", XInput_trackball1_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball1_entry);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball1_entry, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_trackball2_label = gtk_label_new (" 2 : ");
	gtk_widget_ref (XInput_trackball2_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball2_label", XInput_trackball2_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball2_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball2_label, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball2_label), 0, 0.5);

	XInput_trackball3_label = gtk_label_new (" 3 : ");
	gtk_widget_ref (XInput_trackball3_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball3_label", XInput_trackball3_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball3_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball3_label, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball3_label), 0, 0.5);

	XInput_trackball4_label = gtk_label_new (" 4 : ");
	gtk_widget_ref (XInput_trackball4_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball4_label", XInput_trackball4_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball4_label);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball4_label, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (XInput_trackball4_label), 0, 0.5);

	XInput_trackball3_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_trackball3_entry), 20);
	gtk_widget_ref (XInput_trackball3_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball3_entry", XInput_trackball3_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball3_entry);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball3_entry, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_trackball2_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_trackball2_entry), 20);
	gtk_widget_ref (XInput_trackball2_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball2_entry", XInput_trackball2_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball2_entry);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball2_entry, 3, 4, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	XInput_trackball4_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(XInput_trackball4_entry), 20);
	gtk_widget_ref (XInput_trackball4_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "XInput_trackball4_entry", XInput_trackball4_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (XInput_trackball4_entry);
	gtk_table_attach (GTK_TABLE (Xinput_trackball_table), XInput_trackball4_entry, 3, 4, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/*** Keyboard ***/
	keyboard_frame = gtk_frame_new (_("Keyboard"));
	gtk_widget_ref (keyboard_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "keyboard_frame", keyboard_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keyboard_frame);
	gtk_table_attach (GTK_TABLE (controllers_table), keyboard_frame, 0, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	keyboard_table = gtk_table_new (3, 4, FALSE);
	gtk_widget_ref (keyboard_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "keyboard_table", keyboard_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keyboard_table);
	gtk_container_add (GTK_CONTAINER (keyboard_frame), keyboard_table);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				keyboard_xpm);
	keyboard_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (keyboard_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "keyboard_pixmap", keyboard_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keyboard_pixmap);
	gtk_table_attach (GTK_TABLE (keyboard_table), keyboard_pixmap, 0, 1, 0, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (keyboard_pixmap), 0.5, 0.1);
	gtk_misc_set_padding (GTK_MISC (keyboard_pixmap), 5, 5);

/* use config */
 	config_name_checkbutton = gtk_check_button_new_with_label (_("Use config name :"));
 	gtk_widget_ref (config_name_checkbutton);
 	g_object_set_data_full (G_OBJECT (properties_windows), "config_name_checkbutton", config_name_checkbutton,
 				  (GtkDestroyNotify) gtk_widget_unref);
 	gtk_widget_show (config_name_checkbutton);
 	gtk_table_attach (GTK_TABLE (keyboard_table), config_name_checkbutton, 1, 2, 0, 1,
 			  (GtkAttachOptions) (0),
 			  (GtkAttachOptions) (0), 0, 0);

	config_name_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(config_name_entry), 20);
	gtk_widget_ref (config_name_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "config_name_entry", config_name_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (config_name_entry);
	gtk_table_attach (GTK_TABLE (keyboard_table), config_name_entry, 2, 3, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (config_name_entry, 160, -1);


	/* Ctrlr */
	ctrlr_frame = gtk_frame_new (_("Control Panel"));
	gtk_widget_ref (ctrlr_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "ctrlr_frame", ctrlr_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ctrlr_frame);
	gtk_table_attach (GTK_TABLE (keyboard_table), ctrlr_frame, 3, 4, 0, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	ctrlr_table = gtk_table_new (2, 3, FALSE);
	gtk_widget_ref (ctrlr_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "ctrlr_table", ctrlr_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ctrlr_table);
	gtk_container_add (GTK_CONTAINER (ctrlr_frame), ctrlr_table);



	ctrlr_label = gtk_label_new (_("Controller: "));
	gtk_widget_ref (ctrlr_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "ctrlr_label", ctrlr_label,
	    (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ctrlr_label);
	gtk_table_attach (GTK_TABLE (ctrlr_table), ctrlr_label, 0, 1, 0, 1,
				(GtkAttachOptions) (GTK_FILL),
				(GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (ctrlr_label), 0, 0.5);

	ctrlr_combo = gtk_combo_new ();
	gtk_widget_ref (ctrlr_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "ctrlr_combo", ctrlr_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ctrlr_combo);
	gtk_table_attach (GTK_TABLE (ctrlr_table), ctrlr_combo, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_combo_set_value_in_list (GTK_COMBO (ctrlr_combo), TRUE, FALSE);
	/* Getting ctrlr list */
	ctrlr_list = get_ctrlr_list ();

	ctrlr_combo_items = g_list_append (ctrlr_combo_items, (gpointer) _("None"));
	for(my_list = g_list_first(ctrlr_list);
			(my_list != NULL);
			my_list = g_list_next(my_list))
	{
		ctrlr_combo_items = g_list_append (ctrlr_combo_items, (gpointer) _(g_strdup(my_list->data)));
	}
	gtk_combo_set_popdown_strings (GTK_COMBO (ctrlr_combo), ctrlr_combo_items);
	g_list_free (ctrlr_combo_items);
	g_list_free (ctrlr_list);

	ctrlr_combo_entry = GTK_COMBO (ctrlr_combo)->entry;
	gtk_widget_ref (ctrlr_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "ctrlr_combo_entry", ctrlr_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_editable_set_editable (GTK_EDITABLE (ctrlr_combo_entry), FALSE);
	gtk_widget_show (ctrlr_combo_entry);

/* HotRod */
	hotrod_checkbutton = gtk_check_button_new_with_label (_("HotRod support"));
	gtk_widget_ref (hotrod_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "hotrod_checkbutton", hotrod_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hotrod_checkbutton);
	gtk_table_attach (GTK_TABLE (ctrlr_table), hotrod_checkbutton, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* HotRod Second Edition */
	hotrodse_checkbutton = gtk_check_button_new_with_label (_("HotRod SE support"));
	gtk_widget_ref (hotrodse_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "hotrodse_checkbutton", hotrodse_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hotrodse_checkbutton);
	gtk_table_attach (GTK_TABLE (ctrlr_table), hotrodse_checkbutton, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);


/* grab keyboard */
	grabkeyboard_checkbutton = gtk_check_button_new_with_label (_("Grab keyboard"));
	gtk_widget_ref (grabkeyboard_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "grabkeyboard_checkbutton", grabkeyboard_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (grabkeyboard_checkbutton);
	gtk_table_attach (GTK_TABLE (keyboard_table), grabkeyboard_checkbutton, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* winkeys */
	winkeys_checkbutton = gtk_check_button_new_with_label (_("Enable Windows keys"));
	gtk_widget_ref (winkeys_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "winkeys_checkbutton", winkeys_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (winkeys_checkbutton);
	gtk_table_attach (GTK_TABLE (keyboard_table), winkeys_checkbutton, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* key mapping... one day maybe :-) */
	keymapping_frame = gtk_frame_new (_("Key mapping"));
	gtk_widget_ref (keymapping_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "keymapping_frame", keymapping_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keymapping_frame);
	gtk_table_attach (GTK_TABLE (keyboard_table), keymapping_frame, 1, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	keymapping_table = gtk_table_new (2, 1, FALSE);
	gtk_widget_ref (keymapping_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "keymapping_table", keymapping_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keymapping_table);
	gtk_container_add (GTK_CONTAINER (keymapping_frame), keymapping_table);

	keymaptype_label = gtk_label_new (_("Keyboard Layout type : "));
	gtk_widget_ref (keymaptype_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "keymaptype_label", keymaptype_label,
	    (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keymaptype_label);
	gtk_table_attach (GTK_TABLE (keymapping_table), keymaptype_label, 0, 1, 0, 1,
	    (GtkAttachOptions) (GTK_FILL),
	    (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (keymaptype_label), 0, 0.5);

	keymaptype_combo = gtk_combo_new ();
	gtk_widget_ref (keymaptype_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "keymaptype_combo", keymaptype_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keymaptype_combo);
	gtk_table_attach (GTK_TABLE (keymapping_table), keymaptype_combo, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_combo_set_value_in_list (GTK_COMBO (keymaptype_combo), TRUE, FALSE);
	keymaptype_combo_items = g_list_append (keymaptype_combo_items, (gpointer) _("Default layout"));
	for (i=0;x11_keymaps_layout[i].shortname;i++)
	 {
	   keymaptype_combo_items = g_list_append (keymaptype_combo_items,
					(gpointer) _(x11_keymaps_layout[i].name));
	 }
	gtk_combo_set_popdown_strings (GTK_COMBO (keymaptype_combo), keymaptype_combo_items);
	g_list_free (keymaptype_combo_items);

	keymaptype_combo_entry = GTK_COMBO (keymaptype_combo)->entry;
	gtk_widget_ref (keymaptype_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "keymaptype_combo_entry", keymaptype_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_editable_set_editable (GTK_EDITABLE (keymaptype_combo_entry), FALSE);
	gtk_widget_show (keymaptype_combo_entry);

/* ugcicoin */
	ugcicoin_checkbutton = gtk_check_button_new_with_label (_("UGCI(tm) Coin/Play support"));
	gtk_widget_ref (ugcicoin_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "ugcicoin_checkbutton", ugcicoin_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (ugcicoin_checkbutton);
	gtk_table_attach (GTK_TABLE (joystick_table), ugcicoin_checkbutton, 5, 7, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* end controllers*/
	control_label = gtk_label_new (_("Controllers"));
	gtk_widget_ref (control_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "control_label", control_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (control_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), control_label);


	gtk_widget_set_sensitive(paddevname_label,FALSE);
	gtk_widget_set_sensitive(paddevname_entry,FALSE);
	gtk_widget_set_sensitive(x11joyname_label,FALSE);
	gtk_widget_set_sensitive(x11joyname_entry,FALSE);
	gtk_widget_set_sensitive(joydevname_label,FALSE);
	gtk_widget_set_sensitive(joydevname_entry,FALSE);

	switch(target->joytype)
	{
		case(0): /* no joystick */
			gtk_widget_set_sensitive(analogstick_checkbutton,FALSE);
			gtk_widget_set_sensitive(usbpspad_checkbutton,FALSE);
			gtk_widget_set_sensitive(rapidfire_checkbutton,FALSE);
			break;
		case(1): /* i386 style */
		case(4): /* new i386 linux 1.x.x driver */
			gtk_widget_set_sensitive(joydevname_label,TRUE);
			gtk_widget_set_sensitive(joydevname_entry,TRUE);
			break;
		case(2): /* Fm Town Pad */
			gtk_widget_set_sensitive(paddevname_label,TRUE);
			gtk_widget_set_sensitive(paddevname_entry,TRUE);
			break;
		case(3): /* X11 input extension */
			gtk_widget_set_sensitive(x11joyname_label,TRUE);
			gtk_widget_set_sensitive(x11joyname_entry,TRUE);
			break;
	}

	gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), joytype_name[target->joytype]);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (analogstick_checkbutton), target->analogstick);
	gtk_entry_set_text (GTK_ENTRY (ctrlr_combo_entry), target->ctrlr);
	gtk_widget_set_sensitive (GTK_WIDGET (ctrlr_combo), available_options->ctrlr);
	gtk_widget_set_sensitive(hotrod_checkbutton, !(available_options->newhotrodusage));
	gtk_widget_set_sensitive(hotrodse_checkbutton, !(available_options->newhotrodusage));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrod_checkbutton), target->hotrod);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrodse_checkbutton), target->hotrodse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (usbpspad_checkbutton), target->usbpspad);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rapidfire_checkbutton), target->rapidfire);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ugcicoin_checkbutton), target->ugcicoin);
	gtk_entry_set_text (GTK_ENTRY (joydevname_entry), target->joydevname);
	gtk_entry_set_text (GTK_ENTRY (paddevname_entry), target->paddevname);
	gtk_entry_set_text (GTK_ENTRY (x11joyname_entry), target->x11joyname);
/*	gtk_entry_set_text (GTK_ENTRY (XInput_joystick1_entry), target->XInput_joystick1);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick2_entry), target->XInput_joystick2);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick3_entry), target->XInput_joystick3);
	gtk_entry_set_text (GTK_ENTRY (XInput_joystick4_entry), target->XInput_joystick4);*/
	gtk_widget_set_sensitive(GTK_WIDGET(Xinput_joy_frame),FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mouse_checkbutton), target->mouse);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabmouse_checkbutton), target->grabmouse);
	gtk_widget_set_sensitive (GTK_WIDGET (grabmouse_checkbutton), target->mouse && available_options->grabmouse);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball1_entry), target->XInput_trackball1);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball2_entry), target->XInput_trackball2);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball3_entry), target->XInput_trackball3);
	gtk_entry_set_text (GTK_ENTRY (XInput_trackball4_entry), target->XInput_trackball4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabkeyboard_checkbutton), target->grabkeyboard);
	gtk_widget_set_sensitive (GTK_WIDGET (grabkeyboard_checkbutton), available_options->grabkeyboard);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winkeys_checkbutton), target->winkeys);
	gtk_widget_set_sensitive (GTK_WIDGET (config_name_checkbutton), (available_options->cfgname || available_options->ConfigDirectory));
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config_name_checkbutton), target->cfgname_flag);
	gtk_widget_set_sensitive (GTK_WIDGET (config_name_entry), (target->cfgname_flag && (available_options->cfgname || available_options->ConfigDirectory)));
	gtk_entry_set_text (GTK_ENTRY (config_name_entry), target->cfgname);

	for (i=0;x11_keymaps_layout[i].shortname;i++)
	{
		if (strcmp(x11_keymaps_layout[i].shortname,target->keymap)==0)
			gtk_entry_set_text (GTK_ENTRY (keymaptype_combo_entry), _(x11_keymaps_layout[i].name));
	}

	g_signal_connect (G_OBJECT (joytype_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (joytype_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (joytype_combo_entry), "changed",
			          G_CALLBACK (joystick_choosen),
			          NULL);
	g_signal_connect (G_OBJECT (analogstick_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (analogstick_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (hotrod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (hotrod_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (hotrodse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (hotrodse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (usbpspad_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (usbpspad_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (rapidfire_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (rapidfire_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (ugcicoin_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (ugcicoin_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (joydevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (joydevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (paddevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (paddevname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (x11joyname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (x11joyname_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
/*	g_signal_connect (G_OBJECT (XInput_joystick1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_joystick4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_joystick4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);*/
	g_signal_connect (G_OBJECT (mouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (mouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	if(available_options->grabmouse)
		g_signal_connect_after (G_OBJECT (mouse_checkbutton), "toggled",
				          G_CALLBACK (button_toggled),
				          grabmouse_checkbutton);
	g_signal_connect (G_OBJECT (grabmouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (grabmouse_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball1_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball2_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball3_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (XInput_trackball4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (XInput_trackball4_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (winkeys_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (winkeys_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (grabkeyboard_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (grabkeyboard_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
 	g_signal_connect (G_OBJECT (keymaptype_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    apply_button);
 	g_signal_connect (G_OBJECT (keymaptype_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    reset_button);
	if(available_options->cfgname || available_options->ConfigDirectory)
	{
		g_signal_connect (G_OBJECT (config_name_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (config_name_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect (G_OBJECT (config_name_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (config_name_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (config_name_checkbutton), "toggled",
				          G_CALLBACK (button_toggled),
				          config_name_entry);
	}
	if (available_options->ctrlr)
	{
		g_signal_connect (G_OBJECT (ctrlr_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (ctrlr_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
	}

}


void add_misc_options_tab (GtkWidget    *properties_windows,
		           GtkNotebook  *target_notebook,
			   RomEntry     *rom,
			   GtkWidget    *apply_button,
			   GtkWidget    *reset_button,
			   guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;

	GtkWidget *misc_table;
	GtkWidget *misc_hseparator;
	GtkWidget *misc_hbox;
	GtkWidget *misc_pixmap;
	GtkWidget *misc_title;
	GtkWidget *artwork_table;
	GtkWidget *art_res_table;
	GtkWidget *artwork_resolution_combo;
	GList *artwork_resolution_combo_items = NULL;
	GtkWidget *other_misc_frame;
	GtkWidget *other_misc_table;
	GtkWidget *network_table;
	GtkWidget *network_mode_frame;
	GtkWidget *network_mode_table;
	GSList *net_mode_group = NULL;
	GtkWidget *slave_hbox;
	GtkWidget *master_hbox;
	GtkWidget *misc_label;
	GList *debug_size_combo_items = NULL;
	GList *bios_combo_items = NULL;

	int i;
	gchar *used_text;
	gchar title[BUFFER_SIZE];
	xmame_game_options *target;
	xmame_available_options *available_options;

	available_options = xmame_executable_get_options(current_exec);	
	dirty_options_flag = FALSE;

	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	misc_table = gtk_table_new (8, 2, FALSE);
	gtk_widget_ref (misc_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "misc_table", misc_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), misc_table);
	gtk_container_set_border_width (GTK_CONTAINER (misc_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (misc_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (misc_table), 5);

	misc_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (misc_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "misc_hseparator", misc_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_hseparator);
	gtk_table_attach (GTK_TABLE (misc_table), misc_hseparator, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	misc_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (misc_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "misc_hbox", misc_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_hbox);
	gtk_table_attach (GTK_TABLE (misc_table), misc_hbox, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				general_xpm);
	misc_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (misc_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "misc_pixmap", misc_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_pixmap);
	gtk_box_pack_start (GTK_BOX (misc_hbox), misc_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (misc_pixmap), 10, 0);

	if (rom) 
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		misc_title = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		misc_title = gtk_label_new (_("Global game options\nDefault options used by all games"));
	gtk_widget_ref (misc_title);
	g_object_set_data_full (G_OBJECT (properties_windows), "misc_title", misc_title,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_title);
	gtk_box_pack_start (GTK_BOX (misc_hbox), misc_title, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (misc_title), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (misc_title), TRUE);
	gtk_misc_set_padding (GTK_MISC (misc_title), 10, 0);

/* additional artwork */
	artwork_checkbutton = gtk_check_button_new_with_label (_("Use additional game artwork"));
	gtk_widget_ref (artwork_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_checkbutton", artwork_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_checkbutton);
	gtk_table_attach (GTK_TABLE (misc_table), artwork_checkbutton, 0, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	artwork_frame = gtk_frame_new (_("Use additional game artwork"));
	gtk_widget_ref (artwork_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_frame", artwork_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_frame);
	gtk_table_attach (GTK_TABLE (misc_table), artwork_frame, 0, 2, 3, 4,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	artwork_table = gtk_table_new (1, 3, FALSE);
	gtk_widget_ref (artwork_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_table", artwork_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_table);
	gtk_container_add (GTK_CONTAINER (artwork_frame), artwork_table);

	use_backdrops_checkbutton = gtk_check_button_new_with_label (_("Backdrops"));
	gtk_widget_ref (use_backdrops_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "use_backdrops_checkbutton", use_backdrops_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (use_backdrops_checkbutton);
	gtk_table_attach (GTK_TABLE (artwork_table), use_backdrops_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	use_bezels_checkbutton = gtk_check_button_new_with_label (_("Bezels"));
	gtk_widget_ref (use_bezels_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "use_bezels_checkbutton", use_bezels_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (use_bezels_checkbutton);
	gtk_table_attach (GTK_TABLE (artwork_table), use_bezels_checkbutton, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	use_overlays_checkbutton = gtk_check_button_new_with_label (_("Overlays"));
	gtk_widget_ref (use_overlays_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "use_overlays_checkbutton", use_overlays_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (use_overlays_checkbutton);
	gtk_table_attach (GTK_TABLE (artwork_table), use_overlays_checkbutton, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* artwork resolution */
	artwork_resolution_frame = gtk_frame_new (_("Artwork Resolution"));
	gtk_widget_ref (artwork_resolution_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_resolution_frame", artwork_resolution_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_resolution_frame);
	gtk_table_attach (GTK_TABLE (misc_table), artwork_resolution_frame, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	art_res_table = gtk_table_new (1, 1, FALSE);
	gtk_widget_ref (art_res_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "art_res_table", art_res_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (art_res_table);
	gtk_container_add (GTK_CONTAINER (artwork_resolution_frame), art_res_table);

	artwork_resolution_combo = gtk_combo_new ();
	gtk_widget_ref (artwork_resolution_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_resolution_combo", artwork_resolution_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_resolution_combo);
	gtk_table_attach (GTK_TABLE (art_res_table), artwork_resolution_combo, 0, 1, 0, 1,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 35, 5);
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("Auto"));
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("Standard"));
	artwork_resolution_combo_items = g_list_append (artwork_resolution_combo_items, (gpointer) _("High"));
	gtk_combo_set_popdown_strings (GTK_COMBO (artwork_resolution_combo), artwork_resolution_combo_items);
	g_list_free (artwork_resolution_combo_items);

	artwork_resolution_combo_entry = GTK_COMBO (artwork_resolution_combo)->entry;
	gtk_widget_ref (artwork_resolution_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "artwork_resolution_combo_entry", artwork_resolution_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artwork_resolution_combo_entry);
	gtk_editable_set_editable (GTK_EDITABLE (artwork_resolution_combo_entry), FALSE);
	gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), _("Auto"));

/* artwork crop */
	artcrop_frame = gtk_frame_new (_("Artwork Misc"));
	gtk_widget_ref (artcrop_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "artcrop_frame", artcrop_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artcrop_frame);
	gtk_table_attach (GTK_TABLE (misc_table), artcrop_frame, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	artcrop_checkbutton = gtk_check_button_new_with_label (_("Crop artwork"));
	gtk_widget_ref (artcrop_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "artcrop_checkbutton", artcrop_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (artcrop_checkbutton);
	gtk_container_add (GTK_CONTAINER (artcrop_frame), artcrop_checkbutton);

	other_misc_frame = gtk_frame_new (_("Other Options"));
	gtk_widget_ref (other_misc_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "other_misc_frame", other_misc_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (other_misc_frame);
	gtk_table_attach (GTK_TABLE (misc_table), other_misc_frame, 0, 2, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

/* misc options */
	other_misc_table = gtk_table_new (4, 3, FALSE);
	gtk_widget_ref (other_misc_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "other_misc_table", other_misc_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (other_misc_table);
	gtk_container_add (GTK_CONTAINER (other_misc_frame), other_misc_table);

	keyboard_leds_checkbutton = gtk_check_button_new_with_label (_("Use keyboard LEDs as game indicators"));
	gtk_widget_ref (keyboard_leds_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "keyboard_leds_checkbutton", keyboard_leds_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (keyboard_leds_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), keyboard_leds_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), TRUE);

	cheat_checkbutton = gtk_check_button_new_with_label (_("Enable game cheats"));
	gtk_widget_ref (cheat_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "cheat_checkbutton", cheat_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cheat_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), cheat_checkbutton, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), TRUE);

	disclaimer_checkbutton = gtk_check_button_new_with_label (_("Skip Disclaimer Info"));
	gtk_widget_ref (disclaimer_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "disclaimer_checkbutton", disclaimer_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (disclaimer_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), disclaimer_checkbutton, 3, 4, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), TRUE);

	gameinfo_checkbutton = gtk_check_button_new_with_label (_("Skip Game Info"));
	gtk_widget_ref (gameinfo_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "gameinfo_checkbutton", gameinfo_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gameinfo_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), gameinfo_checkbutton, 3, 4, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), TRUE);

	additional_options_checkbutton = gtk_check_button_new_with_label (_("Use additional options"));
	gtk_widget_ref (additional_options_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "additional_options_checkbutton", additional_options_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (additional_options_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), additional_options_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), TRUE);

	additional_options_entry = gtk_entry_new ();
	gtk_widget_ref (additional_options_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "additional_options_entry", additional_options_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (additional_options_entry);
	gtk_table_attach (GTK_TABLE (other_misc_table), additional_options_entry, 1, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
	debug_checkbutton = gtk_check_button_new_with_label (_("debug windows (for developers)"));
	gtk_widget_ref (debug_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "debug_checkbutton", debug_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (debug_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), debug_checkbutton, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	debug_size_label = gtk_label_new (_("Window size : "));
	gtk_widget_ref (debug_size_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "debug_size_label", debug_size_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (debug_size_label);
	gtk_table_attach (GTK_TABLE (other_misc_table), debug_size_label, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (debug_size_label), 1, 0.5);

	debug_size_combo = gtk_combo_new ();
	gtk_widget_ref (debug_size_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "debug_size_combo", debug_size_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (debug_size_combo);
	gtk_table_attach (GTK_TABLE (other_misc_table), debug_size_combo, 2, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (debug_size_combo, 93, -1);
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "640x480");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "800x600");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1024x768");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1280x1024");
	debug_size_combo_items = g_list_append (debug_size_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (debug_size_combo), debug_size_combo_items);
	g_list_free (debug_size_combo_items);

	debug_size_combo_entry = GTK_COMBO (debug_size_combo)->entry;
	gtk_widget_ref (debug_size_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "debug_size_combo_entry", debug_size_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (debug_size_combo_entry);
	gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), "640x480");

	log_flag_checkbutton = gtk_check_button_new_with_label (_("Log debug info"));
	gtk_widget_ref (log_flag_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "log_flag_checkbutton", log_flag_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_flag_checkbutton);
	gtk_table_attach (GTK_TABLE (other_misc_table), log_flag_checkbutton, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	log_label = gtk_label_new (_("File : "));
	gtk_widget_ref (log_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "log_label", log_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_label);
	gtk_table_attach (GTK_TABLE (other_misc_table), log_label, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (log_label), 1, 0.5);

	log_entry = gtk_entry_new ();
	gtk_widget_ref (log_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "log_entry", log_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (log_entry);
	gtk_table_attach (GTK_TABLE (other_misc_table), log_entry, 2, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
/********************************************/
	
	bios_label = gtk_label_new (_("Neo-Geo Bios : "));
	gtk_widget_ref (bios_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "bios_label", bios_label,
	    (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bios_label);
	gtk_table_attach (GTK_TABLE (other_misc_table), bios_label, 3, 4, 2, 3,
	    (GtkAttachOptions) (GTK_FILL),
	    (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (bios_label), 0, 0.5);

	bios_combo = gtk_combo_new ();
	gtk_widget_ref (bios_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "bios_combo", bios_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bios_combo);
	gtk_table_attach (GTK_TABLE (other_misc_table), bios_combo, 3, 4, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_combo_set_value_in_list (GTK_COMBO (bios_combo), TRUE, FALSE);
/*	bios_combo_items = g_list_append (bios_combo_items, (gpointer) _("bios")); */
	i=0;
	do {
		bios_combo_items = g_list_append (bios_combo_items,(gpointer) _(bios_version[i]));
		i++;
	} while (bios_version[i]);
	gtk_combo_set_popdown_strings (GTK_COMBO (bios_combo), bios_combo_items);
	g_list_free (bios_combo_items);

	bios_combo_entry = GTK_COMBO (bios_combo)->entry;
	gtk_widget_ref (bios_combo_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "bios_combo_entry", bios_combo_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_editable_set_editable (GTK_EDITABLE (bios_combo_entry), FALSE);
	gtk_widget_show (bios_combo_entry);

/********************************************/
	
/* network options */
	network_frame = gtk_frame_new (_("Network Options"));
	gtk_widget_ref (network_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "network_frame", network_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (network_frame);
	gtk_table_attach (GTK_TABLE (misc_table), network_frame, 0, 2, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	network_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (network_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "network_table", network_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (network_table);
	gtk_container_add (GTK_CONTAINER (network_frame), network_table);

	network_option_checkbutton = gtk_check_button_new_with_label (_("Use network"));
	gtk_widget_ref (network_option_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "network_option_checkbutton", network_option_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (network_option_checkbutton);
	gtk_table_attach (GTK_TABLE (misc_table), network_option_checkbutton, 0, 2, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* network mode */
	network_mode_frame = gtk_frame_new (_("Network Mode"));
	gtk_widget_ref (network_mode_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "network_mode_frame", network_mode_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (network_mode_frame);
	gtk_table_attach (GTK_TABLE (network_table), network_mode_frame, 0, 2, 0, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	network_mode_table = gtk_table_new (2, 2, FALSE);
	gtk_widget_ref (network_mode_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "network_mode_table", network_mode_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (network_mode_table);
	gtk_container_add (GTK_CONTAINER (network_mode_frame), network_mode_table);
	gtk_table_set_col_spacings (GTK_TABLE (network_mode_table), 40);

/* client */
	client_mode_radiobutton = gtk_radio_button_new_with_label (net_mode_group, _("Client Mode"));
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (client_mode_radiobutton), net_mode_group);
	gtk_widget_ref (client_mode_radiobutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "client_mode_radiobutton", client_mode_radiobutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (client_mode_radiobutton);
	gtk_table_attach (GTK_TABLE (network_mode_table), client_mode_radiobutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	slave_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (slave_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "slave_hbox", slave_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (slave_hbox);
	gtk_table_attach (GTK_TABLE (network_mode_table), slave_hbox, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	slave_label = gtk_label_new (_("Host[:Port] : "));
	gtk_widget_ref (slave_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "slave_label", slave_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (slave_label);
	gtk_box_pack_start (GTK_BOX (slave_hbox), slave_label, FALSE, FALSE, 0);

	slave_entry = (GtkWidget *) gtk_entry_new ();
	gtk_entry_set_max_length (GTK_ENTRY(slave_entry), 20);
	gtk_widget_ref (slave_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "slave_entry", slave_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (slave_entry);
	gtk_box_pack_start (GTK_BOX (slave_hbox), slave_entry, FALSE, TRUE, 0);

/* server */
	server_mode_radiobutton = gtk_radio_button_new_with_label (net_mode_group, _("Server Mode"));
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (server_mode_radiobutton), net_mode_group);
	gtk_widget_ref (server_mode_radiobutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "server_mode_radiobutton", server_mode_radiobutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (server_mode_radiobutton);
	gtk_table_attach (GTK_TABLE (network_mode_table), server_mode_radiobutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (server_mode_radiobutton), TRUE);

	master_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (master_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "master_hbox", master_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (master_hbox);
	gtk_table_attach (GTK_TABLE (network_mode_table), master_hbox, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	master_label = gtk_label_new (_("Number of player : "));
	gtk_widget_ref (master_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "master_label", master_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (master_label);
	gtk_box_pack_start (GTK_BOX (master_hbox), master_label, FALSE, FALSE, 0);

	master_spinbutton_adj = gtk_adjustment_new (target->master, 2, 100, 1, 10, 10);
	master_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (master_spinbutton_adj), 1, 0);
	gtk_widget_ref (master_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "master_spinbutton", master_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (master_spinbutton);
	gtk_box_pack_start (GTK_BOX (master_hbox), master_spinbutton, FALSE, TRUE, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (master_spinbutton), TRUE);

/* netmap key */
	netmapkey_checkbutton = gtk_check_button_new_with_label (_("Use NetMapKey"));
	gtk_widget_ref (netmapkey_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "netmapkey_checkbutton", netmapkey_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (netmapkey_checkbutton);
	gtk_table_attach (GTK_TABLE (network_table), netmapkey_checkbutton, 2, 3, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* statedebug */
	statedebug_checkbutton = gtk_check_button_new_with_label (_("Statedebug"));
	gtk_widget_ref (statedebug_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "statedebug_checkbutton", statedebug_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (statedebug_checkbutton);
	gtk_table_attach (GTK_TABLE (network_table), statedebug_checkbutton, 2, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

/* bind */
	bind_flag_checkbutton = gtk_check_button_new_with_label (_("Bind port :"));
	gtk_widget_ref (bind_flag_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "bind_flag_checkbutton", bind_flag_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bind_flag_checkbutton);
	gtk_table_attach (GTK_TABLE (network_table), bind_flag_checkbutton, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);

	bind_spinbutton_adj = gtk_adjustment_new (target->bind, 1, 65535, 1, 10, 10);
	bind_spinbutton =  gtk_spin_button_new (GTK_ADJUSTMENT (bind_spinbutton_adj), 1, 0);
	gtk_widget_ref (bind_spinbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "bind_spinbutton", bind_spinbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (bind_spinbutton);
	gtk_table_attach (GTK_TABLE (network_table), bind_spinbutton, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (bind_spinbutton), TRUE);

/* parallesynch */
	parallelsync_checkbutton = gtk_check_button_new_with_label (_("Perform network input sync in advance"));
	gtk_widget_ref (parallelsync_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "parallelsync_checkbutton", parallelsync_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (parallelsync_checkbutton);
	gtk_table_attach (GTK_TABLE (network_table), parallelsync_checkbutton, 2, 3, 2, 3,

			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	
/* end misc options */
	misc_label = gtk_label_new (_("Misc"));
	gtk_widget_ref (misc_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "misc_label", misc_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (misc_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), misc_label);

	
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artwork_checkbutton), target->artwork);
	/* the use_backdrops option will be used for all new backdrop option maybe change after */
	gtk_widget_set_sensitive (GTK_WIDGET(artwork_frame), available_options->use_backdrops && target->artwork);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_backdrops_checkbutton), target->use_backdrops);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_bezels_checkbutton), target->use_bezels);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_overlays_checkbutton), target->use_overlays);
	switch(target->artwork_resolution)
	{
		case(0):
			g_snprintf(title,BUFFER_SIZE,"%s",_("Auto"));
			break;
		case(1):
			g_snprintf(title,BUFFER_SIZE,"%s",_("Standard"));
			break;
		case(2):
			g_snprintf(title,BUFFER_SIZE,"%s",_("High"));
			break;
	}
	gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), title);
	gtk_widget_set_sensitive (GTK_WIDGET(artwork_resolution_frame), available_options->artwork_resolution && target->artwork);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artcrop_checkbutton), target->artwork_crop);
	gtk_widget_set_sensitive (GTK_WIDGET(artcrop_frame), available_options->artwork_crop && target->artwork);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), target->keyboard_leds);
	gtk_widget_set_sensitive (GTK_WIDGET(keyboard_leds_checkbutton), available_options->keyboard_leds);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), target->cheat);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), target->skip_disclaimer);
	gtk_widget_set_sensitive (GTK_WIDGET(disclaimer_checkbutton), available_options->skip_disclaimer);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), target->skip_gameinfo);
	gtk_widget_set_sensitive (GTK_WIDGET(gameinfo_checkbutton), available_options->skip_gameinfo);
	gtk_widget_set_sensitive (GTK_WIDGET(bios_label), available_options->bios);
	gtk_widget_set_sensitive (GTK_WIDGET(bios_combo), available_options->bios);
	i=0;
	do {
		if (i == target->bios)
			gtk_entry_set_text (GTK_ENTRY (bios_combo_entry), _(bios_version[i]));
		i++;
	} while (bios_version[i]);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (debug_checkbutton), target->debug);
	gtk_widget_set_sensitive (GTK_WIDGET(debug_checkbutton), available_options->debug);
	gtk_widget_set_sensitive (GTK_WIDGET(debug_size_label), available_options->debug && target->debug);
	gtk_widget_set_sensitive (GTK_WIDGET(debug_size_combo), available_options->debug && target->debug);
	gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), target->debug_size);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), target->use_additional_options);
	gtk_widget_set_sensitive (GTK_WIDGET(additional_options_entry), target->use_additional_options);
	gtk_entry_set_text (GTK_ENTRY (additional_options_entry), target->additional_options);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (log_flag_checkbutton), target->log_flag);
	gtk_widget_set_sensitive (GTK_WIDGET(log_label), target->log_flag);
	gtk_widget_set_sensitive (GTK_WIDGET(log_entry), target->log_flag);
	gtk_entry_set_text (GTK_ENTRY (log_entry), target->log);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (network_option_checkbutton), (target->network_flag)!=0?TRUE:FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET(network_option_checkbutton), available_options->network);
	gtk_widget_set_sensitive (GTK_WIDGET (network_frame), ((target->network_flag)!=0?TRUE:FALSE) && available_options->network);

	gtk_widget_set_sensitive (GTK_WIDGET (slave_label), (target->network_flag)==2?TRUE:FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (slave_entry), (target->network_flag)==2?TRUE:FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (netmapkey_checkbutton), (target->network_flag)==2);
	gtk_widget_set_sensitive (GTK_WIDGET (statedebug_checkbutton), ((target->network_flag)!=2) && available_options->statedebug);
	gtk_widget_set_sensitive (GTK_WIDGET (master_label), (target->network_flag)!=2?TRUE:FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (master_spinbutton), (target->network_flag)!=2?TRUE:FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (client_mode_radiobutton), (target->network_flag)==2?TRUE:FALSE);
	gtk_entry_set_text (GTK_ENTRY (slave_entry), target->slave);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (netmapkey_checkbutton), target->netmapkey);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (parallelsync_checkbutton), target->parallelsync);
	gtk_widget_set_sensitive (GTK_WIDGET(parallelsync_checkbutton), available_options->parallelsync);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (statedebug_checkbutton), target->statedebug);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bind_flag_checkbutton), target->bind_flag);
	gtk_widget_set_sensitive (GTK_WIDGET(bind_spinbutton), available_options->bind && target->bind_flag);
	gtk_widget_set_sensitive (GTK_WIDGET(bind_flag_checkbutton), available_options->bind);

	g_signal_connect (G_OBJECT (artwork_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (artwork_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	if (available_options->use_backdrops)
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  artwork_frame);
	if (available_options->artwork_resolution)
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  artwork_resolution_frame);
	if (available_options->artwork_crop)
		g_signal_connect_after (G_OBJECT (artwork_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  artcrop_frame);
	g_signal_connect (G_OBJECT (use_backdrops_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (use_backdrops_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (use_bezels_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (use_bezels_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (use_overlays_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (use_overlays_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (artwork_resolution_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (artwork_resolution_combo_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (artcrop_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (artcrop_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (disclaimer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (disclaimer_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gameinfo_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gameinfo_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);

	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	if(available_options->debug)
	{
		g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
		g_signal_connect_after (G_OBJECT (debug_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  debug_size_combo);
		g_signal_connect_after (G_OBJECT (debug_checkbutton), "toggled",
				    	  G_CALLBACK (button_toggled),
				    	  debug_size_label);
		g_signal_connect (G_OBJECT (debug_size_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    apply_button);
		g_signal_connect (G_OBJECT (debug_size_combo_entry), "changed",
				    G_CALLBACK (on_dirty_option),
				    reset_button);
	}
	g_signal_connect (G_OBJECT (additional_options_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (additional_options_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (additional_options_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  additional_options_entry);
	g_signal_connect (G_OBJECT (additional_options_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (additional_options_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
 	g_signal_connect (G_OBJECT (bios_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    apply_button);
 	g_signal_connect (G_OBJECT (bios_combo_entry), "changed",
 			    G_CALLBACK (on_dirty_option),
 			    reset_button);

	g_signal_connect (G_OBJECT (log_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (log_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (log_flag_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  log_label);
	g_signal_connect_after (G_OBJECT (log_flag_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  log_entry);
	g_signal_connect (G_OBJECT (log_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (log_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (network_option_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (network_option_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (network_option_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  network_frame);
	g_signal_connect (G_OBJECT (server_mode_radiobutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (server_mode_radiobutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect_after (G_OBJECT (server_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  master_label);
	g_signal_connect_after (G_OBJECT (server_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  master_spinbutton);
	if(available_options->statedebug)
	{
		g_signal_connect_after (G_OBJECT (server_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  statedebug_checkbutton);
	}
	g_signal_connect_after (G_OBJECT (client_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  slave_label);
	g_signal_connect_after (G_OBJECT (client_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  slave_entry);
	g_signal_connect_after (G_OBJECT (client_mode_radiobutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  netmapkey_checkbutton);
	g_signal_connect_after (G_OBJECT (bind_flag_checkbutton), "toggled",
			    	  G_CALLBACK (button_toggled),
			    	  bind_spinbutton);
	g_signal_connect (G_OBJECT (slave_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (slave_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (master_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (master_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (netmapkey_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (netmapkey_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (parallelsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (parallelsync_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (cheat_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (debug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (keyboard_leds_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (bind_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (bind_spinbutton), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (bind_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (bind_flag_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (statedebug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (statedebug_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
}


void add_vector_options_tab (GtkWidget    *properties_windows,
		             GtkNotebook  *target_notebook,
			     RomEntry     *rom,
			     GtkWidget    *apply_button,
			     GtkWidget    *reset_button,
			     guint tab_position)
{
	GdkPixmap *gdk_pixmap;
	GdkBitmap *mask;
	GdkColor  transparent;

	GtkWidget *vector_table;
	GtkWidget *beam_label;
	GtkWidget *flicker_label;
	GtkWidget *intensity_label;
	GtkWidget *vector_hseparator;
	GtkWidget *vector_hbox;
	GtkWidget *vector_pixmap;
	GtkWidget *vector_title_label;
	GtkWidget *gl_vector_frame;
	GtkWidget *gl_vector_table;
	GtkWidget *vectorres_combo;
	GList *vectorres_combo_items = NULL;
	GtkWidget *vector_label;

	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;	

	available_options = xmame_executable_get_options(current_exec);
	dirty_options_flag = FALSE;
  
	if (rom==NULL)
	{
		target = &default_options;
	}
	else
	{
		/* use the selected game option if game_options exists */
		if (game_options)
			target = game_options;
		else
		/* otherwise, use default game option */
		target = &default_options;
	}

	vector_table = gtk_table_new (10, 3, FALSE);
	gtk_widget_ref (vector_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_table", vector_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_table);
	gtk_container_add (GTK_CONTAINER (target_notebook), vector_table);
	gtk_container_set_border_width (GTK_CONTAINER (vector_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (vector_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (vector_table), 5);

	vector_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (vector_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_hbox", vector_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_hbox);
	gtk_table_attach (GTK_TABLE (vector_table), vector_hbox, 0, 3, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask,
				&transparent,
				general_xpm);
	vector_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap,mask);
	gtk_widget_ref (vector_pixmap);
	g_object_unref(gdk_pixmap);
	g_object_unref(mask);

	g_object_set_data_full (G_OBJECT (properties_windows), "vector_pixmap", vector_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_pixmap);
	gtk_box_pack_start (GTK_BOX (vector_hbox), vector_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (vector_pixmap), 10, 0);

	if (rom) 
	{
		used_text = g_strdup_printf("%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
		vector_title_label = gtk_label_new (used_text);
		g_free(used_text);
	}
	else
		vector_title_label = gtk_label_new (_("Global game options\nDefault options used by all games"));
	gtk_widget_ref (vector_title_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_title_label", vector_title_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_title_label);
	gtk_box_pack_start (GTK_BOX (vector_hbox), vector_title_label, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (vector_title_label), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (vector_title_label), TRUE);
	gtk_misc_set_padding (GTK_MISC (vector_title_label), 10, 0);

	vector_hseparator = gtk_hseparator_new ();
	gtk_widget_ref (vector_hseparator);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_hseparator", vector_hseparator,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_hseparator);
	gtk_table_attach (GTK_TABLE (vector_table), vector_hseparator, 0, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

/* tranlucencent vectors */
	antialias_checkbutton = gtk_check_button_new_with_label (_("Draw antialiased vectors"));
	gtk_widget_ref (antialias_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "antialias_checkbutton", antialias_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (antialias_checkbutton);
	gtk_table_attach (GTK_TABLE (vector_table), antialias_checkbutton, 0, 3, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (antialias_checkbutton), TRUE);

/* tranlucencent vectors */
	translucency_checkbutton = gtk_check_button_new_with_label (_("Draw tranlucencent vectors"));
	gtk_widget_ref (translucency_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "translucency_checkbutton", translucency_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (translucency_checkbutton);
	gtk_table_attach (GTK_TABLE (vector_table), translucency_checkbutton, 0, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (translucency_checkbutton), TRUE);

/* beam size */
	beam_label = gtk_label_new (_("Beam size"));
	gtk_widget_ref (beam_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "beam_label", beam_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (beam_label);
	gtk_table_attach (GTK_TABLE (vector_table), beam_label, 0, 3, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (beam_label), 0, 0.5);

	beam_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->beam, 1, 16, 0.1, 0, 0)));
	gtk_widget_ref (beam_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "beam_hscale", beam_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (beam_hscale);
	gtk_table_attach (GTK_TABLE (vector_table), beam_hscale, 0, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_value_pos (GTK_SCALE (beam_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (beam_hscale), 2);

/* Flicker */
	flicker_label = gtk_label_new (_("Flicker"));
	gtk_widget_ref (flicker_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "flicker_label", flicker_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (flicker_label);
	gtk_table_attach (GTK_TABLE (vector_table), flicker_label, 0, 3, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (flicker_label), 0, 0.5);

	flicker_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->flicker, 0, 100, 1, 10, 0)));
	gtk_widget_ref (flicker_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "flicker_hscale", flicker_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (flicker_hscale);
	gtk_table_attach (GTK_TABLE (vector_table), flicker_hscale, 0, 3, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_value_pos (GTK_SCALE (flicker_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (flicker_hscale), 0);

/* Intensity */
	intensity_label = gtk_label_new (_("Intensity"));
	gtk_widget_ref (intensity_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "intensity_label", intensity_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (intensity_label);
	gtk_table_attach (GTK_TABLE (vector_table), intensity_label, 0, 3, 8, 9,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (intensity_label), 0, 0.5);

	intensity_hscale = gtk_hscale_new (GTK_ADJUSTMENT (gtk_adjustment_new (target->intensity, 0.5, 3, 0.01, 1, 0)));
	gtk_widget_ref (intensity_hscale);
	g_object_set_data_full (G_OBJECT (properties_windows), "intensity_hscale", intensity_hscale,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (intensity_hscale);
	gtk_table_attach (GTK_TABLE (vector_table), intensity_hscale, 0, 3, 9, 10,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_scale_set_value_pos (GTK_SCALE (intensity_hscale), GTK_POS_RIGHT);
	gtk_scale_set_digits (GTK_SCALE (intensity_hscale), 2);

/* Fixed resolution */
	vector_fixed_resolution_checkbutton = gtk_check_button_new_with_label (_("Use fixed resolution"));
	gtk_widget_ref (vector_fixed_resolution_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_fixed_resolution_checkbutton", vector_fixed_resolution_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_fixed_resolution_checkbutton);
	gtk_table_attach (GTK_TABLE (vector_table), vector_fixed_resolution_checkbutton, 0, 1, 10, 11,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);

	vectorres_combo = gtk_combo_new ();
	gtk_widget_ref (vectorres_combo);
	g_object_set_data_full (G_OBJECT (properties_windows), "vectorres_combo", vectorres_combo,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vectorres_combo);
	gtk_table_attach (GTK_TABLE (vector_table), vectorres_combo, 1, 2, 10, 11,
			  (GtkAttachOptions) (0),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_widget_set_size_request (vectorres_combo, 91, -1);
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "320x200");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "640x480");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "800x600");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1024x768");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1280x1024");
	vectorres_combo_items = g_list_append (vectorres_combo_items, (gpointer) "1600x1200");
	gtk_combo_set_popdown_strings (GTK_COMBO (vectorres_combo), vectorres_combo_items);
	g_list_free (vectorres_combo_items);

	vectorres_entry = GTK_COMBO (vectorres_combo)->entry;
	gtk_widget_ref (vectorres_entry);
	g_object_set_data_full (G_OBJECT (properties_windows), "vectorres_entry", vectorres_entry,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vectorres_entry);
	gtk_entry_set_text (GTK_ENTRY (vectorres_entry), "640x480");

/* Open GL */
	gl_vector_frame = gtk_frame_new (_("OpenGL options"));
	gtk_widget_ref (gl_vector_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "gl_vector_frame", gl_vector_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gl_vector_frame);
	gtk_table_attach (GTK_TABLE (vector_table), gl_vector_frame, 0, 3, 11, 12,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);

	gl_vector_table = gtk_table_new (2, 1, FALSE);
	gtk_widget_ref (gl_vector_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "gl_vector_table", gl_vector_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gl_vector_table);
	gtk_container_add (GTK_CONTAINER (gl_vector_frame), gl_vector_table);

	gldrawbitmapvec_checkbutton = gtk_check_button_new_with_label (_("Draw bitmap"));
	gtk_widget_ref (gldrawbitmapvec_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "gldrawbitmapvec_checkbutton", gldrawbitmapvec_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (gldrawbitmapvec_checkbutton);
	gtk_table_attach (GTK_TABLE (gl_vector_table), gldrawbitmapvec_checkbutton, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton), TRUE);

	glantialiasvec_checkbutton = gtk_check_button_new_with_label (_("Antialiasing"));
	gtk_widget_ref (glantialiasvec_checkbutton);
	g_object_set_data_full (G_OBJECT (properties_windows), "glantialiasvec_checkbutton", glantialiasvec_checkbutton,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (glantialiasvec_checkbutton);
	gtk_table_attach (GTK_TABLE (gl_vector_table), glantialiasvec_checkbutton, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton), TRUE);

/* End vector options */
	vector_label = gtk_label_new (_("Vector"));
	gtk_widget_ref (vector_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "vector_label", vector_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vector_label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (target_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (target_notebook), tab_position), vector_label);

	
	if(strcmp(current_exec->target,"xgl"))
		gtk_widget_set_sensitive(GTK_WIDGET(gl_vector_frame),FALSE);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (antialias_checkbutton), target->antialias);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (translucency_checkbutton), target->translucency);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vector_fixed_resolution_checkbutton), target->vectorres_flag);
	gtk_entry_set_text (GTK_ENTRY (vectorres_entry), target->vectorres);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmapvec_checkbutton), target->gldrawbitmapvec);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialiasvec_checkbutton), target->glantialiasvec);
	gtk_widget_set_sensitive (GTK_WIDGET(intensity_label), available_options->intensity);
	gtk_widget_set_sensitive (GTK_WIDGET(intensity_hscale), available_options->intensity);
	

	g_signal_connect (G_OBJECT (antialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (antialias_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (translucency_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (translucency_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(flicker_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(flicker_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(beam_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(beam_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(intensity_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gtk_range_get_adjustment(GTK_RANGE(intensity_hscale))), "value-changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (vector_fixed_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (vector_fixed_resolution_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (vectorres_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (vectorres_entry), "changed",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (gldrawbitmapvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (gldrawbitmapvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
	g_signal_connect (G_OBJECT (glantialiasvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    apply_button);
	g_signal_connect (G_OBJECT (glantialiasvec_checkbutton), "toggled",
			    G_CALLBACK (on_dirty_option),
			    reset_button);
}


void
save_properties_options(RomEntry     *rom)
{
	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;
	int i;

	available_options = xmame_executable_get_options(current_exec);
	if (dirty_options_flag)
	{
		if (rom==NULL)
		{/* saving default game options */
			target = &default_options;
		}
		else
		{/* create a new structure if it wasnt existing */
			if (!game_options)
			{
				game_options = g_malloc (sizeof(xmame_game_options));
				((xmame_game_options *)game_options)->additional_options = g_strdup(default_options.additional_options);
			}
			target = game_options;
		}

/*** Video Related ***/
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(bpp_combo_entry),0,-1);
		if (!strcmp(used_text,_("8 bits")))
			target->bpp = 8;
		else if(!strcmp(used_text,_("16 bits")))
			target->bpp = 16;
		else if(!strcmp(used_text,_("32 bits")))
			target->bpp = 32;
		else	
			target->bpp = 0;
		g_free(used_text);
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(arbheight_entry),0,-1);
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(arbheight_checkbutton)))	
			target->arbheight = atoi(used_text);
		else
			target->arbheight = 0;
		g_free(used_text);
		
		target->heightscale = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(heightscale_spinbutton));
		target->widthscale = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widthscale_spinbutton));
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(effect_entry),0,-1);

		/* Find effect number */
		for (i = 0; effect_name[i]; i++)
		{
			if (!strcmp(used_text, _(effect_name[i])))
				break;
		}
		if (!effect_name[i])
			target->effect = 0;
		else
			target->effect = i;

		g_free(used_text);
		
		target->autodouble = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autodouble_checkbutton));
		target->dirty = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(dirty_checkbutton));
		target->scanlines = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(scanlines_checkbutton));
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(frameskippercombo_entry),0,-1);
		if (!strcmp(used_text,_("Enhanced frameskip code")))
			target->frameskipper = 1;
		else
			target->frameskipper = 0;
		g_free(used_text);
		
		target->throttle = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(throttle_checkbutton));
		target->sleepidle = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sleepidle_checkbutton));
		target->autoframeskip = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton));
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(maxautoframeskip_entry),0,-1);
		target->maxautoframeskip = atoi(used_text);
		g_free(used_text);
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(frameskip_entry),0,-1);
		if (!strcmp(used_text,_("Skip 1 of 12 frames")))
			target->frameskip = 1;
		else if (!strcmp(used_text,_("Skip 2 of 12 frames")))
			target->frameskip = 2;
		else if (!strcmp(used_text,_("Skip 3 of 12 frames")))
			target->frameskip = 3;
		else if (!strcmp(used_text,_("Skip 4 of 12 frames")))
			target->frameskip = 4;
		else if (!strcmp(used_text,_("Skip 5 of 12 frames")))
			target->frameskip = 5;
		else if (!strcmp(used_text,_("Skip 6 of 12 frames")))
			target->frameskip = 6;
		else if (!strcmp(used_text,_("Skip 7 of 12 frames")))
			target->frameskip = 7;
		else if (!strcmp(used_text,_("Skip 8 of 12 frames")))
			target->frameskip = 8;
		else if (!strcmp(used_text,_("Skip 9 of 12 frames")))
			target->frameskip = 9;
		else if (!strcmp(used_text,_("Skip 10 of 12 frames")))
			target->frameskip = 10;
		else if (!strcmp(used_text,_("Skip 11 of 12 frames")))
			target->frameskip = 11;
		else
			target->frameskip = 0;
		g_free(used_text);

		if (available_options->dos_brightness)
			target->brightness = gtk_range_get_adjustment(GTK_RANGE(brightness_hscale))->value;
		else
		{
			/* percentage converted to dosmame brightness complient 0.5-2.0 range*/
			target->brightness = (gtk_range_get_adjustment(GTK_RANGE(brightness_hscale))->value)*(1.5/100)+0.5;
		}
		target->gamma_correction = gtk_range_get_adjustment(GTK_RANGE(gamma_hscale))->value;
		target->norotate = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(norotate_checkbutton));

		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(rotation_combo_entry),0,-1);
		if (!strcmp(used_text,_("Clockwise")))
		{
			target->ror= 1;target->rol = 0;
		}
		else if (!strcmp(used_text,_("Anti-clockwise")))
		{
			target->ror= 0;target->rol = 1;
		}
		else
		{
			target->ror= 0;target->rol = 0;
		}
		g_free(used_text);
				
		target->flipx = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(flipx_checkbutton));
		target->flipy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(flipy_checkbutton));
		
		/* from misc tab */
		target->artwork = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(artwork_checkbutton));
		

		/*** OpenGL Related ***/
		target->glfullscreen = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glfullscreen_checkbutton));
		target->gldblbuffer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gldblbuffer_checkbutton));
		target->gltexture_size = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(gltexture_size_spinbutton));
		target->glbilinear = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glbilinear_checkbutton));
		target->glext78 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glext78_checkbutton));
		target->glforceblitmode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glforceblitmode_checkbutton));
		target->gldrawbitmap = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gldrawbitmap_checkbutton));
		target->glcolormod = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glcolormod_checkbutton));
		target->glantialias = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glantialias_checkbutton));
		target->glalphablending = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glalphablending_checkbutton));
		target->cabview = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cabview_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(cabinet_entry),0,-1);
		strncpy(target->cabinet,used_text,20);
		g_free(used_text);
		target->glres_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glres_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(glres_combo_entry),0,-1);
		strncpy(target->glres,used_text,9);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(gllib_entry),0,-1);
		strncpy(target->gllibname,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(glulib_entry),0,-1);
		strncpy(target->glulibname,used_text,20);
		g_free(used_text);
		
		/*** x11 Related ***/
		target->x11_mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(x11_mode_checkbutton));
		target->cursor = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cursor_checkbutton));
		target->mitshm = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mitshm_checkbutton));
		target->xvext = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xvext_checkbutton));
		target->vidix = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vidix_checkbutton));
		target->xvgeom_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xvgeom_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(xvgeom_entry),0,-1);
		strncpy(target->geometry,used_text,9);
		g_free(used_text);
		target->yuv = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(yuv_checkbutton));
		target->yv12 = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(yv12_checkbutton));
		target->xvfullscreen = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xvfullscreen_checkbutton));
		target->xsync = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xsync_checkbutton));
		target->privatecmap = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(privatecmap_checkbutton));
		target->xil = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xil_checkbutton));
		target->mtxil = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mtxil_checkbutton));
		
		/*** FX glide related ***/
		target->fxgkeepaspect = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fxgkeepaspect_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(fx_entry),0,-1);
		strncpy(target->resolution,used_text,20);
		g_free(used_text);
		
		
		/*** SDL related ***/
		target->fullscreen = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fullscreen_checkbutton));
		target->sdl_auto_mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sdl_modes_checkbutton));
		target->modenumber = 0;
		if (current_exec->sdl_modes_hash_table)
		{
			g_hash_table_foreach(current_exec->sdl_modes_hash_table,
 		    	         	  (GHFunc)sdl_modes_combo_comp_inv,
					   target);
		} else {
			target->modenumber = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sdl_modes_spinbutton));
		}
		
		/*** Photon2 related ***/
		target->render_mode = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(render_mode_checkbutton));
		target->phcursor = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(phcursor_checkbutton));
	
		/*** SVGA related ***/
		target->planar = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(planar_checkbutton));
		target->linear = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(linear_checkbutton));
		target->tweak = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tweaked_mode_checkbutton));
		target->centerx = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(centerx_spinbutton));
		target->centery = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(centery_spinbutton));
				
		/*** GGI related ***/
		target->ggilinear = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ggilinear_checkbutton));
		target->ggi_force_resolution= gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ggi_force_resolution_checkbutton));
		target->xres = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ggix_spinbutton));
		target->yres = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ggiy_spinbutton));


/*** Video Mode related ***/
		target->keepaspect = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(keepaspect_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(displayaspectratio_entry),0,-1);
		target->displayaspectratio = atof(used_text);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(disable_mode_entry),0,-1);
		strncpy(target->disablemode,used_text,14);
		g_free(used_text);
		
		
		
/* Sound */
		target->sound = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(sound_checkbutton));
		target->samples = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(samples_checkbutton));
		target->fakesound = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fakesound_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(samplefreq_entry),0,-1);
		target->samplefre = atoi(used_text);
		g_free(used_text);
		target->volume = gtk_range_get_adjustment(GTK_RANGE(db_hscale))->value;
		target->bufsize = gtk_range_get_adjustment(GTK_RANGE(bufsize_hscale))->value;
		used_text = gtk_editable_get_chars(GTK_EDITABLE(audiodevice_combo_entry),0,-1);
		strncpy(target->audiodevice,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(mixerdevice_entry),0,-1);
		strncpy(target->mixerdevice,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(dsp_plugin_entry),0,-1);
		strncpy(target->dsp_plugin,used_text,20);
		g_free(used_text);
		if(current_exec->dsp_plugin_hash_table)
		{
			g_hash_table_foreach(current_exec->dsp_plugin_hash_table,
              	    	         	  (GHFunc)dsp_combo_comp_inv,
					   target);
		}

		used_text = gtk_editable_get_chars(GTK_EDITABLE(mixer_plugin_entry),0,-1);
		strncpy(target->sound_mixer_plugin,used_text,20);
		g_free(used_text);
		if(current_exec->mixer_plugin_hash_table)
		{
			g_hash_table_foreach(current_exec->mixer_plugin_hash_table,
                	           	  (GHFunc)mixer_combo_comp_inv,
					   target);
		}
		used_text = gtk_editable_get_chars(GTK_EDITABLE(soundfile_entry),0,-1);
		strncpy(target->soundfile,used_text,50);
		g_free(used_text);
			
		target->timer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(timer_checkbutton));
		target->artsBufferTime = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(arts_spinbutton));
		target->audio_preferred = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(audio_preferred_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(pcm_entry),0,-1);
		strncpy(target->alsa_pcm,used_text,20);
		g_free(used_text);
		target->alsa_buffer = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(alsa_buffer_spinbutton));
		target->alsacard = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(alsacard_spinbutton));
		target->alsadevice = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(alsadevice_spinbutton));
		
/* controllers */
		used_text = gtk_editable_get_chars(GTK_EDITABLE(joytype_combo_entry),0,-1);
		if (!strcmp(used_text,_("i386 style")))
			target->joytype = 1;
		else if (!strcmp(used_text,_("Fm Town Pad")))
			target->joytype = 2;
		else if (!strcmp(used_text,_("X11 input extension")))
			target->joytype = 3;
		else if (!strcmp(used_text,_("new i386 linux 1.x.x driver")))
			target->joytype = 4;
		else if (!strcmp(used_text,_("NetBSD USB joystick")))
			target->joytype = 5;
		else if (!strcmp(used_text,_("PS2-Linux native pad")))
			target->joytype = 6;
		else if (!strcmp(used_text,_("SDL")))
			target->joytype = 7;
		else
			target->joytype = 0;
		g_free(used_text);
		target->analogstick = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(analogstick_checkbutton));
		target->hotrod = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hotrod_checkbutton));
		target->hotrodse = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(hotrodse_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(ctrlr_combo_entry),0,-1);
		strncpy(target->ctrlr,used_text,20);
		g_free(used_text);
		target->usbpspad = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(usbpspad_checkbutton));
		target->rapidfire = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rapidfire_checkbutton));
		target->ugcicoin = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ugcicoin_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(joydevname_entry),0,-1);
		strncpy(target->joydevname,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(paddevname_entry),0,-1);
		strncpy(target->paddevname,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(x11joyname_entry),0,-1);
		strncpy(target->x11joyname,used_text,20);
		g_free(used_text);
/*		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_joystick1_entry),0,-1);
		strncpy(target->XInput_joystick1,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_joystick2_entry),0,-1);
		strncpy(target->XInput_joystick2,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_joystick3_entry),0,-1);
		strncpy(target->XInput_joystick3,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_joystick4_entry),0,-1);
		strncpy(target->XInput_joystick4,used_text,20);
		g_free(used_text);*/
		target->mouse = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(mouse_checkbutton));
		target->grabmouse = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(grabmouse_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_trackball1_entry),0,-1);
		strncpy(target->XInput_trackball1,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_trackball2_entry),0,-1);
		strncpy(target->XInput_trackball2,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_trackball3_entry),0,-1);
		strncpy(target->XInput_trackball3,used_text,20);
		g_free(used_text);
		used_text = gtk_editable_get_chars(GTK_EDITABLE(XInput_trackball4_entry),0,-1);
		strncpy(target->XInput_trackball4,used_text,20);
		g_free(used_text);
		target->winkeys = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(winkeys_checkbutton));
		target->grabkeyboard = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(grabkeyboard_checkbutton));

		used_text = gtk_editable_get_chars(GTK_EDITABLE(keymaptype_combo_entry),0,-1);
		for (i=0;x11_keymaps_layout[i].shortname;i++)
		 {
		   if (strcmp(_(x11_keymaps_layout[i].name),used_text)==0)
		     strncpy(target->keymap,x11_keymaps_layout[i].shortname,4);
		 }
		g_free(used_text);

				
/* vector */
		if (rom)
		{
			if (rom->vector)
			{
				target->antialias = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(antialias_checkbutton));
				target->translucency = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(translucency_checkbutton));
				target->beam = gtk_range_get_adjustment(GTK_RANGE(beam_hscale))->value;
				target->flicker = gtk_range_get_adjustment(GTK_RANGE(flicker_hscale))->value;
				target->intensity = gtk_range_get_adjustment(GTK_RANGE(intensity_hscale))->value;
				target->vectorres_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vector_fixed_resolution_checkbutton));
				used_text = gtk_editable_get_chars(GTK_EDITABLE(vectorres_entry),0,-1);
				strncpy(target->vectorres,used_text,9);
				g_free(used_text);
				/* (open gl) */
				target->gldrawbitmapvec = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gldrawbitmapvec_checkbutton));
				target->glantialiasvec = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glantialiasvec_checkbutton));
			}
		}
		else
		{
			target->antialias = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(antialias_checkbutton));
			target->translucency = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(translucency_checkbutton));
			target->beam = gtk_range_get_adjustment(GTK_RANGE(beam_hscale))->value;
			target->flicker = gtk_range_get_adjustment(GTK_RANGE(flicker_hscale))->value;
			target->intensity = gtk_range_get_adjustment(GTK_RANGE(intensity_hscale))->value;
			target->vectorres_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(vector_fixed_resolution_checkbutton));
			used_text = gtk_editable_get_chars(GTK_EDITABLE(vectorres_entry),0,-1);
			strncpy(target->vectorres,used_text,9);
			g_free(used_text);
			/* (open gl) */
			target->gldrawbitmapvec = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gldrawbitmapvec_checkbutton));
			target->glantialiasvec = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(glantialiasvec_checkbutton));
		}
			
		
/* misc */
	/*artwork*/
		target->artwork = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(artwork_checkbutton));
		target->use_backdrops = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_backdrops_checkbutton));
		target->use_bezels = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_bezels_checkbutton));
		target->use_overlays = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_overlays_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(artwork_resolution_combo_entry),0,-1);
		if (!strcmp(used_text,_("Standard")))
			target->artwork_resolution = 1;
		else if (!strcmp(used_text,_("High")))
			target->artwork_resolution = 2;
		else
			target->artwork_resolution = 0;
		g_free(used_text);
		target->artwork_crop = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(artcrop_checkbutton));
	/* misc */
		target->keyboard_leds = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(keyboard_leds_checkbutton));
		target->cheat = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cheat_checkbutton));
		target->debug = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(debug_checkbutton));
		target->skip_disclaimer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(disclaimer_checkbutton));
		target->skip_gameinfo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gameinfo_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(debug_size_combo_entry),0,-1);
		strncpy(target->debug_size,used_text,20);
		g_free(used_text);
		target->use_additional_options = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(additional_options_checkbutton));
		/* here I'm using directly the additional option because I don't know its length */
		g_free(target->additional_options);
		target->additional_options = gtk_editable_get_chars(GTK_EDITABLE(additional_options_entry),0,-1);
		target->log_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(log_flag_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(log_entry),0,-1);
		strncpy(target->log,used_text,20);
		g_free(used_text);
		target->cfgname_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(config_name_checkbutton));
		used_text = gtk_editable_get_chars(GTK_EDITABLE(config_name_entry),0,-1);
		strncpy(target->cfgname,used_text,20);
		g_free(used_text);
		
		used_text = gtk_editable_get_chars(GTK_EDITABLE(bios_combo_entry),0,-1);
		i=0;
		do {
			if (strcmp(_(bios_version[i]),used_text) == 0)
				target->bios = i;
			i++;
		} while (bios_version[i]);
		g_free(used_text);
		
		
	/* network */
		if ( gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(network_option_checkbutton)) == 0)
			target->network_flag = 0;
		else
			target->network_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(client_mode_radiobutton))+1;
		used_text = gtk_editable_get_chars(GTK_EDITABLE(slave_entry),0,-1);
		strncpy(target->slave,used_text,20);
		g_free(used_text);
		target->master = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(master_spinbutton));
		target->netmapkey = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(netmapkey_checkbutton));
		target->parallelsync = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(parallelsync_checkbutton));
		target->bind = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(bind_spinbutton));
		target->bind_flag = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bind_flag_checkbutton));
		target->statedebug = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(statedebug_checkbutton));


		dirty_options_flag = FALSE;
	}
}

void
load_properties_options(RomEntry     *rom)
{
	gchar title[BUFFER_SIZE];
	gchar *used_text;
	xmame_game_options *target;
	xmame_available_options *available_options;
	int i;

	available_options = xmame_executable_get_options(current_exec);

/*	if (dirty_options_flag)
	{ */
		if (rom==NULL)
		{
			target = &default_options;
		}
		else
		{
			if (game_options)
				target = game_options;
			else
				target = &default_options;
		}

		/***********/
		/* Display */
		/***********/

		for (i = 0; effect_name[i]; i++); 	/* count effects */

		if (target->effect > i)
			target->effect = 0;

		gtk_entry_set_text (GTK_ENTRY (effect_entry), _(effect_name[target->effect]));
		
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (scanlines_checkbutton), target->scanlines);

		gtk_adjustment_set_value (GTK_ADJUSTMENT(gamma_hscale_adj) , target->gamma_correction);

		if (available_options->dos_brightness)
			gtk_adjustment_set_value (GTK_ADJUSTMENT(brightness_hscale_adj) , target->brightness);
		else
			gtk_adjustment_set_value (GTK_ADJUSTMENT(brightness_hscale_adj) , ((target->brightness)-0.5)*(100/1.5));

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dirty_checkbutton), target->dirty);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (throttle_checkbutton), target->throttle);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sleepidle_checkbutton), target->sleepidle);

		if (target->frameskip == 0 || target->frameskip > 11)
			g_snprintf(title,BUFFER_SIZE,"%s",_("Draw every frame"));
		else
			g_snprintf(title,BUFFER_SIZE,_("Skip %i of 12 frames"), target->frameskip);

		gtk_entry_set_text (GTK_ENTRY (frameskip_entry), title);
		gtk_widget_set_sensitive (frameskip_combo, !(target->autoframeskip));

		if (target->frameskipper == 1)
			gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), _("Enhanced frameskip code"));
		else
			gtk_entry_set_text (GTK_ENTRY (frameskippercombo_entry), _("DOS frameskip code"));

		gtk_widget_set_sensitive(frameskipper_combo,target->autoframeskip);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autoframeskip_checkbutton), target->autoframeskip);

		g_snprintf(title,BUFFER_SIZE,"%i",target->maxautoframeskip);
		gtk_entry_set_text (GTK_ENTRY (maxautoframeskip_entry), title);
		gtk_widget_set_sensitive (maxautoframeskip_combo, target->autoframeskip);

		gtk_adjustment_set_value (GTK_ADJUSTMENT(heightscale_spinbutton_adj) , target->heightscale);

		switch(target->bpp)
		{
			case 8:
			case 16:
			case 32:
				g_snprintf(title,BUFFER_SIZE, _("%i bits"), target->bpp);
				break;
			default:
				g_snprintf(title,BUFFER_SIZE,"%s",_("Auto"));
				break;
		}
		gtk_entry_set_text (GTK_ENTRY (bpp_combo_entry), title);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(widthscale_spinbutton_adj) , target->widthscale);

		g_snprintf(title,BUFFER_SIZE,"%i",target->arbheight);
		gtk_entry_set_text (GTK_ENTRY(arbheight_entry), title);
		gtk_widget_set_sensitive (arbheight_entry, target->arbheight);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (arbheight_checkbutton), target->arbheight);

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(autodouble_checkbutton), target->autodouble);

		if (target->ror)
			g_snprintf(title,BUFFER_SIZE,"%s",_("Clockwise"));
		else if (target->rol)
			g_snprintf(title,BUFFER_SIZE,"%s",_("Anti-clockwise"));
		else
			g_snprintf(title,BUFFER_SIZE,"%s",_("None"));
		gtk_entry_set_text (GTK_ENTRY (rotation_combo_entry), title);

		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(norotate_checkbutton), target->norotate);

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipx_checkbutton), target->flipx);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (flipy_checkbutton), target->flipy);

		/*************/
		/* Rendering */
		/*************/

		gtk_adjustment_set_value (GTK_ADJUSTMENT(gltexture_size_spinbutton_adj) , target->gltexture_size);

		gtk_adjustment_set_value (GTK_ADJUSTMENT(sdl_modes_spinbutton_adj) , target->modenumber);

		gtk_adjustment_set_value (GTK_ADJUSTMENT(ggix_spinbutton_adj) , target->xres);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(ggiy_spinbutton_adj) , target->yres);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(centerx_spinbutton_adj) , target->centerx);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(centery_spinbutton_adj) , target->centery);

		/* Open GL frame */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glfullscreen_checkbutton), target->glfullscreen);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldblbuffer_checkbutton), target->gldblbuffer);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glbilinear_checkbutton), target->glbilinear);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glext78_checkbutton), target->glext78);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glforceblitmode_checkbutton), target->glforceblitmode);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gldrawbitmap_checkbutton), target->gldrawbitmap);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glcolormod_checkbutton), target->glcolormod);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glantialias_checkbutton), target->glantialias);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glalphablending_checkbutton), target->glalphablending);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cabview_checkbutton), target->cabview);
		gtk_widget_set_sensitive(GTK_WIDGET(cabinet_entry),target->cabview);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (glres_checkbutton), target->glres_flag);
		gtk_entry_set_text (GTK_ENTRY (cabinet_entry), target->cabinet);
		gtk_widget_set_sensitive(GTK_WIDGET(glres_combo),target->glres_flag);
		gtk_entry_set_text (GTK_ENTRY (gllib_entry), target->gllibname);
		gtk_entry_set_text (GTK_ENTRY (glulib_entry), target->glulibname);

		/* x11 frame */
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (x11_mode_checkbutton), target->x11_mode);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cursor_checkbutton), target->cursor);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mitshm_checkbutton), target->mitshm);
		gtk_widget_set_sensitive(GTK_WIDGET(mitshm_checkbutton),available_options->mitshm);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvext_checkbutton), target->xvext);
		gtk_widget_set_sensitive(GTK_WIDGET(vidix_checkbutton),available_options->vidix);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (vidix_checkbutton), target->vidix);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvgeom_checkbutton), target->xvgeom_flag);
		gtk_entry_set_text (GTK_ENTRY (xvgeom_entry), target->geometry);
		gtk_widget_set_sensitive(GTK_WIDGET(xvext_checkbutton), available_options->xvext &&
									available_options->mitshm &&
									target->mitshm);
		gtk_widget_set_sensitive(GTK_WIDGET(xv_table2), (target->xvext &&
									available_options->xvext &&
									available_options->mitshm &&
									target->mitshm) ||
									(available_options->vidix &&
									target->vidix));
		gtk_widget_set_sensitive(GTK_WIDGET(xvgeom_combo), target->xvgeom_flag /*&&
									available_options.xvext
									available_options.mitshm &&
									target->mitshm &&
									target->xvext &&
									*/);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (yuv_checkbutton), target->yuv);
		gtk_widget_set_sensitive(GTK_WIDGET(yuv_checkbutton),available_options->yuv);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (yv12_checkbutton), target->yv12);
		gtk_widget_set_sensitive(GTK_WIDGET(yv12_checkbutton),available_options->yv12);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xvfullscreen_checkbutton), target->xvfullscreen);
		gtk_widget_set_sensitive(GTK_WIDGET(xvfullscreen_checkbutton),available_options->fullscreen);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xsync_checkbutton), target->xsync);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (privatecmap_checkbutton), target->privatecmap);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (xil_checkbutton), target->xil);
		gtk_widget_set_sensitive(GTK_WIDGET(mtxil_checkbutton),target->xil);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mtxil_checkbutton), target->mtxil);

		/*** FX glide related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fxgkeepaspect_checkbutton), target->fxgkeepaspect);
		gtk_entry_set_text (GTK_ENTRY (fx_entry), target->resolution);
		gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_label),!(target->sdl_auto_mode));

		/*** SDL related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fullscreen_checkbutton), target->fullscreen);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sdl_modes_checkbutton), (target->sdl_auto_mode));
		if (current_exec->sdl_modes_hash_table)
		{
			gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_combo),!(target->sdl_auto_mode));
		}
		else
		{
			gtk_widget_set_sensitive(GTK_WIDGET(sdl_modes_spinbutton),!(target->sdl_auto_mode));
		}

		/*** Photon2 related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (render_mode_checkbutton), target->render_mode);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (phcursor_checkbutton), !(target->phcursor));

		/*** SVGA related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (planar_checkbutton), target->planar);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (linear_checkbutton), target->linear);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tweaked_mode_checkbutton), target->tweak);
		gtk_widget_set_sensitive(GTK_WIDGET(svga_tweak_table),target->tweak);

		/*** GGI related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggilinear_checkbutton), target->ggilinear);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ggi_force_resolution_checkbutton), target->ggi_force_resolution);
		gtk_widget_set_sensitive(GTK_WIDGET(ggi_res_table),target->ggi_force_resolution);

		/*** Video Mode related ***/
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keepaspect_checkbutton), target->keepaspect);
		gtk_widget_set_sensitive(GTK_WIDGET(displayaspectratio_entry),(target->keepaspect));
		used_text = g_strdup_printf ("%f",target->displayaspectratio);
		gtk_entry_set_text (GTK_ENTRY (displayaspectratio_entry), used_text);
		g_free(used_text);
		gtk_entry_set_text (GTK_ENTRY (disable_mode_entry), target->disablemode);

		/*********/
		/* Sound */
		/*********/

		gtk_adjustment_set_value (GTK_ADJUSTMENT(db_hscale_adj) , target->volume);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(bufsize_hscale_adj) , target->bufsize);

		gtk_adjustment_set_value (GTK_ADJUSTMENT(arts_spinbutton_adj) , target->artsBufferTime);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(alsa_buffer_spinbutton_adj) , target->alsa_buffer);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(alsacard_spinbutton_adj) , target->alsacard);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(alsadevice_spinbutton_adj) , target->alsadevice);

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sound_checkbutton), target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(samples_checkbutton),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(volume_frame),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(bufsize_frame),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(samplefreq_combo),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_label),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(samplefreq_label),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(mixerdevice_label),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_combo),target->sound);
		gtk_widget_set_sensitive(GTK_WIDGET(mixerdevice_combo),target->sound);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (samples_checkbutton), target->samples);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (fakesound_checkbutton), target->fakesound);
		used_text = g_strdup_printf ("%i",target->samplefre);
		gtk_entry_set_text (GTK_ENTRY (samplefreq_entry), used_text);
		gtk_entry_set_text (GTK_ENTRY (audiodevice_combo_entry), target->audiodevice);
		gtk_entry_set_text (GTK_ENTRY (mixerdevice_entry), target->mixerdevice);

		gtk_entry_set_text (GTK_ENTRY (soundfile_entry), target->soundfile);
		if(!strcmp(target->dsp_plugin,"waveout"))
		{
			gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),TRUE);
			gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),FALSE);
		}
		else
		{
			gtk_widget_set_sensitive(GTK_WIDGET(soundfile_hbox),FALSE);
			gtk_widget_set_sensitive(GTK_WIDGET(audiodevice_hbox),TRUE);
		}

		gtk_entry_set_text (GTK_ENTRY (dsp_plugin_entry), target->dsp_plugin);
		if (current_exec->dsp_plugin_hash_table)
		{
			g_hash_table_foreach(current_exec->dsp_plugin_hash_table,
	             	                (GHFunc)dsp_combo_comp,
	             	                target);
		}

		gtk_entry_set_text (GTK_ENTRY (mixer_plugin_entry), target->sound_mixer_plugin);
		if(current_exec->mixer_plugin_hash_table)
		{
			g_hash_table_foreach(current_exec->mixer_plugin_hash_table,
	        	                     (GHFunc)mixer_combo_comp,
	                	             target);
		}

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (timer_checkbutton), target->timer);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (audio_preferred_checkbutton), target->audio_preferred);
		gtk_entry_set_text (GTK_ENTRY (pcm_entry), target->alsa_pcm);

		gtk_widget_set_sensitive (GTK_WIDGET(qnx_frame), available_options->audio_preferred);
		gtk_widget_set_sensitive (GTK_WIDGET(alsa_frame), available_options->list_alsa_cards);
		gtk_widget_set_sensitive (GTK_WIDGET(arts_frame), available_options->artsBufferTime);
		gtk_widget_set_sensitive (GTK_WIDGET(alsacard_label), available_options->alsacard);
		gtk_widget_set_sensitive (GTK_WIDGET(alsacard_spinbutton), available_options->alsacard);
		gtk_widget_set_sensitive (GTK_WIDGET(alsadevice_label), available_options->alsadevice);
		gtk_widget_set_sensitive (GTK_WIDGET(alsadevice_spinbutton), available_options->alsadevice);
		gtk_widget_set_sensitive (GTK_WIDGET(alsa_buffer_label), available_options->alsa_buffer);
		gtk_widget_set_sensitive (GTK_WIDGET(alsa_buffer_spinbutton), available_options->alsa_buffer);
		gtk_widget_set_sensitive (GTK_WIDGET(PCM_label), available_options->alsa_pcm);
		gtk_widget_set_sensitive (GTK_WIDGET(pcm_entry), available_options->alsa_pcm);

		/**************/
		/* Controller */
		/**************/

		gtk_widget_set_sensitive(paddevname_label,FALSE);
		gtk_widget_set_sensitive(paddevname_entry,FALSE);
		gtk_widget_set_sensitive(x11joyname_label,FALSE);
		gtk_widget_set_sensitive(x11joyname_entry,FALSE);
		gtk_widget_set_sensitive(joydevname_label,FALSE);
		gtk_widget_set_sensitive(joydevname_entry,FALSE);
		gtk_widget_set_sensitive(hotrod_checkbutton,FALSE);
		gtk_widget_set_sensitive(hotrodse_checkbutton,FALSE);
		switch(target->joytype)
		{
			case(0):
				g_snprintf(title,BUFFER_SIZE,"%s",_("No joystick"));
				gtk_widget_set_sensitive(analogstick_checkbutton,FALSE);
				gtk_widget_set_sensitive(hotrod_checkbutton,TRUE);
				gtk_widget_set_sensitive(hotrodse_checkbutton,TRUE);
				gtk_widget_set_sensitive(usbpspad_checkbutton,FALSE);
				gtk_widget_set_sensitive(rapidfire_checkbutton,FALSE);
				break;
			case(1):
				g_snprintf(title,BUFFER_SIZE,"%s",_("i386 style"));
				gtk_widget_set_sensitive(joydevname_label,TRUE);
				gtk_widget_set_sensitive(joydevname_entry,TRUE);
				break;
			case(2):
				g_snprintf(title,BUFFER_SIZE,"%s",_("Fm Town Pad"));
				gtk_widget_set_sensitive(paddevname_label,TRUE);
				gtk_widget_set_sensitive(paddevname_entry,TRUE);
				break;
			case(3):
				g_snprintf(title,BUFFER_SIZE,"%s",_("X11 input extension"));
				gtk_widget_set_sensitive(x11joyname_label,TRUE);
				gtk_widget_set_sensitive(x11joyname_entry,TRUE);
				break;
			case(4):
				g_snprintf(title,BUFFER_SIZE,"%s",_("new i386 linux 1.x.x driver"));
				gtk_widget_set_sensitive(joydevname_label,TRUE);
				gtk_widget_set_sensitive(joydevname_entry,TRUE);
				break;
			case(5):
				g_snprintf(title,BUFFER_SIZE,"%s",_("NetBSD USB joystick"));
				break;
			case(6):
				g_snprintf(title,BUFFER_SIZE,"%s",_("PS2-Linux native pad"));
				break;
			case(7):
				g_snprintf(title,BUFFER_SIZE,"%s",_("SDL"));
				break;
		}

		gtk_entry_set_text (GTK_ENTRY (joytype_combo_entry), title);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (analogstick_checkbutton), target->analogstick);
		gtk_entry_set_text (GTK_ENTRY (ctrlr_combo_entry), target->ctrlr);
		gtk_widget_set_sensitive (GTK_WIDGET (ctrlr_combo), available_options->ctrlr);
		gtk_widget_set_sensitive(hotrod_checkbutton, !(available_options->newhotrodusage));
		gtk_widget_set_sensitive(hotrodse_checkbutton, !(available_options->newhotrodusage));
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrod_checkbutton), target->hotrod);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hotrodse_checkbutton), target->hotrodse);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (usbpspad_checkbutton), target->usbpspad);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (rapidfire_checkbutton), target->rapidfire);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (ugcicoin_checkbutton), target->ugcicoin);
		gtk_entry_set_text (GTK_ENTRY (joydevname_entry), target->joydevname);
		gtk_entry_set_text (GTK_ENTRY (paddevname_entry), target->paddevname);
		gtk_entry_set_text (GTK_ENTRY (x11joyname_entry), target->x11joyname);
/*		gtk_entry_set_text (GTK_ENTRY (XInput_joystick1_entry), target->XInput_joystick1);
		gtk_entry_set_text (GTK_ENTRY (XInput_joystick2_entry), target->XInput_joystick2);
		gtk_entry_set_text (GTK_ENTRY (XInput_joystick3_entry), target->XInput_joystick3);
		gtk_entry_set_text (GTK_ENTRY (XInput_joystick4_entry), target->XInput_joystick4);*/
		gtk_widget_set_sensitive(GTK_WIDGET(Xinput_joy_frame),FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (mouse_checkbutton), target->mouse);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabmouse_checkbutton), target->grabmouse);
		gtk_widget_set_sensitive (GTK_WIDGET (grabmouse_checkbutton), target->mouse && available_options->grabmouse);
		gtk_entry_set_text (GTK_ENTRY (XInput_trackball1_entry), target->XInput_trackball1);
		gtk_entry_set_text (GTK_ENTRY (XInput_trackball2_entry), target->XInput_trackball2);
		gtk_entry_set_text (GTK_ENTRY (XInput_trackball3_entry), target->XInput_trackball3);
		gtk_entry_set_text (GTK_ENTRY (XInput_trackball4_entry), target->XInput_trackball4);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (grabkeyboard_checkbutton), target->grabkeyboard);
		gtk_widget_set_sensitive (GTK_WIDGET (grabkeyboard_checkbutton), available_options->grabkeyboard);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (winkeys_checkbutton), target->winkeys);
		gtk_widget_set_sensitive (GTK_WIDGET (config_name_checkbutton), (available_options->cfgname || available_options->ConfigDirectory));
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config_name_checkbutton), target->cfgname_flag);
		gtk_widget_set_sensitive (GTK_WIDGET (config_name_entry), (target->cfgname_flag && (available_options->cfgname || available_options->ConfigDirectory)));
		gtk_entry_set_text (GTK_ENTRY (config_name_entry), target->cfgname);

		for (i=0;x11_keymaps_layout[i].shortname;i++)
		{
			if (strcmp(x11_keymaps_layout[i].shortname,target->keymap)==0)
				gtk_entry_set_text (GTK_ENTRY (keymaptype_combo_entry), _(x11_keymaps_layout[i].name));
		}

		/********/
		/* Misc */
		/********/

		gtk_adjustment_set_value (GTK_ADJUSTMENT(master_spinbutton_adj) , target->master);
		gtk_adjustment_set_value (GTK_ADJUSTMENT(bind_spinbutton_adj) , target->bind);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artwork_checkbutton), target->artwork);
		/* the use_backdrops option will be used for all new backdrop option maybe change after */
		gtk_widget_set_sensitive (GTK_WIDGET(artwork_frame), available_options->use_backdrops && target->artwork);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_backdrops_checkbutton), target->use_backdrops);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_bezels_checkbutton), target->use_bezels);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (use_overlays_checkbutton), target->use_overlays);
		switch(target->artwork_resolution)
		{
			case(0):
				g_snprintf(title,BUFFER_SIZE,"%s",_("Auto"));
				break;
			case(1):
				g_snprintf(title,BUFFER_SIZE,"%s",_("Standard"));
				break;
			case(2):
				g_snprintf(title,BUFFER_SIZE,"%s",_("High"));
				break;
		}
		gtk_entry_set_text (GTK_ENTRY (artwork_resolution_combo_entry), title);
		gtk_widget_set_sensitive (GTK_WIDGET(artwork_resolution_frame), available_options->artwork_resolution && target->artwork);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (artcrop_checkbutton), target->artwork_crop);
		gtk_widget_set_sensitive (GTK_WIDGET(artcrop_frame), available_options->artwork_crop && target->artwork);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (keyboard_leds_checkbutton), target->keyboard_leds);
		gtk_widget_set_sensitive (GTK_WIDGET(keyboard_leds_checkbutton), available_options->keyboard_leds);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cheat_checkbutton), target->cheat);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (disclaimer_checkbutton), target->skip_disclaimer);
		gtk_widget_set_sensitive (GTK_WIDGET(disclaimer_checkbutton), available_options->skip_disclaimer);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (gameinfo_checkbutton), target->skip_gameinfo);
		gtk_widget_set_sensitive (GTK_WIDGET(gameinfo_checkbutton), available_options->skip_gameinfo);
		gtk_widget_set_sensitive (GTK_WIDGET(bios_label), available_options->bios);
		gtk_widget_set_sensitive (GTK_WIDGET(bios_combo), available_options->bios);
		i=0;
		do {
			if (i == target->bios)
				gtk_entry_set_text (GTK_ENTRY (bios_combo_entry), _(bios_version[i]));
			i++;
		} while (bios_version[i]);

		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (debug_checkbutton), target->debug);
		gtk_widget_set_sensitive (GTK_WIDGET(debug_checkbutton), available_options->debug);
		gtk_widget_set_sensitive (GTK_WIDGET(debug_size_label), available_options->debug && target->debug);
		gtk_widget_set_sensitive (GTK_WIDGET(debug_size_combo), available_options->debug && target->debug);
		gtk_entry_set_text (GTK_ENTRY (debug_size_combo_entry), target->debug_size);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (additional_options_checkbutton), target->use_additional_options);
		gtk_widget_set_sensitive (GTK_WIDGET(additional_options_entry), target->use_additional_options);
		gtk_entry_set_text (GTK_ENTRY (additional_options_entry), target->additional_options);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (log_flag_checkbutton), target->log_flag);
		gtk_widget_set_sensitive (GTK_WIDGET(log_label), target->log_flag);
		gtk_widget_set_sensitive (GTK_WIDGET(log_entry), target->log_flag);
		gtk_entry_set_text (GTK_ENTRY (log_entry), target->log);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (network_option_checkbutton), (target->network_flag)!=0?TRUE:FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET(network_option_checkbutton), available_options->network);
		gtk_widget_set_sensitive (GTK_WIDGET (network_frame), ((target->network_flag)!=0?TRUE:FALSE) && available_options->network);

		gtk_widget_set_sensitive (GTK_WIDGET (slave_label), (target->network_flag)==2?TRUE:FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (slave_entry), (target->network_flag)==2?TRUE:FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (netmapkey_checkbutton), (target->network_flag)==2);
		gtk_widget_set_sensitive (GTK_WIDGET (statedebug_checkbutton), ((target->network_flag)!=2) && available_options->statedebug);
		gtk_widget_set_sensitive (GTK_WIDGET (master_label), (target->network_flag)!=2?TRUE:FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (master_spinbutton), (target->network_flag)!=2?TRUE:FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (client_mode_radiobutton), (target->network_flag)==2?TRUE:FALSE);
		gtk_entry_set_text (GTK_ENTRY (slave_entry), target->slave);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (netmapkey_checkbutton), target->netmapkey);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (parallelsync_checkbutton), target->parallelsync);
		gtk_widget_set_sensitive (GTK_WIDGET(parallelsync_checkbutton), available_options->parallelsync);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (statedebug_checkbutton), target->statedebug);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bind_flag_checkbutton), target->bind_flag);
		gtk_widget_set_sensitive (GTK_WIDGET(bind_spinbutton), available_options->bind && target->bind_flag);
		gtk_widget_set_sensitive (GTK_WIDGET(bind_flag_checkbutton), available_options->bind);

		/**********/
		/* Vector */
		/**********/

/*	} */
	dirty_options_flag = FALSE;
	game_options = NULL;
}


/* escape the space character in string */

gchar *escape_space (const gchar *string)
{
	gchar *q;
	gchar *escaped;
	guint spaces = 0;
	const gchar *p = string;

	if (string == NULL)
		return NULL;

	while (*p != '\000')
		spaces += (*p++ == ' ');

	if (!spaces)
		return g_strdup (string);

	escaped = g_new (gchar, strlen (string) + spaces + 1);

	p = string;
	q = escaped;

	while (*p != '\000')
	{
		if (*p == ' ')
			*q++ = '\\';
		*q++ = *p++;
	}
	*q = '\000';

	return escaped;
}


/* all options string are created here */
char *create_Video_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string,
/*	     *scale=NULL,*/
	     *dirty=NULL,
	     *brightness=NULL;
	char float_buf[FLOAT_BUF_SIZE];
	xmame_available_options *available_options;
	
	available_options = xmame_executable_get_options(exec);
	if (available_options->dirty)
		dirty = g_strdup_printf("-%sdirty",(target->dirty)?"":"no");
	/*in the xmame help, scale could be float, but the executable only want int */
/*	if (target->scale!=0)
		scale = g_strdup_printf("-scale %.0f",target->scale);
*/
	
	if (available_options->dos_brightness)
	{
		brightness = g_strdup_printf("-brightness %s",my_dtostr(float_buf, target->brightness));
	}
	else
	{
		brightness = g_strdup_printf("-brightness %i",(int)(((target->brightness)-0.5)*(100/1.5)));
	}
	
	option_string = g_strdup_printf (" -bpp %i "
				"-arbheight %i "
				"-heightscale %i "
				"-widthscale %i "
/*				"%s "	*/			/* scale */
				"-effect %i "
				"-%sautodouble "
				"%s "				/* dirty */
				"-%sscanlines "
				"-frameskipper %i "
				"-%sthrottle "
				"-%ssleepidle "
				"-%sautoframeskip "
				"-maxautoframeskip %i "
				"-frameskip %i "
				"%s "				/* brightness */	
				"-gamma%s %s "			/* allows to add -correction for mame <0.66*/
				"%s "				/* norotate */
				"%s "				/* ror */
				"%s "				/* rol */
				"%s "				/* flipx */
				"%s ",				/* flipy */
				target->bpp,
				target->arbheight,
				target->heightscale,
				target->widthscale,
/*				scale?scale:"",*/
				target->effect,
				(target->autodouble)?"":"no",
				(dirty)?dirty:"",
				(target->scanlines)?"":"no",
				target->frameskipper,
				(target->throttle)?"":"no",
				(target->sleepidle)?"":"no",
				(target->autoframeskip)?"":"no",
				target->maxautoframeskip,
				target->frameskip,
				(brightness)?brightness:"",
				(available_options->gamma_correction)?"-correction":"",
				my_dtostr(float_buf, target->gamma_correction),
				(target->norotate)?"-norotate":"",
				(target->ror)?"-ror":"",
				(target->rol)?"-rol":"",
				(target->flipx)?"-flipx":"",
				(target->flipy)?"-flipy":""
				);
/*	g_free(scale);*/
	g_free(dirty);
	g_free(brightness);

	return option_string;
}


char *create_Sound_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string,
	     *alsacard=NULL,
	     *alsadevice=NULL,
	     *alsa_pcm=NULL,
	     *alsa_buffer=NULL,
	     *audio_preferred=NULL,
	     *artsBufferTime=NULL,
	     *audiodevice=NULL,
	     *mixerdevice=NULL,
	     *dsp_plugin=NULL,
	     *sound_mixer_plugin=NULL;
	char float_buf[FLOAT_BUF_SIZE];
	xmame_available_options *available_options;
		
	available_options = xmame_executable_get_options(exec);

	if(!strcmp(target->dsp_plugin,"waveout"))
	{
		if (strcmp((g_strstrip(target->soundfile)),""))
		{
			gchar *escaped_soundfile;
			escaped_soundfile = escape_space(target->soundfile);
			audiodevice = g_strdup_printf("-audiodevice %s",escaped_soundfile);
			g_free(escaped_soundfile);
		}
	}
	else
	{
		if (strcmp((g_strstrip(target->audiodevice)),""))
			audiodevice = g_strdup_printf("-audiodevice %s",target->audiodevice);
	}
	
	if (strcmp((g_strstrip(target->mixerdevice)),""))
		mixerdevice = g_strdup_printf("-mixerdevice %s",target->mixerdevice);
	

	/* alsa sound */
	if (available_options->list_alsa_cards)
	{
		if (available_options->alsacard)
			alsacard = g_strdup_printf("-alsacard %i",target->alsacard);
		if (available_options->alsadevice)
			alsadevice = g_strdup_printf("-alsadevice %i",target->alsadevice);
		if (available_options->alsa_pcm)
			alsa_pcm = g_strdup_printf("-alsa-pcm %s",target->alsa_pcm);
		if (available_options->alsa_buffer)
			alsa_buffer = g_strdup_printf("-alsa-buffer %i",target->alsa_buffer);
	}
	/* QNX*/
	if (available_options->audio_preferred)
		audio_preferred = g_strdup_printf("-%saudio_preferred",(target->audio_preferred)?"":"no");
	/* aRts*/
	if (available_options->artsBufferTime)
		artsBufferTime = g_strdup_printf("-artsBufferTime %i",target->artsBufferTime);
	
	/* dsp_plugin */
	if (strcmp((g_strstrip(target->dsp_plugin)),""))
		dsp_plugin = g_strdup_printf("-dsp-plugin %s",target->dsp_plugin);
	/* sound_mixer_plugin */
	if (strcmp((g_strstrip(target->sound_mixer_plugin)),""))
		sound_mixer_plugin = g_strdup_printf("-sound-mixer-plugin %s",target->sound_mixer_plugin);

	option_string = g_strdup_printf (" -%ssound "
				"-%ssamples "
				"%s "				/* fakesound */
				"-samplefreq %i "
				"-bufsize %s "
				"-volume %i "
				"%s "				/* audiodevice */
				"%s "				/* mixerdevice */
				"%s "				/* artsBufferTime */
				"%s "				/* alsacard */
				"%s "				/* alsadevice */
				"%s "				/* alsa_pcm */
				"%s "				/* alsa_buffer */
				"%s "				/* QNX audio_preferred */
				"%s "				/* dsp_plugin */
				"%s ",				/* sound_mixer_plugin */
				(target->sound)?"":"no",
				(target->samples)?"":"no",
				(target->fakesound)?"-fakesound":"",
				target->samplefre,
				my_dtostr(float_buf,target->bufsize),
				target->volume,
				audiodevice?audiodevice:"",		/* audiodevice */
				mixerdevice?mixerdevice:"",		/* mixerdevice */
				artsBufferTime?artsBufferTime:"",	/* artsBufferTime */
				alsacard?alsacard:"",			/* alsacard */
				alsadevice?alsadevice:"",		/* alsadevice */
				alsa_pcm?alsa_pcm:"",			/* alsa_pcm */
				alsa_buffer?alsa_buffer:"",		/* alsa_buffer */
				audio_preferred?audio_preferred:"",	/* QNX audio_preferred */
				dsp_plugin?dsp_plugin:"",		/* dsp_plugin */
				sound_mixer_plugin?sound_mixer_plugin:""/* sound_mixer_plugin */
				);
	g_free(audiodevice);
	g_free(mixerdevice);
	g_free(artsBufferTime);
	g_free(alsacard);
	g_free(alsadevice);
	g_free(alsa_pcm);
	g_free(alsa_buffer);
	g_free(audio_preferred);
	g_free(dsp_plugin);
	g_free(sound_mixer_plugin);
	
	return option_string;
}


char *create_Video_Mode_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	
	char *option_string;
	char float_buf[FLOAT_BUF_SIZE];
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);

	if (available_options->video_mode)
	{
		option_string = g_strdup_printf ("-%skeepaspect "
					"-displayaspectratio %s ",
					(target->keepaspect)?"":"no",
					my_dtostr(float_buf, target->displayaspectratio)
					);
	}
	else
		option_string = g_strdup_printf (" ");
	
	return option_string;
}


char *create_Renderer_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string=NULL;
	int x11mode = 0;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);

	if (!strcmp(exec->target,"x11"))
	{
		char	*Video_Mode_option = NULL,
			*mitshm=NULL,
			*xvext=NULL,
			*vidix=NULL,
			*geometry = NULL,
			*newext = NULL;

		if (available_options->mitshm)
		{
			mitshm = g_strdup_printf("-%smitshm",(target->mitshm)?"":"no");
		}
		
		/* put the new extention option (xv and vidix) in a string*/
		if (target->xvgeom_flag && strcmp(target->geometry,""))
			geometry = g_strdup_printf("-geometry %s",target->geometry);
		/* 0.72 removes -fullscreen option in favour of new */
		/* -x11-mode values */
		if (available_options->newx11modeusage)
		{
			newext =  g_strdup_printf("%s "					/* geometry */
					  "%s "					/* yuv */
					  "%s",					/* yv12 */
					  geometry?geometry:"",
					  available_options->yuv?((target->yuv)?"-yuv":"-noyuv"):"",
					  available_options->yv12?((target->yv12)?"-yv12":"-noyv12"):""
					);
		}
		else
		{
			newext =  g_strdup_printf("%s "					/* fullscreen */
					  "%s "					/* geometry */
					  "%s "					/* yuv */
					  "%s",					/* yv12 */
					  available_options->fullscreen?((target->xvfullscreen)?"-fullscreen":"-nofullscreen"):"",
					  geometry?geometry:"",
					  available_options->yuv?((target->yuv)?"-yuv":"-noyuv"):"",
					  available_options->yv12?((target->yv12)?"-yv12":"-noyv12"):""
					);
		}

		if (available_options->xvext)
		{
			if (target->mitshm)
			{	
				xvext = g_strdup_printf("-%sxvext", target->xvext?"":"no");
			}
			else	/* we should not try to xvext if mitshm is not used*/
				xvext = g_strdup_printf("-noxvext");
		}
		/* use vidix if available*/
		if (available_options->vidix)
		{
			/* free xvext in case it was filed previously */
			vidix = g_strdup_printf("-%svidix", target->vidix?"":"no");
		}
		
	
		Video_Mode_option = create_Video_Mode_Related_options_string(exec, target);

		/* 0.72 introduces new usage of -x11-mode: */
		/* 0 = normal windowed */
		/* 1 = DGA fullscreen */
		/* 2 = Xv windowed */
		/* 3 = Xv fullscreen */
		if (available_options->newx11modeusage)
		{
			x11mode=target->x11_mode;
			if (target->xvext)
			{
				x11mode=2;
				if (target->xvfullscreen)
					x11mode=3;
			}

			option_string = g_strdup_printf ("-x11-mode %i "
						"-%scursor "
						"%s "				/* mitshm */
						"%s "				/* vidix */
						"%s "				/* newext */
						"-%sxsync "
						"-%sprivatecmap "
						"-%sxil "
						"-%smtxil "
						"%s ",				/* Video mode */
						x11mode,
						(target->cursor)?"":"no",
						mitshm?mitshm:"",
						vidix?vidix:"",
						newext?newext:"",
						(target->xsync)?"":"no",
						(target->privatecmap)?"":"no",
						(target->xil)?"":"no",
						(target->mtxil)?"":"no",
						Video_Mode_option?Video_Mode_option:""
						);
		}
		else
		{
			option_string = g_strdup_printf ("-x11-mode %i "
						"-%scursor "
						"%s "				/* mitshm */
						"%s "				/* xvext */
						"%s "				/* vidix */
						"%s "				/* newext */
						"-%sxsync "
						"-%sprivatecmap "
						"-%sxil "
						"-%smtxil "
						"%s ",				/* Video mode */
						target->x11_mode,
						(target->cursor)?"":"no",
						mitshm?mitshm:"",
						xvext?xvext:"",
						vidix?vidix:"",
						newext?newext:"",
						(target->xsync)?"":"no",
						(target->privatecmap)?"":"no",
						(target->xil)?"":"no",
						(target->mtxil)?"":"no",
						Video_Mode_option?Video_Mode_option:""
						);
		}
		g_free(Video_Mode_option);
		g_free(xvext);
		g_free(vidix);
		g_free(newext);
		g_free(mitshm);
		g_free(geometry);
	}
	else if(!strcmp(exec->target,"svgalib"))
	{
		char *Video_Mode_option;
		Video_Mode_option = create_Video_Mode_Related_options_string(exec, target);
		option_string = g_strdup_printf ("-%stweak "
						"-%splanar "
						"-%slinear "
						"-centerx %i "
						"-centery %i "
						"%s ",
						(target->tweak)?"":"no",
						(target->planar)?"":"no",
						(target->linear)?"":"no",
						(target->centerx),
						(target->centery),
						Video_Mode_option
						);
		g_free(Video_Mode_option);
	}
	else if(!strcmp(exec->target,"ggi"))
	{
		char *Video_Mode_option, *resolution=NULL;
		Video_Mode_option = create_Video_Mode_Related_options_string(exec, target);
		if(target->ggi_force_resolution)
		{
			resolution = g_strdup_printf("-xres %i -yres %i",target->xres,target->yres);
		}
		option_string = g_strdup_printf ("-%slinear "
						"%s "
						"%s ",
						(target->ggilinear)?"":"no",
						resolution?resolution:"",
						Video_Mode_option
						);
		g_free(Video_Mode_option);
		g_free(resolution);
	}
	else if(!strcmp(exec->target,"xgl"))
	{
		char *gllibname=NULL, *glulibname=NULL, *cabinet=NULL, *glres=NULL;
		if (strcmp((g_strstrip(target->gllibname)),""))
			gllibname = g_strdup_printf("-gllibname %s",target->gllibname);
		if (strcmp((g_strstrip(target->glulibname)),""))
			glulibname = g_strdup_printf("-glulibname %s",target->glulibname);
		if (strcmp((g_strstrip(target->cabinet)),""))
			cabinet = g_strdup_printf("-cabinet %s",target->cabinet);
		if (target->glres_flag)
			glres = g_strdup_printf("-glres %s",target->glres);
		
		option_string = g_strdup_printf ("-%sfullscreen "
						"-%sgldblbuffer "
						"-gltexture_size %i "
						"-%sglforceblitmode "
						"-%sglext78 "
						"-%sglbilinear "
						"-%sgldrawbitmap "
						"-%sglcolormod "
						"-%sglalphablending "
						"-%sglantialias "
						"%s "				/* gllibname */
						"%s "				/* glulibname */
						"-%scabview "
						"%s "				/* cabinet */
						"%s ",				/* glres */
						(target->glfullscreen)?"":"no",
						(target->gldblbuffer)?"":"no",
						target->gltexture_size,
						(target->glforceblitmode)?"":"no",
						(target->glext78)?"":"no",
						(target->glbilinear)?"":"no",
						(target->gldrawbitmap)?"":"no",
						(target->glcolormod)?"":"no",
						(target->glalphablending)?"":"no",
						(target->glantialias)?"":"no",
						gllibname?gllibname:"",
						glulibname?glulibname:"",
						(target->cabview)?"":"no",
						cabinet?cabinet:"",
						glres?glres:""
						);
		g_free(gllibname);
		g_free(glulibname);
		g_free(cabinet);
		g_free(glres);
	}
	else if(!strcmp(exec->target,"xfx") || !strcmp(exec->target,"svgafx"))
	{
		option_string = g_strdup_printf ("-resolution %s "
					"-%skeepaspect ",
					target->resolution,
					(target->fxgkeepaspect)?"":"no"
					);
	}
	else if(!strcmp(exec->target,"SDL"))
	{
		gchar *SDL_mode=NULL;
		if (!(target->sdl_auto_mode))
			SDL_mode = g_strdup_printf("-modenumber %i",target->modenumber);

		option_string = g_strdup_printf ("-%sfullscreen "
					"%s ",
					(target->fullscreen)?"":"no",
					SDL_mode?SDL_mode:""
					);
	}
	else if(!strcmp(exec->target,"photon2"))
	{
		option_string = g_strdup_printf ("-render-mode %i "
					"-%s phcursor ",
					target->render_mode,
					(target->phcursor)?"":"no"
					);
	}
	else			/* at least give an empty line */
		option_string = g_strdup("");
	return option_string;
}


char *create_Input_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string, *joy=NULL,
			*keymap=NULL,
			*trackball1=NULL,
			*trackball2=NULL,
			*trackball3=NULL,
			*trackball4=NULL,
			*ctrlr,
			*x11_options=NULL;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);

	if ((target->joytype==1 || target->joytype==4) && strcmp(g_strstrip(target->joydevname),"") && available_options->joydevname)
	{
		joy = g_strdup_printf ("-joydevname %s",
					target->joydevname);
	} else if (target->joytype==2 && strcmp(g_strstrip(target->paddevname),"") && available_options->joydevname)
	{
		joy = g_strdup_printf ("-paddevname %s",
					target->paddevname);
	} else if (target->joytype==3 && strcmp(g_strstrip(target->x11joyname),"") && available_options->x11joyname)
	{
		joy = g_strdup_printf ("-x11joyname %s",
					target->x11joyname);
	}

	if (available_options->XInput_trackball)
	{
		if (strcmp(g_strstrip(target->XInput_trackball1),""))
		{
			trackball1 = g_strdup_printf ("- %s",
						target->XInput_trackball1);
		}
		if (strcmp(g_strstrip(target->XInput_trackball2),""))
		{
			trackball2 = g_strdup_printf ("- %s",
						target->XInput_trackball2);
		}
		if (strcmp(g_strstrip(target->XInput_trackball3),""))
		{
			trackball3 = g_strdup_printf ("- %s",
						target->XInput_trackball3);
		}
		if (strcmp(g_strstrip(target->XInput_trackball4),""))
		{
			trackball4 = g_strdup_printf ("- %s",
						target->XInput_trackball4);
		}
	}

	/* For now, we share the same keymap for SDL and x11 */
	if (strcmp(g_strstrip(target->keymap),"") &&
	    (strcmp(exec->target,"x11")==0 ||
	     strcmp(exec->target,"SDL")==0))
	{
	  char *mapkey_options=strcmp(exec->target,"x11")?"sdlmapkey":"mapkey";
	  char *oldkeymap;
	  int i;

	  /* Find modified key from the keymap */
	  for (i=0;x11_keymaps_layout[i].shortname;i++)
	   {
	     if (strcmp(x11_keymaps_layout[i].shortname,target->keymap)==0)
	      {
		struct x11_keymap_layout *keys=x11_keymaps_layout[i].keys;
		while (keys->from && keys->to)
		 {
		   if (keymap)
		    {
		      oldkeymap=keymap;
		      keymap = g_strdup_printf("%s -%s 0x%x,0x%x ",
			  oldkeymap, mapkey_options, keys->from, keys->to);
		      g_free(oldkeymap);
		    }
		   else
		     keymap = g_strdup_printf("-%s 0x%x,0x%x ",
			 mapkey_options, keys->from, keys->to);
		   keys++;
		 }
		break;
	      }
	   }
	}

	if (!strcmp(exec->target,"x11") || !strcmp(exec->target,"photon2"))
	{
		x11_options = g_strdup_printf ("-%sgrabmouse "
				"-%swinkeys ",
				(target->grabmouse)?"":"no",
				(target->winkeys)?"":"no"
				);
	}
	if (available_options->newhotrodusage)
	{
		if (strcmp(target->ctrlr,"None"))
			ctrlr = g_strdup_printf ("-ctrlr %s",
				target->ctrlr
				);
		else
			ctrlr = NULL;
	}else
	{
		ctrlr = g_strdup_printf ("-%shotrod "
				"-%shotrodse ",
				(target->hotrod)?"":"no",
				(target->hotrodse)?"":"no"
			);
	}

	option_string = g_strdup_printf ("-joytype %i "
				"-%sanalogstick "
				"%s "					/* joy */
				"-%smouse "
				"%s "
				"-%susbpspad "
				"-%srapidfire "
				"%s "					/* trackball1 */
				"%s "					/* trackball2 */
				"%s "					/* trackball3 */
				"%s "					/* trackball4 */
				"%s "					/* x11_options*/
				"%s " 					/* grabkeyboard */
				"%s "					/* keymap */
				"%s ",					/* ugcicoin */
				target->joytype,
				(target->analogstick)?"":"no",
				joy?joy:"",
				(target->mouse)?"":"no",
				(ctrlr)?ctrlr:"",
				(target->usbpspad)?"":"no",
				(target->rapidfire)?"":"no",
				trackball1?trackball1:"",
				trackball2?trackball2:"",
				trackball3?trackball3:"",
				trackball4?trackball4:"",
				x11_options?x11_options:"",
				available_options->grabkeyboard?((target->grabkeyboard)?"-grabkeyboard":"-nograbkeyboard"):"",
				keymap?keymap:"",
				available_options->ugcicoin?((target->ugcicoin)?"-ugcicoin":"-nougcicoin"):""
				);

	g_free(ctrlr);
	g_free(joy);
	g_free(trackball1);
	g_free(trackball2);
	g_free(trackball3);
	g_free(trackball4);
	g_free(x11_options);
	if (keymap)
	  g_free(keymap);
	return option_string;
}


char *create_Misc_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string, *new_artwork=NULL,
			*keyboard_leds=NULL,
			*debug=NULL,
			*network=NULL,
			*log=NULL,
			*cfgname=NULL,
			*additional_options=NULL,
			*skip_disclaimer=NULL,
			*skip_gameinfo=NULL,
			*bios;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);

	if (target->artwork && available_options->use_backdrops)
	{
		new_artwork = g_strdup_printf ("-%suse_backdrops "				/* use_backdrops */
					"-%suse_overlays "					/* use_overlays */
					"-%suse_bezels "					/* use_bezels */
					"-%sartwork_crop "					/* artwork_crop */
					"-artwork_resolution %i",
					(target->use_backdrops)?"":"no",
					(target->use_overlays)?"":"no",
					(target->use_bezels)?"":"no",
					(target->artwork_crop)?"":"no",
					target->artwork_resolution
					);
	} 

	if (available_options->keyboard_leds)
	{
		keyboard_leds = g_strdup_printf ("-%skeyboard_leds",
					(target->keyboard_leds)?"":"no"
					);
	} 

	if (available_options->skip_disclaimer)
	{
		skip_disclaimer = g_strdup_printf ("-%sskip_disclaimer",
					(target->skip_disclaimer)?"":"no"
					);
	} 
	if (available_options->skip_gameinfo)
	{
		skip_gameinfo = g_strdup_printf ("-%sskip_gameinfo",
					(target->skip_gameinfo)?"":"no"
					);
	} 
	
	
	if (available_options->debug)
	{
		if(strcmp(g_strstrip(target->debug_size),""))
			debug = g_strdup_printf ("-%sdebug "
						"-debug-size %s",
						(target->debug)?"":"no",
						target->debug_size
						);
		else
			debug = g_strdup_printf ("-%sdebug",
						(target->debug)?"":"no"
						);
	} 

	if ((target->network_flag!=0) && available_options->network)
	{
		gchar *parallelsync=NULL, *bind = NULL;
		if (available_options->parallelsync)
		{
			parallelsync = g_strdup_printf("-%sparallelsync",(target->parallelsync)?"":"no");
		}
		if (available_options->bind && target->bind_flag)
		{
			bind = g_strdup_printf("-bind %i",target->bind);
		}
		
		if(target->network_flag==1)	/* master */
			network = g_strdup_printf ("-master %i "
						"-%snetmapkey "
						"%s "		/* parallelsync */
						"%s "		/* statedebug */
						"%s",		/* bind */
						target->master,
						(target->netmapkey)?"":"no",
						parallelsync?parallelsync:"",
						available_options->statedebug?((target->statedebug)?"-statedebug":"-nostatedebug"):"",
						bind?bind:""
						);
		else if(target->network_flag==2)	/* slave */
			network = g_strdup_printf ("-slave %s "
						"-%snetmapkey "
						"%s "		/* parallelsync */
						"%s",		/* bind */
						target->slave,
						(target->netmapkey)?"":"no",
						parallelsync?parallelsync:"",
						bind?bind:""
						);
		g_free(parallelsync);
		g_free(bind);
	}
	
	if(target->log_flag)
	{
		if(strcmp(g_strstrip(target->log),""))
			log = g_strdup_printf ("-log %s",target->log);
		else
			log = g_strdup_printf ("-log xmame.log");
	}

	/* for the cfg_directory option, if available, see in io options */
	if (available_options->cfgname && target->cfgname_flag)
	{
		if(strcmp(g_strstrip(target->cfgname),""))
		{
			cfgname = g_strdup_printf ("-cfgname %s",target->cfgname);
		}
	}
	else if (available_options->ConfigDirectory && (gui_prefs.ConfigDirectory[0] != '\0'))
	{
		gchar *escaped_path;
		escaped_path = escape_space(gui_prefs.ConfigDirectory);
		if (target->cfgname_flag && strcmp(g_strstrip(target->cfgname),""))
		{
			cfgname = g_strdup_printf ("-cfg_directory %s/%s",gui_prefs.ConfigDirectory,target->cfgname);
		} else {
			cfgname = g_strdup_printf ("-cfg_directory %s",gui_prefs.ConfigDirectory);
		}		
		g_free(escaped_path);
	
	} 

	if (target->use_additional_options)
	{
		if(strcmp(g_strstrip(target->additional_options),""))
			additional_options = g_strdup_printf ("%s",target->additional_options);
	} 
	
	if (available_options->bios)
		bios = g_strdup_printf ("-bios %i",target->bios);
	else
		bios = NULL;

	option_string = g_strdup_printf ("-%sartwork "
				"%s "					/* new_artwork */
				"-%scheat "				/* cheat option */
				"%s "					/* keyboard_leds */
				"%s "					/* debug */
				"%s "					/* network */
				"%s "					/* log */
				"%s "					/* cfgname */
				"%s "					/* additional options */
				"%s "					/* skip_disclaimer */
				"%s "					/* skip_gameinfo */
				"%s ",					/* bios */
				(target->artwork)?"":"no",
				new_artwork?new_artwork:"",
				(target->cheat)?"":"no",
				keyboard_leds?keyboard_leds:"",
				debug?debug:"",
				network?network:"",
				log?log:"",
				cfgname?cfgname:"",
				additional_options?additional_options:"",
				skip_disclaimer?skip_disclaimer:"",
				skip_gameinfo?skip_gameinfo:"",
				bios?bios:""
				);
				
	g_free(new_artwork);
	g_free(keyboard_leds);
	g_free(debug);
	g_free(network);
	g_free(log);
	g_free(bios);
	return option_string;
}


char *create_Vector_Related_options_string(XmameExecutable *exec, xmame_game_options *target)
{
	char *option_string;
	char *glvector=NULL, *vectorres=NULL, *intensity=NULL;
	char float_buf[FLOAT_BUF_SIZE];
	char *flicker=NULL, *beam=NULL;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);
	
	if(target->vectorres_flag)
	{
		vectorres = g_strdup_printf ("-vectorres %s",target->vectorres);
	}

	if(available_options->intensity)
	{
		intensity = g_strdup_printf ("-intensity %s",my_dtostr(float_buf,target->intensity));
	}

	if(!strcmp(current_exec->target,"xgl"))
	{
		glvector = g_strdup_printf ("-%sgldrawbitmapvec "
					"-%sglantialiasvec "
					"-glbeam %s",
					(target->gldrawbitmapvec)?"":"no",
					(target->glantialiasvec)?"":"no",
					my_dtostr(float_buf, target->beam)
					);
	}
	flicker = g_strdup(my_dtostr(float_buf,target->flicker));
	beam = g_strdup(my_dtostr(float_buf,target->beam));
	option_string = g_strdup_printf ("-%santialias "
				"-%stranslucency "
				"-flicker %s "
				"-beam %s "
				"%s "
				"%s "
				"%s ",
				(target->antialias)?"":"no",
				(target->translucency)?"":"no",
				flicker,
				beam,
				vectorres?vectorres:"",
				glvector?glvector:"",
				intensity?intensity:""
				);

	g_free(intensity);
	g_free(vectorres);
	g_free(glvector);
	g_free(beam);
	g_free(flicker);

	return option_string;
}


char *create_RomPath_Related_options_string(void)
{
	char *option_string;
	gchar *rompath,*escaped_rompath;
	
	rompath = g_strjoinv(":",gui_prefs.RomPath);
	escaped_rompath = escape_space(rompath);
	g_free(rompath);
	if (escaped_rompath[0] != '\0')
		option_string = g_strdup_printf("-rompath %s ",escaped_rompath);
	else
		option_string = g_strdup(" ");
	g_free(escaped_rompath);

	return option_string;
}


char *create_SamplePath_Related_options_string(void)
{
	char *option_string;
	gchar *samplepath,*escaped_samplepath;

	samplepath = g_strjoinv(":",gui_prefs.SamplePath);
	escaped_samplepath = escape_space(samplepath);
	g_free(samplepath);
	if (escaped_samplepath[0] != '\0')
		option_string = g_strdup_printf("-samplepath %s ",escaped_samplepath);
	else
		option_string = g_strdup(" ");
	g_free(escaped_samplepath);

	return option_string;
}


char *create_io_Related_options_string(XmameExecutable *exec)
{
	char *option_string;
	gchar *artworkpath_option,
			*screenshotdir_option,
			*hiscoredir_option,
			*mameinfofile_option,
			*historyfile_option,
			*hiscorefile_option,
			*cheatfile_option,
			*diffdir_option,
			*ctrlr_directory_option,
			*cfg_directory_option,
			*inipath_option,
			*nvram_directory_option,
			*memcard_directory_option,
			*input_directory_option,
			*state_directory_option,
			*escaped_path;
	xmame_available_options *available_options;
	available_options = xmame_executable_get_options(exec);

 /* we are using new command line options if available */
	if (gui_prefs.ArtworkDirectory[0] != '\0')
	{
		escaped_path = escape_space(gui_prefs.ArtworkDirectory);
		artworkpath_option = g_strdup_printf("-%s %s",available_options->artwork_directory_option, escaped_path);
		g_free(escaped_path);
	}	
	else
		artworkpath_option = g_strdup(" ");
	
	if (gui_prefs.SnapshotDirectory[0] != '\0')
	{
		escaped_path = escape_space(gui_prefs.SnapshotDirectory);
		screenshotdir_option = g_strdup_printf("-%s %s",available_options->snapshot_directory_option, escaped_path);	
		g_free(escaped_path);
	}	
	else
		screenshotdir_option = g_strdup(" ");
	
	if (gui_prefs.HiscoreDirectory[0] != '\0')
	{
		escaped_path = escape_space(gui_prefs.HiscoreDirectory);
		hiscoredir_option = g_strdup_printf("-%s %s",available_options->hiscore_directory_option, escaped_path);	
		g_free(escaped_path);
	}	
	else
		hiscoredir_option = g_strdup(" ");

	if (gui_prefs.CheatFile[0] != '\0')
	{
		escaped_path = escape_space(gui_prefs.CheatFile);
		cheatfile_option = g_strdup_printf("-%s %s",available_options->cheat_file_option, escaped_path);
		g_free(escaped_path);
	}	
	else
		cheatfile_option = g_strdup(" ");
	
	if (gui_prefs.HiscoreFile[0] !='\0')
	{
		escaped_path = escape_space(gui_prefs.HiscoreFile);
		hiscorefile_option = g_strdup_printf("-%s %s", available_options->hiscore_file_option, escaped_path);	
		g_free(escaped_path);
	}	
	else
		hiscorefile_option = g_strdup(" ");
	
	if (gui_prefs.HistoryFile[0] !='\0')
	{
		escaped_path = escape_space(gui_prefs.HistoryFile);
		historyfile_option = g_strdup_printf("-%s %s", available_options->history_file_option, escaped_path);	
		g_free(escaped_path);
	}
	else
		historyfile_option = g_strdup(" ");

	if (gui_prefs.MameInfoFile[0] !='\0')
	{
		escaped_path = escape_space(gui_prefs.MameInfoFile);
		mameinfofile_option = g_strdup_printf("-%s %s", available_options->mameinfo_file_option, escaped_path);
		g_free(escaped_path);
	}
	else
		mameinfofile_option = g_strdup(" ");

	if (available_options->diff_directory_option && (gui_prefs.DiffDirectory[0] !='\0'))
	{
		escaped_path = escape_space(gui_prefs.DiffDirectory);
		diffdir_option = g_strdup_printf("-%s %s", available_options->diff_directory_option, escaped_path);
		g_free(escaped_path);
	}
	else
		diffdir_option = g_strdup(" ");

	/* for this option, see in the input option as this option can change if cfname has bee set or not */
/*	if (available_options.ConfigDirectory  && (strlen(gui_prefs.ConfigDirectory)>0))
	{
		escaped_path = escape_space(gui_prefs.ConfigDirectory);
		cfg_directory_option = g_strdup_printf("-cfg_directory %s",escaped_path);
		g_free(escaped_path);
 }
	else
*/		cfg_directory_option = g_strdup(" ");

	if (available_options->IniPath  && (gui_prefs.inipath[0]!='\0'))
	{
		escaped_path = escape_space(gui_prefs.inipath);
		inipath_option = g_strdup_printf("-inipath %s",escaped_path);
		g_free(escaped_path);
	}
	else
		inipath_option = g_strdup(" ");
	
	if (available_options->NVRamDirectory  && (gui_prefs.NVRamDirectory[0] !='\0'))
	{
		escaped_path = escape_space(gui_prefs.NVRamDirectory);
		nvram_directory_option = g_strdup_printf("-nvram_directory %s",escaped_path);	
		g_free(escaped_path);
	}	
	else
		nvram_directory_option = g_strdup(" ");

GXMAME_DEBUG("%s %i", gui_prefs.CtrlrDirectory, available_options->CtrlrDirectory);
	if (available_options->CtrlrDirectory  && (gui_prefs.CtrlrDirectory[0]!='\0'))
	{
		escaped_path = escape_space(gui_prefs.CtrlrDirectory);
		ctrlr_directory_option = g_strdup_printf("-ctrlr_directory %s",escaped_path);	
		g_free(escaped_path);
	}	
	else
		ctrlr_directory_option = g_strdup(" ");
	
	if (available_options->StateDirectory  && (gui_prefs.StateDirectory[0] !='\0'))
	{
		escaped_path = escape_space(gui_prefs.StateDirectory);
		state_directory_option = g_strdup_printf("-state_directory %s",escaped_path);
		g_free(escaped_path);
	}
	else
		state_directory_option = g_strdup(" ");
	
	if (available_options->InputDirectory  && (gui_prefs.InputDirectory[0] != '\0'))
	{
		escaped_path = escape_space(gui_prefs.InputDirectory);
		input_directory_option = g_strdup_printf("-input_directory %s",escaped_path);	
		g_free(escaped_path);
	}	
	else
		input_directory_option = g_strdup(" ");
	
	if (available_options->MemCardDirectory  && (gui_prefs.MemCardDirectory[0] != '\0'))
	{
		escaped_path = escape_space(gui_prefs.MemCardDirectory);
		memcard_directory_option = g_strdup_printf("-memcard_directory %s",escaped_path);	
		g_free(escaped_path);
	}	
	else
		memcard_directory_option = g_strdup(" ");
	

       option_string = g_strdup_printf("%s "	/* artworkpath_option*/
			"%s "			/* screenshotdir_option */
			"%s "			/* hiscoredir_option */
			"%s "			/* cheatfile_option */
			"%s "			/* hiscorefile_option */
			"%s "			/* historyfile_option */
			"%s "			/* mameinfofile_option */
			"%s "			/* diffdir_option */
			"%s "			/* ctrlr_directory_option */
			"%s "			/* cfg_directory_option */
			"%s "			/* inipath_option */
			"%s "			/* nvram_directory_option */
			"%s "			/* memcard_directory_option */
			"%s "			/* input_directory_option */
			"%s "			/* state_directory_option */
			,
			artworkpath_option,
			screenshotdir_option,
			hiscoredir_option,
			cheatfile_option,
			hiscorefile_option,
			historyfile_option,
			mameinfofile_option,
			diffdir_option,
			ctrlr_directory_option,
			cfg_directory_option,
			inipath_option,
			nvram_directory_option,
			memcard_directory_option,
			input_directory_option,
			state_directory_option
			);
	g_free(artworkpath_option);
	g_free(screenshotdir_option);
	g_free(hiscoredir_option);
	g_free(cheatfile_option);
	g_free(hiscorefile_option);
	g_free(historyfile_option);
	g_free(mameinfofile_option);
	g_free(diffdir_option);
	g_free(ctrlr_directory_option);
	g_free(cfg_directory_option);
	g_free(inipath_option);
	g_free(nvram_directory_option);
	g_free(memcard_directory_option);
	g_free(input_directory_option);
	g_free(state_directory_option);
	
	return option_string;
}
