/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include "gxmame.h"
#include <gtk/gtk.h>

void add_display_options_tab (GtkWidget    *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *applybutton,
				GtkWidget    *resetbutton,
				guint         tab_position);

void add_rendering_options_tab (GtkWidget    *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *apply_button,
				GtkWidget    *reset_button,
				guint         tab_position);

void add_sound_options_tab (GtkWidget    *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *apply_button,
				GtkWidget    *reset_button,
				guint         tab_position);

void add_controller_options_tab (GtkWidget    *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *apply_button,
				GtkWidget    *reset_button,
				guint         tab_position);

void add_misc_options_tab (GtkWidget     *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *apply_button,
				GtkWidget    *reset_button,
				guint         tab_position);

void add_vector_options_tab (GtkWidget    *properties_windows,
				GtkNotebook  *target_notebook,
				RomEntry     *rom,
				GtkWidget    *apply_button,
				GtkWidget    *reset_button,
				guint         tab_position);

/* on screen options -> rom */
void
save_properties_options (RomEntry *rom);

/* rom -> on screen options */
void
load_properties_options (RomEntry *rom);

/* options string creation */
char *
create_Video_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_Sound_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_Renderer_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_Input_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_Misc_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_Vector_Related_options_string (XmameExecutable *exec, xmame_game_options *target);

char *
create_RomPath_Related_options_string (void);

char *
create_SamplePath_Related_options_string (void);

char *
create_io_Related_options_string (XmameExecutable *exec);

gchar *
escape_space (const gchar *string);

#endif /* __OPTIONS_H__ */
