/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "gxmame.h"
#include "callbacks.h"
#include "progression_window.h"
#include "gui.h"

GtkWidget *game_loading_progression;
GtkWidget *current_rom_loading;


GtkWidget*
create_loading_progress_window (gboolean cancel_available)
{
	GtkWidget *loading_progress_window;
	GtkWidget *vbox2;
#ifdef DEBUG
	GtkWidget *loading_cancel_button;
#endif

	loading_progress_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_set_data (G_OBJECT (loading_progress_window), "loading_progress_window", loading_progress_window);
	gtk_container_set_border_width (GTK_CONTAINER (loading_progress_window), 15);
	gtk_window_set_title (GTK_WINDOW (loading_progress_window), _("Progression Window"));
	gtk_window_set_position (GTK_WINDOW (loading_progress_window), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (loading_progress_window), TRUE);
	gtk_window_set_default_size (GTK_WINDOW (loading_progress_window), 350, 120);
	gtk_window_set_resizable (GTK_WINDOW (loading_progress_window), TRUE);
	gtk_window_set_transient_for(GTK_WINDOW(loading_progress_window),GTK_WINDOW(MainWindow));

	vbox2 = gtk_vbox_new (TRUE, 0);
	gtk_widget_ref (vbox2);
	g_object_set_data_full (G_OBJECT (loading_progress_window), "vbox2", vbox2,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox2);
	gtk_container_add (GTK_CONTAINER (loading_progress_window), vbox2);

	game_loading_progression = gtk_progress_bar_new ();
	gtk_widget_ref (game_loading_progression);
	g_object_set_data_full (G_OBJECT (loading_progress_window), "game_loading_progression", game_loading_progression,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (game_loading_progression);
	gtk_box_pack_start (GTK_BOX (vbox2), game_loading_progression, FALSE, FALSE, 11);

	current_rom_loading = gtk_label_new (_("rom"));
	gtk_widget_ref (current_rom_loading);
	g_object_set_data_full (G_OBJECT (loading_progress_window), "current_rom_loading", current_rom_loading,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (current_rom_loading);
	gtk_box_pack_start (GTK_BOX (vbox2), current_rom_loading, FALSE, FALSE, 0);
#ifdef DEBUG
	if (cancel_available)
	{
		loading_cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
		gtk_widget_ref (loading_cancel_button);
		g_object_set_data_full (G_OBJECT (loading_progress_window), "loading_cancel_button", loading_cancel_button,
					  (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (loading_cancel_button);
		gtk_box_pack_start (GTK_BOX (vbox2), loading_cancel_button, FALSE, FALSE, 0);
	}
#endif

	/* Only hide the window if user try to close it
	   after need to stop the execution of xmame I I found a way to do that */
	g_signal_connect (G_OBJECT (loading_progress_window), "delete_event",
			    G_CALLBACK (gtk_widget_hide),
			    NULL);

	return loading_progress_window;
}


void update_loading_progress_window (gfloat current_value, const gchar *current_rom)
{
	gtk_label_set_text(GTK_LABEL(current_rom_loading),current_rom);
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR(game_loading_progression), current_value);
}
