/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "common.h"

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "properties.h"
#include "gxmame.h"
#include "gui.h"
#include "io.h"
#include "options.h"
#include "icones.h"


#define BUFFER_SIZE 1000



void
on_properties_reset_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);
void
on_properties_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);
void
on_properties_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);
void
on_properties_apply_button_clicked     (GtkButton       *button,
                                        gpointer         user_data);

void
exit_properties_window		       (GtkWidget      *window,
                                        gpointer         user_data
		                        );
void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data);
/*from the gui.c*/
void select_game(RomEntry *rom);



GtkWidget *details_audit_result;
GtkTextBuffer *details_audit_result_buffer;
GtkWidget *sample_check_result;
GtkWidget *rom_check_result;
GtkWidget *notebook1;
GtkWidget *manu_status_value;
gboolean game_checked = FALSE;



GtkWidget*
create_properties_windows (void)
{
	GtkWidget *properties_windows;
	GtkWidget *vbox9;
	GtkWidget *general_table;
	GtkWidget *general_hbox;
	GtkWidget *hseparator7;
	GtkWidget *hseparator8;
	GtkWidget *hseparator9;
	GtkWidget *hseparator10;
	GtkWidget *cpu_label;
	GtkWidget *manu_stat_label;
	GtkWidget *cpu_value;
	GtkWidget *sound_value;
	GtkWidget *screen_colors_clone_value;
	GtkWidget *screen_colors_label;
	GtkWidget *sound_label;
	GtkWidget *title_rom_value;
	GtkWidget *general_panel;
	GtkWidget *audit_panel;
	GtkWidget *hbox3;
	/*audit panel */
	GtkWidget *audit_table;
	GtkWidget *audit_detail_frame;
	GtkWidget *scrolledwindow7;
	GtkWidget *audit_hbox;
	GtkWidget *audit_pixmap;
	GtkWidget *title_romname;
	GtkWidget *hseparator11;
	GtkWidget *rom_check_label;
	GtkWidget *sample_check_label;
  
	GtkWidget *properties_ok_button;
	GtkWidget *properties_apply_button;
	GtkWidget *properties_cancel_button;
	GtkWidget *properties_reset_button;
/*	guint properties_reset_button_key; */
	GtkAccelGroup *accel_group;
	GtkWidget *general_pixmap;
	GdkPixmap *gdk_pixmap1;
	GdkBitmap *mask1;
	GdkColor  transparent;

	GdkPixbuf *icon_pixbuf;
	ZIP *zip;
	gchar *zipfile;
	
	gchar title[BUFFER_SIZE];
	gchar *value[NB_CPU];
	gchar *value1, *value2;
	gint i;
	GList *listpointer;
	gboolean game_found=FALSE;
	gboolean specific_game_properties;
	RomEntry *tmprom = NULL;
	game_checked = FALSE;

	accel_group = gtk_accel_group_new ();
	
	/* try to load the game options */
	specific_game_properties=load_options(gui_prefs.DefaultGame_p);
	

	properties_windows = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_set_data (G_OBJECT (properties_windows), "properties_windows", properties_windows);
	g_snprintf(title,BUFFER_SIZE,_("Properties for %s"),gui_prefs.DefaultGame);
	gtk_window_set_title (GTK_WINDOW (properties_windows), title);
	gtk_window_set_position (GTK_WINDOW (properties_windows), GTK_WIN_POS_MOUSE);
	gtk_window_set_transient_for(GTK_WINDOW(properties_windows),GTK_WINDOW(MainWindow));
	gtk_window_set_modal(GTK_WINDOW(properties_windows),TRUE);
			
	vbox9 = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox9);
	g_object_set_data_full (G_OBJECT (properties_windows), "vbox9", vbox9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox9);
	gtk_container_add (GTK_CONTAINER (properties_windows), vbox9);

	notebook1 = gtk_notebook_new ();
	gtk_widget_ref (notebook1);
	g_object_set_data_full (G_OBJECT (properties_windows), "notebook1", notebook1,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (notebook1);
	gtk_box_pack_start (GTK_BOX (vbox9), notebook1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (notebook1), 8);

	general_table = gtk_table_new (9, 3, FALSE);
	gtk_widget_ref (general_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "general_table", general_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (general_table);
	gtk_container_add (GTK_CONTAINER (notebook1), general_table);
	gtk_container_set_border_width (GTK_CONTAINER (general_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (general_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (general_table), 5);

	general_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (general_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "general_hbox", general_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (general_hbox);
	gtk_table_attach (GTK_TABLE (general_table), general_hbox, 0, 2, 0, 1,
			 (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			 (GtkAttachOptions) (0), 0, 5);

	/* try to open zipfile and get the game icon inside */
	zipfile = g_build_filename(gui_prefs.IconDirectory, "icons.zip", NULL);
	zip = openzip(zipfile);
	
	icon_pixbuf = get_icon_for_rom(gui_prefs.DefaultGame_p, 32, zip);
	
	/* done with the zip, close it */
	if (zip)
		closezip(zip);
	g_free(zipfile);
	
	/* either ise the pixbuf from the game, or the general inline pixmap*/
	if (icon_pixbuf != NULL)
	{
		gdk_pixbuf_render_pixmap_and_mask(icon_pixbuf,
					&gdk_pixmap1,
					&mask1,
					127);
		g_object_unref(icon_pixbuf);
	}
	else
	{
		gdk_pixmap1 = gdk_pixmap_create_from_xpm_d(
					MainWindow->window,
					&mask1,
					&transparent,
					general_xpm);
	}
	
	general_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap1,mask1);
	gtk_widget_ref (general_pixmap);
	g_object_unref(gdk_pixmap1);
	g_object_unref(mask1);
	g_object_set_data_full (G_OBJECT (properties_windows), "general_pixmap", general_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (general_pixmap);
	gtk_box_pack_start (GTK_BOX (general_hbox), general_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (general_pixmap), 10, 0);

	/*title_rom_value = gtk_label_new (_("Title\n\"romname\""));*/
	g_snprintf(title,BUFFER_SIZE,"%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
	title_rom_value = gtk_label_new (title);
	gtk_widget_ref (title_rom_value);
	g_object_set_data_full (G_OBJECT (properties_windows), "title_rom_value", title_rom_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (title_rom_value);
	gtk_box_pack_start (GTK_BOX (general_hbox), title_rom_value, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (title_rom_value), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (title_rom_value), TRUE);
	gtk_misc_set_padding (GTK_MISC (title_rom_value), 10, 0);

	hseparator7 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator7);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator7", hseparator7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator7);
	gtk_table_attach (GTK_TABLE (general_table), hseparator7, 0, 3, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	manu_stat_label = gtk_label_new (_("Year:\nManufacturer:\nStatus:"));
	gtk_widget_ref (manu_stat_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "manu_stat_label", manu_stat_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (manu_stat_label);
	gtk_table_attach (GTK_TABLE (general_table), manu_stat_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (manu_stat_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (manu_stat_label), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (manu_stat_label), 10, 0);

	/*manu_status_value = gtk_label_new (_("Year Manufacturer value\nStatus value"));*/
	if ((gui_prefs.DefaultGame_p)->has_roms == 2)
		g_snprintf(title,BUFFER_SIZE,_("%s\n%s\nUnknown"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
	else if ((gui_prefs.DefaultGame_p)->has_roms == 0)
		g_snprintf(title,BUFFER_SIZE,_("%s\n%s\nROMs missing"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
	else if (!(gui_prefs.DefaultGame_p)->status)
		g_snprintf(title,BUFFER_SIZE,_("%s\n%s\nNot working"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
	else
		g_snprintf(title,BUFFER_SIZE,_("%s\n%s\nWorking"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);

	manu_status_value = gtk_label_new (title);
	gtk_widget_ref (manu_status_value);
	g_object_set_data_full (G_OBJECT (properties_windows), "manu_status_value", manu_status_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (manu_status_value);
	gtk_table_attach (GTK_TABLE (general_table), manu_status_value, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (manu_status_value), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (manu_status_value), 0, 0.5);

	hseparator8 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator8);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator8", hseparator8,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator8);
	gtk_table_attach (GTK_TABLE (general_table), hseparator8, 0, 3, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	cpu_label = gtk_label_new (_("CPU:"));
	gtk_widget_ref (cpu_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "cpu_label", cpu_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cpu_label);
	gtk_table_attach (GTK_TABLE (general_table), cpu_label, 0, 1, 4, 5,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (cpu_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (cpu_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (cpu_label), 10, 0);

	for(i=0; i < NB_CPU; i++)
	{
		if (strcmp((gui_prefs.DefaultGame_p)->cpu_info[i].name,"-"))
		{
			value[i] = g_strdup_printf("%s %f Mhz%s",
				(gui_prefs.DefaultGame_p)->cpu_info[i].name,
				(gui_prefs.DefaultGame_p)->cpu_info[i].clock/1000000.0,
				(gui_prefs.DefaultGame_p)->cpu_info[i].sound_flag?_(" (sound)"):" ");
		}
		else
			value[i] = NULL;
	}

	title[0]='\0';
	for(i=0; i < NB_CPU; i++)
	{
		if(value[i])
		{
			g_strlcat(title, value[i], BUFFER_SIZE);
			g_strlcat(title, "\n", BUFFER_SIZE);
		}
	}
	title[strlen(title)-1]= '\0';
	cpu_value = gtk_label_new (title);

	for(i=0; i < NB_CPU; i++)
		g_free(value[i]);

	gtk_widget_ref (cpu_value);
	g_object_set_data_full (G_OBJECT (properties_windows), "cpu_value", cpu_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cpu_value);
	gtk_table_attach (GTK_TABLE (general_table), cpu_value, 1, 2, 4, 5,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (cpu_value), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (cpu_value), 0, 0.5);

	hseparator9 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator9);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator9", hseparator9,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator9);
	gtk_table_attach (GTK_TABLE (general_table), hseparator9, 0, 3, 5, 6,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	sound_label = gtk_label_new (_("Sound:"));
	gtk_widget_ref (sound_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_label", sound_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_label);
	gtk_table_attach (GTK_TABLE (general_table), sound_label, 0, 1, 6, 7,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (sound_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (sound_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (sound_label), 10, 0);

	title[0] = '\0';
	for(i=0; i < NB_CPU; i++)
	{
		if (strcmp((gui_prefs.DefaultGame_p)->sound_info[i].name,"-"))
		{
			if ((gui_prefs.DefaultGame_p)->sound_info[i].clock==0)
				value[i] = g_strdup_printf("%s",(gui_prefs.DefaultGame_p)->sound_info[i].name);
			else
				value[i] = g_strdup_printf("%s %f Mhz",
					(gui_prefs.DefaultGame_p)->sound_info[i].name,
					(gui_prefs.DefaultGame_p)->sound_info[i].clock/1000000.0);
		}
		else
			value[i] = NULL;
	}

	title[0]='\0';
	for(i=0; i < NB_CPU; i++)
	{
		if(value[i])
		{
			g_strlcat(title, value[i], BUFFER_SIZE);
			g_strlcat(title, "\n", BUFFER_SIZE);
		}
	}
	title[strlen(title)-1]= '\0';

	sound_value = gtk_label_new (title);

	for(i=0; i < NB_CPU; i++)
		g_free(value[i]);

	gtk_widget_ref (sound_value);
	g_object_set_data_full (G_OBJECT (properties_windows), "sound_value", sound_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sound_value);
	gtk_table_attach (GTK_TABLE (general_table), sound_value, 1, 2, 6, 7,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (sound_value), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (sound_value), 0, 0);

	hseparator10 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator10);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator10", hseparator10,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator10);
	gtk_table_attach (GTK_TABLE (general_table), hseparator10, 0, 3, 7, 8,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	if (strcmp((gui_prefs.DefaultGame_p)->cloneof,"-"))
		screen_colors_label = gtk_label_new (_("Screen:\nColors:\nClone of:"));
	else
		screen_colors_label = gtk_label_new (_("Screen:\nColors:\n"));
	gtk_widget_ref (screen_colors_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "screen_colors_label", screen_colors_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (screen_colors_label);
	gtk_table_attach (GTK_TABLE (general_table), screen_colors_label, 0, 1, 8, 9,
			  (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 3);
	gtk_label_set_justify (GTK_LABEL (screen_colors_label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment (GTK_MISC (screen_colors_label), 0, 0);
	gtk_misc_set_padding (GTK_MISC (screen_colors_label), 10, 0);

	/* doesn't display resolution if this is a vector game */
	if (!(gui_prefs.DefaultGame_p)->vector)
		value1 = g_strdup_printf("%i x %i ",(gui_prefs.DefaultGame_p)->screen_x,(gui_prefs.DefaultGame_p)->screen_y);
	else
		value1 = g_strdup_printf(" ");
	
	/* find the clone name if there is a clone */
	if (strcmp((gui_prefs.DefaultGame_p)->cloneof,"-"))
	{
		for(listpointer = g_list_first(roms), game_found = FALSE;
				(listpointer != NULL);
				listpointer = g_list_next(listpointer))
		{
			tmprom = (RomEntry *) listpointer->data;
			if (!strcmp(tmprom->romname,(gui_prefs.DefaultGame_p)->cloneof))
			{
				game_found = TRUE;
				break;
			}
		}
		if (game_found)
		{
			if (tmprom->the_trailer && gui_prefs.ModifyThe)
				value2 = g_strstrip(g_strdup_printf("%s, The %s - \"%s\"",tmprom->gamename,tmprom->gamenameext,(gui_prefs.DefaultGame_p)->cloneof));
			else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
				value2 = g_strstrip(g_strdup_printf("The %s %s - \"%s\"",tmprom->gamename,tmprom->gamenameext,(gui_prefs.DefaultGame_p)->cloneof));
			else
				value2 = g_strstrip(g_strdup_printf("%s %s - \"%s\"",tmprom->gamename,tmprom->gamenameext,(gui_prefs.DefaultGame_p)->cloneof));
		}
		else
			value2 = g_strdup_printf(" - \"%s\"",(gui_prefs.DefaultGame_p)->cloneof);
	}
	else
		value2 = g_strdup_printf(" ");
	
	g_snprintf(title,BUFFER_SIZE,"%s(%s) %.2f Hz\n%i colors\n%s",
			value1,
			(gui_prefs.DefaultGame_p)->horizontal?"horz":"vert",
			(gui_prefs.DefaultGame_p)->screen_freq,
			(gui_prefs.DefaultGame_p)->colors,
			value2);
	g_free(value1);
	g_free(value2);
	screen_colors_clone_value = gtk_label_new (title);
	gtk_widget_ref (screen_colors_clone_value);
	g_object_set_data_full (G_OBJECT (properties_windows), "screen_colors_clone_value", screen_colors_clone_value,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (screen_colors_clone_value);
	gtk_table_attach (GTK_TABLE (general_table), screen_colors_clone_value, 1, 2, 8, 9,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_label_set_justify (GTK_LABEL (screen_colors_clone_value), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (screen_colors_clone_value), TRUE);
	gtk_misc_set_alignment (GTK_MISC (screen_colors_clone_value), 0, 0);


	/*Audit panel*/
	audit_table = gtk_table_new (5, 2, FALSE);
	gtk_widget_ref (audit_table);
	g_object_set_data_full (G_OBJECT (properties_windows), "audit_table", audit_table,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audit_table);
	gtk_container_add (GTK_CONTAINER (notebook1), audit_table);
	gtk_container_set_border_width (GTK_CONTAINER (audit_table), 10);
	gtk_table_set_row_spacings (GTK_TABLE (audit_table), 5);
	gtk_table_set_col_spacings (GTK_TABLE (audit_table), 5);

	audit_detail_frame = gtk_frame_new (_("Details"));
	gtk_widget_ref (audit_detail_frame);
	g_object_set_data_full (G_OBJECT (properties_windows), "audit_detail_frame", audit_detail_frame,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audit_detail_frame);
	gtk_table_attach (GTK_TABLE (audit_table), audit_detail_frame, 0, 2, 4, 5,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

	scrolledwindow7 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow7);
	g_object_set_data_full (G_OBJECT (properties_windows), "scrolledwindow7", scrolledwindow7,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow7);
	gtk_container_add (GTK_CONTAINER (audit_detail_frame), scrolledwindow7);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow7), 10);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow7), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

	details_audit_result_buffer = gtk_text_buffer_new (NULL);
	details_audit_result = gtk_text_view_new_with_buffer (details_audit_result_buffer);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW(details_audit_result), FALSE);
	gtk_text_view_set_editable (GTK_TEXT_VIEW(details_audit_result), FALSE);
	gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW(details_audit_result), GTK_WRAP_WORD);

	gtk_widget_ref (details_audit_result);
	g_object_set_data_full (G_OBJECT (properties_windows), "details_audit_result", details_audit_result,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (details_audit_result);
	gtk_container_add (GTK_CONTAINER (scrolledwindow7), details_audit_result);

	audit_hbox = gtk_hbox_new (FALSE, 10);
	gtk_widget_ref (audit_hbox);
	g_object_set_data_full (G_OBJECT (properties_windows), "audit_hbox", audit_hbox,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audit_hbox);
	gtk_table_attach (GTK_TABLE (audit_table), audit_hbox, 0, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 5);

	gdk_pixmap1 = gdk_pixmap_create_from_xpm_d(
				MainWindow->window,
				&mask1,
				&transparent,
				checkmark_xpm);
	audit_pixmap = (GtkWidget *) gtk_image_new_from_pixmap (gdk_pixmap1,mask1);
	gtk_widget_ref (audit_pixmap);
	g_object_unref(gdk_pixmap1);
	g_object_unref(mask1);
	g_object_set_data_full (G_OBJECT (properties_windows), "audit_pixmap", audit_pixmap,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audit_pixmap);
	gtk_box_pack_start (GTK_BOX (audit_hbox), audit_pixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (audit_pixmap), 10, 0);

	g_snprintf(title,BUFFER_SIZE,"%s\n\"%s\"",gui_prefs.DefaultGame,(gui_prefs.DefaultGame_p)->romname);
	title_romname = gtk_label_new (title);
	gtk_widget_ref (title_romname);
	g_object_set_data_full (G_OBJECT (properties_windows), "title_romname", title_romname,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (title_romname);
	gtk_box_pack_start (GTK_BOX (audit_hbox), title_romname, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (title_romname), GTK_JUSTIFY_LEFT);
	gtk_label_set_line_wrap (GTK_LABEL (title_romname), TRUE);
	gtk_misc_set_padding (GTK_MISC (title_romname), 10, 0);

	sample_check_result = gtk_label_new (_("Checking..."));
	gtk_widget_ref (sample_check_result);
	g_object_set_data_full (G_OBJECT (properties_windows), "sample_check_result", sample_check_result,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sample_check_result);
	gtk_table_attach (GTK_TABLE (audit_table), sample_check_result, 1, 2, 3, 4,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (sample_check_result), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (sample_check_result), 30, 0);

	rom_check_result = gtk_label_new (_("Checking..."));
	gtk_widget_ref (rom_check_result);
	g_object_set_data_full (G_OBJECT (properties_windows), "rom_check_result", rom_check_result,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rom_check_result);
	gtk_table_attach (GTK_TABLE (audit_table), rom_check_result, 1, 2, 2, 3,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (rom_check_result), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (rom_check_result), 30, 0);

	hseparator11 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator11);
	g_object_set_data_full (G_OBJECT (properties_windows), "hseparator11", hseparator11,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator11);
	gtk_table_attach (GTK_TABLE (audit_table), hseparator11, 0, 2, 1, 2,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 10, 0);

	rom_check_label = gtk_label_new (_("ROM check:"));
	gtk_widget_ref (rom_check_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "rom_check_label", rom_check_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (rom_check_label);
	gtk_table_attach (GTK_TABLE (audit_table), rom_check_label, 0, 1, 2, 3,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (rom_check_label), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (rom_check_label), 10, 0);

	sample_check_label = gtk_label_new (_("Sample check:"));
	gtk_widget_ref (sample_check_label);
	g_object_set_data_full (G_OBJECT (properties_windows), "sample_check_label", sample_check_label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (sample_check_label);
	gtk_table_attach (GTK_TABLE (audit_table), sample_check_label, 0, 1, 3, 4,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (sample_check_label), 0, 0.5);
	gtk_misc_set_padding (GTK_MISC (sample_check_label), 10, 0);

	
	/* General panel */
	general_panel = gtk_label_new (_("General"));
	gtk_widget_ref (general_panel);
	g_object_set_data_full (G_OBJECT (properties_windows), "general_panel", general_panel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (general_panel);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), general_panel);

	audit_panel = (GtkWidget *) gtk_label_new (_("Audit"));
	gtk_widget_ref (audit_panel);
	g_object_set_data_full (G_OBJECT (properties_windows), "audit_panel", audit_panel,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (audit_panel);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), audit_panel);

	hbox3 = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (hbox3);
	g_object_set_data_full (G_OBJECT (properties_windows), "hbox3", hbox3,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbox3);
	gtk_box_pack_start (GTK_BOX (vbox9), hbox3, FALSE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox3), 5);

	properties_cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	gtk_widget_ref (properties_cancel_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_cancel_button", properties_cancel_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_cancel_button);
	gtk_widget_set_size_request (properties_cancel_button, BUTTON_WIDTH, -1);

	properties_apply_button = gtk_button_new_from_stock (GTK_STOCK_APPLY);
	gtk_widget_ref (properties_apply_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_apply_button", properties_apply_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_apply_button);
	gtk_widget_set_sensitive (properties_apply_button,FALSE);
	gtk_widget_set_size_request (properties_apply_button, BUTTON_WIDTH, -1);

	properties_ok_button = gtk_button_new_from_stock (GTK_STOCK_OK);
	gtk_widget_ref (properties_ok_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_ok_button", properties_ok_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_ok_button);
	gtk_widget_set_size_request (properties_ok_button, BUTTON_WIDTH, -1);

	properties_reset_button = gtk_button_new_with_mnemonic (_("_Reset to Default"));
	gtk_widget_ref (properties_reset_button);
	g_object_set_data_full (G_OBJECT (properties_windows), "properties_reset_button", properties_reset_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (properties_reset_button);
	gtk_widget_set_size_request (properties_reset_button, 120, -1);
	gtk_widget_set_sensitive (properties_reset_button,specific_game_properties);

	gtk_box_pack_start (GTK_BOX (hbox3), properties_reset_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox3), properties_ok_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox3), properties_apply_button, FALSE, TRUE, 3);
	gtk_box_pack_end (GTK_BOX (hbox3), properties_cancel_button, FALSE, TRUE, 3);

	add_display_options_tab(properties_windows,
			 	GTK_NOTEBOOK (notebook1),
			 	gui_prefs.DefaultGame_p,
			 	properties_apply_button,
			 	properties_reset_button,
			 	2);
	add_rendering_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 gui_prefs.DefaultGame_p,
				 properties_apply_button,
				 properties_reset_button,
				 3);
	add_sound_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 gui_prefs.DefaultGame_p,
				 properties_apply_button,
				 properties_reset_button,
				 4);
	add_controller_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 gui_prefs.DefaultGame_p,
				 properties_apply_button,
				 properties_reset_button,
				 5);
	add_misc_options_tab(properties_windows,
				 GTK_NOTEBOOK (notebook1),
				 gui_prefs.DefaultGame_p,
				 properties_apply_button,
				 properties_reset_button,
				 6);
	if ((gui_prefs.DefaultGame_p)->vector)
	{
		add_vector_options_tab(properties_windows,
				       GTK_NOTEBOOK (notebook1),
				       gui_prefs.DefaultGame_p,
				       properties_apply_button,
				       properties_reset_button,
				       7);
	}

	g_signal_connect_after (G_OBJECT (notebook1), "switch_page",
			    G_CALLBACK (on_notebook1_switch_page),
			    NULL);
	g_signal_connect (G_OBJECT (properties_reset_button), "clicked",
			    G_CALLBACK (on_properties_reset_button_clicked),
			    G_OBJECT (properties_apply_button));
	/*temp, change as soon as preferences are implemented */
	g_signal_connect (G_OBJECT (properties_ok_button), "clicked",
			    G_CALLBACK (on_properties_ok_button_clicked),
			    G_OBJECT (properties_windows));
	g_signal_connect_swapped (G_OBJECT (properties_cancel_button), "clicked",
			           G_CALLBACK (exit_properties_window),
			           G_OBJECT (properties_windows));
	g_signal_connect (G_OBJECT (properties_apply_button), "clicked",
			    G_CALLBACK (on_properties_apply_button_clicked),
			    NULL);
	g_signal_connect_swapped (G_OBJECT (properties_windows), "delete-event",
			           G_CALLBACK (exit_properties_window),
			           G_OBJECT (properties_windows));

	gtk_window_add_accel_group (GTK_WINDOW (properties_windows), accel_group);

	return properties_windows;
}


void
on_properties_reset_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *filename;
	filename = g_build_filename(g_get_home_dir(), ".gxmame", "options", ((RomEntry *)gui_prefs.DefaultGame_p)->romname, NULL);
	unlink(filename);
	load_options(NULL);
	load_properties_options(NULL);
	gtk_widget_set_sensitive (GTK_WIDGET(button),FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET(user_data),FALSE);
}

void
on_properties_ok_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	save_properties_options(gui_prefs.DefaultGame_p);
	save_options(gui_prefs.DefaultGame_p);
	exit_properties_window(GTK_WIDGET(user_data),NULL);
}

void
on_properties_apply_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	save_properties_options(gui_prefs.DefaultGame_p);
	save_options(gui_prefs.DefaultGame_p);
	gtk_widget_set_sensitive(GTK_WIDGET(button),FALSE);
}

void
exit_properties_window		       (GtkWidget      *window,
                                        gpointer        user_data
		                        )
{
	/* needed to prevent the audit tab to be showed and game audited */
	g_signal_handlers_disconnect_by_func   (G_OBJECT(notebook1),
                                         (gpointer)on_notebook1_switch_page,
                                         NULL);
	gtk_widget_destroy(window);
	/* reenable joystick, was disabled in callback.c (on_properties_activate)*/
	joy_focus_on();
}

void
on_notebook1_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	FILE *xmame_pipe=NULL;
	gchar line[BUFFER_SIZE];
	const gchar *title;
	gchar *line_print;
	gchar *command, *p, *name;
	gchar *rompath_option,*samplepath_option;
	guint status;
	gboolean error_during_check=FALSE;
	GtkTextIter text_iter;

	if (page_num == 1 && !game_checked)
	{
		while (gtk_events_pending()) gtk_main_iteration();
		if (!current_exec)
		{
			title = _("Can't audit game");
			gtk_label_set_text(GTK_LABEL(rom_check_result),title);
			if ((gui_prefs.DefaultGame_p)->nb_samples >0)
			{
				gtk_label_set_text(GTK_LABEL(sample_check_result),title);
			}
			else
			{
				gtk_label_set_text(GTK_LABEL(sample_check_result), _("None required"));
			}
			game_checked = TRUE;
			return;
		}
		GXMAME_DEBUG("single audit");
		rompath_option = create_RomPath_Related_options_string();
		command = g_strdup_printf("%s -verifyroms %s %s 2>/dev/null",
				current_exec->path,
				rompath_option,
				(gui_prefs.DefaultGame_p)->romname);
		g_free(rompath_option);
		GXMAME_DEBUG("running command %s",command);
		xmame_pipe = popen(command, "r");
		if (!xmame_pipe)
		{
			GXMAME_DEBUG("Could not run %s", command);
			g_free(command);
			return;
		}
		/* Loading */
		while (fgets(line, BUFFER_SIZE, xmame_pipe))
		{
			/* jump the last comments */
			if (!line[0] || !line[1])	/* same as strlen <= 1 but faster */
				break;

			if (!strncmp(line,"romset",6))
			{
				for(p = name = line+7;(*p && (*p != ' '));p++);
				*p='\0';p++;
				if (!strncmp(p,"correct",7))
				{
					title = _("Passed");
					status = 1;
				}
				else if (!strncmp(p,"incorrect",9) && error_during_check==TRUE)
				{
					status = 0;
					title = _("Incorrect");
				} else if (!strncmp(p,"not found",9))
				{
					status = 0;
					title = _("Not found");
				}
				else if (!strncmp(p,"best available",14))
				{
					status = 1;
					title = _("Best available");
				}
				else
				{
					status = 2;
					title = _("Unknown");
				}
				(gui_prefs.DefaultGame_p)->has_roms = status;
				
				gtk_label_set_text(GTK_LABEL(rom_check_result),title);
				/*continue with the GUI */
				error_during_check = FALSE;
				while (gtk_events_pending()) gtk_main_iteration();
			}
			else
			{
				gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER(details_audit_result_buffer), &text_iter);
				gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_audit_result_buffer), &text_iter, line, -1);
				error_during_check = TRUE;
				while (gtk_events_pending()) gtk_main_iteration();
			}
			while (gtk_events_pending()) gtk_main_iteration();
		}
		pclose(xmame_pipe);
		g_free(command);

		/*Samples now*/
		if ((gui_prefs.DefaultGame_p)->nb_samples >0)
		{
			samplepath_option = create_SamplePath_Related_options_string();
			command = g_strdup_printf("%s -verifysamples %s %s 2>/dev/null",
					current_exec->path,
					samplepath_option,
					(gui_prefs.DefaultGame_p)->romname);
			g_free(samplepath_option);
			GXMAME_DEBUG("running command %s",command);
			xmame_pipe = popen(command, "r");
			/* Loading */
			while (fgets(line, BUFFER_SIZE, xmame_pipe))
			{
				/* jump the last comments */
				if (!line[0] || !line[1])
					break;

				if (!strncmp(line,"sampleset",9))
				{
					for(p = name = line+10;(*p && (*p != ' '));p++);
					*p='\0';p++;
					if (!strncmp(p,"correct",7))
					{
						title = _("Passed");
						status = 1;
					}
					else if (!strncmp(p,"incorrect",9) && error_during_check==TRUE)
					{
						title = _("Incorrect");
						status = 0;
					} else
					{
						status = 2;
						title = _("Not found");
					}
					(gui_prefs.DefaultGame_p)->has_samples = status;
					gtk_label_set_text(GTK_LABEL(sample_check_result),title);

					(gui_prefs.DefaultGame_p)->has_samples = status;
					/*continue with the GUI */
					error_during_check = FALSE;
					while (gtk_events_pending()) gtk_main_iteration();
				}
				else
				{
					gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER(details_audit_result_buffer), &text_iter);
					gtk_text_buffer_insert (GTK_TEXT_BUFFER(details_audit_result_buffer), &text_iter, line, -1);
					error_during_check = TRUE;
					while (gtk_events_pending()) gtk_main_iteration();
				}
				while (gtk_events_pending()) gtk_main_iteration();
			}
			pclose(xmame_pipe);
			g_free(command);
		}
		else
		{
			gtk_label_set_text(GTK_LABEL(sample_check_result),_("None required"));
		}
		game_checked = TRUE;
		if ((gui_prefs.DefaultGame_p)->has_roms == 2)
			line_print = g_strdup_printf(_("%s\n%s\nUnknown"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
		else if ((gui_prefs.DefaultGame_p)->has_roms == 0)
			line_print = g_strdup_printf(_("%s\n%s\nROMs missing"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
		else if (!(gui_prefs.DefaultGame_p)->status)
			line_print = g_strdup_printf(_("%s\n%s\nNot working"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
		else
			line_print = g_strdup_printf(_("%s\n%s\nWorking"),(gui_prefs.DefaultGame_p)->year,(gui_prefs.DefaultGame_p)->manu);
		gtk_label_set_text(GTK_LABEL(manu_status_value), line_print);
		g_free(line_print);
		/* Update the Main gui*/
		update_game_in_list((gui_prefs.DefaultGame_p)->position);
		select_game(gui_prefs.DefaultGame_p);
	}
}

