/*
 * GXMame
 *
 * 2002, 2003, Stéphane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __XMAME_EXECUTABLE_H__
#define __XMAME_EXECUTABLE_H__

#include "common.h"

typedef struct _xmame_available_options {
	gboolean debug;			/* is a debug enabled version? */
	gboolean use_backdrops;		/* new artwork system 0.61-pr2 */
	gboolean use_overlays;		/* could join all these */
	gboolean use_bezels;		/* | */
	gboolean artwork_crop;		/* | */
	gboolean artwork_resolution;	/* | */
	gboolean intensity;		/* vector intensity 0.61-r3 */
	gboolean list_display_plugins;	/* different display ??? */
	gboolean artsBufferTime;	/* aRts sound system */	
	gboolean list_alsa_cards;	/* Alsa sound system */
	gboolean alsacard;	
	gboolean alsadevice;	
	gboolean list_alsa_pcm ;	/* 0.9 */
	gboolean alsa_pcm;	
	gboolean alsa_buffer;
	gboolean audio_preferred;	/* QNX */
	gboolean network;		/* network enabled*/
	gboolean parallelsync;		/* with parallel sync patch 0.61-pr1 */
	gboolean bind;			/* bind & statedebug from netmame 0.6rc1*/
	gboolean statedebug;
	gboolean list_dsp_plugins;	/* list dsp plugins */
	gboolean list_mixer_plugins;	/* list mixer plugins */
	gboolean keyboard_leds;		/* use keyboard leds */
	gboolean dirty;			/* dirty not in 0.61 pr1 */
	gboolean xvext;			/* xv extension 0.60 + patch from
					   Alastair M. Robinson*/
	gboolean vidix;			/* another target from Alastair M. Robinson
					   0.61.1 + patch */
	gboolean yuv;			/* yuv 0.61.1 pr7 */
	gboolean yv12;			/* yv12 0.61.1 pr10? */
	gboolean mitshm;		/* MIT shared memory if not compiled in */
	
	gboolean fullscreen;		/* fullscreen option (only used for the 
					   fullscreen xv mode) */
	gboolean video_mode;		/* video mode related if dga wasn't
					   compiled in*/

	gboolean XInput_trackball;	/* inputs */
	gboolean paddevname;
	gboolean x11joyname;
	gboolean joydevname;
	gboolean grabmouse;
	gboolean grabkeyboard;
	gboolean cfgname;		/* config name in 0.61 pr5 from Benoit Dumont */
	gboolean ctrlr;			/* Controller Name */
	gboolean listmodes;		/* SDL List mode */

	const gchar *artwork_directory_option;
	const gchar *hiscore_directory_option;
	const gchar *snapshot_directory_option;
	const gchar *diff_directory_option;
	const gchar *cheat_file_option;
	const gchar *hiscore_file_option;
	const gchar *history_file_option;
	const gchar *mameinfo_file_option;

	gboolean gamma_correction;	/* old version of gamma (changed in 0.66.1)*/
	gboolean dos_brightness;	/* brightness between 0.5 and 2 instead of % (xmame 0.66) */
	
	gboolean InputDirectory;
	gboolean NVRamDirectory;
	gboolean MemCardDirectory;
	gboolean ConfigDirectory;
	gboolean StateDirectory;
	gboolean CtrlrDirectory;
	gboolean IniPath;
	
	gboolean skip_disclaimer;
	gboolean skip_gameinfo;

	gboolean bios;
	gboolean ugcicoin;

	gboolean newx11modeusage;	/* for 0.72.1 -x11-mode changes */
	gboolean newhotrodusage;	/* 0.74.1 has new hotrod options */
} xmame_available_options;

typedef struct _xmame_executable {
	gchar *name;
	gchar *target;
	gchar *version;
	gchar *path;
	xmame_available_options *available_options;
	GHashTable *dsp_plugin_hash_table;
	GHashTable *mixer_plugin_hash_table;
	GHashTable *display_plugins_hash_table;
	GHashTable *sdl_modes_hash_table;
} XmameExecutable;

/* Initializes the xmame executables table */
void
xmame_table_init(void);

/* Destroys the table and all executables inside */
void
xmame_table_free(void);

gint
xmame_table_size(void);

/* Adds the executable with the given path to the table
* and returns the executable.
* Guarantees: 
* - only one executable in the table with the same path.
* - only valid executables are added.
* - version information is in the struct.
*/
XmameExecutable *
xmame_table_add(const gchar *path);

/* Gets the executable with the given path */
XmameExecutable *
xmame_table_get(const gchar *path);

/* Gets the executable with the given name */
XmameExecutable *
xmame_table_get_by_name(const gchar *name);

/* Returns a NULL terminated list
* with all the paths in the table.
* Free the list with g_free.
*/
gchar **
xmame_table_get_all();

gboolean
xmame_executable_set_version(XmameExecutable *exec);

/* Use this macro to check for valid executables.
   This is to make it clear what we are doing.
*/
#define xmame_executable_is_valid(exec) xmame_executable_set_version(exec)

/*
* Frees the options for the executable.
* Useful when we want to force reading them with set_options.
*/
void
xmame_executable_free_options(XmameExecutable *exec);

/* Gets the available_options for the executable
* It will only parse them the first time so
* you can call this often.
*/
xmame_available_options *
xmame_executable_get_options(XmameExecutable *exec);

#endif
