/*
 * Decompiled with CFR 0.152.
 */
public abstract class AuctionActionImpl
implements AuctionAction {
    protected String m_id;
    protected AuctionEntry m_auct;
    protected Currency m_amount;
    protected int m_quant;
    int m_result = -1;

    protected AuctionActionImpl(String string, Currency currency, int n) {
        this.m_id = string;
        this.m_auct = null;
        this.m_amount = currency;
        this.m_quant = n;
    }

    protected AuctionActionImpl(AuctionEntry auctionEntry, Currency currency, int n) {
        this.m_auct = auctionEntry;
        this.m_id = auctionEntry.getIdentifier();
        this.m_amount = currency;
        this.m_quant = n;
    }

    public String activate() {
        if (this.m_auct == null) {
            this.m_auct = FilterManager.getInstance().whereIsAuction(this.m_id).getEntry(this.m_id);
            if (this.m_auct == null) {
                this.m_result = 14;
                return this.getBidResult(this.m_amount, this.m_result);
            }
        }
        this.m_result = this.execute(this.m_auct, this.m_amount, this.m_quant);
        String string = this.getBidResult(this.m_amount, this.m_result);
        this.m_auct.setLastStatus(string);
        this.m_auct.update();
        return string;
    }

    protected abstract int execute(AuctionEntry var1, Currency var2, int var3);

    public int getResult() {
        return this.m_result;
    }

    public Currency getAmount() {
        return this.m_amount;
    }

    public int getQuantity() {
        return this.m_quant;
    }

    public boolean isSuccessful() {
        return this.m_result == 4 || this.m_result == 6 || this.m_result == 5;
    }

    public String getBidResult(Currency currency, int n) {
        String string;
        switch (n) {
            case -1: {
                string = "Bidding " + currency + " apparently failed for an unknown reason.  Check the auction in the browser, to see if the bid went through anyway.";
                break;
            }
            case 1: 
            case 9: {
                string = "Bidding apparently failed, as the auction cannot be bid on anymore (probably ended)!";
                break;
            }
            case 6: {
                string = "Your dutch bid was confirmed, and you are in the list of high bidders!";
                break;
            }
            case 10: {
                string = "Your bid failed, as you are disallowed from bidding on this seller's items.";
                break;
            }
            case 8: {
                string = "Your bid was too low, and was not accepted.";
                break;
            }
            case 13: {
                string = "Your bid was below or equal to your previous high bid, and was not accepted.";
                break;
            }
            case 11: {
                string = "Your bid was successful, but it did not meet the reserve price.";
                break;
            }
            case 2: {
                string = "Bidding apparently failed, because of an an invalid amount (" + currency + ").";
                break;
            }
            case 3: {
                string = "Your bid for " + currency + " was submitted, but someone else's bid is still higher.";
                break;
            }
            case 12: {
                string = "Bid failed due to connection problem.  Probably a timeout trying to reach eBay.";
                break;
            }
            case 14: {
                string = "Your bid failed because the item was removed from JBidwatcher before the bid executed.";
                break;
            }
            case 4: 
            case 5: {
                string = "Congratulations!  You have the high bid with " + currency + '.';
                break;
            }
            case 17: {
                string = "You cannot interact with any auctions, your account has been suspended.";
                break;
            }
            case 18: {
                string = "Sign in failed repeatedly during bid.  Check your username and password information in the Configuration Manager.";
                break;
            }
            case 19: {
                string = "You are registered in a country to which the seller doesn't ship.";
                break;
            }
            case 20: {
                string = "You don't meet some requirement the seller has set for the item.  Check the item details for more information.";
                break;
            }
            default: {
                string = "Something VERY wrong has happened, and I don't know what it is.  Check the auction to see if your bid went through.";
            }
        }
        return string;
    }
}

